/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.process.DeliverOperationData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractFileAdvisor
implements IOperationAdvisor {
    private static final String TAG_COMPONENTS = "components";
    private static final String TAG_COMPONENT = "component";
    private static final String ATTR_NAME = "name";
    private static final String DATA_TAG_DATA = "data";
    public static final String DATA_ATTR_FILE_ITEMID = "fileItemId";
    public static final String DATA_ATTR_FILE_NAME = "fileName";
    public static final String DATA_ATTR_COMPONENT_ITEMID = "componentItemId";
    public static final String DATA_ATTR_WORKSPACE_ITEMID = "workspaceItemId";
    private List fComponents;

    protected abstract IReportInfo getProblem(IFile var1, IAdvisorInfoCollector var2, IProgressMonitor var3);

    protected void initialize(IProcessConfigurationElement advisorConfiguration) {
        this.fComponents = null;
        IProcessConfigurationElement[] children = advisorConfiguration.getChildren();
        int i = 0;
        while (i < children.length) {
            IProcessConfigurationElement child = children[i];
            if (child.getName().equals(TAG_COMPONENTS)) {
                IProcessConfigurationElement[] components = child.getChildren();
                this.fComponents = new ArrayList();
                int j = 0;
                while (j < components.length) {
                    String componentName;
                    IProcessConfigurationElement element = components[j];
                    if (element.getName().equals(TAG_COMPONENT) && (componentName = element.getAttribute(ATTR_NAME)) != null) {
                        this.fComponents.add(componentName);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object operationData = operation.getOperationData();
        if (!(operationData instanceof DeliverOperationData)) {
            return;
        }
        monitor.beginTask("", 1000);
        try {
            List changeSets;
            this.initialize(advisorConfiguration);
            DeliverOperationData data = (DeliverOperationData)operationData;
            IWorkspace sourceWorkspace = data.getSourceWorkspace();
            ITeamRepository teamRepository = (ITeamRepository)sourceWorkspace.getOrigin();
            try {
                changeSets = teamRepository.itemManager().fetchCompleteItems(data.getChangeSetHandles(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            catch (TeamRepositoryException e) {
                DefinitionsIdeUIPlugin.getDefault().log(e);
                collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.AbstractFileAdvisor_7, (Throwable)e));
                monitor.done();
                return;
            }
            SubProgressMonitor changeSetMonitor = new SubProgressMonitor(monitor, 950);
            changeSetMonitor.beginTask(Messages.AbstractFileAdvisor_8, changeSets.size() * 1000);
            for (IChangeSet changeSet : changeSets) {
                if (changeSet == null) {
                    collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.AbstractFileAdvisor_9, (Throwable)new TeamRepositoryException(Messages.AbstractFileAdvisor_10)));
                    continue;
                }
                IComponentHandle componentHandle = changeSet.getComponent();
                IComponent component = (IComponent)teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)componentHandle);
                if (component != null && this.fComponents != null && !this.fComponents.contains(component.getName())) continue;
                int interval = 500;
                long stopTime = System.currentTimeMillis() + (long)interval;
                ArrayList<Object> problems = new ArrayList<Object>();
                List changes = changeSet.changes();
                SubProgressMonitor changeMonitor = new SubProgressMonitor((IProgressMonitor)changeSetMonitor, 1000);
                changeMonitor.beginTask(Messages.AbstractFileAdvisor_11, changes.size() * 1000);
                for (IChange change : changes) {
                    int changeKind = change.kind();
                    if ((changeKind & 2) != 2 && changeKind != 1) {
                        changeMonitor.worked(1000);
                        continue;
                    }
                    IVersionableHandle versionableHandle = change.afterState();
                    try {
                        IReportInfo problem;
                        IFile file;
                        IResource resource;
                        ISharingManager sharingManager = FileSystemCore.getSharingManager();
                        IShareable shareable = sharingManager.findShareable(sharingManager.getDefaultCFARoot(), versionableHandle, componentHandle, (IContextHandle)sourceWorkspace, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)changeMonitor, 100));
                        if (shareable == null || !((resource = (IResource)shareable.getAdapter(IResource.class)) instanceof IFile) || !(file = (IFile)resource).exists() || (problem = this.getProblem(file, collector, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)changeMonitor, 900))) == null) continue;
                        Exception dataException = null;
                        if (problem instanceof IAdvisorInfo) {
                            try {
                                this.setProblemData((IAdvisorInfo)problem, (IWorkspaceHandle)sourceWorkspace, componentHandle, (IFileItemHandle)versionableHandle, resource.getName());
                            }
                            catch (ParserConfigurationException e) {
                                dataException = e;
                            }
                            catch (TransformerException e) {
                                dataException = e;
                            }
                            catch (IOException e) {
                                dataException = e;
                            }
                        }
                        problems.add(problem);
                        if (dataException != null) {
                            IAdvisorInfo exceptionInfo = collector.createExceptionInfo(Messages.AbstractFileAdvisor_12, (Throwable)dataException);
                            exceptionInfo.setSeverity(2);
                            problems.add(exceptionInfo);
                        }
                        if (System.currentTimeMillis() <= stopTime) continue;
                        collector.addInfos(problems.toArray(new IReportInfo[problems.size()]));
                        problems.clear();
                        stopTime = System.currentTimeMillis() + (long)interval;
                    }
                    catch (FileSystemClientException e) {
                        collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.AbstractFileAdvisor_13, (Throwable)e));
                    }
                }
                changeMonitor.done();
                if (problems.size() <= 0) continue;
                collector.addInfos(problems.toArray(new IReportInfo[problems.size()]));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract void appendToProblemData(Element var1, Object var2, Document var3);

    protected void setProblemData(IAdvisorInfo problem, IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, IFileItemHandle fileItem, String fileName) throws ParserConfigurationException, TransformerException, IOException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement(DATA_TAG_DATA);
        if (workspaceHandle != null && componentHandle != null && fileItem != null && fileName != null) {
            root.setAttribute(DATA_ATTR_WORKSPACE_ITEMID, workspaceHandle.getItemId().getUuidValue());
            root.setAttribute(DATA_ATTR_COMPONENT_ITEMID, componentHandle.getItemId().getUuidValue());
            root.setAttribute(DATA_ATTR_FILE_ITEMID, fileItem.getItemId().getUuidValue());
            root.setAttribute(DATA_ATTR_FILE_NAME, fileName);
        }
        doc.appendChild(root);
        this.appendToProblemData(root, problem.getProblemObject(), doc);
        String data = AbstractModel.serializeDocument((Document)doc);
        problem.setData(data);
    }
}

