/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProcessContainer;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ProcessDefinitionExportUtil {
    public static final int VERSION_1 = 1;

    public static void exportProcessContainer(String directoryPath, IProcessContainer container, IDefinitionExportContext context, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IContent state;
        Map processData;
        IContent spec;
        String summary;
        String contentURL;
        String name;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProcessAttachmentHandle[] attachmentHandles = container.getAttachments();
        monitor.beginTask("", attachmentHandles.length * 1000 + 400);
        String processId = null;
        IContent description = null;
        if (container instanceof IProjectArea) {
            IProjectArea projectArea = (IProjectArea)container;
            name = projectArea.getProcessName();
            contentURL = projectArea.getProcessContentURL();
            summary = projectArea.getProcessSummary();
        } else if (container instanceof IProcessDefinition) {
            IProcessDefinition definition = (IProcessDefinition)container;
            name = definition.getName();
            contentURL = definition.getProcessContentURL();
            summary = definition.getDescription().getSummary();
            description = definition.getDescription().getDetails();
            processId = definition.getProcessId();
        } else {
            throw new TeamRepositoryException(Messages.getCommonString("ProcessDefinitionExportUtil.0"));
        }
        File selectedDir = new File(directoryPath);
        if (!selectedDir.exists()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionExportUtil.1"), directoryPath));
        }
        if (!selectedDir.isDirectory()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionExportUtil.2"), directoryPath));
        }
        File baseDir = ProcessDefinitionExportUtil.createDirectory(selectedDir, processId != null ? processId : name, context);
        ProcessDefinitionExportUtil.writeFile(baseDir, "name.txt", name, "UTF-8", context);
        if (contentURL != null && contentURL.length() > 0) {
            ProcessDefinitionExportUtil.writeFile(baseDir, "contentURL.txt", contentURL, "UTF-8", context);
        }
        if (processId != null && processId.length() > 0) {
            ProcessDefinitionExportUtil.writeFile(baseDir, "processId.txt", processId, "UTF-8", context);
        }
        if (summary != null && summary.length() > 0) {
            ProcessDefinitionExportUtil.writeFile(baseDir, "summary.txt", summary, "UTF-8", context);
        }
        if (description != null) {
            ProcessDefinitionExportUtil.writeFile(baseDir, "description.txt", description, context, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        if ((spec = (IContent)(processData = container.getProcessData()).get("com.ibm.team.internal.process.compiled.xml")) != null) {
            ProcessDefinitionExportUtil.writeFile(baseDir, "specification.txt", spec, context, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        if ((state = (IContent)processData.get("com.ibm.team.internal.process.state.xml")) != null) {
            ProcessDefinitionExportUtil.writeFile(baseDir, "state.txt", state, context, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        if (attachmentHandles.length > 0) {
            StringBuffer buffer = new StringBuffer();
            File attachmentDir = ProcessDefinitionExportUtil.createDirectory(baseDir, "attachments", context);
            List attachments = context.fetchCompleteItems(Arrays.asList(attachmentHandles), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            int i = 0;
            for (IProcessAttachment attachment : attachments) {
                Path path = new Path(attachment.getPath());
                buffer.append(path.toString()).append(System.getProperty("line.separator"));
                IContent content = attachment.getContent();
                StringBuffer fileName = new StringBuffer(Integer.toString(i++));
                String extension = path.getFileExtension();
                if (extension != null) {
                    fileName.append('.').append(extension);
                }
                ProcessDefinitionExportUtil.writeFile(attachmentDir, fileName.toString(), content, context, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            ProcessDefinitionExportUtil.writeFile(baseDir, "attachments.txt", buffer.toString(), "UTF-8", context);
        }
        ProcessDefinitionExportUtil.writeFile(baseDir, "version.txt", Integer.toString(1), "UTF-8", context);
    }

    public static File createZip(File directory, File archive, IDefinitionExportContext context) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(archive));
        ZipOutputStream zipStream = new ZipOutputStream(stream);
        try {
            ProcessDefinitionExportUtil.writeFileToZip(directory, zipStream, (IPath)new Path(directory.toString()));
        }
        finally {
            zipStream.close();
        }
        return archive;
    }

    private static void writeFileToZip(File file, ZipOutputStream zipStream, IPath rootPath) throws IOException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                File child = children[i];
                ProcessDefinitionExportUtil.writeFileToZip(child, zipStream, rootPath);
                ++i;
            }
        } else {
            Path filePath = new Path(file.toString());
            int matching = filePath.matchingFirstSegments(rootPath);
            if (matching > 0 && filePath.segmentCount() > matching) {
                String relativePath = filePath.removeFirstSegments(matching).setDevice(null).toString();
                ZipEntry entry = new ZipEntry(relativePath);
                zipStream.putNextEntry(entry);
                FileInputStream inputStream = new FileInputStream(file);
                byte[] buffer = new byte[8192];
                int read = inputStream.read(buffer);
                while (read > 0) {
                    zipStream.write(buffer, 0, read);
                    read = inputStream.read(buffer);
                }
                zipStream.flush();
                zipStream.closeEntry();
            }
        }
    }

    private static void writeFile(File directory, String fileName, String string, String encoding, IDefinitionExportContext context) throws IOException {
        File file = ProcessDefinitionExportUtil.createFile(directory, fileName, context);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        try {
            writer.write(string);
        }
        finally {
            writer.close();
        }
    }

    public static void writeFile(File directory, String fileName, IContent content, IDefinitionExportContext context, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        byte[] bytes = context.readContent(content, monitor);
        String encoding = content.getCharacterEncoding();
        if (encoding == null || encoding.length() == 0) {
            ProcessDefinitionExportUtil.writeFile(directory, fileName, bytes, context);
        } else {
            String stringContent = new String(bytes, encoding);
            ProcessDefinitionExportUtil.writeFile(directory, fileName, stringContent, encoding, context);
        }
    }

    private static void writeFile(File directory, String fileName, byte[] content, IDefinitionExportContext context) throws IOException {
        File file = ProcessDefinitionExportUtil.createFile(directory, fileName, context);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            outputStream.write(content);
        }
        finally {
            outputStream.close();
        }
    }

    private static File createFile(File directory, String fileName, IDefinitionExportContext context) throws IOException {
        return context.createFile(directory, fileName, false);
    }

    private static File createDirectory(File parentDirectory, String directoryName, IDefinitionExportContext context) throws IOException {
        return context.createFile(parentDirectory, directoryName, true);
    }

    public static interface IDefinitionExportContext {
        public List fetchCompleteItems(List var1, IProgressMonitor var2) throws TeamRepositoryException;

        public File createFile(File var1, String var2, boolean var3) throws IOException;

        public byte[] readContent(IContent var1, IProgressMonitor var2) throws TeamRepositoryException;
    }
}

