/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.internal.client.workingcopies.PropertyWorkingCopy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class StringWorkingCopy
extends PropertyWorkingCopy {
    private final IDocumentListener fDirtyListener = new DirtyListener();
    private IDocument fDocument = new Document();

    public StringWorkingCopy(String initialContent) {
        this.fDocument.set(this.filter(initialContent));
        this.fDocument.addDocumentListener(this.fDirtyListener);
    }

    protected StringWorkingCopy() {
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void dispose() {
        this.fDocument = null;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.fDocument == null;
    }

    public void asyncUpdate(final String newContent, IUpdateContext context) {
        if (this.isDisposed()) {
            return;
        }
        if (this.fDocument.get().equals(newContent)) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                StringWorkingCopy.this.updateDocumentContent(newContent);
            }
        };
        if (context != null) {
            context.execute(runnable);
        } else {
            runnable.run();
        }
    }

    protected void updateDocumentContent(String newContent) {
        if (!(this.isDisposed() || this.isDirty() || this.fDocument.get().equals(newContent))) {
            this.fDocument.removeDocumentListener(this.fDirtyListener);
            this.fDocument.set(this.filter(newContent));
            this.fDocument.addDocumentListener(this.fDirtyListener);
        }
    }

    protected String filter(String content) {
        return content;
    }

    private class DirtyListener
    implements IDocumentListener {
        private DirtyListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            StringWorkingCopy.this.setDirty(true, true);
        }
    }
}

