/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.client.ISimpleFileListener;
import com.ibm.team.process.client.ISimpleFileManager;
import com.ibm.team.process.common.ISimpleFile;
import com.ibm.team.process.common.service.ISimpleFileService;
import com.ibm.team.process.internal.common.simplefile.query.BaseSimpleFileQueryModel;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SimpleFileManager
implements ISimpleFileManager {
    private final IClientLibraryContext fContext;
    private List fListeners = new ArrayList();

    public SimpleFileManager(IClientLibraryContext context) {
        this.fContext = context;
    }

    public ISimpleFile create(final String path, final IContent content, IProgressMonitor monitor) throws TeamRepositoryException {
        final ISimpleFile file = (ISimpleFile)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return SimpleFileManager.this.getService().create(path, content);
            }
        }, this.getProgressMonitor(monitor));
        this.runSimpleFileNotifier(new ISimpleFileNotifier(){

            public void notifyListener(ISimpleFileListener listener) {
                listener.handleFileAdded(file);
            }
        });
        return (ISimpleFile)this.shareSingle((IItem)file);
    }

    public void delete(final ISimpleFile file, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                SimpleFileManager.this.getService().delete(file);
                return null;
            }
        }, this.getProgressMonitor(monitor));
        this.runSimpleFileNotifier(new ISimpleFileNotifier(){

            public void notifyListener(ISimpleFileListener listener) {
                listener.handleFileDeleted(file);
            }
        });
    }

    public ISimpleFile get(final String path, IProgressMonitor monitor) throws TeamRepositoryException {
        ISimpleFile file = (ISimpleFile)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return SimpleFileManager.this.getService().get(path);
            }
        }, this.getProgressMonitor(monitor));
        return (ISimpleFile)this.shareSingle((IItem)file);
    }

    public ISimpleFile save(final ISimpleFile record, IProgressMonitor monitor) throws TeamRepositoryException {
        final ISimpleFile file = (ISimpleFile)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return SimpleFileManager.this.getService().save(record);
            }
        }, this.getProgressMonitor(monitor));
        this.runSimpleFileNotifier(new ISimpleFileNotifier(){

            public void notifyListener(ISimpleFileListener listener) {
                listener.handleFileChanged(file);
            }
        });
        return (ISimpleFile)this.shareSingle((IItem)file);
    }

    public ISimpleFile[] findAllFiles(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            final IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)BaseSimpleFileQueryModel.SimpleFileQueryModel.ROOT);
            final IQueryService queryService = (IQueryService)this.fContext.getServiceInterface(IQueryService.class);
            IItemQueryPage page = (IItemQueryPage)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return queryService.queryItems(query, IQueryService.EMPTY_PARAMETERS, 10);
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            List itemHandles = page.getItemHandles();
            SubProgressMonitor pageMonitor = new SubProgressMonitor(monitor, 800);
            pageMonitor.beginTask("", (int)Math.ceil((double)(page.getResultSize() - 10) / 10.0) * 1000);
            while (page.hasNext()) {
                final UUID token = page.getToken();
                final int nextStartPosition = page.getNextStartPosition();
                page = (IItemQueryPage)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                    public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                        return queryService.fetchPage(token, nextStartPosition, 10);
                    }
                }, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pageMonitor, 1000));
                itemHandles.addAll(page.getItemHandles());
            }
            List list = this.getItemManager().fetchCompleteItems(itemHandles, 1, monitor);
            ListIterator iter = list.listIterator();
            while (iter.hasNext()) {
                if (iter.next() != null) continue;
                iter.remove();
            }
            ISimpleFile[] iSimpleFileArray = list.toArray(new ISimpleFile[list.size()]);
            return iSimpleFileArray;
        }
        finally {
            monitor.done();
        }
    }

    protected IItem shareSingle(IItem item) throws TeamRepositoryException {
        if (item != null) {
            List items = this.getItemManager().applyItemUpdates(Collections.singletonList(item));
            return (IItem)items.get(0);
        }
        return null;
    }

    private ISimpleFileService getService() {
        return (ISimpleFileService)this.fContext.getServiceInterface(ISimpleFileService.class);
    }

    private IItemManager getItemManager() {
        return this.fContext.teamRepository().itemManager();
    }

    private IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSimpleFileListener(ISimpleFileListener listener) {
        List list = this.fListeners;
        synchronized (list) {
            if (!this.fListeners.contains(listener)) {
                this.fListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSimpleFileListener(ISimpleFileListener listener) {
        List list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISimpleFileListener[] getListeners() {
        List list = this.fListeners;
        synchronized (list) {
            return this.fListeners.toArray(new ISimpleFileListener[this.fListeners.size()]);
        }
    }

    public void runSimpleFileNotifier(final ISimpleFileNotifier notifier) {
        ISimpleFileListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISimpleFileListener listener = listeners[i];
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    notifier.notifyListener(listener);
                }

                public void handleException(Throwable exception) {
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    private static interface ISimpleFileNotifier {
        public void notifyListener(ISimpleFileListener var1);
    }
}

