/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.client;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class TeamAreaHierarchyMigrationHelper {
    public static IDevelopmentLineHandle getDevelopmentLine(IProjectAreaHandle projectAreaHandle, String developmentLineId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 1000);
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        IProjectArea projectArea = (IProjectArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
        IDevelopmentLineHandle[] developmentLineHandles = projectArea.getDevelopmentLines();
        if (developmentLineHandles != null) {
            List developmentLines = teamRepository.itemManager().fetchCompleteItems(Arrays.asList(developmentLineHandles), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            for (IDevelopmentLine line : developmentLines) {
                if (line == null || !developmentLineId.equals(line.getId())) continue;
                return line;
            }
        }
        return null;
    }
}

