/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.client;

import com.ibm.team.process.common.advice.runtime.IOperationAdviceListener;
import com.ibm.team.process.common.advice.runtime.IOperationAdviceManager;
import com.ibm.team.process.internal.client.InternalProcessClient;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdvisorRegistry;
import com.ibm.team.process.internal.common.advice.runtime.OperationParticipantRegistry;
import com.ibm.team.process.internal.common.advice.runtime.OperationRegistry;
import com.ibm.team.repository.common.util.ExtensionReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ProcessClient {
    private static IOperationAdviceManager fgOperationAdviceManager;

    public static IOperationAdviceManager getOperationAdviceManager() {
        if (fgOperationAdviceManager == null) {
            fgOperationAdviceManager = new OperationAdviceManager(new OperationRegistry("com.ibm.team.process.client", "configurationPoints"), new OperationParticipantRegistry("com.ibm.team.process.client", "operationParticipants"), new OperationAdvisorRegistry("com.ibm.team.process.client", "operationAdvisors"), 5);
            new OperationAdviceListenerRegistry(fgOperationAdviceManager).start();
        }
        return fgOperationAdviceManager;
    }

    private static class OperationAdviceListenerRegistry
    extends ExtensionReader {
        private static final String ATTR_CLASS = "class";
        private final IOperationAdviceManager fOperationAdviceManager;

        public OperationAdviceListenerRegistry(IOperationAdviceManager operationAdviceManager) {
            super("com.ibm.team.process.client", "operationAdviceListeners");
            this.fOperationAdviceManager = operationAdviceManager;
        }

        protected boolean handleExtensionAdded(IConfigurationElement element) {
            try {
                IOperationAdviceListener listener = (IOperationAdviceListener)element.createExecutableExtension(ATTR_CLASS);
                this.fOperationAdviceManager.addAdviceListener(listener);
                return true;
            }
            catch (CoreException e) {
                InternalProcessClient.log(e.getStatus());
                return false;
            }
        }
    }
}

