/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.metronome.internal;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.metronome.internal.Messages;
import com.ibm.team.metronome.internal.MetronomeModel;
import com.ibm.team.metronome.internal.MetronomeWindow;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MetronomeRepositorySelectionToolItem {
    private Map<IStatistics, MetronomeWindow> mapMetronomeWindows;
    MetronomeModel metronomeModel;
    private ToolItem fItem;
    private Menu fMenu;
    private ITeamRepository defaultRepo;
    private Listener fPopupListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.detail != 4 && MetronomeRepositorySelectionToolItem.this.defaultRepo != null) {
                MetronomeRepositorySelectionToolItem.this.openMetronomeWindow(MetronomeRepositorySelectionToolItem.this.defaultRepo.statistics(), MetronomeRepositorySelectionToolItem.this.defaultRepo.getRepositoryURI());
            } else {
                MetronomeRepositorySelectionToolItem.this.showPopupMenu(event);
            }
        }
    };
    private SelectionAdapter fMenuItemSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MenuItem item = (MenuItem)e.widget;
            if (item.getSelection()) {
                MetronomeRepositorySelectionToolItem.this.defaultRepo = (ITeamRepository)e.widget.getData();
                MetronomeRepositorySelectionToolItem.this.repositorySelected();
                MetronomeRepositorySelectionToolItem.this.openMetronomeWindow(MetronomeRepositorySelectionToolItem.this.defaultRepo.statistics(), MetronomeRepositorySelectionToolItem.this.defaultRepo.getRepositoryURI());
            }
        }
    };

    public MetronomeRepositorySelectionToolItem(ToolBar toolBar, int style, MetronomeModel metronomeModel) {
        this.metronomeModel = metronomeModel;
        this.mapMetronomeWindows = new HashMap<IStatistics, MetronomeWindow>();
        this.defaultRepo = this.restoreLastSelection();
        this.fItem = new ToolItem(toolBar, style | 4);
        this.fItem.addListener(13, this.fPopupListener);
        this.fItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (MetronomeWindow metronomeWindow : MetronomeRepositorySelectionToolItem.this.mapMetronomeWindows.values()) {
                    metronomeWindow.close();
                }
                if (MetronomeRepositorySelectionToolItem.this.fMenu != null) {
                    MetronomeRepositorySelectionToolItem.this.fMenu.dispose();
                }
            }
        });
    }

    public ToolItem getControl() {
        return this.fItem;
    }

    protected void repositorySelected() {
    }

    private void createMenu() {
        this.checkSelectedRepository();
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu((Decorations)this.fItem.getParent().getShell(), 8);
        StandardLabelProvider labelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repos.length) {
            ITeamRepository repository = repos[i];
            MenuItem item = new MenuItem(this.fMenu, 16);
            String label = labelProvider.getText((Object)repository);
            if (label == null) {
                label = repository.getName();
            }
            if (label == null) {
                label = repository.getRepositoryURI();
            }
            item.setText(label);
            item.setImage(labelProvider.getImage((Object)repository));
            if (repository.loggedIn()) {
                if (this.defaultRepo == repository) {
                    item.setSelection(true);
                }
                item.addSelectionListener((SelectionListener)this.fMenuItemSelectionListener);
                item.setData((Object)repository);
            } else {
                item.setEnabled(false);
            }
            ++i;
        }
        if (repos.length > 0) {
            new MenuItem(this.fMenu, 2);
        }
        MenuItem close = new MenuItem(this.fMenu, 8);
        close.setText(Messages.MetronomeRepositorySelectionToolItem_closeAction);
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui").putBoolean("prefs_show_metronome_trim", false);
            }
        });
    }

    private void showPopupMenu(Event event) {
        this.createMenu();
        Rectangle bounds = this.fItem.getParent().getBounds();
        Point point = new Point(event.x, bounds.y + bounds.height);
        point = this.fItem.getDisplay().map((Control)this.fItem.getParent(), null, point);
        this.fMenu.setLocation(point);
        this.fMenu.setVisible(true);
    }

    private ITeamRepository restoreLastSelection() {
        return this.getFirstActiveRepository();
    }

    private ITeamRepository getFirstActiveRepository() {
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repos.length) {
            if (repos[i].loggedIn()) {
                return repos[i];
            }
            ++i;
        }
        return null;
    }

    private void checkSelectedRepository() {
        if (this.defaultRepo == null || !this.defaultRepo.loggedIn()) {
            this.defaultRepo = this.getFirstActiveRepository();
        }
    }

    public void openMetronomeWindow(IStatistics statistics, String repoName) {
        MetronomeWindow metronomeWindow;
        if (!this.mapMetronomeWindows.containsKey(statistics) || this.mapMetronomeWindows.get(statistics).getShell() == null) {
            metronomeWindow = new MetronomeWindow(this.metronomeModel, statistics, repoName);
            this.mapMetronomeWindows.put(statistics, metronomeWindow);
            metronomeWindow.open();
        }
        metronomeWindow = this.mapMetronomeWindows.get(statistics);
        metronomeWindow.setActive();
    }
}

