/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.metronome.internal;

import com.ibm.team.metronome.internal.Messages;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.IItemType;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetronomeModel
extends EventSource
implements IListener,
ITeamRepositoryService.IRepositoryServiceListener {
    private static MetronomeModel INSTANCE;
    private final Map<IStatistics, RepoStats> repoStatistics = Collections.synchronizedMap(new HashMap());

    public static synchronized MetronomeModel getInstance() {
        if (INSTANCE == null) {
            MetronomeModel model = new MetronomeModel();
            model.init();
            INSTANCE = model;
        }
        return INSTANCE;
    }

    private MetronomeModel() {
    }

    private void init() {
        ITeamRepositoryService rs = TeamPlatform.getTeamRepositoryService();
        ITeamRepository[] repo = rs.getTeamRepositories();
        int i = 0;
        while (i < repo.length) {
            this.addedRepository(repo[i]);
            ++i;
        }
        rs.addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
    }

    public void addedRepository(ITeamRepository repository) {
        IStatistics stats = repository.statistics();
        if (!this.repoStatistics.containsKey(stats)) {
            RepoStats rs = new RepoStats(stats);
            this.repoStatistics.put(stats, rs);
        }
        stats.addGenericListener((Object)"com.ibm.team.repository.statistics.serviceMethod", (IListener)this);
        stats.addGenericListener((Object)"com.ibm.team.repository.statistics.itemType", (IListener)this);
    }

    public void removedRepository(ITeamRepository repository) {
        IStatistics stats = repository.statistics();
        stats.removeGenericListener((Object)"com.ibm.team.repository.statistics.serviceMethod", (IListener)this);
        stats.removeGenericListener((Object)"com.ibm.team.repository.statistics.itemType", (IListener)this);
    }

    public void handleEvents(List events) {
        for (IPropertyChangeEvent event : events) {
            IItemType itemType;
            Map<IItemType, ItemTypeStats> itemTypes;
            IStatistics stats = (IStatistics)event.getEventSource();
            RepoStats rs = this.repoStatistics.get(stats);
            Object obj = event.getObject();
            if (obj instanceof Method) {
                ServiceStats ss;
                Map<Class<?>, ServiceStats> services = rs.services;
                Method method = (Method)obj;
                Class<?> service = method.getDeclaringClass();
                if (!services.containsKey(service)) {
                    ss = new ServiceStats(service);
                    services.put(service, ss);
                }
                ss = services.get(service);
                Map<Method, MethodStats> methods = ss.methods;
                if (!methods.containsKey(method)) {
                    MethodStats ms = new MethodStats(method);
                    methods.put(method, ms);
                }
                Long timeBefore = (Long)event.getOldValue();
                Long timeAfter = (Long)event.getNewValue();
                long elapsedTime = timeAfter - timeBefore;
                MethodStats ms = methods.get(method);
                if (ms.worstElapedTimeSoFar == 0L || ms.worstElapedTimeSoFar < elapsedTime) {
                    ms.worstElapedTimeSoFar = elapsedTime;
                }
            } else if (obj instanceof IItemType && !(itemTypes = rs.itemTypes).containsKey(itemType = (IItemType)obj)) {
                ItemTypeStats itemTypeStats = new ItemTypeStats(itemType);
                itemTypes.put(itemType, itemTypeStats);
            }
            if (!this.hasGenericListeners()) continue;
            this.queueEvent(event);
        }
    }

    public Class<?>[] getServices(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        Set<Class<?>> services = rs.services.keySet();
        return services.toArray(new Class[services.size()]);
    }

    public Method[] getMethods(IStatistics statistics, Class<?> service) {
        RepoStats rs = this.repoStatistics.get(statistics);
        ServiceStats ss = rs.services.get(service);
        Set<Method> methods = ss.methods.keySet();
        return methods.toArray(new Method[methods.size()]);
    }

    public IItemType[] getItemTypes(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        Set<IItemType> itemTypes = rs.itemTypes.keySet();
        return itemTypes.toArray(new IItemType[itemTypes.size()]);
    }

    public String[] getServiceData(IStatistics statistics, Class<?> service) {
        long serviceCallCount = this.getServiceCallCount(statistics, service);
        String formatString = serviceCallCount == 1L ? Messages.MetronomeModel_serviceSingularHitsFormat : Messages.MetronomeModel_servicePluralHitsFormat;
        String serviceName = NLS.bind((String)formatString, (Object[])new String[]{"" + serviceCallCount, this.getServiceName(service), "" + this.getServiceElapsedTime(statistics, service) / 1000.0});
        return new String[]{serviceName, "", "", "", "", "", this.getFullServiceName(service)};
    }

    public String[] getMethodData(IStatistics statistics, Class<?> service, Method method) {
        return new String[]{this.getMethodName(method), Long.toString(this.getMethodCallCount(statistics, service, method)), Double.toString(this.getMethodElapsedTime(statistics, service, method) / 1000.0), Long.toString(this.getMethodTimeRatio(statistics, service, method)), Double.toString(this.getMethodAverageTime(statistics, service, method) / 1000.0), Double.toString((double)this.getMethodWorstTime(statistics, service, method) / 1000.0), this.getFullMethodName(method)};
    }

    public String[] getItemTypeData(IStatistics statistics, IItemType itemType) {
        return new String[]{this.getItemTypeName(itemType), Long.toString(this.getItemCount(statistics, itemType)), Long.toString(Math.round(this.getItemSize(statistics, itemType))), Long.toString(this.getItemSizeRatio(statistics, itemType)), Long.toString(this.getItemHits(statistics, itemType)), Long.toString(this.getItemMisses(statistics, itemType)), Long.toString(this.getItemRefreshes(statistics, itemType))};
    }

    public String getMethodName(Method method) {
        return method.getName();
    }

    private String getFullMethodName(Method method) {
        return String.valueOf(method.getDeclaringClass().getName()) + "." + method.getName();
    }

    public String getServiceName(Class<?> service) {
        String fullServiceName = this.getFullServiceName(service);
        return fullServiceName.substring(fullServiceName.lastIndexOf(46) + 1);
    }

    private String getFullServiceName(Class<?> service) {
        return service.getName();
    }

    public long getServiceCallCount(IStatistics statistics, Class<?> service) {
        long count = 0L;
        RepoStats rs = this.repoStatistics.get(statistics);
        ServiceStats ss = rs.services.get(service);
        for (MethodStats ms : ss.methods.values()) {
            count += this.getMethodCallCount(statistics, service, ms.method);
        }
        return count;
    }

    public double getServiceElapsedTime(IStatistics statistics, Class<?> service) {
        long count = 0L;
        RepoStats rs = this.repoStatistics.get(statistics);
        ServiceStats ss = rs.services.get(service);
        for (MethodStats ms : ss.methods.values()) {
            count = (long)((double)count + this.getMethodElapsedTime(statistics, service, ms.method));
        }
        return count;
    }

    public long getMethodCallCount(IStatistics statistics, Class<?> service, Method method) {
        RepoStats rs = this.repoStatistics.get(statistics);
        ServiceStats ss = rs.services.get(service);
        MethodStats ms = ss.methods.get(method);
        return rs.statistics.getServiceMethodCallCount(method) - ms.callCountWhenLastReset;
    }

    public double getMethodElapsedTime(IStatistics statistics, Class<?> service, Method method) {
        RepoStats rs = this.repoStatistics.get(statistics);
        ServiceStats ss = rs.services.get(service);
        MethodStats ms = ss.methods.get(method);
        return rs.statistics.getServiceMethodElapsedTime(method) - ms.elapsedTimeWhenLastReset;
    }

    private long getMethodTimeRatio(IStatistics statistics, Class<?> service, Method method) {
        return Math.round(this.getMethodElapsedTime(statistics, service, method) / (double)this.getTotalElapsedTime(statistics) * 100.0);
    }

    private double getMethodAverageTime(IStatistics statistics, Class<?> service, Method method) {
        return Math.round(this.getMethodElapsedTime(statistics, service, method) / (double)this.getMethodCallCount(statistics, service, method));
    }

    private long getMethodWorstTime(IStatistics statistics, Class<?> service, Method method) {
        RepoStats rs = this.repoStatistics.get(statistics);
        ServiceStats ss = rs.services.get(service);
        MethodStats ms = ss.methods.get(method);
        return ms.worstElapedTimeSoFar;
    }

    public String getItemTypeName(IItemType itemType) {
        return itemType.getName();
    }

    public long getItemCount(IStatistics statistics, IItemType itemType) {
        RepoStats rs = this.repoStatistics.get(statistics);
        return rs.statistics.getItemTypeCacheCount(itemType);
    }

    public double getItemSize(IStatistics statistics, IItemType itemType) {
        RepoStats rs = this.repoStatistics.get(statistics);
        return rs.statistics.getItemTypeCacheSize(itemType);
    }

    private long getItemSizeRatio(IStatistics statistics, IItemType itemType) {
        return Math.round(this.getItemSize(statistics, itemType) / (double)this.getTotalCacheSize(statistics) * 100.0);
    }

    public long getItemHits(IStatistics statistics, IItemType itemType) {
        RepoStats rs = this.repoStatistics.get(statistics);
        ItemTypeStats itemTypes = rs.itemTypes.get(itemType);
        return rs.statistics.getItemTypeCacheHits(itemType) - itemTypes.cacheHitsWhenLastReset;
    }

    public long getItemMisses(IStatistics statistics, IItemType itemType) {
        RepoStats rs = this.repoStatistics.get(statistics);
        ItemTypeStats itemTypes = rs.itemTypes.get(itemType);
        return rs.statistics.getItemTypeCacheMisses(itemType) - itemTypes.cacheMissesWhenLastReset;
    }

    public long getItemRefreshes(IStatistics statistics, IItemType itemType) {
        RepoStats rs = this.repoStatistics.get(statistics);
        ItemTypeStats itemTypes = rs.itemTypes.get(itemType);
        return rs.statistics.getItemTypeCacheRefreshes(itemType) - itemTypes.cacheRefreshesWhenLastReset;
    }

    public long getTotalMethodCount(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        return statistics.getTotalServiceCallCount() - rs.totalCallCountWhenLastReset;
    }

    public long getTotalElapsedTime(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        return statistics.getTotalServiceElapsedTime() - rs.totalElapsedTimeWhenLastReset;
    }

    public long getTotalItemCount(IStatistics statistics) {
        return statistics.getTotalCacheCount();
    }

    public long getTotalCacheSize(IStatistics statistics) {
        return statistics.getTotalCacheSize();
    }

    public void resetServiceMethodStats(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        rs.totalCallCountWhenLastReset = statistics.getTotalServiceCallCount();
        rs.totalElapsedTimeWhenLastReset = statistics.getTotalServiceElapsedTime();
        for (ServiceStats ss : rs.services.values()) {
            Map<Method, MethodStats> methods = ss.methods;
            for (MethodStats ms : methods.values()) {
                ms.callCountWhenLastReset = rs.statistics.getServiceMethodCallCount(ms.method);
                ms.elapsedTimeWhenLastReset = rs.statistics.getServiceMethodElapsedTime(ms.method);
                ms.worstElapedTimeSoFar = 0L;
            }
        }
    }

    public void resetItemTypeStats(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        for (ItemTypeStats is : rs.itemTypes.values()) {
            is.cacheHitsWhenLastReset = rs.statistics.getItemTypeCacheHits(is.itemType);
            is.cacheMissesWhenLastReset = rs.statistics.getItemTypeCacheMisses(is.itemType);
            is.cacheRefreshesWhenLastReset = rs.statistics.getItemTypeCacheRefreshes(is.itemType);
        }
    }

    private class ItemTypeStats {
        IItemType itemType;
        long cacheHitsWhenLastReset;
        long cacheMissesWhenLastReset;
        long cacheRefreshesWhenLastReset;

        ItemTypeStats(IItemType itemType) {
            this.itemType = itemType;
            this.cacheHitsWhenLastReset = 0L;
            this.cacheMissesWhenLastReset = 0L;
            this.cacheRefreshesWhenLastReset = 0L;
        }
    }

    private class MethodStats {
        Method method;
        long callCountWhenLastReset;
        long elapsedTimeWhenLastReset;
        long worstElapedTimeSoFar;

        MethodStats(Method method) {
            this.method = method;
            this.callCountWhenLastReset = 0L;
            this.elapsedTimeWhenLastReset = 0L;
            this.worstElapedTimeSoFar = 0L;
        }
    }

    private class RepoStats {
        IStatistics statistics;
        Map<Class<?>, ServiceStats> services;
        Map<IItemType, ItemTypeStats> itemTypes;
        long totalCallCountWhenLastReset;
        long totalElapsedTimeWhenLastReset;

        RepoStats(IStatistics statistics) {
            this.statistics = statistics;
            this.services = new HashMap();
            this.itemTypes = new HashMap<IItemType, ItemTypeStats>();
            this.totalCallCountWhenLastReset = 0L;
            this.totalElapsedTimeWhenLastReset = 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServiceStats {
        Class<?> service;
        Map<Method, MethodStats> methods;

        ServiceStats(Class<?> service) {
            this.service = service;
            this.methods = new HashMap<Method, MethodStats>();
        }
    }
}

