/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.rcp.ui.internal.gef.view;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class NodeFigure
extends Label {
    private boolean fHasFocus;
    private boolean fIsSelected;
    private boolean fIsOpened;
    private boolean fIsActive;

    public NodeFigure() {
        this.setLabelAlignment(1);
    }

    private Rectangle getSelectionRectangle() {
        Rectangle bounds = this.getTextBounds();
        bounds.expand(new Insets(0, 0, 0, -1));
        this.translateToParent((Translatable)bounds);
        bounds.intersect(this.getBounds());
        return bounds;
    }

    protected void paintFigure(Graphics graphics) {
        if (this.fIsOpened || this.fIsActive || this.fIsSelected || this.fHasFocus) {
            Rectangle selectionRect = this.getSelectionRectangle();
            if (this.fIsOpened || this.fIsActive) {
                graphics.pushState();
                graphics.setBackgroundColor(this.fIsActive ? ColorConstants.red : ColorConstants.blue);
                graphics.fillRectangle(selectionRect.getCopy().expand(new Insets(1, 1, 1, 1)));
                graphics.setBackgroundColor(ColorConstants.white);
                graphics.fillRectangle(selectionRect);
                graphics.popState();
            }
            if (this.fIsSelected) {
                graphics.pushState();
                graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
                graphics.fillRectangle(selectionRect);
                graphics.popState();
                graphics.setForegroundColor(ColorConstants.white);
            }
            if (this.fHasFocus) {
                graphics.pushState();
                graphics.setXORMode(true);
                graphics.setForegroundColor(ColorConstants.menuBackgroundSelected);
                graphics.setBackgroundColor(ColorConstants.white);
                graphics.drawFocus(selectionRect.resize(-1, -1));
                graphics.popState();
            }
        }
        super.paintFigure(graphics);
    }

    public void setSelected(boolean value) {
        this.fIsSelected = value;
        this.repaint();
    }

    public void setFocus(boolean value) {
        this.fHasFocus = value;
        this.repaint();
    }

    public void setOpened(boolean value) {
        this.fIsOpened = value;
        this.repaint();
    }

    public void setActive(boolean value) {
        this.fIsActive = value;
        this.repaint();
    }

    public void setIcon(Image image) {
        super.setIcon(image);
    }

    public void setText(String label) {
        super.setText(label);
    }

    public void setFont(Font font) {
        super.setFont(font);
    }
}

