/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.rcp.ui;

import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.rcp.ui.ILinksViewerActionProvider;
import com.ibm.team.links.rcp.ui.ILinksViewerContentProvider;
import com.ibm.team.links.rcp.ui.internal.Activator;
import com.ibm.team.links.rcp.ui.internal.gef.controller.LinkEditPartFactory;
import com.ibm.team.links.rcp.ui.internal.gef.controller.NodePart;
import com.ibm.team.links.rcp.ui.internal.gef.model.ConnectionElement;
import com.ibm.team.links.rcp.ui.internal.gef.model.DiagramElement;
import com.ibm.team.links.rcp.ui.internal.gef.model.NodeElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinksViewer
extends StructuredViewer {
    private ScrollingGraphicalViewer fGraphicalViewer = new ScrollingGraphicalViewer();
    private ILinkManager fLinkManager;
    private IReferenceFactory fReferenceFactory;
    private ILinksViewerActionProvider fLinksViewerActionProvider;
    private DiagramElement fDiagramElement;
    private DiagramElement fFilteredDiagramElement;
    private static final List EMPTY_LIST = new ArrayList(0);

    public LinksViewer(Composite parent) {
        this.fGraphicalViewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        this.fGraphicalViewer.setEditDomain(new EditDomain());
        this.fGraphicalViewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler((GraphicalViewer)this.fGraphicalViewer));
        this.fGraphicalViewer.setEditPartFactory((EditPartFactory)new LinkEditPartFactory(this));
        Control canvas = this.fGraphicalViewer.createControl(parent);
        canvas.setBackground(ColorConstants.listBackground);
    }

    private void createNodesAndConnections(IItemHandle sourceItemHandle, LegendLinks legendLinks, DiagramElement diagram) {
        NodeElement sourceNode = new NodeElement(sourceItemHandle);
        diagram.addChild(sourceNode);
        HashSet<UUID> visitedItems = new HashSet<UUID>();
        ArrayList<NodeElement> sourceNodes = new ArrayList<NodeElement>();
        sourceNodes.add(sourceNode);
        visitedItems.add(sourceItemHandle.getItemId());
        this.createNodesAndConnections(sourceNodes, legendLinks, diagram, visitedItems);
    }

    private void createNodesAndConnections(Collection<NodeElement> sourceNodes, LegendLinks legendLinks, DiagramElement diagram, HashSet<UUID> visitedItems) {
        ArrayList<NodeElement> nextLevelNodes = new ArrayList<NodeElement>();
        ILinkCollection linkCollection = this.getLinks(sourceNodes, legendLinks);
        ILinksViewerContentProvider.LinkType[] linkTypeArray = legendLinks.getLinkTypes();
        int n = linkTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILinksViewerContentProvider.LinkType linkType = linkTypeArray[n2];
            Collection links = linkCollection.getLinksById(linkType.getIdentifier());
            for (ILink link : links) {
                IItemHandle targetItemHandle = (IItemHandle)link.getTargetRef().resolve();
                IItemHandle sourceItemHandle = (IItemHandle)link.getSourceRef().resolve();
                NodeElement sourceNode = diagram.getNewestNodeElement(sourceItemHandle.getItemId());
                NodeElement targetNode = new NodeElement(targetItemHandle);
                diagram.addChild(targetNode);
                new ConnectionElement(sourceNode, targetNode, linkType);
                UUID targetUuid = targetItemHandle.getItemId();
                if (visitedItems.contains(targetUuid)) continue;
                visitedItems.add(targetUuid);
                nextLevelNodes.add(targetNode);
            }
            ++n2;
        }
        if (nextLevelNodes.size() > 0) {
            this.createNodesAndConnections(nextLevelNodes, legendLinks, diagram, visitedItems);
        }
    }

    private void createFilteredNodesAndConnections(NodeElement sourceNode, NodeElement filteredSourceNode, NodeElement filteredRootNode, LegendLinks legendLinks, DiagramElement diagram) {
        for (ConnectionElement childConnElement : sourceNode.getSourceConnections()) {
            ILinksViewerContentProvider.LinkType linkType = childConnElement.getLinkType();
            ILinksViewerContentProvider.LinkType updatedLinkType = legendLinks.getLinkType(linkType.getIdentifier());
            NodeElement childNodeElement = childConnElement.getTarget();
            if (updatedLinkType.isVisible()) {
                NodeElement filteredParentNodeElement;
                NodeElement filteredChildNodeElement = this.createFilteredNodeElement(childNodeElement);
                if (filteredSourceNode.getItemHandle().equals((Object)sourceNode.getItemHandle())) {
                    filteredParentNodeElement = filteredSourceNode;
                } else {
                    filteredParentNodeElement = this.getPreviouslyCreatedRootChild(sourceNode.getItemHandle(), filteredRootNode, diagram);
                    if (filteredParentNodeElement == null) {
                        filteredParentNodeElement = this.createFilteredNodeElement(sourceNode);
                        diagram.addChild(filteredParentNodeElement);
                        new ConnectionElement(filteredRootNode, filteredParentNodeElement, null);
                    }
                }
                diagram.addChild(filteredChildNodeElement);
                new ConnectionElement(filteredParentNodeElement, filteredChildNodeElement, updatedLinkType);
                this.createFilteredNodesAndConnections(childNodeElement, filteredChildNodeElement, filteredRootNode, legendLinks, diagram);
                continue;
            }
            this.createFilteredNodesAndConnections(childNodeElement, filteredSourceNode, filteredRootNode, legendLinks, diagram);
        }
    }

    private NodeElement getPreviouslyCreatedRootChild(IItemHandle itemHandle, NodeElement filteredRootNode, DiagramElement diagram) {
        NodeElement previouslyCreatedRootChild = null;
        UUID rootUuid = filteredRootNode.getItemHandle().getItemId();
        ArrayList<NodeElement> nodeElements = diagram.getNodeElements(itemHandle.getItemId());
        if (nodeElements != null) {
            for (NodeElement nodeElement : nodeElements) {
                for (ConnectionElement sourceConnElement : nodeElement.getTargetConnections()) {
                    NodeElement sourceNodeElement = sourceConnElement.getSource();
                    if (!sourceNodeElement.getItemHandle().getItemId().equals((Object)rootUuid)) continue;
                    previouslyCreatedRootChild = nodeElement;
                    break;
                }
                if (previouslyCreatedRootChild != null) break;
            }
        }
        return previouslyCreatedRootChild;
    }

    private DiagramElement createDiagram(IItemHandle[] sourceItemHandles, LegendLinks legendLinks) {
        DiagramElement diagram = new DiagramElement();
        IItemHandle[] iItemHandleArray = sourceItemHandles;
        int n = sourceItemHandles.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandle sourceItemHandle = iItemHandleArray[n2];
            this.createNodesAndConnections(sourceItemHandle, legendLinks, diagram);
            ++n2;
        }
        return diagram;
    }

    private DiagramElement createFilteredDiagram(LegendLinks legendLinks) {
        DiagramElement diagram = new DiagramElement();
        IItemHandle[] iItemHandleArray = (IItemHandle[])this.getInput();
        int n = iItemHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandle rootItemHandle = iItemHandleArray[n2];
            ArrayList<NodeElement> nodeElements = this.fDiagramElement.getNodeElements(rootItemHandle.getItemId());
            for (NodeElement nodeElement : nodeElements) {
                if (nodeElement.getTargetConnections().size() != 0) continue;
                NodeElement copyRootNode = this.createFilteredNodeElement(nodeElement);
                diagram.addChild(copyRootNode);
                this.createFilteredNodesAndConnections(nodeElement, copyRootNode, copyRootNode, legendLinks, diagram);
            }
            ++n2;
        }
        return diagram;
    }

    private NodeElement createFilteredNodeElement(NodeElement nodeElement) {
        IItemHandle itemHandle = nodeElement.getItemHandle();
        return new NodeElement(itemHandle);
    }

    private ILinkCollection getLinks(Collection<NodeElement> sources, LegendLinks linkTypes) {
        ILinkCollection links = null;
        IReference[] references = new IReference[sources.size()];
        int index = 0;
        for (NodeElement source : sources) {
            references[index++] = this.fReferenceFactory.createReferenceToItem(source.getItemHandle());
        }
        try {
            ILinkQueryPage page = this.fLinkManager.findLinksBySource(linkTypes.getLinkIdentifiers(), references, null);
            links = page.getAllLinksFromHereOn();
        }
        catch (TeamRepositoryException e) {
            Activator.getDefault().log("Unable to retrieve links for " + sources.size() + " source item(s)", e);
        }
        return links;
    }

    public void setContentProvider(ILinksViewerContentProvider provider) {
        super.setContentProvider((IContentProvider)provider);
    }

    public void setLinksViewerActionProvider(ILinksViewerActionProvider actionProvider) {
        this.fLinksViewerActionProvider = actionProvider;
    }

    public ILinksViewerActionProvider getLinksViewerActionProvider() {
        return this.fLinksViewerActionProvider;
    }

    private DiagramElement getCurrentlyDisplayedDiagram() {
        if (this.fFilteredDiagramElement != null) {
            return this.fFilteredDiagramElement;
        }
        return this.fDiagramElement;
    }

    private ArrayList<NodePart> getNodeParts(IItemHandle itemHandle) {
        ArrayList<NodePart> nodeParts = new ArrayList<NodePart>();
        Map map = this.fGraphicalViewer.getEditPartRegistry();
        ArrayList<NodeElement> nodeElements = this.getCurrentlyDisplayedDiagram().getNodeElements(itemHandle.getItemId());
        if (nodeElements != null) {
            for (NodeElement nodeElement : nodeElements) {
                NodePart nodePart = (NodePart)((Object)map.get(nodeElement));
                if (nodePart == null) continue;
                nodeParts.add(nodePart);
            }
        }
        return nodeParts;
    }

    public void setItemOpened(IItemHandle itemHandle, boolean isOpened) {
        ArrayList<NodePart> nodeParts = this.getNodeParts(itemHandle);
        if (nodeParts != null) {
            for (NodePart nodePart : nodeParts) {
                nodePart.setOpened(isOpened);
            }
        }
    }

    public void setItemActive(IItemHandle itemHandle, boolean isActive) {
        ArrayList<NodePart> nodeParts = this.getNodeParts(itemHandle);
        if (nodeParts != null) {
            for (NodePart nodePart : nodeParts) {
                nodePart.setActive(isActive);
            }
        }
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List getSelectionFromWidget() {
        return EMPTY_LIST;
    }

    protected void internalRefresh(Object input) {
        if (input != null) {
            new UIJob("Drawing links view"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ArrayList nodeParts;
                    ArrayList activeItemHandles = new ArrayList();
                    ArrayList openItemHandles = new ArrayList();
                    LinksViewer.this.findActiveOrOpenItemHandles(activeItemHandles, openItemHandles);
                    if (LinksViewer.this.fFilteredDiagramElement != null) {
                        LinksViewer.this.fGraphicalViewer.setContents((Object)LinksViewer.this.fFilteredDiagramElement);
                    } else {
                        LinksViewer.this.fGraphicalViewer.setContents((Object)LinksViewer.this.fDiagramElement);
                    }
                    for (IItemHandle activeItemHandle : activeItemHandles) {
                        nodeParts = LinksViewer.this.getNodeParts(activeItemHandle);
                        for (NodePart nodePart : nodeParts) {
                            nodePart.setActive(true);
                        }
                    }
                    for (IItemHandle openItemHandle : openItemHandles) {
                        nodeParts = LinksViewer.this.getNodeParts(openItemHandle);
                        for (NodePart nodePart : nodeParts) {
                            nodePart.setOpened(true);
                        }
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public void reveal(Object element) {
        IItemHandle itemToReveal = (IItemHandle)element;
        NodePart topmostNodePart = null;
        int lowestY = Integer.MAX_VALUE;
        ArrayList<NodePart> nodeParts = this.getNodeParts(itemToReveal);
        for (NodePart nodePart : nodeParts) {
            int y = nodePart.getFigure().getClientArea().y;
            if (y >= lowestY) continue;
            lowestY = y;
            topmostNodePart = nodePart;
        }
        if (topmostNodePart != null) {
            this.fGraphicalViewer.reveal(topmostNodePart);
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    public Control getControl() {
        return this.fGraphicalViewer.getControl();
    }

    private void refreshDiagram(IItemHandle[] itemHandles) {
        if (itemHandles != null) {
            ITeamRepository repo = (ITeamRepository)itemHandles[0].getOrigin();
            this.fLinkManager = (ILinkManager)repo.getClientLibrary(ILinkManager.class);
            this.fReferenceFactory = this.fLinkManager.referenceFactory();
            ILinksViewerContentProvider contentProvider = (ILinksViewerContentProvider)this.getContentProvider();
            LegendLinks legendLinks = new LegendLinks(contentProvider.getLinkTypes());
            this.fDiagramElement = this.createDiagram(itemHandles, legendLinks);
            if (legendLinks.containsAtLeastOneFilteredLinkType()) {
                this.fFilteredDiagramElement = this.createFilteredDiagram(legendLinks);
            }
            contentProvider.resolve(this.fDiagramElement.getAllUniqueNodeElementItemHandles());
        }
    }

    public void refresh(Object element, boolean updateLabels) {
        this.refreshDiagram((IItemHandle[])element);
        super.refresh(element, updateLabels);
    }

    public void refresh(Object element) {
        this.refreshDiagram((IItemHandle[])element);
        super.refresh(element);
    }

    public void linkTypesHaveChanged() {
        ILinksViewerContentProvider contentProvider = (ILinksViewerContentProvider)this.getContentProvider();
        LegendLinks linkTypes = new LegendLinks(contentProvider.getLinkTypes());
        this.fFilteredDiagramElement = linkTypes.containsAtLeastOneFilteredLinkType() ? this.createFilteredDiagram(linkTypes) : null;
        this.internalRefresh(this.getInput());
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.refreshDiagram((IItemHandle[])input);
        this.internalRefresh(input);
        super.inputChanged(input, oldInput);
    }

    public IItemHandle getItemHandleAt(int x, int y) {
        NodePart nodePart;
        IItemHandle itemHandle = null;
        EditPart editPart = this.fGraphicalViewer.findObjectAt(new Point(x, y));
        if (editPart != null && editPart instanceof NodePart && (nodePart = (NodePart)editPart) != null) {
            NodeElement nodeElement = (NodeElement)nodePart.getModel();
            itemHandle = nodeElement.getItemHandle();
        }
        return itemHandle;
    }

    public void update(Object element, String[] properties) {
        this.internalRefresh(this.getInput());
        super.update(element, properties);
    }

    public void update(Object[] elements, String[] properties) {
        this.internalRefresh(this.getInput());
        super.update(elements, properties);
    }

    private void findActiveOrOpenItemHandles(ArrayList<IItemHandle> activeItemHandles, ArrayList<IItemHandle> openItemHandles) {
        IItemHandle[] allUniqueNodeElementItemHandles;
        DiagramElement currentlyDisplayedDiagram = this.getCurrentlyDisplayedDiagram();
        IItemHandle[] iItemHandleArray = allUniqueNodeElementItemHandles = currentlyDisplayedDiagram.getAllUniqueNodeElementItemHandles();
        int n = allUniqueNodeElementItemHandles.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandle itemHandle = iItemHandleArray[n2];
            ArrayList<NodePart> nodeParts = this.getNodeParts(itemHandle);
            if (!nodeParts.isEmpty()) {
                NodePart firstNodePart = nodeParts.get(0);
                if (firstNodePart.isActive()) {
                    activeItemHandles.add(itemHandle);
                }
                if (firstNodePart.isOpened()) {
                    openItemHandles.add(itemHandle);
                }
            }
            ++n2;
        }
    }

    private class LegendLinks {
        private HashMap<String, ILinksViewerContentProvider.LinkType> fLinkTypeMap;
        private ILinksViewerContentProvider.LinkType[] fLinkTypes;

        public LegendLinks(ILinksViewerContentProvider.LinkType[] linkTypes) {
            this.fLinkTypes = linkTypes;
            this.fLinkTypeMap = new HashMap();
            ILinksViewerContentProvider.LinkType[] linkTypeArray = linkTypes;
            int n = linkTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ILinksViewerContentProvider.LinkType linkType = linkTypeArray[n2];
                this.fLinkTypeMap.put(linkType.getIdentifier(), linkType);
                ++n2;
            }
        }

        public ILinksViewerContentProvider.LinkType getLinkType(String linkIdentifier) {
            return this.fLinkTypeMap.get(linkIdentifier);
        }

        public String[] getLinkIdentifiers() {
            Set<String> keys = this.fLinkTypeMap.keySet();
            return keys.toArray(new String[keys.size()]);
        }

        public ILinksViewerContentProvider.LinkType[] getLinkTypes() {
            return this.fLinkTypes;
        }

        private boolean containsAtLeastOneFilteredLinkType() {
            boolean containsAtLeastOneFilteredLinkType = false;
            for (ILinksViewerContentProvider.LinkType linkType : this.fLinkTypeMap.values()) {
                if (linkType.isVisible()) continue;
                containsAtLeastOneFilteredLinkType = true;
                break;
            }
            return containsAtLeastOneFilteredLinkType;
        }
    }
}

