/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.itemview;

import com.ibm.team.jface.GradientUtilities;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.itemview.ItemViewControl;
import com.ibm.team.jface.itemview.Messages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HeaderControlsContainer
extends Composite {
    private ItemViewControl fItemViewControl;
    private Composite fControlsContainer;
    private ResourceManager fResourceManager;
    private String fTitle;
    private String fStatusLabel;
    private boolean fShowFullContents;
    private boolean fSideBarVisible;

    public HeaderControlsContainer(ItemViewControl itemViewControl, int style) {
        super(itemViewControl.getHeaderContainer(), style);
        this.fItemViewControl = itemViewControl;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
    }

    public void create(FormToolkit toolkit) {
        boolean isEmbedded = toolkit != null;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 1, true, false));
        if (isEmbedded) {
            toolkit.paintBordersFor((Composite)this);
            toolkit.adapt((Composite)this);
        } else {
            GradientUtilities.setVerticalGradientWithBottomLine(this, this.getDisplay().getSystemColor(1), JazzResources.getColor("com.ibm.team.jface.itemview.GradientColor"), JazzResources.getColor("com.ibm.team.jface.itemview.OutlineColor"));
        }
        Composite titleContainer = new Composite((Composite)this, 0);
        titleContainer.setLayout((Layout)new GridLayout(2, false));
        titleContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        Label imgLabel = new Label(titleContainer, 0);
        imgLabel.setImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.NEWS));
        imgLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        ((GridData)imgLabel.getLayoutData()).verticalSpan = 2;
        Label titleLabel = this.createTitle(titleContainer, "Foo", 0);
        titleLabel.setText(this.fTitle);
        Label statusLabel = new Label(titleContainer, 0);
        statusLabel.setText(this.fStatusLabel);
        GridLayout controlsLayout = new GridLayout(1, false);
        controlsLayout.marginWidth = 0;
        controlsLayout.marginHeight = 0;
        this.fControlsContainer = new Composite((Composite)this, 0);
        this.fControlsContainer.setLayout((Layout)controlsLayout);
        this.fControlsContainer.setLayoutData((Object)new GridData(0x1000008, 0x1000008, false, true));
        Composite toggleComposite = isEmbedded ? toolkit.createComposite(this.fControlsContainer, 0) : new Composite(this.fControlsContainer, 0);
        toggleComposite.setLayout((Layout)new GridLayout(1, false));
        toggleComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        ToolBar toggleBar = new ToolBar(toggleComposite, 0x820000);
        toggleBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        final ToolItem collapseAll = new ToolItem(toggleBar, 16);
        collapseAll.setImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.COLLAPSE_ITEMS));
        collapseAll.setToolTipText(Messages.HeaderControlsContainer_EXCERTPS);
        collapseAll.setSelection(!this.fShowFullContents);
        collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (collapseAll.getSelection()) {
                    HeaderControlsContainer.this.fItemViewControl.notifyCollapsedAll();
                }
            }
        });
        final ToolItem expandAll = new ToolItem(toggleBar, 16);
        expandAll.setImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.EXPAND_ITEMS));
        expandAll.setToolTipText(Messages.HeaderControlsContainer_FULL_CONTENT);
        expandAll.setSelection(this.fShowFullContents);
        expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (expandAll.getSelection()) {
                    HeaderControlsContainer.this.fItemViewControl.notifyExpandedAll();
                }
            }
        });
        new ToolItem(toggleBar, 2);
        final ToolItem toggleSideBar = new ToolItem(toggleBar, 32);
        toggleSideBar.setImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.TOGGLE_SIDEBAR));
        toggleSideBar.setToolTipText(Messages.HeaderControlsContainer_SHOW_SIDEBAR);
        toggleSideBar.setSelection(this.fSideBarVisible);
        toggleSideBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HeaderControlsContainer.this.fItemViewControl.notifySideBarToggled(toggleSideBar.getSelection());
            }
        });
        toggleBar.pack();
    }

    private Label createTitle(Composite parent, String text, int style) {
        Label l = new Label(parent, style);
        l.setText(text);
        l.setForeground(JazzResources.getColor("com.ibm.team.jface.itemview.TitleColor"));
        l.setFont(JFaceResources.getHeaderFont());
        return l;
    }

    public void setStatusLabel(String statusLabel) {
        this.fStatusLabel = statusLabel;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    void setShowFullContents(boolean showFullContents) {
        this.fShowFullContents = showFullContents;
    }

    void setSideBarVisible(boolean visible) {
        this.fSideBarVisible = visible;
    }
}

