/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.dashboard.ISection;
import com.ibm.team.jface.internal.JFacePlugin;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class SectionDescriptor {
    private static final HashMap<String, IConfigurationElement> fSectionTypes = new HashMap();
    static final String MEMENTO_SECTION_DESCRIPTORS = "sectionDescriptors";
    static final String MEMENTO_USER_SETTINGS = "userSettings";
    private static final String SECTION_CLASS = "class";
    private static final String SECTION_ICON = "icon";
    private static final String SECTION_IS_TEMPLATE = "isTemplate";
    private static final String SECTION_ID = "id";
    private static final String SECTION_IS_OPENABLE = "isOpenable";
    private static final String SECTION_IS_DELETABLE = "isDeletable";
    private static final String SECTION_IS_CLONEABLE = "isCloneable";
    private static final String SECTION_NAME = "name";
    private static final String SECTION_TYPE_ID = "type_id";
    private static final String SECTION_PARAMETER_ELEMENT = "parameter";
    private static final String SECTION_PARAMETER_NAME_ATTRIBUTE = "name";
    private static final String SECTION_PARAMETER_VALUE_ATTRIBUTE = "value";
    private static final String SECTION_PARAMETER_CLASS_ATTRIBUTE = "class";
    private static final String SECTION_HIDE_CHEVRON = "hideChevron";
    private String fId;
    private boolean fIsErrorLoading;
    private boolean fIsOpenable;
    private boolean fIsCloneable;
    private boolean fIsDeletable;
    private boolean fHideChevron;
    private String fName;
    private String fNamespace;
    private IMemento fSavedUserSettings;
    private WeakReference<ISection> fWeakSection;
    private String fSectionClassName;
    private String fSectionIconPath;
    private String fTypeId;
    private boolean fIsTemplate;
    private IConfigurationElement fConfigElement;
    private boolean fIsDeleted;

    private SectionDescriptor(String id, String name, IConfigurationElement configElement) {
        this.fId = id;
        this.fName = name;
        this.fConfigElement = configElement;
        if (configElement != null) {
            this.fNamespace = configElement.getNamespaceIdentifier();
            this.fTypeId = configElement.getAttribute(SECTION_ID);
            this.fSectionClassName = configElement.getNamespaceIdentifier();
            this.fSectionIconPath = configElement.getAttribute(SECTION_ICON);
            this.fIsOpenable = Boolean.valueOf(configElement.getAttribute(SECTION_IS_OPENABLE));
            this.fIsDeletable = Boolean.valueOf(configElement.getAttribute(SECTION_IS_DELETABLE));
            String isCloneableVal = configElement.getAttribute(SECTION_IS_CLONEABLE);
            this.fIsCloneable = isCloneableVal != null ? Boolean.valueOf(isCloneableVal) : true;
            this.fHideChevron = Boolean.valueOf(configElement.getAttribute(SECTION_HIDE_CHEVRON));
            this.fIsTemplate = Boolean.valueOf(configElement.getAttribute(SECTION_IS_TEMPLATE));
            if (this.fTypeId != null) {
                this.fIsTemplate = false;
            }
        }
    }

    boolean createSection() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                JFacePlugin.getDefault().log("createSection()", e);
            }

            public void run() throws Exception {
                IConfigurationElement configElement = (IConfigurationElement)fSectionTypes.get(SectionDescriptor.this.fTypeId);
                SectionDescriptor.this.fIsErrorLoading = true;
                if (configElement != null) {
                    ISection section = (ISection)configElement.createExecutableExtension("class");
                    if (section != null) {
                        SectionDescriptor.this.fWeakSection = new WeakReference<ISection>(section);
                    }
                    SectionDescriptor.this.fIsErrorLoading = false;
                }
            }
        });
        return this.fWeakSection != null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SectionDescriptor)) {
            return false;
        }
        return this.fId.equals(((SectionDescriptor)obj).getId());
    }

    final String getId() {
        return this.fId;
    }

    String getName() {
        return this.fName;
    }

    String getNamespace() {
        return this.fNamespace;
    }

    IMemento getSavedUserSettings() {
        return this.fSavedUserSettings;
    }

    ISection getSection() {
        return this.fWeakSection != null ? (ISection)this.fWeakSection.get() : null;
    }

    public String getSectionClassName() {
        return this.fSectionClassName;
    }

    String getSectionIconPath() {
        return this.fSectionIconPath;
    }

    String getTypeId() {
        return this.fTypeId;
    }

    public int hashCode() {
        return this.fId.hashCode();
    }

    boolean isOpenable() {
        return this.fIsOpenable;
    }

    boolean isDeletable() {
        return this.fIsDeletable;
    }

    boolean isCloneable() {
        return this.fIsCloneable;
    }

    public boolean isChevronHidden() {
        return this.fHideChevron;
    }

    void save(IMemento memento) {
        if (this.fIsDeleted) {
            return;
        }
        IMemento sectionMemento = memento.createChild(MEMENTO_SECTION_DESCRIPTORS);
        sectionMemento.putString(SECTION_ID, this.getId());
        sectionMemento.putString("name", this.getName());
        sectionMemento.putString(SECTION_TYPE_ID, this.getTypeId());
        sectionMemento.putString("class", this.getSectionClassName());
        sectionMemento.putString(SECTION_IS_OPENABLE, Boolean.toString(this.isOpenable()));
        sectionMemento.putString(SECTION_IS_DELETABLE, Boolean.toString(this.isDeletable()));
        sectionMemento.putString(SECTION_IS_CLONEABLE, Boolean.toString(this.isCloneable()));
        sectionMemento.putString(SECTION_HIDE_CHEVRON, Boolean.toString(this.isChevronHidden()));
        IMemento userSettings = sectionMemento.createChild(MEMENTO_USER_SETTINGS);
        if (!this.fIsErrorLoading && this.fWeakSection != null) {
            ISection section = (ISection)this.fWeakSection.get();
            if (section != null) {
                section.saveState(userSettings);
            }
        } else if (this.fSavedUserSettings != null) {
            userSettings.putMemento(this.fSavedUserSettings);
        }
    }

    void setDeleted() {
        this.fIsDeleted = true;
    }

    void setId(String id) {
        this.fId = id;
    }

    void setName(String name) {
        this.fName = name;
    }

    void setOpenable(boolean isOpenable) {
        this.fIsOpenable = isOpenable;
    }

    void setDeletable(boolean isDeletable) {
        this.fIsDeletable = isDeletable;
    }

    void setCloneable(boolean isCloneable) {
        this.fIsCloneable = isCloneable;
    }

    void setHideChevron(boolean hideChevron) {
        this.fHideChevron = hideChevron;
    }

    void setSavedUserSettings(IMemento settings) {
        this.fSavedUserSettings = settings;
    }

    void setSectionClassName(String sectionClassName) {
        this.fSectionClassName = sectionClassName;
    }

    void setSectionIconPath(String iconPath) {
        this.fSectionIconPath = iconPath;
    }

    void setTypeId(String typeId) {
        this.fTypeId = typeId;
    }

    static SectionDescriptor cloneFrom(SectionDescriptor sectionDescriptor, String newId, String name) {
        XMLMemento sectionMemento = XMLMemento.createWriteRoot((String)"teamcentral");
        sectionDescriptor.save((IMemento)sectionMemento);
        SectionDescriptor clonedSection = SectionDescriptor.createFrom(sectionMemento.getChild(MEMENTO_SECTION_DESCRIPTORS));
        clonedSection.setId(newId);
        clonedSection.setName(name);
        return clonedSection;
    }

    static SectionDescriptor createFrom(IConfigurationElement configElement) {
        String id = configElement.getAttribute(SECTION_ID);
        String name = configElement.getAttribute("name");
        String iconPath = configElement.getAttribute(SECTION_ICON);
        Assert.isNotNull((Object)id);
        boolean isOpenable = Boolean.valueOf(configElement.getAttribute(SECTION_IS_OPENABLE));
        boolean isDeletable = Boolean.valueOf(configElement.getAttribute(SECTION_IS_DELETABLE));
        String isCloneableVal = configElement.getAttribute(SECTION_IS_CLONEABLE);
        boolean isCloneable = isCloneableVal != null ? Boolean.valueOf(isCloneableVal) : true;
        boolean isTemplate = Boolean.valueOf(configElement.getAttribute(SECTION_IS_TEMPLATE));
        boolean hideChevron = Boolean.valueOf(configElement.getAttribute(SECTION_HIDE_CHEVRON));
        SectionDescriptor sectionDesc = new SectionDescriptor(id, name, configElement);
        sectionDesc.setSectionIconPath(iconPath);
        sectionDesc.setOpenable(isOpenable);
        sectionDesc.setDeletable(isDeletable);
        sectionDesc.setCloneable(isCloneable);
        sectionDesc.setIsTemplate(isTemplate);
        sectionDesc.setHideChevron(hideChevron);
        fSectionTypes.put(id, configElement);
        return sectionDesc;
    }

    private void setIsTemplate(boolean isTemplate) {
        this.fIsTemplate = isTemplate;
    }

    private static SectionDescriptor createFrom(IMemento memento) {
        String id = memento.getString(SECTION_ID);
        String name = memento.getString("name");
        String typeId = memento.getString(SECTION_TYPE_ID);
        IConfigurationElement configElement = fSectionTypes.get(typeId);
        Assert.isNotNull((Object)typeId);
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)name);
        SectionDescriptor sectionDesc = new SectionDescriptor(id, name, configElement);
        if (configElement == null) {
            sectionDesc.setTypeId(memento.getString(SECTION_TYPE_ID));
            sectionDesc.setSectionClassName(memento.getString("class"));
            sectionDesc.setOpenable(Boolean.valueOf(memento.getString(SECTION_IS_OPENABLE)));
            sectionDesc.setDeletable(Boolean.valueOf(memento.getString(SECTION_IS_DELETABLE)));
            sectionDesc.setCloneable(Boolean.valueOf(memento.getString(SECTION_IS_CLONEABLE)));
            sectionDesc.setHideChevron(Boolean.valueOf(memento.getString(SECTION_HIDE_CHEVRON)));
        } else if (!id.equals(typeId)) {
            sectionDesc.setDeletable(true);
        }
        sectionDesc.setSavedUserSettings(memento.getChild(MEMENTO_USER_SETTINGS));
        return sectionDesc;
    }

    static SectionDescriptor[] createSections(IMemento memento) {
        ArrayList<SectionDescriptor> sections = new ArrayList<SectionDescriptor>();
        if (memento != null && memento.getChildren(MEMENTO_SECTION_DESCRIPTORS).length > 0) {
            IMemento[] sectionDescriptors = memento.getChildren(MEMENTO_SECTION_DESCRIPTORS);
            int i = 0;
            while (i < sectionDescriptors.length) {
                SectionDescriptor sd = SectionDescriptor.createFrom(sectionDescriptors[i]);
                if (!"com.ibm.magnolia.workitems.views.scrapSection".equals(sd.getId())) {
                    sections.add(sd);
                }
                ++i;
            }
            return sections.toArray(new SectionDescriptor[sections.size()]);
        }
        return new SectionDescriptor[0];
    }

    public String getParameter(String parameterName) {
        IConfigurationElement parameterElement = this.getParameterElement(parameterName);
        return parameterElement != null ? parameterElement.getValue() : null;
    }

    public String getParameterValue(String parameterName) {
        return this.internalGetParameterValue(parameterName);
    }

    public Object createExecutableParameter(String parameterName) throws CoreException {
        IConfigurationElement parameterElement = this.getParameterElement(parameterName);
        return parameterElement != null ? parameterElement.createExecutableExtension("class") : null;
    }

    public boolean hasParameter(String parameterName) {
        return this.getParameterElement(parameterName) != null;
    }

    private IConfigurationElement getParameterElement(String parameterName) {
        IConfigurationElement configElement = fSectionTypes.get(this.fTypeId);
        IConfigurationElement[] elements = configElement.getChildren(SECTION_PARAMETER_ELEMENT);
        int i = 0;
        while (i < elements.length) {
            if (parameterName.equals(elements[i].getAttribute("name"))) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }

    private String internalGetParameterValue(String parameterName) {
        IConfigurationElement configElement = fSectionTypes.get(this.fTypeId);
        IConfigurationElement[] elements = configElement.getChildren(SECTION_PARAMETER_ELEMENT);
        int i = 0;
        while (i < elements.length) {
            if (parameterName.equals(elements[i].getAttribute("name"))) {
                return elements[i].getAttribute(SECTION_PARAMETER_VALUE_ATTRIBUTE);
            }
            ++i;
        }
        return null;
    }

    public boolean isTemplate() {
        return this.fIsTemplate;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigElement;
    }
}

