/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal;

import com.ibm.team.foundation.common.internal.util.Dates;
import com.ibm.team.foundation.rcp.core.IDateProvider;
import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.internal.Messages;
import com.ibm.team.jface.itemview.IItemViewUIAdvisor;
import com.ibm.team.jface.itemview.ItemViewUIConfigurer;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import com.ibm.team.jface.itemview.ItemViewerSorter;
import com.ibm.team.jface.itemview.MarkupItemView;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;

public class ItemViewUIAdvisor
implements IItemViewUIAdvisor {
    private static final long DAY = 86400000L;
    private final Collator fCollator = Collator.getInstance();

    public void configure(ItemViewUIConfigurer configurer) {
        configurer.addFilter(new ItemViewerFilter(new NotFromTodayFilter(), "com.ibm.team.jface.internal.TodayFilter", Messages.ItemViewUIAdvisor_FILTER_NEWS_OLDER_ONE_DAY, 1));
        configurer.addFilter(new ItemViewerFilter(new ReadItemsFilter(), "com.ibm.team.jface.internal.ReadFilter", Messages.ItemViewUIAdvisor_FILTER_READ_NEWS, 1));
        configurer.addSorter(new ItemViewerSorter(new TitleSorter(), "com.ibm.team.jface.internal.TitleSorter", Messages.ItemViewUIAdvisor_SORT_TITLE));
        ItemViewerSorter dateSorter = new ItemViewerSorter(new DateSorter(), "com.ibm.team.jface.internal.DateSorter", Messages.ItemViewUIAdvisor_SORT_DATE);
        configurer.addSorter(dateSorter);
        configurer.setDefaultSorter(dateSorter);
    }

    class DateSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object e1, Object e2) {
            IDateProvider dateProvider1 = MarkupItemView.getDateProvider(e1);
            IDateProvider dateProvider2 = MarkupItemView.getDateProvider(e2);
            if (dateProvider1 != null && dateProvider2 != null) {
                Date date1 = dateProvider1.getDate();
                Date date2 = dateProvider2.getDate();
                if (date2 != null) {
                    return Dates.compareTo((Date)date2, (Date)date1);
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class NotFromTodayFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IDateProvider dateProvider = MarkupItemView.getDateProvider(element);
            if (dateProvider != null) {
                Date date = dateProvider.getDate();
                Date now = new Date();
                return now.getTime() - date.getTime() <= 86400000L;
            }
            return false;
        }
    }

    class ReadItemsFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IAdaptable adapter;
            IReadStateTracker tracker;
            if (element instanceof GenericAggregationBin) {
                element = ((GenericAggregationBin)element).getMostRecent();
            }
            if (element instanceof IReadStateTracker) {
                return !((IReadStateTracker)element).isMarkedRead();
            }
            if (element instanceof IAdaptable && (tracker = (IReadStateTracker)(adapter = (IAdaptable)element).getAdapter(IReadStateTracker.class)) != null) {
                return !tracker.isMarkedRead();
            }
            return true;
        }
    }

    class TitleSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object e1, Object e2) {
            IDomainAdapter domainAdapter1 = DomainAdapterUtils.getDomainAdapter(e1);
            IDomainAdapter domainAdapter2 = DomainAdapterUtils.getDomainAdapter(e2);
            return this.compare(viewer, e1, e2, domainAdapter1, domainAdapter2);
        }

        public int compare(Viewer viewer, Object e1, Object e2, IDomainAdapter adapter1, IDomainAdapter adapter2) {
            if (adapter1 != null && adapter2 != null) {
                String title1 = adapter1.generateTitle(e1);
                String title2 = adapter2.generateTitle(e2);
                if (title1 != null) {
                    return ItemViewUIAdvisor.this.fCollator.compare(title1, title2);
                }
            }
            return super.compare(viewer, e1, e2);
        }

        public void sort(final Viewer viewer, Object[] elements) {
            final HashMap<Object, IDomainAdapter> domainAdapters = new HashMap<Object, IDomainAdapter>();
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof GenericAggregationBin) {
                    element = ((GenericAggregationBin)element).getMostRecent();
                }
                domainAdapters.put(element, DomainAdapterUtils.getDomainAdapter(element));
                ++i;
            }
            Arrays.sort(elements, new Comparator(){

                public int compare(Object a, Object b) {
                    if (a instanceof GenericAggregationBin) {
                        a = ((GenericAggregationBin)a).getMostRecent();
                    }
                    if (b instanceof GenericAggregationBin) {
                        b = ((GenericAggregationBin)b).getMostRecent();
                    }
                    return TitleSorter.this.compare(viewer, a, b, (IDomainAdapter)domainAdapters.get(b), (IDomainAdapter)domainAdapters.get(b));
                }
            });
        }
    }
}

