/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.charts;

import com.ibm.team.jface.charts.BarViewer;
import com.ibm.team.jface.charts.IChartElementProviderExt;
import com.ibm.team.jface.charts.IProgressChartElementProvider;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class SingleBarViewer
extends BarViewer {
    private static final int MINIMAL_BAR_HEIGHT = 6;
    private static final int PREFERRED_BAR_HEIGHT = 9;
    private static final int ANNOTATION_SPACING = 5;
    private Rectangle fProgressDifBounds;
    private boolean fDrawTopText;
    private boolean fDrawPercentage;

    public SingleBarViewer(Composite composite, String chartName, boolean useGradients) {
        super(composite, chartName, useGradients);
        this.fDrawTopText = true;
    }

    public SingleBarViewer(Composite composite, String chartName, boolean useGradients, boolean drawTopText, boolean drawPercentage) {
        super(composite, chartName, useGradients);
        this.fDrawTopText = drawTopText;
        this.fDrawPercentage = drawPercentage;
    }

    public Object getElement(Point position) {
        if (this.fChartElementProvider instanceof IProgressChartElementProvider && this.fProgressDifBounds != null && this.fProgressDifBounds.contains(position)) {
            return this;
        }
        Object[] elements = this.fContentProvider.getElements(null);
        if (elements == null || elements.length == 0) {
            return null;
        }
        if (elements.length == 1) {
            return elements[0];
        }
        float[] relatives = this.getRelatives();
        int curX = 0;
        int a = 0;
        while (a < elements.length) {
            if (position.x < (curX += (int)((float)this.getChartBounds().width * relatives[a]))) {
                return elements[a];
            }
            ++a;
        }
        return null;
    }

    public Rectangle getElementBounds(Point position) {
        if (this.fChartElementProvider instanceof IProgressChartElementProvider && this.fProgressDifBounds != null && this.fProgressDifBounds.contains(position)) {
            return this.fProgressDifBounds;
        }
        Object[] elements = this.fContentProvider.getElements(null);
        if (elements.length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        float[] relatives = this.getRelatives();
        int curX = 0;
        int hoveredIndex = -1;
        int a = 0;
        while (a < elements.length) {
            if (position.x < (curX += (int)((float)this.getChartBounds().width * relatives[a]))) {
                hoveredIndex = a;
                curX -= (int)((float)this.getChartBounds().width * relatives[a]);
                break;
            }
            ++a;
        }
        if (hoveredIndex == -1) {
            hoveredIndex = elements.length - 1;
        }
        int x = curX;
        int y = this.getChartBounds().y;
        int width = (int)((float)this.getChartBounds().width * relatives[hoveredIndex]);
        int height = this.getChartBounds().height;
        return new Rectangle(x, y, width, height);
    }

    public Point getMinimalSize() {
        GC gc = new GC((Drawable)this.fComposite);
        int textHeight = gc.textExtent((String)"Fog").y;
        int barMinHeight = 6;
        gc.dispose();
        return new Point(-1, textHeight * (this.fDrawTopText ? 2 : 1) + barMinHeight + (!"".equals(this.fChartName) ? textHeight : 0) + 6);
    }

    public Point getPreferredSize() {
        GC gc = new GC((Drawable)this.fComposite);
        int textHeight = gc.textExtent((String)"Fog").y;
        int barMinHeight = 9;
        gc.dispose();
        return new Point(-1, textHeight * (this.fDrawTopText ? 2 : 1) + barMinHeight + (!"".equals(this.fChartName) ? textHeight : 0) + 6);
    }

    protected void onPaint(GC gc) {
        Object[] elements = this.fContentProvider.getElements(null);
        float[] relatives = this.getRelatives();
        int curX = 0;
        boolean inProgressMode = this.fChartElementProvider instanceof IProgressChartElementProvider;
        boolean drawStringsTransparent = this.getDrawStringsTransparent();
        ArrayList<Rectangle> cacheBarBounds = new ArrayList<Rectangle>();
        int chartLabelHeight = 0;
        if (!"".equals(this.fChartName)) {
            chartLabelHeight = gc.textExtent((String)this.fChartName).y;
            gc.drawString(String.valueOf(this.fChartName) + ": ", 0, 0, true);
        }
        int a = 0;
        while (a < elements.length) {
            boolean useShortText;
            Color barActiveFgColor;
            Color barActiveBgColor;
            Color barFgColor;
            Color barBgColor;
            Rectangle barBounds = new Rectangle(curX, chartLabelHeight, (int)((float)this.getChartBounds().width * relatives[a]), this.getChartBounds().height);
            cacheBarBounds.add(barBounds);
            Font defaultFont = gc.getFont();
            Font font = this.fChartElementProvider.getFont(elements[a]);
            Font annotationFont = this.fChartElementProvider.getAnnotationFont(elements[a]);
            if (font != null) {
                gc.setFont(font);
            }
            if (this.fChartElementProvider instanceof IChartElementProviderExt) {
                IChartElementProviderExt extProvider = (IChartElementProviderExt)this.fChartElementProvider;
                barBgColor = extProvider.getBackgroundColor(elements[a]);
                barFgColor = extProvider.getForegroundColor(elements[a]);
                barActiveBgColor = extProvider.getActiveBackgroundColor(elements[a]);
                barActiveFgColor = extProvider.getActiveForegroundColor(elements[a]);
            } else {
                barBgColor = this.fChartElementProvider.getColor(elements[a] + "_bg");
                barFgColor = this.fChartElementProvider.getColor(elements[a] + "_fg");
                barActiveBgColor = this.fChartElementProvider.getColor(elements[a] + "_activeBg");
                barActiveFgColor = this.fChartElementProvider.getColor(elements[a] + "_activeFg");
            }
            gc.setForeground(this.getTextColor());
            int posX = 0;
            int textHeight = 0;
            if (this.fDrawTopText) {
                String value = this.fChartElementProvider.getValueAsString(elements[a]);
                String annotation = this.fChartElementProvider.getAnnotation(elements[a]);
                if (inProgressMode) {
                    if (a == 0) {
                        value = ((IProgressChartElementProvider)this.fChartElementProvider).getMinLabel();
                    } else if (a == elements.length - 1) {
                        value = ((IProgressChartElementProvider)this.fChartElementProvider).getMaxLabel();
                    }
                }
                Point valueSize = gc.textExtent(value);
                valueSize.y += 3;
                int textWidth = valueSize.x;
                textHeight = valueSize.y;
                Point annotationSize = null;
                int annotationWidth = 0;
                if (annotation != null) {
                    if (annotationFont != null) {
                        gc.setFont(annotationFont);
                    }
                    annotationSize = gc.textExtent(annotation);
                    annotationWidth = annotationSize.x;
                    textWidth += 5 + annotationWidth;
                    textHeight = Math.max(textHeight, annotationSize.y);
                    gc.setFont(font != null ? font : defaultFont);
                }
                posX = curX + barBounds.width / 2 - textWidth / 2;
                if (barBounds.width == 0) {
                    posX = curX + textWidth + 5;
                }
                if (a == 0) {
                    posX = 0;
                } else if (a == elements.length - 1) {
                    posX = this.getChartBounds().width - textWidth;
                }
                if (posX < 0) {
                    posX = 0;
                } else if (posX + textWidth > this.getChartBounds().width) {
                    posX = this.getChartBounds().width - textWidth;
                }
                if (!drawStringsTransparent) {
                    gc.setBackground(this.fComposite.getBackground());
                }
                gc.drawString(value, posX, barBounds.y, drawStringsTransparent);
                if (annotation != null) {
                    if (annotationFont != null) {
                        gc.setFont(annotationFont);
                    }
                    gc.drawString(annotation, posX + valueSize.x + 5, barBounds.y, drawStringsTransparent);
                    if (annotationFont != null) {
                        gc.setFont(font != null ? font : defaultFont);
                    }
                }
            }
            String name = (useShortText = this.useShortText(gc, elements[a], relatives[a])) ? this.fChartElementProvider.getShortText(elements[a]) : this.fChartElementProvider.getText(elements[a]);
            Point nameSize = gc.textExtent(name);
            posX = curX + barBounds.width / 2 - nameSize.x / 2;
            if (barBounds.width == 0) {
                posX = curX + nameSize.x + 5;
            }
            if (a == 0) {
                posX = 0;
            } else if (a == elements.length - 1) {
                posX = this.getChartBounds().width - nameSize.x;
            }
            if (posX < 0) {
                posX = 0;
            } else if (posX + nameSize.x > this.getChartBounds().width) {
                posX = this.getChartBounds().width - nameSize.x;
            }
            if (!drawStringsTransparent) {
                gc.setBackground(this.fComposite.getBackground());
            }
            gc.drawString(name, posX, barBounds.height - nameSize.y, drawStringsTransparent);
            int availableBarHeight = barBounds.height - textHeight - nameSize.y - chartLabelHeight - 3;
            if (availableBarHeight <= 0) {
                availableBarHeight = 1;
            }
            gc.setBackground(this.fSelectedBar == elements[a] ? barActiveBgColor : barBgColor);
            if (this.fUseGradients) {
                gc.setForeground(this.fSelectedBar == elements[a] ? barActiveFgColor : barFgColor);
                gc.fillGradientRectangle(barBounds.x + 1, barBounds.y + textHeight + 1, barBounds.width - 2, availableBarHeight / 2, true);
            } else {
                gc.setForeground(this.fSelectedBar == elements[a] ? barActiveFgColor : barFgColor);
                gc.fillRectangle(barBounds.x + 1, barBounds.y + textHeight, barBounds.width - 2, availableBarHeight / 2);
            }
            gc.setBackground(this.fSelectedBar == elements[a] ? barActiveFgColor : barFgColor);
            gc.setForeground(this.fSelectedBar == elements[a] ? barActiveBgColor : barBgColor);
            if (this.fUseGradients) {
                gc.fillGradientRectangle(barBounds.x + 1, barBounds.y + 1 + availableBarHeight / 2 + textHeight, barBounds.width - 2, availableBarHeight / 2 - 1, true);
            } else {
                gc.fillRectangle(barBounds.x + 1, barBounds.y + availableBarHeight / 2 + textHeight, barBounds.width - 2, availableBarHeight / 2);
            }
            if (availableBarHeight > 1) {
                gc.setForeground(barActiveBgColor);
                gc.drawRectangle(barBounds.x, barBounds.y + textHeight, barBounds.width - 1, barBounds.height - 1 - textHeight - nameSize.y - chartLabelHeight - 3);
                if (this.fFocussedBar == elements[a]) {
                    Rectangle focusBounds = new Rectangle(barBounds.x + 1, barBounds.y + textHeight + 1, barBounds.width - 2, barBounds.height - textHeight - nameSize.y - chartLabelHeight - 2);
                    if (focusBounds.width <= 0) {
                        focusBounds.width = 2;
                        focusBounds.x = posX + 1;
                    }
                    gc.setForeground(this.fComposite.getDisplay().getSystemColor(2));
                    gc.drawFocus(focusBounds.x, focusBounds.y, focusBounds.width, focusBounds.height - 3);
                }
            }
            curX += barBounds.width;
            ++a;
        }
        if ((inProgressMode || this.fDrawPercentage) && elements.length == 2) {
            int qryValueA = this.fChartElementProvider.getValue(elements[0]);
            int qryValueB = this.fChartElementProvider.getValue(elements[1]);
            int qryValueSum = qryValueA + qryValueB;
            int todayPosX = 0;
            IProgressChartElementProvider progressProvider = null;
            int labelHeight = gc.textExtent((String)"Fog").y;
            boolean isProgressPositive = false;
            curX = 0;
            if (inProgressMode) {
                int actualProgress = qryValueA;
                progressProvider = (IProgressChartElementProvider)this.fChartElementProvider;
                int exptectedProgress = (int)((float)(qryValueSum * progressProvider.getValue()) / (float)progressProvider.getMaximum());
                isProgressPositive = actualProgress >= exptectedProgress;
                gc.setForeground(progressProvider.getProgressFontColor(isProgressPositive));
                todayPosX = (int)((float)(this.getChartBounds().width * progressProvider.getValue()) / (float)progressProvider.getMaximum());
                int progressDif = actualProgress - exptectedProgress;
                if (progressDif < 0) {
                    progressDif *= -1;
                }
                String appendix = isProgressPositive ? "+" : "-";
                String progressDifValue = String.valueOf(appendix) + String.valueOf(progressDif);
                int progressDifLabelWidth = gc.textExtent((String)progressDifValue).x;
                int progressDifLabelPoxX = todayPosX - progressDifLabelWidth / 2;
                int minBound = gc.textExtent((String)progressProvider.getMinLabel()).x + 1;
                int maxBound = this.getChartBounds().width - gc.textExtent((String)progressProvider.getMaxLabel()).x - 4;
                if (progressDifLabelPoxX < minBound) {
                    progressDifLabelPoxX = minBound;
                    progressDifValue = "|" + progressDifValue;
                }
                if (progressDifLabelPoxX + progressDifLabelWidth > maxBound) {
                    progressDifLabelPoxX = maxBound - progressDifLabelWidth;
                    progressDifValue = String.valueOf(progressDifValue) + "|";
                }
                gc.drawString(progressDifValue, progressDifLabelPoxX, 0, true);
                int trianglePosY = this.getChartBounds().height - labelHeight - 3;
                if (todayPosX <= 0) {
                    todayPosX = 2;
                } else if (todayPosX >= this.getChartBounds().width) {
                    todayPosX = this.getChartBounds().width - 3;
                }
                gc.drawPoint(todayPosX, trianglePosY);
                gc.drawLine(todayPosX - 1, trianglePosY + 1, todayPosX + 1, trianglePosY + 1);
                gc.drawLine(todayPosX - 2, trianglePosY + 2, todayPosX + 2, trianglePosY + 2);
            }
            if (qryValueA == 0 && qryValueB == 0) {
                return;
            }
            int qryValueAInPercent = (int)(100.0f / (float)qryValueSum * (float)qryValueA);
            int qryValueBInPercent = 100 - qryValueAInPercent;
            int a2 = 0;
            while (a2 < elements.length) {
                Rectangle barBounds = (Rectangle)cacheBarBounds.get(a2);
                String value = String.valueOf(String.valueOf(a2 == 0 ? qryValueAInPercent : qryValueBInPercent)) + "%";
                Point valueSize = gc.textExtent(value);
                int posX = curX + barBounds.width / 2 - valueSize.x / 2;
                if (barBounds.width == 0) {
                    posX = curX + valueSize.x + 5;
                }
                if (posX < 0) {
                    posX = 0;
                } else if (posX + valueSize.x > this.getChartBounds().width) {
                    posX = this.getChartBounds().width - valueSize.x;
                }
                gc.setForeground(this.getTextColor());
                gc.drawString(value, posX, barBounds.y + (this.fDrawTopText ? this.getChartBounds().height / 2 - valueSize.y / 2 : Math.max(0, (barBounds.height - valueSize.y - 3 - valueSize.y) / 2)), true);
                curX += barBounds.width;
                ++a2;
            }
            if (inProgressMode) {
                Rectangle difBarBounds = new Rectangle(0, 0, 0, 0);
                Rectangle firstBarBounds = (Rectangle)cacheBarBounds.get(0);
                Rectangle secondBarBounds = (Rectangle)cacheBarBounds.get(1);
                if (todayPosX < secondBarBounds.x) {
                    difBarBounds.x = todayPosX;
                    difBarBounds.y = firstBarBounds.y + labelHeight + 1 + 3;
                    difBarBounds.width = firstBarBounds.x + firstBarBounds.width - todayPosX - 1;
                    difBarBounds.height = firstBarBounds.height - labelHeight * 2 - 2 - 6;
                } else {
                    difBarBounds.x = secondBarBounds.x + 1;
                    difBarBounds.y = secondBarBounds.y + labelHeight + 1 + 3;
                    difBarBounds.width = todayPosX - firstBarBounds.width;
                    difBarBounds.height = secondBarBounds.height - labelHeight * 2 - 2 - 6;
                }
                gc.setBackground(progressProvider.getProgressColor(isProgressPositive));
                gc.setAlpha(35);
                gc.fillRectangle(difBarBounds);
                this.fProgressDifBounds = new Rectangle(difBarBounds.x, this.getChartBounds().y, difBarBounds.width, this.getChartBounds().height);
            }
        }
    }

    protected boolean getDrawStringsTransparent() {
        return this.fChartElementProvider instanceof IProgressChartElementProvider;
    }

    private boolean useShortText(GC gc, Object element, float relWidth) {
        int cellWidth = (int)((float)this.getChartBounds().width * relWidth);
        return gc.textExtent((String)this.fChartElementProvider.getText((Object)element)).x > cellWidth;
    }

    private Color getTextColor() {
        int color = this.isEnabled() ? 2 : 16;
        return this.fComposite.getDisplay().getSystemColor(color);
    }
}

