/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.views;

import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.TableColumnInfo;
import com.ibm.team.interop.ide.ui.internal.editors.ExternalProxyEditor;
import com.ibm.team.interop.ide.ui.internal.views.Messages;
import com.ibm.team.interop.ide.ui.internal.views.SyncStatusContentProvider;
import com.ibm.team.interop.ide.ui.internal.views.SyncStatusLabelProvider;
import com.ibm.team.interop.rcp.ui.internal.ExternalProxyWorkingCopy;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.openactions.OpenAction;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncStatusView
extends ViewPart {
    public static final int SYNC_TIME_COLUMN_INDEX = 0;
    public static final String SYNC_TIME_COLUMN_NAME = Messages.SyncStatusView_UPDATE_TIME_COLUMN_HEADER;
    public static final int STATUS_COLUMN_INDEX = 1;
    public static final String STATUS_COLUMN_NAME = Messages.SyncStatusView_STATUS_COLUMN_HEADER;
    public static final int EXTERNAL_TYPE_COLUMN_INDEX = 2;
    public static final String EXTERNAL_TYPE_COLUMN_NAME = Messages.SyncStatusView_EXTERNAL_TYPE_COLUMN_HEADER;
    public static final int EXTERNAL_ID_COLUMN_INDEX = 3;
    public static final String EXTERNAL_ID_COLUMN_NAME = Messages.SyncStatusView_EXTERNAL_ID_COLUMN_HEADER;
    public static final int ITEM_TYPE_COLUMN_INDEX = 4;
    public static final String ITEM_TYPE_COLUMN_NAME = Messages.SyncStatusView_ITEM_TYPE_COLUMN_HEADER;
    public static final int ITEM_ID_COLUMN_INDEX = 5;
    public static final String ITEM_ID_COLUMN_NAME = Messages.SyncStatusView_ITEM_ID_COLUMN_HEADER;
    public static final int LAST_ERROR_COLUMN_INDEX = 6;
    public static final String LAST_ERROR_COLUMN_NAME = Messages.SyncStatusView_LAST_ERROR_COLUMN_HEADER;
    public static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(0, 16384, (ColumnLayoutData)new ColumnWeightData(12, true), SYNC_TIME_COLUMN_NAME, null), new TableColumnInfo(1, 16384, (ColumnLayoutData)new ColumnWeightData(12, true), STATUS_COLUMN_NAME, null), new TableColumnInfo(2, 16384, (ColumnLayoutData)new ColumnWeightData(12, true), EXTERNAL_TYPE_COLUMN_NAME, null), new TableColumnInfo(3, 16384, (ColumnLayoutData)new ColumnWeightData(12, true), EXTERNAL_ID_COLUMN_NAME, null), new TableColumnInfo(4, 16384, (ColumnLayoutData)new ColumnWeightData(12, true), ITEM_TYPE_COLUMN_NAME, null), new TableColumnInfo(5, 16384, (ColumnLayoutData)new ColumnWeightData(15, true), ITEM_ID_COLUMN_NAME, null), new TableColumnInfo(6, 16384, (ColumnLayoutData)new ColumnWeightData(25, true), LAST_ERROR_COLUMN_NAME, null)};
    private SelectionListener fColumnSortListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableColumn sortColumn;
            Table table = SyncStatusView.this.fTableViewer.getTable();
            TableColumn column = (TableColumn)e.getSource();
            if (column == (sortColumn = table.getSortColumn())) {
                int currentDirection = table.getSortDirection();
                table.setSortDirection(currentDirection == 128 ? 1024 : 128);
            } else {
                table.setSortColumn(column);
            }
            SyncStatusView.this.fTableViewer.refresh();
        }
    };
    private IDoubleClickListener fDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            SyncStatusView.this.openSyncStatus();
        }
    };
    private TableViewer fTableViewer;
    private SyncStatusContentProvider fContentProvider;
    private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    private IAction fRefreshAction;

    public void createPartControl(Composite parent) {
        this.fTableViewer = new TableViewer(parent, 82690);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new SyncStatusLabelProvider(this.fStandardLabelProvider));
        this.fContentProvider = new SyncStatusContentProvider(this, this.fTableViewer);
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTableViewer.setComparator((ViewerComparator)new SyncStatusViewerComparator());
        this.fTableViewer.setInput(new Object());
        Table table = this.fTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumnInfo.createColumns(table, COLUMN_INFO, null);
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.addSelectionListener(this.fColumnSortListener);
            ++n2;
        }
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(128);
        new SyncStatusTooltipSupport((Control)table, true, false, this.fStandardLabelProvider);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTableViewer);
        this.createContextMenu();
        this.createToolBarActions();
        this.hookListeners();
        this.updateStatus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.interop.ide.ui.syncStatusView");
    }

    public void dispose() {
        this.unhookListeners();
        this.fStandardLabelProvider.dispose();
        super.dispose();
    }

    public void setFocus() {
        this.fTableViewer.getTable().setFocus();
    }

    public void showSyncStatus(SyncStatusContentProvider.QueryInput queryInput) {
        this.fTableViewer.setInput((Object)queryInput);
    }

    void updateStatus() {
        String description = "";
        if (this.fContentProvider != null) {
            description = this.fContentProvider.getContentDescription();
            this.fRefreshAction.setEnabled(this.fContentProvider.getInput() != null);
        }
        this.updateStatus(description);
    }

    void updateStatus(String text) {
        this.setContentDescription(text);
    }

    private List<ExternalProxyWorkingCopy> getSelectedElements() {
        ArrayList<ExternalProxyWorkingCopy> elements = new ArrayList<ExternalProxyWorkingCopy>();
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object selected : ss) {
                if (!(selected instanceof ExternalProxyWorkingCopy)) continue;
                elements.add((ExternalProxyWorkingCopy)selected);
            }
        }
        return elements;
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopUpMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
                ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
                List elements = SyncStatusView.this.getSelectedElements();
                if (elements.size() == 1) {
                    manager.appendToGroup("jazz.open.group", (IAction)new OpenSyncStatusAction());
                    ExternalProxyWorkingCopy proxyWorkingCopy = (ExternalProxyWorkingCopy)elements.get(0);
                    if (proxyWorkingCopy.getLinkedItemHandle() != null && proxyWorkingCopy.getLinkedItemHandle().hasFullState()) {
                        manager.appendToGroup("jazz.open.group", (IAction)new OpenLinkedItemAction());
                    }
                    if (proxyWorkingCopy.getSyncRule() != null) {
                        manager.appendToGroup("jazz.open.group", (IAction)new OpenSyncRuleAction());
                    }
                }
                if (elements.size() != 0) {
                    manager.appendToGroup("jazz.refactoring.group", (IAction)new StopSynchronizingAction());
                }
            }
        });
        this.fTableViewer.getControl().setMenu(menuMgr.createContextMenu(this.fTableViewer.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
    }

    private void createToolBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.fRefreshAction = new Action(){

            public void run() {
                if (SyncStatusView.this.fContentProvider != null) {
                    SyncStatusView.this.fContentProvider.refresh();
                }
            }
        };
        this.fRefreshAction.setText(Messages.SyncStatusView_REFRESH_ACTION_NAME);
        this.fRefreshAction.setToolTipText(Messages.SyncStatusView_REFRESH_ACTION_TOOLTIP);
        this.fRefreshAction.setImageDescriptor(InteropIdeUIPlugin.REFRESH_ACTION_IMAGE_DESCRIPTOR);
        this.fRefreshAction.setEnabled(false);
        toolBarManager.add(this.fRefreshAction);
    }

    private void hookListeners() {
        this.fTableViewer.addDoubleClickListener(this.fDoubleClickListener);
    }

    private void unhookListeners() {
        this.fTableViewer.removeDoubleClickListener(this.fDoubleClickListener);
    }

    private void openSyncStatus() {
        List<ExternalProxyWorkingCopy> elements = this.getSelectedElements();
        if (elements.size() == 1) {
            ExternalProxyEditor.openEditor(this.getSite().getPage(), elements.get(0).getExternalProxy());
        }
    }

    private void openLinkedItem() {
        ExternalProxyWorkingCopy proxyWorkingCopy;
        List<ExternalProxyWorkingCopy> elements = this.getSelectedElements();
        if (elements.size() == 1 && (proxyWorkingCopy = elements.get(0)).getLinkedItemHandle() != null && proxyWorkingCopy.getLinkedItemHandle().hasFullState()) {
            Location location = Location.itemLocation((IItemHandle)proxyWorkingCopy.getLinkedItemHandle(), (String)proxyWorkingCopy.getRepository().getRepositoryURI());
            Hyperlinks.open((URI)location.toAbsoluteUri(), null);
        }
    }

    private void openSyncRule() {
        ExternalProxyWorkingCopy proxyWorkingCopy;
        List<ExternalProxyWorkingCopy> elements = this.getSelectedElements();
        if (elements.size() == 1 && (proxyWorkingCopy = elements.get(0)).getSyncRule() != null) {
            OpenAction.openObject((Object)proxyWorkingCopy.getSyncRule(), (Shell)this.getSite().getShell(), (IWorkbenchPage)this.getSite().getPage());
        }
    }

    private void stopSynchronizing() {
        final List<ExternalProxyWorkingCopy> elements = this.getSelectedElements();
        Job job = new Job(Messages.SyncStatusView_STOP_SYNCHRONIZING_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)elements.size());
                for (ExternalProxyWorkingCopy externalProxyWorkingCopy : elements) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    externalProxyWorkingCopy.deleteExternalProxy((IProgressMonitor)progress.newChild(1));
                }
                return Status.OK_STATUS;
            }
        };
        if (elements.size() != 0) {
            job.setSystem(false);
            job.schedule();
        }
    }

    private class OpenLinkedItemAction
    extends Action {
        public OpenLinkedItemAction() {
            super(Messages.SyncStatusView_OPEN_ITEM_ACTION_NAME);
        }

        public void run() {
            SyncStatusView.this.openLinkedItem();
        }
    }

    private class OpenSyncRuleAction
    extends Action {
        public OpenSyncRuleAction() {
            super(Messages.SyncStatusView_OPEN_SYNCRULE_ACTION_NAME);
        }

        public void run() {
            SyncStatusView.this.openSyncRule();
        }
    }

    private class OpenSyncStatusAction
    extends Action {
        public OpenSyncStatusAction() {
            super(Messages.SyncStatusView_OPEN_STATUS_ACTION_NAME);
        }

        public void run() {
            SyncStatusView.this.openSyncStatus();
        }
    }

    private class StopSynchronizingAction
    extends Action {
        public StopSynchronizingAction() {
            super(Messages.SyncStatusView_STOP_SYNCING_ACTION_NAME);
        }

        public void run() {
            if (!MessageDialog.openConfirm((Shell)SyncStatusView.this.getSite().getShell(), (String)Messages.SyncStatusView_STOP_SYNCING_CONFIRM_TITLE, (String)Messages.SyncStatusView_STOP_SYNCING_CONFIRM_PROMPT)) {
                return;
            }
            SyncStatusView.this.stopSynchronizing();
        }
    }

    private static class SyncStatusTooltipSupport
    extends TooltipSupport {
        private final StandardLabelProvider fStandardLabelProvider;

        public SyncStatusTooltipSupport(Control control, boolean isFocusable, boolean isOpenable, StandardLabelProvider standardLabelProvider) {
            super(control, isFocusable, isOpenable);
            this.fStandardLabelProvider = standardLabelProvider;
            this.setPreferredFocusSize(new Point(380, 110));
            this.setPreferredHoverSize(new Point(285, 82));
        }

        protected String getMarkup(Object element, boolean isFocus) {
            StringBuilder body = new StringBuilder();
            ExternalProxyWorkingCopy proxyWorkingCopy = (ExternalProxyWorkingCopy)element;
            IExternalProxy proxy = proxyWorkingCopy.getExternalProxy();
            IItemHandle itemHandle = proxyWorkingCopy.getLinkedItemHandle();
            if (proxy.getExternalIdHint() != null && proxy.getExternalIdHint().length() != 0) {
                body.append(NLS.bind((String)Messages.SyncStatusView_EXTERNAL_ID_TOOLTIP_SECTION, (Object[])new Object[]{proxy.getExternalIdHint()}));
            } else if (proxyWorkingCopy.getExternalUri() != null && proxyWorkingCopy.getExternalUri().length() != 0) {
                body.append(NLS.bind((String)Messages.SyncStatusView_EXTERNAL_URI_TOOLTIP_SECTION, (Object[])new Object[]{proxyWorkingCopy.getExternalUri()}));
            }
            if (itemHandle != null) {
                if (itemHandle.hasFullState()) {
                    Object value;
                    String itemNameProperty;
                    IItem item = itemHandle.getFullState();
                    String itemId = null;
                    try {
                        itemId = this.fStandardLabelProvider.getText((Object)item);
                    }
                    catch (Throwable throwable) {}
                    if (itemId == null && (itemNameProperty = ((ItemType)item.getItemType()).idPropertyName()) != null && itemNameProperty.length() != 0 && (value = ((Item)item).getPropertyValue(itemNameProperty)) != null) {
                        itemId = value.toString();
                    }
                    if (itemId == null) {
                        itemId = Messages.SyncStatusView_UNKNOWN_ITEM_ID;
                    }
                    body.append(NLS.bind((String)Messages.SyncStatusView_ITEM_ID_TOOLTIP_SECTION, (Object[])new Object[]{itemId}));
                }
                body.append(NLS.bind((String)Messages.SyncStatusView_ITEM_TYPE_TOOLTIP_SECTION, (Object[])new Object[]{itemHandle.getItemType().getName()}));
            }
            body.append(NLS.bind((String)Messages.SyncStatusView_SYNC_STATUS_TOOLTIP_SECTION, (Object[])new Object[]{proxyWorkingCopy.getSyncStatusText()}));
            if (proxy.getLastErrorString() != null && proxy.getLastErrorString().length() != 0) {
                body.append(NLS.bind((String)Messages.SyncStatusView_LAST_ERROR_TOOLTIP_SECTION, (Object[])new Object[]{proxy.getLastErrorString().replaceAll("\n", "<br>")}));
            }
            return body.toString();
        }
    }

    private static class SyncStatusViewerComparator
    extends ViewerComparator {
        private SyncStatusViewerComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result;
            Table table = ((TableViewer)viewer).getTable();
            TableColumn sortColumn = table.getSortColumn();
            int columnIndex = sortColumn == null ? 0 : table.indexOf(sortColumn);
            int direction = table.getSortDirection();
            if (columnIndex == 0) {
                ExternalProxyWorkingCopy wc1 = (ExternalProxyWorkingCopy)e1;
                ExternalProxyWorkingCopy wc2 = (ExternalProxyWorkingCopy)e2;
                Date d1 = wc1.getExternalProxy().modified();
                Date d2 = wc2.getExternalProxy().modified();
                result = d1 == null ? -1 : (d2 == null ? 1 : d1.compareTo(d2));
            } else {
                ITableLabelProvider labelProvider = (ITableLabelProvider)((TableViewer)viewer).getLabelProvider();
                String s1 = labelProvider.getColumnText(e1, columnIndex);
                String s2 = labelProvider.getColumnText(e2, columnIndex);
                result = s1.compareToIgnoreCase(s2);
            }
            return direction == 128 ? result : -result;
        }
    }
}

