/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.views;

import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.ide.ui.internal.views.Messages;
import com.ibm.team.interop.rcp.ui.internal.ExternalProxyWorkingCopy;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.util.NLS;
import java.text.DateFormat;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class SyncStatusLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final DateFormat fgDateTimeFormatter = DateFormat.getDateTimeInstance(3, 3);
    private static final Pattern LINE_TERMINATOR_PATTERN = Pattern.compile("[\\r\\n]+");
    private static final String BLANK = " ";
    private final StandardLabelProvider fStdLabelProvider;

    public SyncStatusLabelProvider(StandardLabelProvider stdLabelProvider) {
        this.fStdLabelProvider = stdLabelProvider;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof ExternalProxyWorkingCopy)) {
            return null;
        }
        ExternalProxyWorkingCopy proxyWorkingCopy = (ExternalProxyWorkingCopy)element;
        IExternalProxy proxy = proxyWorkingCopy.getExternalProxy();
        ISyncRule syncRule = proxyWorkingCopy.getSyncRule();
        IItemHandle itemHandle = proxyWorkingCopy.getLinkedItemHandle();
        StringBuilder s = new StringBuilder();
        switch (columnIndex) {
            case 0: {
                if (proxy.modified() == null) break;
                s.append(fgDateTimeFormatter.format(proxy.modified()));
                break;
            }
            case 1: {
                s.append(proxyWorkingCopy.getSyncStatusText());
                break;
            }
            case 2: {
                if (syncRule == null || syncRule.getExternalTypeName() == null) break;
                s.append(syncRule.getExternalTypeName());
                break;
            }
            case 3: {
                String uri;
                if (proxy.getExternalIdHint() != null) {
                    s.append(proxy.getExternalIdHint());
                }
                if (s.length() != 0 || (uri = proxyWorkingCopy.getExternalUri()) == null) break;
                s.append(uri);
                break;
            }
            case 4: {
                if (itemHandle == null) break;
                s.append(itemHandle.getItemType().getName());
                break;
            }
            case 5: {
                if (itemHandle == null) break;
                if (itemHandle.hasFullState()) {
                    s.append(this.fStdLabelProvider.getText((Object)itemHandle.getFullState()));
                    break;
                }
                Exception itemError = proxyWorkingCopy.getLinkedItemError();
                if (itemError instanceof ItemNotFoundException) {
                    s.append(NLS.bind((String)Messages.SyncStatusLabelProvider_ERROR_ITEM_NOT_FOUND, (Object[])new Object[]{itemHandle.getItemId().getUuidValue()}));
                    break;
                }
                s.append(NLS.bind((String)Messages.SyncStatusLabelProvider_ERROR_RESOLVING_ITEM, (Object[])new Object[]{itemHandle.getItemId().getUuidValue(), itemError == null ? "" : itemError.toString()}));
                break;
            }
            case 6: {
                if (proxy.getLastErrorString() == null) break;
                s.append(LINE_TERMINATOR_PATTERN.matcher(proxy.getLastErrorString()).replaceAll(BLANK));
            }
        }
        return s.toString();
    }
}

