/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.common.IExternalRepositoryConnection;
import com.ibm.team.interop.common.IExternalRepositoryConnectionHandle;
import com.ibm.team.interop.common.IPropertyMapping;
import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.common.IValueMapping;
import com.ibm.team.interop.common.InteropFactory;
import com.ibm.team.interop.common.rcp.dto.IManagerInfoDTO;
import com.ibm.team.interop.common.rcp.dto.IPropertyInfoDTO;
import com.ibm.team.interop.common.rcp.dto.ITransformerInfoDTO;
import com.ibm.team.interop.common.rcp.dto.ITypeInfoDTO;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.ConstrainedTableViewer;
import com.ibm.team.interop.ide.ui.internal.TableColumnInfo;
import com.ibm.team.interop.ide.ui.internal.TeamAreaSelectorControl;
import com.ibm.team.interop.ide.ui.internal.WidgetUtil;
import com.ibm.team.interop.ide.ui.internal.editors.Messages;
import com.ibm.team.interop.ide.ui.internal.editors.PropertyMappingContentProvider;
import com.ibm.team.interop.ide.ui.internal.editors.PropertyMappingDialog;
import com.ibm.team.interop.ide.ui.internal.editors.PropertyMappingLabelProvider;
import com.ibm.team.interop.ide.ui.internal.editors.RequiredPropertiesDialog;
import com.ibm.team.interop.ide.ui.internal.editors.SyncRuleEditor;
import com.ibm.team.interop.ide.ui.internal.editors.ValueMappingDialog;
import com.ibm.team.interop.rcp.ui.internal.SyncRuleWorkingCopy;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.ui.editor.TeamFormPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncRuleOverviewPage
extends TeamFormPage {
    static final int ITEM_IDENTIFIER_COLUMN = 0;
    static final String ITEM_IDENTIFIER_COLUMN_NAME = Messages.SyncRuleOverviewPage_ITEM_IDENTIFIER_COLUMN_HEADER;
    static final int ITEM_PROPERTY_COLUMN = 1;
    static final String ITEM_PROPERTY_COLUMN_NAME = Messages.SyncRuleOverviewPage_ITEM_PROPERTY_COLUMN_HEADER;
    static final int DIRECTION_COLUMN = 2;
    static final String DIRECTION_COLUMN_NAME = Messages.SyncRuleOverviewPage_DIRECTION_COLUMN_HEADER;
    static final int EXTERNAL_IDENTIFIER_COLUMN = 3;
    static final String EXTERNAL_IDENTIFIER_COLUMN_NAME = Messages.SyncRuleOverviewPage_EXTERNAL_IDENTIFIER_COLUMN_HEADER;
    static final int EXTERNAL_PROPERTY_COLUMN = 4;
    static final String EXTERNAL_PROPERTY_COLUMN_NAME = Messages.SyncRuleOverviewPage_EXTERNAL_PROPERTY_COLUMN_HEADER;
    static final int IMAGE_COLUMN_WIDTH = 80;
    static final TableColumnInfo[] PROPERTY_MAPPINGS_COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(0, 16384, (ColumnLayoutData)new ColumnWeightData(10, true), ITEM_IDENTIFIER_COLUMN_NAME, null), new TableColumnInfo(1, 16384, (ColumnLayoutData)new ColumnWeightData(35, true), ITEM_PROPERTY_COLUMN_NAME, null), new TableColumnInfo(2, 16384, (ColumnLayoutData)new ColumnWeightData(10, true), DIRECTION_COLUMN_NAME, null), new TableColumnInfo(3, 16384, (ColumnLayoutData)new ColumnWeightData(10, true), EXTERNAL_IDENTIFIER_COLUMN_NAME, null), new TableColumnInfo(4, 16384, (ColumnLayoutData)new ColumnWeightData(35, true), EXTERNAL_PROPERTY_COLUMN_NAME, null)};
    private IChangeListener fWorkingCopyListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property != IWorkingCopy.PROP_VALID) {
                return;
            }
            if (!SyncRuleOverviewPage.this.fWorkingCopy.isValid()) {
                return;
            }
            if (!SyncRuleOverviewPage.this.isDirty()) {
                SyncRuleOverviewPage.this.fInitialized = false;
                SyncRuleOverviewPage.this.refresh();
            }
        }
    };
    private IPropertyChangeListener fPreferencePropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("syncRuleEditor.showArchivedTeamAreas")) {
                Object newValue = event.getNewValue();
                if (newValue instanceof Boolean) {
                    SyncRuleOverviewPage.this.fShowArchivedButton.setSelection(((Boolean)newValue).booleanValue());
                } else if (newValue instanceof String) {
                    SyncRuleOverviewPage.this.fShowArchivedButton.setSelection(Boolean.parseBoolean(newValue.toString()));
                } else {
                    SyncRuleOverviewPage.this.fShowArchivedButton.setSelection(false);
                }
                SyncRuleOverviewPage.this.archiveFilterSelected();
            }
        }
    };
    private SelectionListener fPageDirtySelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            SyncRuleOverviewPage.this.setPageDirty(true);
        }

        public void widgetSelected(SelectionEvent e) {
            SyncRuleOverviewPage.this.setPageDirty(true);
        }
    };
    private ModifyListener fPageDirtyModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SyncRuleOverviewPage.this.setPageDirty(true);
        }
    };
    private SelectionListener fMappingDirtySelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            SyncRuleOverviewPage.this.setMappingDirty(true);
        }

        public void widgetSelected(SelectionEvent e) {
            SyncRuleOverviewPage.this.setMappingDirty(true);
        }
    };
    private ModifyListener fMappingDirtyModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SyncRuleOverviewPage.this.setMappingDirty(true);
        }
    };
    private SelectionListener fPropertyMappingColumnSortListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableColumn sortColumn;
            TableColumn column = (TableColumn)e.getSource();
            if (column == (sortColumn = SyncRuleOverviewPage.this.fPropertyMappingTable.getSortColumn())) {
                int currentDirection = SyncRuleOverviewPage.this.fPropertyMappingTable.getSortDirection();
                SyncRuleOverviewPage.this.fPropertyMappingTable.setSortDirection(currentDirection == 128 ? 1024 : 128);
            } else {
                SyncRuleOverviewPage.this.fPropertyMappingTable.setSortColumn(column);
            }
            SyncRuleOverviewPage.this.fPropertyMappingTableViewer.refresh();
        }
    };
    private ViewerComparator fPropertyMappingViewerComparator = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            String s2;
            String s1;
            Table table = ((TableViewer)viewer).getTable();
            TableColumn sortColumn = table.getSortColumn();
            int columnIndex = sortColumn == null ? 0 : table.indexOf(sortColumn);
            int direction = table.getSortDirection();
            IPropertyMapping m1 = (IPropertyMapping)e1;
            IPropertyMapping m2 = (IPropertyMapping)e2;
            switch (columnIndex) {
                case 1: {
                    s1 = SyncRuleOverviewPage.this.fItemPropertyChoices.getDisplayNameByAlternateName(m1.getItemPropertyName());
                    s2 = SyncRuleOverviewPage.this.fItemPropertyChoices.getDisplayNameByAlternateName(m2.getItemPropertyName());
                    break;
                }
                case 4: {
                    s1 = SyncRuleOverviewPage.this.fExternalPropertyChoices.getDisplayNameByAlternateName(m1.getExternalPropertyName());
                    s2 = SyncRuleOverviewPage.this.fExternalPropertyChoices.getDisplayNameByAlternateName(m2.getExternalPropertyName());
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (s1 == null) {
                s1 = EMPTY;
            }
            if (s2 == null) {
                s2 = EMPTY;
            }
            int result = s1.compareToIgnoreCase(s2);
            return direction == 128 ? result : -result;
        }
    };
    private final FetchExternalTypeInfoJob fFetchExternalTypeInfoJob = new FetchExternalTypeInfoJob();
    private Comparator<IValueMapping> fValueMappingComparator = new Comparator<IValueMapping>(){

        @Override
        public int compare(IValueMapping o1, IValueMapping o2) {
            String s2;
            String s1 = o1.getItemValue();
            if (s1 == null) {
                s1 = "";
            }
            if ((s2 = o2.getItemValue()) == null) {
                s2 = "";
            }
            return s1.compareToIgnoreCase(s2);
        }
    };
    private ViewerComparator fValueMappingViewerComparator = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            String s2;
            String s1;
            Table table = ((TableViewer)viewer).getTable();
            TableColumn sortColumn = table.getSortColumn();
            int columnIndex = sortColumn == null ? 0 : table.indexOf(sortColumn);
            int direction = table.getSortDirection();
            IValueMapping m1 = (IValueMapping)e1;
            IValueMapping m2 = (IValueMapping)e2;
            switch (columnIndex) {
                case 0: {
                    s1 = m1.getItemValue();
                    s2 = m2.getItemValue();
                    break;
                }
                case 1: {
                    s1 = m1.getExternalValue();
                    s2 = m2.getExternalValue();
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            int result = s1.compareToIgnoreCase(s2);
            return direction == 128 ? result : -result;
        }
    };
    private SelectionListener fValueMappingColumnSortListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableColumn sortColumn;
            Table table = SyncRuleOverviewPage.this.fValueMappingsTableViewer.getTable();
            TableColumn column = (TableColumn)e.getSource();
            if (column == (sortColumn = table.getSortColumn())) {
                int currentDirection = table.getSortDirection();
                table.setSortDirection(currentDirection == 128 ? 1024 : 128);
            } else {
                table.setSortColumn(column);
            }
            SyncRuleOverviewPage.this.fValueMappingsTableViewer.refresh();
        }
    };
    private static final String PAGE_ID = "com.ibm.team.interop.ide.ui.SyncRuleEditor.Overview";
    private static final String PAGE_TITLE = Messages.SyncRuleOverviewPage_OVERVIEW_PAGE_TITLE;
    private static final int DOT_CHAR = 46;
    private static final int COLON_CHAR = 58;
    private static final String EMPTY = new String();
    private static final String IGNORED_REGEXP = "[ _]+";
    private static final int ITEM_VALUE_COLUMN = 0;
    private static final String ITEM_VALUE_COLUMN_NAME = Messages.SyncRuleOverviewPage_ITEM_VALUE_COLUMN_HEADER;
    private static final int EXTERNAL_VALUE_COLUMN = 1;
    private static final String EXTERNAL_VALUE_COLUMN_NAME = Messages.SyncRuleOverviewPage_EXTERNAL_VALUE_COLUMN_HEADER;
    private static final TableColumnInfo[] VALUE_MAPPINGS_COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(0, 16384, (ColumnLayoutData)new ColumnWeightData(50, true), ITEM_VALUE_COLUMN_NAME, null), new TableColumnInfo(1, 16384, (ColumnLayoutData)new ColumnWeightData(50, true), EXTERNAL_VALUE_COLUMN_NAME, null)};
    private final SyncRuleWorkingCopy fWorkingCopy;
    private final ResourceManager fResourceManager;
    private final Map<String, IManagerInfoDTO> fItemManagerToManagerInfoMap = new HashMap<String, IManagerInfoDTO>();
    private final Map<String, List<IManagerInfoDTO>> fItemTypeToManagerInfoMap = new HashMap<String, List<IManagerInfoDTO>>();
    private final Map<String, Map<String, ITypeInfoDTO>> fItemTypeToTypeInfoMap = new HashMap<String, Map<String, ITypeInfoDTO>>();
    private final Map<String, IManagerInfoDTO> fExternalManagerToManagerInfoMap = new HashMap<String, IManagerInfoDTO>();
    private final Map<String, List<IManagerInfoDTO>> fExternalTypeToManagerInfoMap = new HashMap<String, List<IManagerInfoDTO>>();
    private final Map<String, ITypeInfoDTO> fShortExternalTypeToTypeInfoMap = new HashMap<String, ITypeInfoDTO>();
    private final WidgetUtil.ComboChoices<ITypeInfoDTO> fItemTypeChoices = new WidgetUtil.ComboChoices();
    private final WidgetUtil.ComboChoices<ITypeInfoDTO> fItemTypeQualifierChoices = new WidgetUtil.ComboChoices();
    private final WidgetUtil.ComboChoices<IManagerInfoDTO> fItemManagerChoices = new WidgetUtil.ComboChoices();
    private final WidgetUtil.ComboChoices<IExternalRepositoryConnection> fExternalRepositoryChoices = new WidgetUtil.ComboChoices();
    private final WidgetUtil.ComboChoices<ITypeInfoDTO> fExternalTypeChoices = new WidgetUtil.ComboChoices();
    private final WidgetUtil.ComboChoices<IManagerInfoDTO> fExternalManagerChoices = new WidgetUtil.ComboChoices();
    private boolean fPageDirty;
    private boolean fMappingDirty;
    private boolean fInitialized;
    private Combo fItemTypeCombo;
    private Combo fItemTypeQualifierCombo;
    private Combo fItemManagerCombo;
    private Combo fExternalRepositoryCombo;
    private Combo fExternalTypeCombo;
    private Combo fExternalManagerCombo;
    private Label fEnabledTeamAreasLabel;
    private TeamAreaSelectorControl fTeamAreaSelector;
    private Button fShowArchivedButton;
    private Spinner fMaxCycleCountSpinner;
    private Button fSyncAllItemStatesButton;
    private Table fPropertyMappingTable;
    private TableViewer fPropertyMappingTableViewer;
    private Button fInitializePropertyMappingsButton;
    private Button fAddPropertyMappingsButton;
    private Button fRemovePropertyMappingsButton;
    private final WidgetUtil.ComboChoices<IPropertyInfoDTO> fItemPropertyChoices = new WidgetUtil.ComboChoices();
    private final WidgetUtil.ComboChoices<IPropertyInfoDTO> fExternalPropertyChoices = new WidgetUtil.ComboChoices();
    private final WidgetUtil.ComboChoices<SyncDirection> fSyncDirectionChoices = new WidgetUtil.ComboChoices();
    private final WidgetUtil.ComboChoices<String> fReferenceSyncRuleChoices = new WidgetUtil.ComboChoices();
    private final WidgetUtil.ComboChoices<ITransformerInfoDTO> fValueTransformerChoices = new WidgetUtil.ComboChoices();
    private IPropertyMapping fCurrentMapping;
    private Composite fMappingDetailsComposite;
    private Button fNoItemPropertyButton;
    private Button fNoExternalPropertyButton;
    private Combo fItemPropertyNameCombo;
    private Combo fSyncDirectionCombo;
    private Combo fExternalPropertyNameCombo;
    private Button fItemIdentifierButton;
    private Button fExternalIdentifierButton;
    private Button fExternalModifierButton;
    private Button fNoTransformButton;
    private Combo fReferenceSyncRuleCombo;
    private Combo fValueTransformerCombo;
    private Hyperlink fRequiredPropertiesLink;
    private TableViewer fValueMappingsTableViewer;
    private Button fInitializeValueMappingsButton;
    private Button fAddValueMappingsButton;
    private Button fRemoveValueMappingsButton;
    private Button fChangeValueMappingButton;

    public SyncRuleOverviewPage(FormEditor editor, SyncRuleWorkingCopy workingCopy, ResourceManager resourceManager) {
        super(editor, PAGE_ID, PAGE_TITLE);
        this.fWorkingCopy = workingCopy;
        this.fResourceManager = resourceManager;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getFormBodyMargins()).spacing(LayoutConstants2.getFormBodySpacing()).applyTo(body);
        Section typeMappingSection = this.createTypeMappingSection(body);
        GridDataFactory.swtDefaults().align(1, 4).grab(false, true).hint(200, -1).applyTo((Control)typeMappingSection);
        Section propertyMappingSection = this.createPropertyMappingSection(body);
        GridDataFactory.fillDefaults().grab(true, true).minSize(300, -1).applyTo((Control)propertyMappingSection);
        this.fWorkingCopy.addListener(this.fWorkingCopyListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)body, "com.ibm.team.interop.ide.ui.syncRuleEditorOverview");
    }

    public void dispose() {
        this.fWorkingCopy.removeListener(this.fWorkingCopyListener);
        InteropIdeUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPreferencePropertyChangeListener);
        super.dispose();
    }

    public boolean isDirty() {
        return this.fPageDirty || super.isDirty();
    }

    public void setPageDirty(boolean dirty) {
        if (this.fInitialized) {
            boolean wasDirty = this.isDirty();
            this.fPageDirty = dirty;
            if (dirty != wasDirty) {
                this.firePropertyChange(257);
            }
        }
    }

    public void prepareForReload() {
        this.setPageDirty(false);
        this.fInitialized = false;
    }

    public void refresh() {
        this.loadManagerInfo();
        ISyncRule syncRule = this.fWorkingCopy.getSyncRule();
        IItemType syncItemType = syncRule.getSyncItemType();
        String syncItemTypeName = syncItemType == null ? null : String.valueOf(syncItemType.getNamespaceURI()) + "." + syncItemType.getName();
        WidgetUtil.setComboChoices(this.fItemTypeCombo, this.fItemTypeChoices, false);
        WidgetUtil.setComboSelection(this.fItemTypeCombo, this.fItemTypeChoices.getDisplayNameByAlternateName(syncItemTypeName), this.fItemTypeChoices);
        this.itemTypeSelected();
        WidgetUtil.setComboChoices(this.fItemTypeQualifierCombo, this.fItemTypeQualifierChoices, false);
        WidgetUtil.setComboSelection(this.fItemTypeQualifierCombo, this.fItemTypeQualifierChoices.getDisplayNameByAlternateName(syncRule.getSyncItemTypeQualifier()), this.fItemTypeQualifierChoices);
        WidgetUtil.setComboChoices(this.fItemManagerCombo, this.fItemManagerChoices, false);
        String itemManagerName = syncRule.getItemManager();
        WidgetUtil.setComboSelection(this.fItemManagerCombo, this.fItemManagerChoices.getDisplayNameByAlternateName(itemManagerName), this.fItemManagerChoices);
        WidgetUtil.setComboChoices(this.fExternalRepositoryCombo, this.fExternalRepositoryChoices, false);
        IExternalRepositoryConnection externalRepository = this.fWorkingCopy.getExternalRepositoryConnection();
        String externalRepositoryName = externalRepository == null ? Messages.SyncRuleOverviewPage_CHOICE_NONE : externalRepository.getName();
        WidgetUtil.setComboSelection(this.fExternalRepositoryCombo, externalRepositoryName, this.fExternalRepositoryChoices);
        WidgetUtil.setComboChoices(this.fExternalManagerCombo, this.fExternalManagerChoices, false);
        String externalManagerName = syncRule.getExternalManager();
        WidgetUtil.setComboSelection(this.fExternalManagerCombo, this.fExternalManagerChoices.getDisplayNameByAlternateName(externalManagerName), this.fExternalManagerChoices);
        WidgetUtil.setComboSelection(this.fExternalTypeCombo, this.fExternalTypeChoices.getDisplayNameByAlternateName(syncRule.getExternalTypeName()), this.fExternalTypeChoices);
        this.externalManagerOrRepositorySelected();
        this.createItemPropertyChoices(this.getSelectedItemTypeInfo());
        this.createExternalPropertyChoices(this.getSelectedExternalTypeInfo());
        this.fMaxCycleCountSpinner.setSelection(syncRule.getMaxCycleCount());
        this.fSyncAllItemStatesButton.setSelection(syncRule.isSyncAllItemStates());
        this.fPropertyMappingTableViewer.setInput((Object)this.fWorkingCopy);
        IProjectArea projectArea = this.fWorkingCopy.getProjectArea();
        if (projectArea != null) {
            this.fTeamAreaSelector.setSelectedTeamAreas(projectArea, this.fWorkingCopy.getSyncRule().getEnabledTeamAreas(), this.fShowArchivedButton.getSelection());
            this.updateEnabledTeamAreasLabel();
        }
        this.itemTypeSelectionChanged();
        this.propertyMappingSelectionChanged((IStructuredSelection)this.fPropertyMappingTableViewer.getSelection());
        this.fInitialized = true;
    }

    public void commit() {
        if (this.fPageDirty) {
            ISyncRule syncRule = this.fWorkingCopy.getSyncRule();
            String itemTypeString = null;
            ITypeInfoDTO typeInfo = WidgetUtil.getComboSelection(this.fItemTypeCombo, this.fItemTypeChoices);
            if (typeInfo != null) {
                itemTypeString = typeInfo.getName();
            }
            if (itemTypeString != null && itemTypeString.length() != 0) {
                String itemTypeNamespace;
                String itemTypeName;
                int sepIndex = itemTypeString.lastIndexOf(46);
                if (sepIndex <= 0) {
                    itemTypeName = itemTypeString;
                    itemTypeNamespace = EMPTY;
                } else {
                    itemTypeName = itemTypeString.substring(sepIndex + 1);
                    itemTypeNamespace = itemTypeString.substring(0, sepIndex);
                }
                IItemType itemType = IItemType.IRegistry.INSTANCE.getItemType(itemTypeName, itemTypeNamespace);
                syncRule.setSyncItemType(itemType);
            } else {
                syncRule.setSyncItemType(null);
            }
            ITypeInfoDTO subTypeInfo = WidgetUtil.getComboSelection(this.fItemTypeQualifierCombo, this.fItemTypeQualifierChoices);
            if (subTypeInfo != null) {
                syncRule.setSyncItemTypeQualifier(subTypeInfo.getQualifierId());
            } else {
                syncRule.setSyncItemTypeQualifier(this.fItemTypeQualifierCombo.getText());
            }
            IManagerInfoDTO managerInfo = WidgetUtil.getComboSelection(this.fItemManagerCombo, this.fItemManagerChoices);
            if (managerInfo != null) {
                syncRule.setItemManager(managerInfo.getId());
            } else {
                syncRule.setItemManager(null);
            }
            IExternalRepositoryConnection externalRepository = WidgetUtil.getComboSelection(this.fExternalRepositoryCombo, this.fExternalRepositoryChoices);
            syncRule.setExternalRepository((IExternalRepositoryConnectionHandle)externalRepository);
            this.fWorkingCopy.updateExternalRepositoryConnection(externalRepository);
            typeInfo = WidgetUtil.getComboSelection(this.fExternalTypeCombo, this.fExternalTypeChoices);
            if (typeInfo != null) {
                syncRule.setExternalTypeName(typeInfo.getName());
            } else {
                syncRule.setExternalTypeName(this.fExternalTypeCombo.getText());
            }
            managerInfo = WidgetUtil.getComboSelection(this.fExternalManagerCombo, this.fExternalManagerChoices);
            if (managerInfo != null) {
                syncRule.setExternalManager(managerInfo.getId());
            } else {
                syncRule.setExternalManager(null);
            }
            Collection<ITeamArea> enabledTeamAreas = this.fTeamAreaSelector.getExplicitlySelectedTeamAreas();
            syncRule.getEnabledTeamAreas().clear();
            for (ITeamArea teamArea : enabledTeamAreas) {
                syncRule.getEnabledTeamAreas().add(teamArea);
            }
            syncRule.setMaxCycleCount(this.fMaxCycleCountSpinner.getSelection());
            syncRule.setSyncAllItemStates(this.fSyncAllItemStatesButton.getSelection());
            this.commitMappingDetails();
        }
    }

    private Section createTypeMappingSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = this.createSection(toolkit, parent, 450, Messages.SyncRuleOverviewPage_TYPE_MAPPING_SECTION_TITLE);
        Composite sectionComposite = toolkit.createComposite((Composite)section, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(sectionComposite);
        section.setClient((Control)sectionComposite);
        Composite typeMappingComposite = toolkit.createComposite(sectionComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(typeMappingComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)typeMappingComposite);
        toolkit.createLabel(typeMappingComposite, Messages.SyncRuleOverviewPage_ITEM_TYPE_LABEL);
        this.fItemTypeCombo = new Combo(typeMappingComposite, 12);
        GridDataFactory.fillDefaults().grab(true, false).hint(75, -1).applyTo((Control)this.fItemTypeCombo);
        this.fItemTypeCombo.setToolTipText(Messages.SyncRuleOverviewPage_ITEM_TYPE_TOOLTIP);
        this.fItemTypeCombo.addModifyListener(this.fPageDirtyModifyListener);
        this.fItemTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.itemTypeSelected();
            }
        });
        toolkit.createLabel(typeMappingComposite, Messages.SyncRuleOverviewPage_ITEM_TYPE_QUALIFIER_LABEL);
        this.fItemTypeQualifierCombo = new Combo(typeMappingComposite, 4);
        GridDataFactory.fillDefaults().grab(true, false).hint(75, -1).applyTo((Control)this.fItemTypeQualifierCombo);
        this.fItemTypeQualifierCombo.setToolTipText(Messages.SyncRuleOverviewPage_ITEM_TYPE_QUALIFIER_TOOLTIP);
        this.fItemTypeQualifierCombo.addModifyListener(this.fPageDirtyModifyListener);
        toolkit.createLabel(typeMappingComposite, Messages.SyncRuleOverviewPage_ITEM_MANAGER_LABEL);
        this.fItemManagerCombo = new Combo(typeMappingComposite, 12);
        GridDataFactory.fillDefaults().grab(true, false).hint(75, -1).applyTo((Control)this.fItemManagerCombo);
        this.fItemManagerCombo.setToolTipText(Messages.SyncRuleOverviewPage_ITEM_MANAGER_TOOLTIP);
        this.fItemManagerCombo.addModifyListener(this.fPageDirtyModifyListener);
        toolkit.createLabel(typeMappingComposite, Messages.SyncRuleOverviewPage_EXTERNAL_REPOSITORY_LABEL);
        this.fExternalRepositoryCombo = new Combo(typeMappingComposite, 12);
        GridDataFactory.fillDefaults().grab(true, false).hint(75, -1).applyTo((Control)this.fExternalRepositoryCombo);
        this.fExternalRepositoryCombo.setToolTipText(Messages.SyncRuleOverviewPage_EXTERNAL_REPOSITORY_TOOLTIP);
        this.fExternalRepositoryCombo.addModifyListener(this.fPageDirtyModifyListener);
        this.fExternalRepositoryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.externalManagerOrRepositorySelected();
            }
        });
        toolkit.createLabel(typeMappingComposite, Messages.SyncRuleOverviewPage_EXTERNAL_MANAGER_LABEL);
        this.fExternalManagerCombo = new Combo(typeMappingComposite, 12);
        GridDataFactory.fillDefaults().grab(true, false).hint(75, -1).applyTo((Control)this.fExternalManagerCombo);
        this.fExternalManagerCombo.setToolTipText(Messages.SyncRuleOverviewPage_EXTERNAL_MANAGER_TOOLTIP);
        this.fExternalManagerCombo.addModifyListener(this.fPageDirtyModifyListener);
        this.fExternalManagerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.externalManagerOrRepositorySelected();
            }
        });
        toolkit.createLabel(typeMappingComposite, Messages.SyncRuleOverviewPage_EXTERNAL_TYPE_LABEL);
        this.fExternalTypeCombo = new Combo(typeMappingComposite, 4);
        GridDataFactory.fillDefaults().grab(true, false).hint(75, -1).applyTo((Control)this.fExternalTypeCombo);
        this.fExternalTypeCombo.setToolTipText(Messages.SyncRuleOverviewPage_EXTERNAL_TYPE_TOOLTIP);
        this.fExternalTypeCombo.addModifyListener(this.fPageDirtyModifyListener);
        Composite optionsComposite = toolkit.createComposite(sectionComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(optionsComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)optionsComposite);
        toolkit.createLabel(optionsComposite, Messages.SyncRuleOverviewPage_CYCLE_COUNT_LABEL);
        this.fMaxCycleCountSpinner = new Spinner(optionsComposite, 0);
        this.fMaxCycleCountSpinner.setToolTipText(Messages.SyncRuleOverviewPage_CYCLE_COUNT_TOOLTIP);
        this.fMaxCycleCountSpinner.addModifyListener(this.fPageDirtyModifyListener);
        GridLayoutFactory.fillDefaults().generateLayout((Composite)this.fMaxCycleCountSpinner);
        this.fSyncAllItemStatesButton = toolkit.createButton(optionsComposite, Messages.SyncRuleOverviewPage_SYNC_ALL_ITEM_STATES_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fSyncAllItemStatesButton);
        this.fSyncAllItemStatesButton.setToolTipText(Messages.SyncRuleOverviewPage_SYNC_ALL_ITEM_STATES_TOOLTIP);
        this.fSyncAllItemStatesButton.addSelectionListener(this.fPageDirtySelectionListener);
        Composite teamAreasComposite = toolkit.createComposite(sectionComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(teamAreasComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)teamAreasComposite);
        this.fEnabledTeamAreasLabel = toolkit.createLabel(teamAreasComposite, NLS.bind((String)Messages.SyncRuleOverviewPage_ENABLED_TEAM_AREAS_LABEL, (Object[])new Object[]{0}));
        this.fEnabledTeamAreasLabel.setToolTipText(Messages.SyncRuleOverviewPage_TEAM_AREA_SELECTOR_TOOLTIP);
        this.fTeamAreaSelector = new TeamAreaSelectorControl(teamAreasComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.fTeamAreaSelector.getControl());
        this.fTeamAreaSelector.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (SyncRuleOverviewPage.this.fTeamAreaSelector.isDirty()) {
                    SyncRuleOverviewPage.this.setPageDirty(true);
                }
                SyncRuleOverviewPage.this.updateEnabledTeamAreasLabel();
            }
        });
        this.fShowArchivedButton = toolkit.createButton(teamAreasComposite, Messages.SyncRuleOverviewPage_SHOW_ARCHIVED_BUTTON_LABEL, 32);
        GridDataFactory.fillDefaults().applyTo((Control)this.fShowArchivedButton);
        boolean showArchived = InteropIdeUIPlugin.getDefault().getPreferenceStore().getBoolean("syncRuleEditor.showArchivedTeamAreas");
        this.fShowArchivedButton.setSelection(showArchived);
        this.fShowArchivedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.archiveFilterSelected();
            }
        });
        InteropIdeUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPreferencePropertyChangeListener);
        return section;
    }

    private Section createPropertyMappingSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = this.createSection(toolkit, parent, 450, Messages.SyncRuleOverviewPage_PROPERTY_MAPPINGS_SECTION_TITLE);
        Composite sectionComposite = toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)sectionComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sectionComposite);
        this.fPropertyMappingTableViewer = new ConstrainedTableViewer(toolkit, sectionComposite, 84738, false);
        this.fPropertyMappingTable = this.fPropertyMappingTableViewer.getTable();
        this.fPropertyMappingTable.setHeaderVisible(true);
        this.fPropertyMappingTable.setLinesVisible(true);
        this.fPropertyMappingTable.setEnabled(true);
        TableColumnInfo.createColumns(this.fPropertyMappingTable, PROPERTY_MAPPINGS_COLUMN_INFO, this.fResourceManager);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fPropertyMappingTable);
        this.fPropertyMappingTable.getColumn(1).addSelectionListener(this.fPropertyMappingColumnSortListener);
        this.fPropertyMappingTable.getColumn(4).addSelectionListener(this.fPropertyMappingColumnSortListener);
        this.fPropertyMappingTable.setSortColumn(this.fPropertyMappingTable.getColumn(1));
        this.fPropertyMappingTable.setSortDirection(128);
        this.fPropertyMappingTable.getColumn(0).setToolTipText(Messages.SyncRuleOverviewPage_ITEM_IDENTIFIER_COLUMN_TOOLTIP);
        this.fPropertyMappingTable.getColumn(3).setToolTipText(Messages.SyncRuleOverviewPage_EXTERNAL_IDENTIFIER_COLUMN_TOOLTIP);
        this.fPropertyMappingTable.getColumn(2).setToolTipText(Messages.SyncRuleOverviewPage_DIRECTION_COLUMN_TOOLTIP);
        this.fPropertyMappingTableViewer.setContentProvider((IContentProvider)new PropertyMappingContentProvider());
        this.fPropertyMappingTableViewer.setLabelProvider((IBaseLabelProvider)new PropertyMappingLabelProvider(this.fItemPropertyChoices, this.fExternalPropertyChoices, this.fResourceManager));
        this.fPropertyMappingTableViewer.setComparator(this.fPropertyMappingViewerComparator);
        this.fPropertyMappingTableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SyncRuleOverviewPage.this.propertyMappingSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        ConstrainedTableViewer.hookResizeHandler((Composite)section, this.fPropertyMappingTable, PROPERTY_MAPPINGS_COLUMN_INFO);
        Composite buttonComposite = toolkit.createComposite(sectionComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(buttonComposite);
        GridDataFactory.fillDefaults().grab(false, false).align(1, 128).applyTo((Control)buttonComposite);
        this.fAddPropertyMappingsButton = toolkit.createButton(buttonComposite, Messages.SyncRuleOverviewPage_PROPERTY_ADD_BUTTON_LABEL, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 128).applyTo((Control)this.fAddPropertyMappingsButton);
        this.fAddPropertyMappingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.editPropertyMappings(false);
            }
        });
        this.fRemovePropertyMappingsButton = toolkit.createButton(buttonComposite, Messages.SyncRuleOverviewPage_PROPERTY_REMOVE_BUTTON_LABEL, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 128).applyTo((Control)this.fRemovePropertyMappingsButton);
        this.fRemovePropertyMappingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.removePropertyMappings();
            }
        });
        this.fInitializePropertyMappingsButton = toolkit.createButton(buttonComposite, Messages.SyncRuleOverviewPage_PROPERTY_INITIALIZE_BUTTON_LABEL, 8);
        this.fInitializePropertyMappingsButton.setToolTipText(Messages.SyncRuleOverviewPage_INITIALIZE_BUTTON_TOOLTIP);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 128).applyTo((Control)this.fInitializePropertyMappingsButton);
        this.fInitializePropertyMappingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.editPropertyMappings(true);
            }
        });
        Group detailsComposite = new Group(sectionComposite, 0);
        this.fMappingDetailsComposite = detailsComposite;
        detailsComposite.setText(Messages.SyncRuleOverviewPage_MAPPING_DETAILS_LABEL);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo((Composite)detailsComposite);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)detailsComposite);
        Composite propertyNameComposite = new Composite((Composite)detailsComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(propertyNameComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)propertyNameComposite);
        toolkit.createLabel(propertyNameComposite, Messages.SyncRuleOverviewPage_ITEM_PROPERTY_LABEL);
        toolkit.createLabel(propertyNameComposite, Messages.SyncRuleOverviewPage_SYNC_DIRECTION_LABEL);
        toolkit.createLabel(propertyNameComposite, Messages.SyncRuleOverviewPage_EXTERNAL_PROPERTY_LABEL);
        this.fNoItemPropertyButton = toolkit.createButton(propertyNameComposite, Messages.SyncRuleOverviewPage_NONE_BUTTON_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fNoItemPropertyButton);
        this.fNoItemPropertyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.noItemPropertyButtonSelected();
            }
        });
        toolkit.createLabel(propertyNameComposite, EMPTY);
        this.fNoExternalPropertyButton = toolkit.createButton(propertyNameComposite, Messages.SyncRuleOverviewPage_NONE_BUTTON_LABEL, 32);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fNoExternalPropertyButton);
        this.fNoExternalPropertyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.noExternalPropertyButtonSelected();
            }
        });
        this.fItemPropertyNameCombo = new Combo(propertyNameComposite, 4);
        GridDataFactory.fillDefaults().grab(true, false).hint(60, -1).applyTo((Control)this.fItemPropertyNameCombo);
        this.fItemPropertyNameCombo.setToolTipText(Messages.SyncRuleOverviewPage_ITEM_PROPERTY_TOOLTIP);
        this.fItemPropertyNameCombo.addModifyListener(this.fMappingDirtyModifyListener);
        this.fItemPropertyNameCombo.addSelectionListener(this.fMappingDirtySelectionListener);
        this.fSyncDirectionCombo = new Combo(propertyNameComposite, 12);
        GridDataFactory.fillDefaults().grab(true, false).hint(30, -1).applyTo((Control)this.fSyncDirectionCombo);
        this.fSyncDirectionCombo.setToolTipText(Messages.SyncRuleOverviewPage_SYNC_DIRECTION_TOOLTIP);
        this.fSyncDirectionCombo.addModifyListener(this.fMappingDirtyModifyListener);
        this.fExternalPropertyNameCombo = new Combo(propertyNameComposite, 4);
        GridDataFactory.fillDefaults().grab(true, false).hint(60, -1).applyTo((Control)this.fExternalPropertyNameCombo);
        this.fExternalPropertyNameCombo.setToolTipText(Messages.SyncRuleOverviewPage_EXTERNAL_PROPERTY_TOOLTIP);
        this.fExternalPropertyNameCombo.addModifyListener(this.fMappingDirtyModifyListener);
        this.fExternalPropertyNameCombo.addSelectionListener(this.fMappingDirtySelectionListener);
        this.fItemIdentifierButton = toolkit.createButton(propertyNameComposite, Messages.SyncRuleOverviewPage_ITEM_IDENTIFIER_LABEL, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.fItemIdentifierButton);
        this.fItemIdentifierButton.setToolTipText(Messages.SyncRuleOverviewPage_ITEM_IDENTIFIER_TOOLTIP);
        this.fItemIdentifierButton.addSelectionListener(this.fMappingDirtySelectionListener);
        this.fExternalIdentifierButton = toolkit.createButton(propertyNameComposite, Messages.SyncRuleOverviewPage_EXTERNAL_IDENTIFIER_LABEL, 32);
        this.fExternalIdentifierButton.setToolTipText(Messages.SyncRuleOverviewPage_EXTERNAL_IDENTIFIER_TOOLTIP);
        this.fExternalIdentifierButton.addSelectionListener(this.fMappingDirtySelectionListener);
        Label dummy = toolkit.createLabel(propertyNameComposite, EMPTY);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)dummy);
        this.fExternalModifierButton = toolkit.createButton(propertyNameComposite, Messages.SyncRuleOverviewPage_EXTERNAL_MODIFIER_LABEL, 32);
        this.fExternalModifierButton.setToolTipText(Messages.SyncRuleOverviewPage_EXTERNAL_MODIFIER_TOOLTIP);
        this.fExternalModifierButton.addSelectionListener(this.fMappingDirtySelectionListener);
        this.fNoTransformButton = new Button((Composite)detailsComposite, 32);
        GridDataFactory.fillDefaults().applyTo((Control)this.fNoTransformButton);
        this.fNoTransformButton.setText(Messages.SyncRuleOverviewPage_NO_TRANSFORM_LABEL);
        this.fNoTransformButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.noTransformPressed();
                SyncRuleOverviewPage.this.setMappingDirty(true);
            }
        });
        Composite valueTransformComposite = new Composite((Composite)detailsComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(valueTransformComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)valueTransformComposite);
        toolkit.createLabel(valueTransformComposite, Messages.SyncRuleOverviewPage_REFERENCE_SYNCRULE_LABEL, 0);
        this.fReferenceSyncRuleCombo = new Combo(valueTransformComposite, 4);
        GridDataFactory.fillDefaults().grab(true, false).hint(60, -1).applyTo((Control)this.fReferenceSyncRuleCombo);
        this.fReferenceSyncRuleCombo.setToolTipText(Messages.SyncRuleOverviewPage_REFERENCE_SYNCRULE_TOOLTIP);
        this.fReferenceSyncRuleCombo.addModifyListener(this.fMappingDirtyModifyListener);
        toolkit.createLabel(valueTransformComposite, Messages.SyncRuleOverviewPage_VALUE_TRANSFORMER_LABEL, 0);
        this.fValueTransformerCombo = new Combo(valueTransformComposite, 12);
        GridDataFactory.fillDefaults().grab(true, false).hint(60, -1).applyTo((Control)this.fValueTransformerCombo);
        this.fValueTransformerCombo.setToolTipText(Messages.SyncRuleOverviewPage_VALUE_TRANSFORMER_TOOLTIP);
        this.fValueTransformerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.valueTransformerSelectionChanged();
            }
        });
        toolkit.createLabel(valueTransformComposite, EMPTY);
        this.fRequiredPropertiesLink = toolkit.createHyperlink(valueTransformComposite, Messages.SyncRuleOverviewPage_REQUIRED_PROPERTIES_LABEL, 0);
        GridDataFactory.fillDefaults().applyTo((Control)this.fRequiredPropertiesLink);
        this.fRequiredPropertiesLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SyncRuleOverviewPage.this.editRequiredProperties();
            }
        });
        toolkit.createLabel((Composite)detailsComposite, Messages.SyncRuleOverviewPage_VALUE_MAPPINGS_LABEL, 0);
        Composite valueMappingsComposite = new Composite((Composite)detailsComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(valueMappingsComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)valueMappingsComposite);
        this.fValueMappingsTableViewer = new ConstrainedTableViewer(toolkit, valueMappingsComposite, 68354, false);
        Table table = this.fValueMappingsTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumnInfo.createColumns(table, VALUE_MAPPINGS_COLUMN_INFO, this.fResourceManager);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        table.getColumn(0).addSelectionListener(this.fValueMappingColumnSortListener);
        table.getColumn(1).addSelectionListener(this.fValueMappingColumnSortListener);
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(128);
        this.fValueMappingsTableViewer.setContentProvider((IContentProvider)new ValueMappingsContentProvider());
        this.fValueMappingsTableViewer.setLabelProvider((IBaseLabelProvider)new ValueMappingsLabelProvider(this.fResourceManager));
        this.fValueMappingsTableViewer.setComparator(this.fValueMappingViewerComparator);
        this.fValueMappingsTableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SyncRuleOverviewPage.this.valueMappingSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        this.fValueMappingsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SyncRuleOverviewPage.this.editValueMappings(true, false);
            }
        });
        ConstrainedTableViewer.hookResizeHandler(valueMappingsComposite, table, VALUE_MAPPINGS_COLUMN_INFO);
        buttonComposite = new Composite(valueMappingsComposite, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonComposite);
        GridDataFactory.fillDefaults().grab(false, false).align(1, 128).applyTo((Control)buttonComposite);
        this.fAddValueMappingsButton = new Button(buttonComposite, 8);
        this.fAddValueMappingsButton.setText(Messages.SyncRuleOverviewPage_VALUE_ADD_BUTTON_LABEL);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)this.fAddValueMappingsButton);
        this.fAddValueMappingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.editValueMappings(false, false);
            }
        });
        this.fRemoveValueMappingsButton = new Button(buttonComposite, 8);
        this.fRemoveValueMappingsButton.setText(Messages.SyncRuleOverviewPage_VALUE_REMOVE_BUTTON_LABEL);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)this.fRemoveValueMappingsButton);
        this.fRemoveValueMappingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.removeValueMappings();
            }
        });
        this.fChangeValueMappingButton = new Button(buttonComposite, 8);
        this.fChangeValueMappingButton.setText(Messages.SyncRuleOverviewPage_VALUE_CHANGE_BUTTON_LABEL);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)this.fChangeValueMappingButton);
        this.fChangeValueMappingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.editValueMappings(true, false);
            }
        });
        this.fInitializeValueMappingsButton = toolkit.createButton(buttonComposite, Messages.SyncRuleOverviewPage_VALUE_INITIALIZE_BUTTON_LABEL, 8);
        this.fInitializeValueMappingsButton.setToolTipText(Messages.SyncRuleOverviewPage_INITIALIZE_VALUE_MAPPINGS_TOOLTIP);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 128).applyTo((Control)this.fInitializeValueMappingsButton);
        this.fInitializeValueMappingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncRuleOverviewPage.this.editValueMappings(false, true);
            }
        });
        return section;
    }

    private void archiveFilterSelected() {
        this.fTeamAreaSelector.setIncludeArchived(this.fShowArchivedButton.getSelection());
        InteropIdeUIPlugin.getDefault().getPreferenceStore().setValue("syncRuleEditor.showArchivedTeamAreas", this.fShowArchivedButton.getSelection());
    }

    private void itemTypeSelected() {
        ITypeInfoDTO typeInfo = WidgetUtil.getComboSelection(this.fItemTypeCombo, this.fItemTypeChoices);
        if (typeInfo == null) {
            this.createItemManagerChoices(null);
            this.fItemTypeQualifierChoices.clear();
        } else {
            Map<String, ITypeInfoDTO> typeQualifierMap;
            List<IManagerInfoDTO> managerInfoList = this.fItemTypeToManagerInfoMap.get(typeInfo.getName());
            if (managerInfoList != null) {
                this.createItemManagerChoices(managerInfoList);
            }
            if ((typeQualifierMap = this.fItemTypeToTypeInfoMap.get(typeInfo.getName())) != null) {
                this.createTypeQualifierChoices(typeQualifierMap);
            }
        }
        WidgetUtil.setComboChoices(this.fItemManagerCombo, this.fItemManagerChoices, true);
        if (typeInfo == null) {
            WidgetUtil.setComboSelection(this.fItemManagerCombo, this.fItemManagerChoices.getDisplayNameByAlternateName(null), this.fItemManagerChoices);
        }
        WidgetUtil.setComboChoices(this.fItemTypeQualifierCombo, this.fItemTypeQualifierChoices, true);
        this.itemTypeSelectionChanged();
    }

    private void externalManagerOrRepositorySelected() {
        if (!this.fWorkingCopy.isLicensed()) {
            return;
        }
        SyncRuleEditor editor = (SyncRuleEditor)this.getEditor();
        IManagerInfoDTO managerInfo = WidgetUtil.getComboSelection(this.fExternalManagerCombo, this.fExternalManagerChoices);
        IExternalRepositoryConnection externalConnection = WidgetUtil.getComboSelection(this.fExternalRepositoryCombo, this.fExternalRepositoryChoices);
        if (!this.fFetchExternalTypeInfoJob.cancel()) {
            try {
                this.fFetchExternalTypeInfoJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (managerInfo == null || externalConnection == null) {
            editor.updateStatus(null);
            this.fExternalTypeChoices.clear();
            WidgetUtil.setComboChoices(this.fExternalTypeCombo, this.fExternalTypeChoices, true);
            return;
        }
        editor.updateStatus(StatusUtil.newStatus((Object)((Object)this), (int)1, (String)Messages.SyncRuleOverviewPage_MESSAGE_FETCHING_EXTERNAL_TYPE_INFO));
        this.fFetchExternalTypeInfoJob.setJobInfo(managerInfo, externalConnection, this.fInitialized);
        this.fFetchExternalTypeInfoJob.schedule();
    }

    private void itemTypeSelectionChanged() {
        ITypeInfoDTO typeInfo = WidgetUtil.getComboSelection(this.fItemTypeCombo, this.fItemTypeChoices);
        this.fInitializePropertyMappingsButton.setEnabled(typeInfo != null);
    }

    private void propertyMappingSelectionChanged(IStructuredSelection selection) {
        this.fRemovePropertyMappingsButton.setEnabled(selection.size() > 0);
        this.refreshMappingDetails();
    }

    private void valueMappingSelectionChanged(IStructuredSelection selection) {
        this.fRemoveValueMappingsButton.setEnabled(selection.size() > 0);
        this.fChangeValueMappingButton.setEnabled(selection.size() == 1);
    }

    private void valueTransformerSelectionChanged() {
        ITransformerInfoDTO transformerInfo = WidgetUtil.getComboSelection(this.fValueTransformerCombo, this.fValueTransformerChoices);
        this.fRequiredPropertiesLink.setVisible(transformerInfo != null);
        this.setMappingDirty(true);
    }

    protected void noItemPropertyButtonSelected() {
        boolean enabled;
        boolean bl = enabled = !this.fNoItemPropertyButton.getSelection();
        if (!enabled) {
            WidgetUtil.setComboSelection(this.fItemPropertyNameCombo, null, this.fItemPropertyChoices);
        }
        this.fItemPropertyNameCombo.setEnabled(enabled);
        this.setMappingDirty(true);
    }

    protected void noExternalPropertyButtonSelected() {
        boolean enabled;
        boolean bl = enabled = !this.fNoExternalPropertyButton.getSelection();
        if (!enabled) {
            WidgetUtil.setComboSelection(this.fExternalPropertyNameCombo, null, this.fExternalPropertyChoices);
        }
        this.fExternalPropertyNameCombo.setEnabled(enabled);
        this.setMappingDirty(true);
    }

    private void setMappingDirty(boolean dirty) {
        if (this.fInitialized) {
            this.fMappingDirty = dirty;
            if (dirty) {
                this.setPageDirty(dirty);
            }
        }
    }

    private void refreshMappingDetails() {
        this.commitMappingDetails();
        boolean wasInitialized = this.fInitialized;
        this.fInitialized = false;
        this.createSyncDirectionChoices();
        WidgetUtil.setComboChoices(this.fSyncDirectionCombo, this.fSyncDirectionChoices, false);
        IStructuredSelection selection = (IStructuredSelection)this.fPropertyMappingTableViewer.getSelection();
        if (selection.size() != 1) {
            this.fCurrentMapping = null;
            this.fNoItemPropertyButton.setSelection(true);
            this.fNoExternalPropertyButton.setSelection(true);
            WidgetUtil.setComboSelection(this.fItemPropertyNameCombo, null, this.fItemPropertyChoices);
            WidgetUtil.setComboSelection(this.fExternalPropertyNameCombo, null, this.fExternalPropertyChoices);
            WidgetUtil.setComboSelection(this.fSyncDirectionCombo, Messages.SyncRuleOverviewPage_CHOICE_NONE, this.fSyncDirectionChoices);
            this.fItemIdentifierButton.setSelection(false);
            this.fExternalIdentifierButton.setSelection(false);
            this.fExternalModifierButton.setSelection(false);
            this.fNoTransformButton.setSelection(true);
            WidgetUtil.setComboSelection(this.fReferenceSyncRuleCombo, null, this.fReferenceSyncRuleChoices);
            WidgetUtil.setComboSelection(this.fValueTransformerCombo, null, this.fValueTransformerChoices);
            this.fValueMappingsTableViewer.setInput(null);
            this.fMappingDetailsComposite.setEnabled(false);
        } else {
            this.fCurrentMapping = (IPropertyMapping)selection.getFirstElement();
            this.createItemPropertyChoices(this.getSelectedItemTypeInfo());
            this.createExternalPropertyChoices(this.getSelectedExternalTypeInfo());
            this.fMappingDetailsComposite.setEnabled(true);
            WidgetUtil.setComboChoices(this.fItemPropertyNameCombo, this.fItemPropertyChoices, false);
            String propName = this.fCurrentMapping.getItemPropertyName();
            if (propName == null || propName.length() == 0) {
                this.fNoItemPropertyButton.setSelection(true);
                WidgetUtil.setComboSelection(this.fItemPropertyNameCombo, null, this.fItemPropertyChoices);
            } else {
                this.fNoItemPropertyButton.setSelection(false);
                WidgetUtil.setComboSelection(this.fItemPropertyNameCombo, this.fItemPropertyChoices.getDisplayNameByAlternateName(propName), this.fItemPropertyChoices);
            }
            WidgetUtil.setComboChoices(this.fExternalPropertyNameCombo, this.fExternalPropertyChoices, false);
            propName = this.fCurrentMapping.getExternalPropertyName();
            if (propName == null || propName.length() == 0) {
                this.fNoExternalPropertyButton.setSelection(true);
                WidgetUtil.setComboSelection(this.fExternalPropertyNameCombo, null, this.fExternalPropertyChoices);
            } else {
                this.fNoExternalPropertyButton.setSelection(false);
                WidgetUtil.setComboSelection(this.fExternalPropertyNameCombo, this.fExternalPropertyChoices.getDisplayNameByAlternateName(propName), this.fExternalPropertyChoices);
            }
            SyncDirection syncDirection = this.fCurrentMapping.isIncoming() && this.fCurrentMapping.isOutgoing() ? SyncDirection.IN_OUT : (this.fCurrentMapping.isIncoming() ? SyncDirection.IN : (this.fCurrentMapping.isOutgoing() ? SyncDirection.OUT : SyncDirection.NONE));
            WidgetUtil.setComboSelection(this.fSyncDirectionCombo, this.fSyncDirectionChoices.getDisplayNameByAlternateName(syncDirection.name()), this.fSyncDirectionChoices);
            this.fItemIdentifierButton.setSelection(this.fCurrentMapping.isItemIdentifier());
            this.fExternalIdentifierButton.setSelection(this.fCurrentMapping.isExternalIdentifier());
            this.fExternalModifierButton.setSelection(this.fCurrentMapping.isExternalModifier());
            this.fNoTransformButton.setSelection(!(this.fCurrentMapping.getReferenceSyncRule() != null && this.fCurrentMapping.getReferenceSyncRule().length() != 0 || this.fCurrentMapping.getTransformExtension() != null && this.fCurrentMapping.getTransformExtension().length() != 0 || !this.fCurrentMapping.getValueMappings().isEmpty()));
            this.createSyncRuleChoices();
            WidgetUtil.setComboChoices(this.fReferenceSyncRuleCombo, this.fReferenceSyncRuleChoices, false);
            WidgetUtil.setComboSelection(this.fReferenceSyncRuleCombo, this.fCurrentMapping.getReferenceSyncRule(), this.fReferenceSyncRuleChoices);
            this.createTransformerChoices();
            WidgetUtil.setComboChoices(this.fValueTransformerCombo, this.fValueTransformerChoices, false);
            WidgetUtil.setComboSelection(this.fValueTransformerCombo, this.fValueTransformerChoices.getDisplayNameByAlternateName(this.fCurrentMapping.getTransformExtension()), this.fValueTransformerChoices);
            this.fValueMappingsTableViewer.setInput((Object)this.fCurrentMapping);
            this.valueMappingSelectionChanged((IStructuredSelection)this.fValueMappingsTableViewer.getSelection());
        }
        this.noTransformPressed();
        this.noItemPropertyButtonSelected();
        this.noExternalPropertyButtonSelected();
        this.fInitialized = wasInitialized;
    }

    private void commitMappingDetails() {
        if (this.fCurrentMapping == null || !this.fMappingDirty) {
            return;
        }
        IPropertyInfoDTO propertyInfo = WidgetUtil.getComboSelection(this.fItemPropertyNameCombo, this.fItemPropertyChoices);
        if (propertyInfo != null) {
            this.fCurrentMapping.setItemPropertyName(propertyInfo.getName());
        } else {
            this.fCurrentMapping.setItemPropertyName(this.fItemPropertyNameCombo.getText());
        }
        propertyInfo = WidgetUtil.getComboSelection(this.fExternalPropertyNameCombo, this.fExternalPropertyChoices);
        if (propertyInfo != null) {
            this.fCurrentMapping.setExternalPropertyName(propertyInfo.getName());
        } else {
            this.fCurrentMapping.setExternalPropertyName(this.fExternalPropertyNameCombo.getText());
        }
        SyncDirection syncDirection = WidgetUtil.getComboSelection(this.fSyncDirectionCombo, this.fSyncDirectionChoices);
        if (syncDirection == null) {
            syncDirection = SyncDirection.NONE;
        }
        switch (syncDirection) {
            case NONE: {
                this.fCurrentMapping.setIncoming(false);
                this.fCurrentMapping.setOutgoing(false);
                break;
            }
            case IN: {
                this.fCurrentMapping.setIncoming(true);
                this.fCurrentMapping.setOutgoing(false);
                break;
            }
            case OUT: {
                this.fCurrentMapping.setIncoming(false);
                this.fCurrentMapping.setOutgoing(true);
                break;
            }
            case IN_OUT: {
                this.fCurrentMapping.setIncoming(true);
                this.fCurrentMapping.setOutgoing(true);
            }
        }
        this.fCurrentMapping.setItemIdentifier(this.fItemIdentifierButton.getSelection());
        this.fCurrentMapping.setExternalIdentifier(this.fExternalIdentifierButton.getSelection());
        this.fCurrentMapping.setExternalModifier(this.fExternalModifierButton.getSelection());
        if (this.fNoTransformButton.getSelection()) {
            this.fCurrentMapping.setReferenceSyncRule(null);
            this.fCurrentMapping.setTransformExtension(null);
            this.fCurrentMapping.getValueMappings().clear();
        } else {
            this.fCurrentMapping.setReferenceSyncRule(this.fReferenceSyncRuleCombo.getText());
            ITransformerInfoDTO transformerInfo = WidgetUtil.getComboSelection(this.fValueTransformerCombo, this.fValueTransformerChoices);
            if (transformerInfo != null) {
                this.fCurrentMapping.setTransformExtension(transformerInfo.getId());
            } else {
                this.fCurrentMapping.setTransformExtension(null);
            }
        }
        this.fPropertyMappingTableViewer.update((Object)this.fCurrentMapping, null);
        this.setMappingDirty(false);
    }

    private ITypeInfoDTO getSelectedItemTypeInfo() {
        Map<String, ITypeInfoDTO> subTypeInfoMap;
        String itemTypeName = null;
        ITypeInfoDTO itemTypeInfo = WidgetUtil.getComboSelection(this.fItemTypeCombo, this.fItemTypeChoices);
        itemTypeName = itemTypeInfo != null ? itemTypeInfo.getName() : this.fItemTypeCombo.getText();
        if (itemTypeName != null && (subTypeInfoMap = this.fItemTypeToTypeInfoMap.get(itemTypeName)) != null) {
            if (subTypeInfoMap.size() == 1) {
                itemTypeInfo = subTypeInfoMap.values().iterator().next();
            } else {
                itemTypeInfo = WidgetUtil.getComboSelection(this.fItemTypeQualifierCombo, this.fItemTypeQualifierChoices);
                if (itemTypeInfo == null && this.fItemTypeQualifierCombo.getText() != null) {
                    itemTypeInfo = subTypeInfoMap.get(this.fItemTypeQualifierCombo.getText());
                }
            }
        }
        return itemTypeInfo;
    }

    private ITypeInfoDTO getSelectedExternalTypeInfo() {
        ITypeInfoDTO externalTypeInfo = WidgetUtil.getComboSelection(this.fExternalTypeCombo, this.fExternalTypeChoices);
        if (externalTypeInfo == null && this.fExternalTypeCombo.getText() != null) {
            String shortTypeName = this.createShortNameFromDottedName(this.fExternalTypeCombo.getText());
            externalTypeInfo = this.fShortExternalTypeToTypeInfoMap.get(shortTypeName);
        }
        return externalTypeInfo;
    }

    private void noTransformPressed() {
        boolean transformEnabled = !this.fNoTransformButton.getSelection();
        this.fReferenceSyncRuleCombo.setEnabled(transformEnabled);
        this.fValueTransformerCombo.setEnabled(transformEnabled);
        this.fValueMappingsTableViewer.getTable().setEnabled(transformEnabled);
        this.fAddValueMappingsButton.setEnabled(transformEnabled);
        this.fRemoveValueMappingsButton.setEnabled(transformEnabled);
        this.fChangeValueMappingButton.setEnabled(transformEnabled);
        this.fInitializeValueMappingsButton.setEnabled(transformEnabled);
        this.fRequiredPropertiesLink.setEnabled(transformEnabled);
        this.valueTransformerSelectionChanged();
        if (transformEnabled) {
            this.valueMappingSelectionChanged((IStructuredSelection)this.fValueMappingsTableViewer.getSelection());
        } else {
            this.fValueMappingsTableViewer.setInput(null);
        }
    }

    private void editPropertyMappings(boolean initialize) {
        IPropertyMapping[] newMappings = null;
        ITypeInfoDTO itemTypeInfo = this.getSelectedItemTypeInfo();
        ITypeInfoDTO externalTypeInfo = this.getSelectedExternalTypeInfo();
        if (initialize) {
            this.createItemPropertyChoices(itemTypeInfo);
            this.createExternalPropertyChoices(externalTypeInfo);
            newMappings = this.addCandidatePropertyMappings(itemTypeInfo, externalTypeInfo);
        } else {
            WidgetUtil.ComboChoices<IPropertyInfoDTO> itemPropertyChoices = this.createUnmappedItemPropertyChoices(itemTypeInfo);
            WidgetUtil.ComboChoices<IPropertyInfoDTO> externalPropertyChoices = this.createUnmappedExternalPropertyChoices(externalTypeInfo);
            this.createSyncDirectionChoices();
            PropertyMappingDialog dialog = new PropertyMappingDialog(this.getEditorSite().getShell(), itemPropertyChoices, externalPropertyChoices, this.fSyncDirectionChoices, this.fResourceManager);
            if (dialog.open() == 0) {
                newMappings = dialog.getPropertyMappings();
            }
        }
        if (newMappings != null && newMappings.length != 0) {
            ISyncRule syncRule = this.fWorkingCopy.getSyncRule();
            syncRule.addPropertyMappings(newMappings);
            this.fPropertyMappingTableViewer.refresh();
            this.fPropertyMappingTableViewer.setSelection((ISelection)new StructuredSelection((Object)newMappings[0]));
            this.fPropertyMappingTableViewer.getTable().showSelection();
            this.propertyMappingSelectionChanged((IStructuredSelection)this.fPropertyMappingTableViewer.getSelection());
            this.setPageDirty(true);
        }
    }

    private IPropertyMapping[] addCandidatePropertyMappings(ITypeInfoDTO itemTypeInfo, ITypeInfoDTO externalTypeInfo) {
        if (itemTypeInfo == null) {
            return new IPropertyMapping[0];
        }
        HashSet<String> existingItemProperties = new HashSet<String>();
        HashSet<String> existingExternalProperties = new HashSet<String>();
        List currentMappings = this.fWorkingCopy.getSyncRule().getPropertyMappings();
        ArrayList<IPropertyMapping> newMappings = new ArrayList<IPropertyMapping>();
        for (IPropertyMapping mapping : currentMappings) {
            if (mapping.getItemPropertyName() != null && mapping.getItemPropertyName().length() != 0) {
                existingItemProperties.add(mapping.getItemPropertyName());
            }
            if (mapping.getExternalPropertyName() == null || mapping.getExternalPropertyName().length() == 0) continue;
            existingExternalProperties.add(mapping.getExternalPropertyName());
        }
        for (IPropertyInfoDTO itemPropInfo : itemTypeInfo.getProperties()) {
            String itemPropName = itemPropInfo.getName();
            if (existingItemProperties.contains(itemPropName)) continue;
            IPropertyInfoDTO externalPropInfo = this.findMatchingExternalPropertyInfo(itemPropInfo, externalTypeInfo, existingExternalProperties);
            IPropertyMapping mapping = InteropFactory.INSTANCE.createPropertyMapping();
            mapping.setItemPropertyName(itemPropName);
            mapping.setItemIdentifier(itemPropInfo.isIdentifier());
            mapping.setTransformExtension(itemPropInfo.getTransformer());
            mapping.setRequiredItemPropertiesList(itemPropInfo.getRequiredProperties());
            mapping.setIncoming(true);
            if (externalPropInfo != null) {
                mapping.setExternalPropertyName(externalPropInfo.getName());
                mapping.setExternalIdentifier(externalPropInfo.isIdentifier());
                mapping.setExternalModifier(externalPropInfo.isModifier());
                mapping.setTransformExtension(externalPropInfo.getTransformer());
                mapping.setRequiredExternalPropertiesList(externalPropInfo.getRequiredProperties());
                mapping.setOutgoing(true);
                existingExternalProperties.add(externalPropInfo.getName());
            }
            newMappings.add(mapping);
        }
        return newMappings.toArray(new IPropertyMapping[newMappings.size()]);
    }

    private IPropertyInfoDTO findMatchingExternalPropertyInfo(IPropertyInfoDTO itemPropInfo, ITypeInfoDTO externalTypeInfo, Set<String> alreadyMappedExternalPropNames) {
        if (externalTypeInfo == null) {
            return null;
        }
        String itemPropNameText = this.canonicalizeText(itemPropInfo.getName());
        String itemDisplayNameText = this.canonicalizeText(itemPropInfo.getDisplayname());
        IPropertyInfoDTO externalPropInfo = null;
        for (IPropertyInfoDTO propInfo : externalTypeInfo.getProperties()) {
            if (alreadyMappedExternalPropNames.contains(propInfo.getName())) continue;
            String externalPropNameText = this.canonicalizeText(propInfo.getName());
            String externalDisplayNameText = this.canonicalizeText(propInfo.getDisplayname());
            if (!itemPropNameText.contains(externalPropNameText) && !externalPropNameText.contains(itemPropNameText) && (itemDisplayNameText == null || !itemDisplayNameText.contains(externalPropNameText) && !externalPropNameText.contains(itemDisplayNameText)) && (externalDisplayNameText == null || !itemPropNameText.contains(externalDisplayNameText) && !externalDisplayNameText.contains(itemPropNameText)) && (itemDisplayNameText == null || externalDisplayNameText == null || !itemDisplayNameText.contains(externalDisplayNameText) && !externalDisplayNameText.contains(itemDisplayNameText)) || externalPropInfo != null && propInfo.getName().length() >= externalPropInfo.getName().length()) continue;
            externalPropInfo = propInfo;
        }
        return externalPropInfo;
    }

    private String canonicalizeText(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll(IGNORED_REGEXP, EMPTY).toLowerCase();
    }

    private void removePropertyMappings() {
        ISyncRule syncRule = this.fWorkingCopy.getSyncRule();
        List mappings = syncRule.getPropertyMappings();
        IStructuredSelection selection = (IStructuredSelection)this.fPropertyMappingTableViewer.getSelection();
        List toRemove = selection.toList();
        Iterator iterator = mappings.iterator();
        while (iterator.hasNext()) {
            if (!toRemove.contains(iterator.next())) continue;
            iterator.remove();
        }
        this.fPropertyMappingTableViewer.refresh();
        this.setPageDirty(true);
    }

    private void editValueMappings(boolean selected, boolean initialize) {
        IStructuredSelection selection;
        IValueMapping editMapping = null;
        IValueMapping[] newMappings = null;
        if (selected && (selection = (IStructuredSelection)this.fValueMappingsTableViewer.getSelection()).size() == 1) {
            editMapping = (IValueMapping)selection.getFirstElement();
        }
        IValueMapping[] currentMappings = this.fCurrentMapping.getValueMappings().toArray(new IValueMapping[0]);
        Arrays.sort(currentMappings, this.fValueMappingComparator);
        IPropertyInfoDTO itemPropertyInfo = WidgetUtil.getComboSelection(this.fItemPropertyNameCombo, this.fItemPropertyChoices);
        IPropertyInfoDTO externalPropertyInfo = WidgetUtil.getComboSelection(this.fExternalPropertyNameCombo, this.fExternalPropertyChoices);
        if (initialize) {
            newMappings = this.addCandidateValueMappings(itemPropertyInfo, externalPropertyInfo);
        } else {
            ValueMappingDialog dialog = new ValueMappingDialog(this.getEditorSite().getShell(), this.createItemPropertyValueChoices(itemPropertyInfo, currentMappings), this.createExternalPropertyValueChoices(externalPropertyInfo, currentMappings), editMapping, this.fResourceManager);
            if (dialog.open() == 0) {
                newMappings = dialog.getValueMappings();
            }
        }
        if (newMappings != null && newMappings.length != 0) {
            if (selected) {
                this.fValueMappingsTableViewer.update((Object)editMapping, null);
            } else {
                IValueMapping[] iValueMappingArray = newMappings;
                int n = newMappings.length;
                int n2 = 0;
                while (n2 < n) {
                    IValueMapping mapping = iValueMappingArray[n2];
                    this.fCurrentMapping.getValueMappings().add(mapping);
                    ++n2;
                }
                this.fValueMappingsTableViewer.setInput((Object)this.fCurrentMapping);
                this.fValueMappingsTableViewer.refresh();
                this.fValueMappingsTableViewer.setSelection((ISelection)new StructuredSelection((Object)newMappings[0]));
                this.fValueMappingsTableViewer.getTable().showSelection();
                this.valueMappingSelectionChanged((IStructuredSelection)this.fValueMappingsTableViewer.getSelection());
            }
            this.setMappingDirty(true);
        }
    }

    private IValueMapping[] addCandidateValueMappings(IPropertyInfoDTO itemPropertyInfo, IPropertyInfoDTO externalPropertyInfo) {
        if (itemPropertyInfo == null) {
            return new IValueMapping[0];
        }
        HashSet<String> existingItemValues = new HashSet<String>();
        HashSet<String> existingExternalValues = new HashSet<String>();
        List currentMappings = this.fCurrentMapping.getValueMappings();
        ArrayList<IValueMapping> newMappings = new ArrayList<IValueMapping>();
        for (IValueMapping mapping : currentMappings) {
            if (mapping.getItemValue() != null && mapping.getItemValue().length() != 0) {
                existingItemValues.add(mapping.getItemValue());
            }
            if (mapping.getExternalValue() == null || mapping.getExternalValue().length() == 0) continue;
            existingExternalValues.add(mapping.getExternalValue());
        }
        for (String itemValue : itemPropertyInfo.getAllowedValues()) {
            if (existingItemValues.contains(itemValue)) continue;
            String externalValue = this.findMatchingExternalValue(itemValue, externalPropertyInfo, existingExternalValues);
            IValueMapping mapping = InteropFactory.INSTANCE.createValueMapping();
            mapping.setItemValue(itemValue);
            if (externalValue != null) {
                mapping.setExternalValue(externalValue);
                existingExternalValues.add(externalValue);
            }
            newMappings.add(mapping);
        }
        return newMappings.toArray(new IValueMapping[newMappings.size()]);
    }

    private String findMatchingExternalValue(String itemValue, IPropertyInfoDTO externalPropertyInfo, Set<String> alreadyMappedExternalValues) {
        if (externalPropertyInfo == null) {
            return null;
        }
        String itemText = this.canonicalizeText(itemValue);
        String externalValue = null;
        for (String value : externalPropertyInfo.getAllowedValues()) {
            String externalText;
            if (alreadyMappedExternalValues.contains(value) || !itemText.contains(externalText = this.canonicalizeText(value)) && !externalText.contains(itemText) || externalValue != null && value.length() >= externalValue.length()) continue;
            externalValue = value;
        }
        return externalValue;
    }

    private void removeValueMappings() {
        List mappings = this.fCurrentMapping.getValueMappings();
        IStructuredSelection selection = (IStructuredSelection)this.fValueMappingsTableViewer.getSelection();
        List toRemove = selection.toList();
        Iterator iterator = mappings.iterator();
        while (iterator.hasNext()) {
            if (!toRemove.contains(iterator.next())) continue;
            iterator.remove();
        }
        this.fValueMappingsTableViewer.refresh();
        this.setMappingDirty(true);
    }

    private void editRequiredProperties() {
        RequiredPropertiesDialog dialog = new RequiredPropertiesDialog(this.getEditorSite().getShell(), this.fWorkingCopy.getSyncRule().getPropertyMappings(), this.fCurrentMapping, this.fResourceManager);
        if (dialog.open() == 0) {
            this.fCurrentMapping.setRequiredItemPropertiesList(dialog.getRequiredItemProperties());
            this.fCurrentMapping.setRequiredExternalPropertiesList(dialog.getRequiredExternalProperties());
            this.setMappingDirty(true);
        }
    }

    private Section createSection(FormToolkit toolkit, Composite parent, int style, String title) {
        Section section = toolkit.createSection(parent, style | 0x2000);
        section.setText(title);
        return section;
    }

    private void loadManagerInfo() {
        int n;
        this.fItemManagerToManagerInfoMap.clear();
        this.fItemTypeToManagerInfoMap.clear();
        this.fItemTypeToTypeInfoMap.clear();
        this.fItemManagerChoices.clear();
        this.fItemManagerChoices.add(Messages.SyncRuleOverviewPage_CHOICE_NONE, null, null);
        this.fItemTypeChoices.clear();
        this.fItemTypeChoices.add(Messages.SyncRuleOverviewPage_CHOICE_NONE, null, null);
        this.fItemTypeQualifierChoices.clear();
        IManagerInfoDTO[] managerInfo = this.fWorkingCopy.getItemManagerInfo();
        if (managerInfo != null) {
            IManagerInfoDTO[] iManagerInfoDTOArray = managerInfo;
            n = managerInfo.length;
            int n2 = 0;
            while (n2 < n) {
                IManagerInfoDTO info = iManagerInfoDTOArray[n2];
                String managerName = info.getName();
                if (managerName == null || managerName.length() == 0) {
                    managerName = info.getId();
                }
                this.fItemManagerChoices.add(managerName, info.getId(), info);
                this.fItemManagerToManagerInfoMap.put(info.getId(), info);
                ITypeInfoDTO[] managerTypeInfo = this.fWorkingCopy.getItemManagerTypeInfo(info);
                if (managerTypeInfo != null) {
                    ITypeInfoDTO[] iTypeInfoDTOArray = managerTypeInfo;
                    int n3 = managerTypeInfo.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ITypeInfoDTO typeInfo = iTypeInfoDTOArray[n4];
                        Map<String, ITypeInfoDTO> subTypeInfoMap = this.fItemTypeToTypeInfoMap.get(typeInfo.getName());
                        if (subTypeInfoMap == null) {
                            subTypeInfoMap = new HashMap<String, ITypeInfoDTO>();
                            String friendlyTypeName = this.createFriendlyDottedName(typeInfo.getName());
                            this.fItemTypeChoices.add(friendlyTypeName, typeInfo.getName(), typeInfo);
                            List<IManagerInfoDTO> managerInfoList = this.fItemTypeToManagerInfoMap.get(typeInfo.getName());
                            if (managerInfoList == null) {
                                managerInfoList = new ArrayList<IManagerInfoDTO>();
                            }
                            managerInfoList.add(info);
                            this.fItemTypeToManagerInfoMap.put(typeInfo.getName(), managerInfoList);
                        }
                        if (typeInfo.getQualifierId() == null) {
                            subTypeInfoMap.put(EMPTY, typeInfo);
                        } else {
                            subTypeInfoMap.put(typeInfo.getQualifierId(), typeInfo);
                        }
                        this.fItemTypeToTypeInfoMap.put(typeInfo.getName(), subTypeInfoMap);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        this.fExternalRepositoryChoices.clear();
        this.fExternalRepositoryChoices.add(Messages.SyncRuleOverviewPage_CHOICE_NONE, null, null);
        List externalRepositories = this.fWorkingCopy.getExternalRepositoryConnections();
        if (externalRepositories != null) {
            for (IExternalRepositoryConnection externalRepository : externalRepositories) {
                this.fExternalRepositoryChoices.add(externalRepository.getName(), null, externalRepository);
            }
        }
        this.fExternalManagerToManagerInfoMap.clear();
        this.fExternalTypeToManagerInfoMap.clear();
        this.fShortExternalTypeToTypeInfoMap.clear();
        this.fExternalManagerChoices.clear();
        this.fExternalManagerChoices.add(Messages.SyncRuleOverviewPage_CHOICE_NONE, null, null);
        this.fExternalTypeChoices.clear();
        managerInfo = this.fWorkingCopy.getExternalManagerInfo();
        if (managerInfo != null) {
            IManagerInfoDTO[] iManagerInfoDTOArray = managerInfo;
            int n5 = managerInfo.length;
            n = 0;
            while (n < n5) {
                IManagerInfoDTO info = iManagerInfoDTOArray[n];
                String managerName = info.getName();
                if (managerName == null || managerName.length() == 0) {
                    managerName = info.getId();
                }
                this.fExternalManagerChoices.add(managerName, info.getId(), info);
                this.fExternalManagerToManagerInfoMap.put(info.getId(), info);
                ++n;
            }
        }
    }

    private void createItemManagerChoices(Collection<IManagerInfoDTO> managerInfoList) {
        this.fItemManagerChoices.clear();
        if (managerInfoList == null) {
            this.fItemManagerChoices.add(Messages.SyncRuleOverviewPage_CHOICE_NONE, null, null);
            managerInfoList = this.fItemManagerToManagerInfoMap.values();
        }
        for (IManagerInfoDTO info : managerInfoList) {
            String managerName = info.getName();
            if (managerName == null || managerName.length() == 0) {
                managerName = info.getId();
            }
            this.fItemManagerChoices.add(managerName, info.getId(), info);
        }
    }

    private void createTypeQualifierChoices(Map<String, ITypeInfoDTO> typeQualifierMap) {
        this.fItemTypeQualifierChoices.clear();
        for (ITypeInfoDTO typeInfo : typeQualifierMap.values()) {
            String typeQualifierName = typeInfo.getQualifierName();
            if ((typeQualifierName == null || typeQualifierName.length() == 0) && typeInfo.getQualifierId() != null) {
                typeQualifierName = this.createFriendlyDottedName(typeInfo.getQualifierId());
            }
            if (typeQualifierName == null || typeQualifierName.length() == 0) continue;
            this.fItemTypeQualifierChoices.add(typeQualifierName, typeInfo.getQualifierId(), typeInfo);
        }
    }

    private void createTransformerChoices() {
        ITransformerInfoDTO[] transformerInfo = this.fWorkingCopy.getValueTransformerInfo();
        this.fValueTransformerChoices.clear();
        this.fValueTransformerChoices.add(Messages.SyncRuleOverviewPage_CHOICE_NONE, null, null);
        int i = 0;
        while (i < transformerInfo.length) {
            String name = transformerInfo[i].getName();
            if (name == null || name.length() == 0) {
                name = transformerInfo[i].getId();
            }
            this.fValueTransformerChoices.add(name, transformerInfo[i].getId(), transformerInfo[i]);
            ++i;
        }
    }

    private void createSyncRuleChoices() {
        List syncRules = this.fWorkingCopy.getSyncRulesInProjectArea();
        this.fReferenceSyncRuleChoices.clear();
        int i = 0;
        while (i < syncRules.size()) {
            this.fReferenceSyncRuleChoices.add(((ISyncRule)syncRules.get(i)).getName(), null, ((ISyncRule)syncRules.get(i)).getName());
            ++i;
        }
    }

    private void createItemPropertyChoices(ITypeInfoDTO itemTypeInfo) {
        this.fItemPropertyChoices.clear();
        if (itemTypeInfo != null && itemTypeInfo.getProperties().size() != 0) {
            for (IPropertyInfoDTO propertyInfo : itemTypeInfo.getProperties()) {
                String displayName = propertyInfo.getDisplayname();
                if (displayName == null || displayName.length() == 0) {
                    displayName = propertyInfo.getName();
                }
                this.fItemPropertyChoices.add(displayName, propertyInfo.getName(), propertyInfo);
            }
        } else {
            List mappings = this.fWorkingCopy.getSyncRule().getPropertyMappings();
            for (IPropertyMapping mapping : mappings) {
                if (mapping.getItemPropertyName() == null || mapping.getItemPropertyName().length() == 0) continue;
                IPropertyInfoDTO info = InteropFactory.INSTANCE.createPropertyInfoDTO();
                info.setName(mapping.getItemPropertyName());
                info.setIdentifier(mapping.isItemIdentifier());
                info.setTransformer(mapping.getTransformExtension());
                this.fItemPropertyChoices.add(mapping.getItemPropertyName(), mapping.getItemPropertyName(), info);
            }
        }
    }

    private WidgetUtil.ComboChoices<IPropertyInfoDTO> createUnmappedItemPropertyChoices(ITypeInfoDTO itemTypeInfo) {
        this.createItemPropertyChoices(itemTypeInfo);
        WidgetUtil.ComboChoices<IPropertyInfoDTO> choices = new WidgetUtil.ComboChoices<IPropertyInfoDTO>();
        List mappings = this.fWorkingCopy.getSyncRule().getPropertyMappings();
        HashSet<String> existingMappings = new HashSet<String>();
        for (IPropertyMapping mapping : mappings) {
            if (mapping.getItemPropertyName() == null || mapping.getItemPropertyName().length() == 0) continue;
            existingMappings.add(mapping.getItemPropertyName());
        }
        for (IPropertyInfoDTO choice : this.fItemPropertyChoices.getChoices()) {
            if (existingMappings.contains(choice.getName())) continue;
            String displayName = choice.getDisplayname();
            if (displayName == null || displayName.length() == 0) {
                displayName = choice.getName();
            }
            choices.add(displayName, choice.getName(), choice);
        }
        return choices;
    }

    private void createExternalPropertyChoices(ITypeInfoDTO externalTypeInfo) {
        this.fExternalPropertyChoices.clear();
        if (externalTypeInfo != null && externalTypeInfo.getProperties().size() != 0) {
            for (IPropertyInfoDTO propertyInfo : externalTypeInfo.getProperties()) {
                String displayName = propertyInfo.getDisplayname();
                if (displayName == null || displayName.length() == 0) {
                    displayName = propertyInfo.getName();
                }
                this.fExternalPropertyChoices.add(displayName, propertyInfo.getName(), propertyInfo);
            }
        } else {
            List mappings = this.fWorkingCopy.getSyncRule().getPropertyMappings();
            for (IPropertyMapping mapping : mappings) {
                if (mapping.getExternalPropertyName() == null || mapping.getExternalPropertyName().length() == 0) continue;
                IPropertyInfoDTO info = InteropFactory.INSTANCE.createPropertyInfoDTO();
                info.setName(mapping.getExternalPropertyName());
                info.setIdentifier(mapping.isExternalIdentifier());
                info.setModifier(mapping.isExternalModifier());
                info.setTransformer(mapping.getTransformExtension());
                this.fExternalPropertyChoices.add(mapping.getExternalPropertyName(), mapping.getExternalPropertyName(), info);
            }
        }
    }

    private WidgetUtil.ComboChoices<IPropertyInfoDTO> createUnmappedExternalPropertyChoices(ITypeInfoDTO externalTypeInfo) {
        this.createExternalPropertyChoices(externalTypeInfo);
        WidgetUtil.ComboChoices<IPropertyInfoDTO> choices = new WidgetUtil.ComboChoices<IPropertyInfoDTO>();
        List mappings = this.fWorkingCopy.getSyncRule().getPropertyMappings();
        HashSet<String> existingMappings = new HashSet<String>();
        for (IPropertyMapping mapping : mappings) {
            if (mapping.getExternalPropertyName() == null || mapping.getExternalPropertyName().length() == 0) continue;
            existingMappings.add(mapping.getExternalPropertyName());
        }
        for (IPropertyInfoDTO choice : this.fExternalPropertyChoices.getChoices()) {
            if (existingMappings.contains(choice.getName())) continue;
            String displayName = choice.getDisplayname();
            if (displayName == null || displayName.length() == 0) {
                displayName = choice.getName();
            }
            choices.add(displayName, choice.getName(), choice);
        }
        return choices;
    }

    private WidgetUtil.ComboChoices<String> createItemPropertyValueChoices(IPropertyInfoDTO itemPropertyInfo, IValueMapping[] currentMappings) {
        WidgetUtil.ComboChoices<String> choices = new WidgetUtil.ComboChoices<String>();
        if (itemPropertyInfo != null && itemPropertyInfo.getAllowedValues().size() != 0) {
            for (String value : itemPropertyInfo.getAllowedValues()) {
                choices.add(value, null, value);
            }
        } else {
            IValueMapping[] iValueMappingArray = currentMappings;
            int n = currentMappings.length;
            int n2 = 0;
            while (n2 < n) {
                IValueMapping mapping = iValueMappingArray[n2];
                if (mapping.getItemValue() != null && mapping.getItemValue().length() != 0 && choices.getChoiceByDisplayName(mapping.getItemValue()) == null) {
                    choices.add(mapping.getItemValue(), null, mapping.getItemValue());
                }
                ++n2;
            }
        }
        return choices;
    }

    private WidgetUtil.ComboChoices<String> createExternalPropertyValueChoices(IPropertyInfoDTO externalPropertyInfo, IValueMapping[] currentMappings) {
        WidgetUtil.ComboChoices<String> choices = new WidgetUtil.ComboChoices<String>();
        if (externalPropertyInfo != null && externalPropertyInfo.getAllowedValues().size() != 0) {
            for (String value : externalPropertyInfo.getAllowedValues()) {
                choices.add(value, null, value);
            }
        } else {
            IValueMapping[] iValueMappingArray = currentMappings;
            int n = currentMappings.length;
            int n2 = 0;
            while (n2 < n) {
                IValueMapping mapping = iValueMappingArray[n2];
                if (mapping.getExternalValue() != null && mapping.getExternalValue().length() != 0 && choices.getChoiceByDisplayName(mapping.getExternalValue()) == null) {
                    choices.add(mapping.getExternalValue(), null, mapping.getExternalValue());
                }
                ++n2;
            }
        }
        return choices;
    }

    private void createSyncDirectionChoices() {
        if (this.fSyncDirectionChoices.getChoices().size() != 0) {
            return;
        }
        this.fSyncDirectionChoices.add(Messages.SyncRuleOverviewPage_CHOICE_NONE, SyncDirection.NONE.name(), SyncDirection.NONE);
        this.fSyncDirectionChoices.add(Messages.SyncRuleOverviewPage_SYNC_DIRECTION_IN, SyncDirection.IN.name(), SyncDirection.IN);
        this.fSyncDirectionChoices.add(Messages.SyncRuleOverviewPage_SYNC_DIRECTION_OUT, SyncDirection.OUT.name(), SyncDirection.OUT);
        this.fSyncDirectionChoices.add(Messages.SyncRuleOverviewPage_SYNC_DIRECTION_IN_OUT, SyncDirection.IN_OUT.name(), SyncDirection.IN_OUT);
    }

    private String createFriendlyDottedName(String dottedName) {
        int dotIndex = dottedName.indexOf(46);
        if (dotIndex < 0) {
            return dottedName;
        }
        if ((dotIndex = dottedName.indexOf(46, dotIndex + 1)) < 0) {
            return dottedName;
        }
        StringBuilder sb = new StringBuilder();
        dotIndex = dottedName.lastIndexOf(46);
        int prefixIndex = dottedName.indexOf(58);
        int start = 0;
        if (prefixIndex > 0) {
            start = prefixIndex + 1;
            sb.append(dottedName.substring(0, start));
            sb.append(' ');
        }
        sb.append(dottedName.substring(dotIndex + 1));
        sb.append(" - ");
        sb.append(dottedName.substring(start, dotIndex));
        return sb.toString();
    }

    private String createShortNameFromDottedName(String dottedName) {
        int dotIndex = dottedName.lastIndexOf(46);
        if (dotIndex < 0 || dotIndex == dottedName.length() - 1) {
            return dottedName;
        }
        return dottedName.substring(dotIndex + 1);
    }

    private void updateEnabledTeamAreasLabel() {
        this.fEnabledTeamAreasLabel.setText(NLS.bind((String)Messages.SyncRuleOverviewPage_ENABLED_TEAM_AREAS_LABEL, (Object[])new Object[]{this.fTeamAreaSelector.getSelectedTeamAreaCount()}));
    }

    private class FetchExternalTypeInfoJob
    extends Job {
        private IManagerInfoDTO fManagerInfo;
        private IExternalRepositoryConnection fExternalConnection;
        private boolean fWasInitialized;

        public FetchExternalTypeInfoJob() {
            super(Messages.SyncRuleOverviewPage_FETCH_EXTERNAL_TYPE_INFO_JOB_NAME);
            this.setSystem(true);
        }

        public void setJobInfo(IManagerInfoDTO managerInfo, IExternalRepositoryConnection externalConnection, boolean wasInitialized) {
            this.fManagerInfo = managerInfo;
            this.fExternalConnection = externalConnection;
            this.fWasInitialized = wasInitialized;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IStatus status = null;
            ITypeInfoDTO[] managerTypeInfo = SyncRuleOverviewPage.this.fWorkingCopy.getExternalManagerTypeInfo(this.fManagerInfo, this.fExternalConnection, monitor);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            SyncRuleOverviewPage.this.fExternalTypeChoices.clear();
            if (managerTypeInfo == null) {
                if (SyncRuleOverviewPage.this.fWorkingCopy.getLastError() != null) {
                    status = StatusUtil.newStatus((Object)((Object)this), (int)2, (String)Messages.SyncRuleOverviewPage_MESSAGE_EXTERNAL_TYPE_INFO_NOT_AVAILABLE, (Throwable)SyncRuleOverviewPage.this.fWorkingCopy.getLastError());
                }
            } else {
                SyncRuleOverviewPage.this.fShortExternalTypeToTypeInfoMap.clear();
                ITypeInfoDTO[] iTypeInfoDTOArray = managerTypeInfo;
                int n = managerTypeInfo.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeInfoDTO typeInfo = iTypeInfoDTOArray[n2];
                    String friendlyTypeName = SyncRuleOverviewPage.this.createFriendlyDottedName(typeInfo.getName());
                    SyncRuleOverviewPage.this.fExternalTypeChoices.add(friendlyTypeName, typeInfo.getName(), typeInfo);
                    String shortTypeName = SyncRuleOverviewPage.this.createShortNameFromDottedName(typeInfo.getName());
                    if (shortTypeName.length() != 0) {
                        SyncRuleOverviewPage.this.fShortExternalTypeToTypeInfoMap.put(shortTypeName, typeInfo);
                    }
                    ++n2;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (!SyncRuleOverviewPage.this.fExternalTypeCombo.isDisposed()) {
                final IStatus newStatus = status;
                SyncRuleOverviewPage.this.fExternalTypeCombo.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        String currentValue;
                        boolean saveInitialized = SyncRuleOverviewPage.this.fInitialized;
                        SyncRuleOverviewPage.this.fInitialized = false;
                        WidgetUtil.setComboChoices(SyncRuleOverviewPage.this.fExternalTypeCombo, SyncRuleOverviewPage.this.fExternalTypeChoices, saveInitialized);
                        if (!FetchExternalTypeInfoJob.this.fWasInitialized && SyncRuleOverviewPage.this.fExternalTypeCombo.getSelectionIndex() == -1 && (currentValue = SyncRuleOverviewPage.this.fWorkingCopy.getSyncRule().getExternalTypeName()) != null && currentValue.length() != 0) {
                            WidgetUtil.setComboSelection(SyncRuleOverviewPage.this.fExternalTypeCombo, currentValue, SyncRuleOverviewPage.this.fExternalTypeChoices);
                        }
                        SyncRuleOverviewPage.this.fInitialized = saveInitialized;
                        SyncRuleEditor editor = (SyncRuleEditor)SyncRuleOverviewPage.this.getEditor();
                        editor.updateStatus(newStatus);
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SyncDirection {
        NONE,
        IN,
        OUT,
        IN_OUT;

    }

    private static class ValueMappingsContentProvider
    implements IStructuredContentProvider {
        private IPropertyMapping fPropertyMapping;

        private ValueMappingsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.fPropertyMapping == null) {
                return new Object[0];
            }
            return this.fPropertyMapping.getValueMappings().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fPropertyMapping = newInput instanceof IPropertyMapping ? (IPropertyMapping)newInput : null;
        }
    }

    private static class ValueMappingsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final ResourceManager fResourceManager;

        ValueMappingsLabelProvider(ResourceManager resourceManager) {
            this.fResourceManager = resourceManager;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IValueMapping valueMapping = (IValueMapping)element;
            switch (columnIndex) {
                case 0: {
                    if (!valueMapping.isDefaultItemValue()) break;
                    return this.fResourceManager.createImage(InteropIdeUIPlugin.DEFAULT_IMAGE_DESCRIPTOR);
                }
                case 1: {
                    if (!valueMapping.isDefaultExternalValue()) break;
                    return this.fResourceManager.createImage(InteropIdeUIPlugin.DEFAULT_IMAGE_DESCRIPTOR);
                }
            }
            return this.fResourceManager.createImage(InteropIdeUIPlugin.EMPTY_IMAGE_DESCRIPTOR);
        }

        public String getColumnText(Object element, int columnIndex) {
            IValueMapping valueMapping = (IValueMapping)element;
            switch (columnIndex) {
                case 0: {
                    return valueMapping.getItemValue();
                }
                case 1: {
                    return valueMapping.getExternalValue();
                }
            }
            return null;
        }
    }
}

