/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.rcp.ui.internal.ExternalProxyWorkingCopy;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class ExternalProxyEditorInput
extends PlatformObject
implements IEditorInput {
    private final ExternalProxyWorkingCopy fWorkingCopy;

    public ExternalProxyEditorInput(ITeamRepository repository, UUID itemId) {
        if (repository == null) {
            throw new IllegalArgumentException("repository cannot be null");
        }
        this.fWorkingCopy = new ExternalProxyWorkingCopy(repository, itemId, true);
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fWorkingCopy.getImage();
    }

    public String getName() {
        return this.fWorkingCopy.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fWorkingCopy.getToolTipText();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExternalProxyEditorInput) {
            ExternalProxyEditorInput input = (ExternalProxyEditorInput)((Object)o);
            UUID thisId = this.fWorkingCopy.getExternalProxyItemId();
            UUID otherId = input.getWorkingCopy().getExternalProxyItemId();
            if (thisId == null) {
                return otherId == null;
            }
            if (otherId == null) {
                return false;
            }
            return thisId.equals((Object)otherId);
        }
        return super.equals(o);
    }

    public ExternalProxyWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }
}

