/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.editors.Messages;
import com.ibm.team.interop.rcp.ui.InteropRcpUiPlugin;
import com.ibm.team.interop.rcp.ui.internal.ExternalProxyWorkingCopy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.IProgressService;

public class ExternalProxyEditorHeader
extends AbstractFormPart {
    private final IEditorPart fEditor;
    private final ExternalProxyWorkingCopy fWorkingCopy;
    private final ResourceManager fResourceManager;

    public ExternalProxyEditorHeader(IEditorPart editor, IManagedForm headerForm, ExternalProxyWorkingCopy workingCopy, ResourceManager resourceManager) {
        this.fEditor = editor;
        this.fWorkingCopy = workingCopy;
        this.fResourceManager = resourceManager;
        FormToolkit toolkit = headerForm.getToolkit();
        toolkit.decorateFormHeading(headerForm.getForm().getForm());
        headerForm.getForm().setText(Messages.ExternalProxyEditorHeader_EDITOR_TITLE);
        headerForm.getForm().setImage(this.fResourceManager.createImage(InteropRcpUiPlugin.PROXY_IMAGE_DESCRIPTOR));
        this.createToolBar(headerForm);
    }

    private void createToolBar(IManagedForm headerForm) {
        IToolBarManager toolbarManager = headerForm.getForm().getToolBarManager();
        Action refresh = new Action(Messages.ExternalProxyEditorHeader_ACTION_REFRESH, 1){

            public void run() {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                try {
                    progressService.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            ExternalProxyEditorHeader.this.doRevert(monitor);
                        }
                    });
                }
                catch (Exception e) {
                    InteropIdeUIPlugin.getDefault().log(Messages.ExternalProxyEditorHeader_ERROR_CANNOT_REFRESH, e);
                }
            }
        };
        refresh.setImageDescriptor(InteropIdeUIPlugin.REFRESH_ACTION_IMAGE_DESCRIPTOR);
        refresh.setToolTipText(Messages.ExternalProxyEditorHeader_TOOLTIP_REFRESH);
        toolbarManager.add((IAction)refresh);
        toolbarManager.update(false);
    }

    private void doRevert(IProgressMonitor monitor) {
        try {
            this.fWorkingCopy.revert(monitor);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.fEditor.getSite().getShell(), (String)Messages.ExternalProxyEditorHeader_ERROR_RELOADING_STATUS, null, (IStatus)e.getStatus());
        }
    }
}

