/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal;

import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.Messages;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamAreaSelectorControl {
    private ICheckStateListener fCheckStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof ITeamArea) {
                ITeamArea teamArea = (ITeamArea)element;
                Object parent = TeamAreaSelectorControl.this.fTreeViewer.getParent(element);
                if (parent != null && TeamAreaSelectorControl.this.fTreeViewer.getChecked(parent) && !TeamAreaSelectorControl.this.fTreeViewer.getGrayed(parent)) {
                    TeamAreaSelectorControl.this.fTreeViewer.setChecked(element, true);
                    this.showElementTooltip(element, Messages.TeamAreaSelectorControl_CHILD_ALWAYS_ENABLED_TOOLTIP);
                } else if (TeamAreaSelectorControl.this.fTreeViewer.getGrayed(element) || event.getChecked()) {
                    TeamAreaSelectorControl.this.addSelectedTeamArea((ITeamAreaHandle)teamArea);
                    TeamAreaSelectorControl.this.fDirty = true;
                } else if (TeamAreaSelectorControl.this.getSelectedTeamAreaCount() == 1) {
                    TeamAreaSelectorControl.this.fTreeViewer.setChecked(element, true);
                    this.showElementTooltip(element, Messages.TeamAreaSelectorControl_ONE_TEAM_AREA_ENABLED_TOOLTIP);
                } else {
                    TeamAreaSelectorControl.this.removeSelectedTeamArea((ITeamAreaHandle)teamArea);
                    TeamAreaSelectorControl.this.fDirty = true;
                }
            }
        }

        private void showElementTooltip(Object element, String text) {
            TreeItem item = TeamAreaSelectorControl.this.fTreeViewer.getTreeItem(element);
            if (item == null) {
                return;
            }
            DefaultToolTip tooltip = new DefaultToolTip(TeamAreaSelectorControl.this.fTreeViewer.getControl(), 2, true);
            tooltip.setHideOnMouseDown(true);
            tooltip.setHideDelay(3000);
            tooltip.setText(text);
            tooltip.show(new Point(item.getBounds().x, item.getBounds().y));
        }
    };
    private ITreeViewerListener fTreeViewerListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            TeamAreaSelectorControl.this.fTreeViewer.updateSubtreeSelectedState(event.getElement());
        }
    };
    private final TeamAreaSelectorTreeViewer fTreeViewer;
    private final TeamAreaSelectorContentProvider fContentProvider;
    private IProjectArea fProjectArea;
    private ITeamAreaHierarchy fTeamAreaHierarchy;
    private boolean fIncludeArchived = false;
    private Map<UUID, ITeamArea> fTeamAreasByItemId = Collections.synchronizedMap(new HashMap());
    private Set<UUID> fSelectedTeamAreaItemIds = Collections.synchronizedSet(new HashSet());
    private boolean fDirty;

    public TeamAreaSelectorControl(Composite parent, int style) {
        Tree tree = new Tree(parent, 2084);
        this.fTreeViewer = new TeamAreaSelectorTreeViewer(tree);
        this.fContentProvider = new TeamAreaSelectorContentProvider((TreeViewer)this.fTreeViewer);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.fTreeViewer.setComparator(new ViewerComparator());
        this.fTreeViewer.setAutoExpandLevel(2);
        this.fTreeViewer.addCheckStateListener(this.fCheckStateListener);
        this.fTreeViewer.addTreeListener(this.fTreeViewerListener);
    }

    public Control getControl() {
        return this.fTreeViewer.getTree();
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.fTreeViewer.addCheckStateListener(listener);
    }

    public void setSelectedTeamAreas(IProjectArea projectArea, Collection<ITeamAreaHandle> teamAreaHandles, boolean includeArchived) {
        this.fProjectArea = projectArea;
        this.fTeamAreaHierarchy = this.fProjectArea.getTeamAreaHierarchy();
        this.fIncludeArchived = includeArchived;
        this.fTreeViewer.setInput(projectArea);
        this.fSelectedTeamAreaItemIds.clear();
        if (teamAreaHandles.isEmpty()) {
            this.fTreeViewer.setAllChecked(true);
            return;
        }
        this.fTreeViewer.setAllChecked(false);
        for (ITeamAreaHandle teamAreaHandle : teamAreaHandles) {
            this.addSelectedTeamArea(teamAreaHandle);
        }
        this.fTreeViewer.refresh();
        this.fDirty = false;
    }

    public void setIncludeArchived(boolean includeArchived) {
        if (this.fIncludeArchived != includeArchived) {
            this.fIncludeArchived = includeArchived;
            this.fTreeViewer.refresh();
        }
    }

    public Collection<ITeamArea> getExplicitlySelectedTeamAreas() {
        ArrayList<ITeamArea> teamAreas = new ArrayList<ITeamArea>(this.fSelectedTeamAreaItemIds.size());
        for (UUID itemId : this.fSelectedTeamAreaItemIds) {
            ITeamArea teamArea = this.fTeamAreasByItemId.get(itemId);
            if (teamArea == null) continue;
            teamAreas.add(teamArea);
        }
        return teamAreas;
    }

    public int getSelectedTeamAreaCount() {
        if (this.fSelectedTeamAreaItemIds.isEmpty()) {
            return this.fTeamAreaHierarchy.getTeamAreas().size();
        }
        int count = 0;
        for (UUID teamAreaId : this.fSelectedTeamAreaItemIds) {
            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle(teamAreaId, null);
            if (teamAreaHandle == null) continue;
            count += this.getTeamAreaSubtreeCount(teamAreaHandle);
        }
        return count;
    }

    private void addSelectedTeamArea(ITeamAreaHandle teamAreaHandle) {
        this.fSelectedTeamAreaItemIds.add(teamAreaHandle.getItemId());
        if (this.fSelectedTeamAreaItemIds.size() == this.fTeamAreasByItemId.size()) {
            this.fSelectedTeamAreaItemIds.clear();
        } else {
            this.removeAllChildren(teamAreaHandle);
        }
        ITeamArea teamArea = this.fTeamAreasByItemId.get(teamAreaHandle.getItemId());
        if (teamArea != null) {
            this.updateSelectedState(teamArea);
        }
    }

    private void removeSelectedTeamArea(ITeamAreaHandle teamAreaHandle) {
        if (this.fSelectedTeamAreaItemIds.isEmpty()) {
            Set roots = this.fTeamAreaHierarchy.getRoots();
            for (ITeamAreaHandle root : roots) {
                this.fSelectedTeamAreaItemIds.add(root.getItemId());
            }
        }
        if (this.fSelectedTeamAreaItemIds.size() == 1) {
            this.addChildren(teamAreaHandle);
        }
        this.fSelectedTeamAreaItemIds.remove(teamAreaHandle.getItemId());
        ITeamArea teamArea = this.fTeamAreasByItemId.get(teamAreaHandle.getItemId());
        if (teamArea != null) {
            this.updateSelectedState(teamArea);
        }
    }

    private void addChildren(ITeamAreaHandle teamAreaHandle) {
        if (this.fTeamAreaHierarchy == null) {
            return;
        }
        Set childHandles = this.fTeamAreaHierarchy.getChildren(teamAreaHandle);
        for (ITeamAreaHandle childHandle : childHandles) {
            this.fSelectedTeamAreaItemIds.add(childHandle.getItemId());
        }
    }

    private void removeAllChildren(ITeamAreaHandle teamAreaHandle) {
        if (this.fTeamAreaHierarchy == null) {
            return;
        }
        Set childHandles = this.fTeamAreaHierarchy.getChildren(teamAreaHandle);
        for (ITeamAreaHandle childHandle : childHandles) {
            this.fSelectedTeamAreaItemIds.remove(childHandle.getItemId());
            this.removeAllChildren(childHandle);
        }
    }

    private void updateSelectedState(Object element) {
        ITeamArea teamArea;
        Object parent;
        if (!(element instanceof ITeamArea)) {
            return;
        }
        boolean selected = false;
        if (this.fSelectedTeamAreaItemIds.isEmpty()) {
            selected = true;
        } else {
            parent = element;
            while (parent != null) {
                teamArea = (ITeamArea)parent;
                if (this.fSelectedTeamAreaItemIds.contains(teamArea.getItemId())) {
                    selected = true;
                    break;
                }
                parent = this.fTreeViewer.getParent(parent);
            }
        }
        if (selected) {
            this.fTreeViewer.setSubtreeChecked(element, true);
            this.fTreeViewer.setGrayed(element, false);
            parent = this.fTreeViewer.getParent(element);
            while (parent != null) {
                if (!this.fTreeViewer.getChecked(parent)) {
                    this.fTreeViewer.setGrayChecked(parent, true);
                }
                parent = this.fTreeViewer.getParent(parent);
            }
        } else if (this.anyChildSelected((ITeamAreaHandle)((ITeamArea)element))) {
            this.fTreeViewer.setGrayChecked(element, true);
        } else {
            this.fTreeViewer.setSubtreeChecked(element, false);
            this.fTreeViewer.setGrayed(element, false);
            parent = this.fTreeViewer.getParent(element);
            while (parent != null) {
                teamArea = (ITeamArea)parent;
                if (!this.fSelectedTeamAreaItemIds.contains(teamArea.getItemId()) && !this.anyChildSelected((ITeamAreaHandle)teamArea)) {
                    this.fTreeViewer.setGrayChecked(parent, false);
                }
                parent = this.fTreeViewer.getParent(parent);
            }
        }
    }

    private boolean anyChildSelected(ITeamAreaHandle parent) {
        if (this.fTeamAreaHierarchy == null) {
            return false;
        }
        Set childHandles = this.fTeamAreaHierarchy.getChildren(parent);
        for (ITeamAreaHandle childHandle : childHandles) {
            if (this.fSelectedTeamAreaItemIds.contains(childHandle.getItemId())) {
                return true;
            }
            if (!this.anyChildSelected(childHandle)) continue;
            return true;
        }
        return false;
    }

    private int getTeamAreaSubtreeCount(ITeamAreaHandle parent) {
        int count = 1;
        if (this.fTeamAreaHierarchy != null) {
            Set childHandles = this.fTeamAreaHierarchy.getChildren(parent);
            for (ITeamAreaHandle childHandle : childHandles) {
                count += this.getTeamAreaSubtreeCount(childHandle);
            }
        }
        return count;
    }

    private ITeamRepository teamRepository(IItemHandle itemHandle) {
        return (ITeamRepository)itemHandle.getOrigin();
    }

    private IItemManager itemManager(IItemHandle itemHandle) {
        return this.teamRepository(itemHandle).itemManager();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TeamAreaSelectorContentProvider
    implements ITreeContentProvider,
    IDeferredWorkbenchAdapter {
        private final TreeViewer fTreeViewer;
        private final DeferredTreeContentManager fContentManager;

        public TeamAreaSelectorContentProvider(TreeViewer treeViewer) {
            this.fTreeViewer = treeViewer;
            this.fContentManager = new DeferredContentManager(this, (AbstractTreeViewer)this.fTreeViewer);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITeamArea && !TeamAreaSelectorControl.this.fTeamAreasByItemId.isEmpty()) {
                return this.getTeamAreaChildren(parentElement).toArray();
            }
            return this.fContentManager.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            ITeamAreaHandle parentHandle;
            if (element instanceof ITeamArea && TeamAreaSelectorControl.this.fTeamAreaHierarchy != null && (parentHandle = TeamAreaSelectorControl.this.fTeamAreaHierarchy.getParent((ITeamAreaHandle)element)) != null) {
                return TeamAreaSelectorControl.this.fTeamAreasByItemId.get(parentHandle.getItemId());
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ITeamArea && TeamAreaSelectorControl.this.fTeamAreaHierarchy != null) {
                ITeamArea teamArea = (ITeamArea)element;
                return TeamAreaSelectorControl.this.fTeamAreaHierarchy.getChildren((ITeamAreaHandle)teamArea).size() != 0;
            }
            return true;
        }

        public Object[] getElements(Object inputElement) {
            return this.fContentManager.getChildren((Object)TeamAreaSelectorControl.this.fProjectArea);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            Set childHandles;
            if (TeamAreaSelectorControl.this.fProjectArea == null) {
                return;
            }
            Map map = TeamAreaSelectorControl.this.fTeamAreasByItemId;
            synchronized (map) {
                List teamAreaHandles;
                if (TeamAreaSelectorControl.this.fTeamAreasByItemId.isEmpty() && (teamAreaHandles = TeamAreaSelectorControl.this.fTeamAreaHierarchy.getTeamAreas()).size() > 0) {
                    try {
                        List teamAreas = TeamAreaSelectorControl.this.itemManager((IItemHandle)TeamAreaSelectorControl.this.fProjectArea).fetchCompleteItems(new ArrayList(teamAreaHandles), 0, monitor);
                        for (ITeamArea teamArea : teamAreas) {
                            TeamAreaSelectorControl.this.fTeamAreasByItemId.put(teamArea.getItemId(), teamArea);
                        }
                    }
                    catch (NotLoggedInException notLoggedInException) {
                    }
                    catch (TeamRepositoryException e) {
                        InteropIdeUIPlugin.getDefault().log(Messages.TeamAreaSelectorControl_ERROR_FETCHING_TEAM_AREAS, e);
                    }
                }
            }
            if (object instanceof IProjectArea) {
                childHandles = TeamAreaSelectorControl.this.fTeamAreaHierarchy.getRoots();
            } else if (object instanceof ITeamArea) {
                childHandles = TeamAreaSelectorControl.this.fTeamAreaHierarchy.getChildren((ITeamAreaHandle)((ITeamArea)object));
            } else {
                return;
            }
            try {
                try {
                    if (childHandles.size() > 0) {
                        List teamAreas = TeamAreaSelectorControl.this.itemManager((IItemHandle)TeamAreaSelectorControl.this.fProjectArea).fetchCompleteItems(new ArrayList(childHandles), 0, monitor);
                        for (ITeamArea teamArea : teamAreas) {
                            TeamAreaSelectorControl.this.fTeamAreasByItemId.put(teamArea.getItemId(), teamArea);
                            if (!TeamAreaSelectorControl.this.fIncludeArchived && teamArea.isArchived()) continue;
                            collector.add((Object)teamArea, monitor);
                        }
                    }
                }
                catch (NotLoggedInException notLoggedInException) {
                    collector.done();
                }
                catch (TeamRepositoryException e) {
                    InteropIdeUIPlugin.getDefault().log(Messages.TeamAreaSelectorControl_ERROR_FETCHING_TEAM_AREAS, e);
                    collector.done();
                }
            }
            finally {
                collector.done();
            }
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return null;
        }

        private List<ITeamArea> getTeamAreaChildren(Object parent) {
            Set childHandles;
            if (TeamAreaSelectorControl.this.fTeamAreaHierarchy == null) {
                return Collections.emptyList();
            }
            if (parent instanceof IProjectArea) {
                childHandles = TeamAreaSelectorControl.this.fTeamAreaHierarchy.getRoots();
            } else if (parent instanceof ITeamArea) {
                childHandles = TeamAreaSelectorControl.this.fTeamAreaHierarchy.getChildren((ITeamAreaHandle)((ITeamArea)parent));
            } else {
                return Collections.emptyList();
            }
            ArrayList<ITeamArea> children = new ArrayList<ITeamArea>(childHandles.size());
            for (ITeamAreaHandle childHandle : childHandles) {
                ITeamArea child = (ITeamArea)TeamAreaSelectorControl.this.fTeamAreasByItemId.get(childHandle.getItemId());
                if (!TeamAreaSelectorControl.this.fIncludeArchived && child.isArchived()) continue;
                children.add(child);
            }
            return children;
        }

        private class DeferredContentManager
        extends DeferredTreeContentManager {
            public DeferredContentManager(ITreeContentProvider provider, AbstractTreeViewer viewer) {
                super(provider, viewer);
            }

            protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                if (TeamAreaSelectorContentProvider.this.hasChildren(element)) {
                    return TeamAreaSelectorContentProvider.this;
                }
                return super.getAdapter(element);
            }
        }
    }

    private class TeamAreaSelectorTreeViewer
    extends CheckboxTreeViewer {
        public TeamAreaSelectorTreeViewer(Tree tree) {
            super(tree);
            this.setUseHashlookup(true);
        }

        public void add(Object parentElementOrTreePath, Object childElement) {
            super.add(parentElementOrTreePath, childElement);
            TeamAreaSelectorControl.this.updateSelectedState(childElement);
        }

        public void add(Object parentElementOrTreePath, Object[] childElements) {
            super.add(parentElementOrTreePath, childElements);
            Object[] objectArray = childElements;
            int n = childElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                TeamAreaSelectorControl.this.updateSelectedState(element);
                ++n2;
            }
        }

        public boolean setSubtreeChecked(Object element, boolean state) {
            Object[] children;
            if (!this.setChecked(element, state)) {
                return false;
            }
            this.setGrayed(element, false);
            if (this.getExpandedState(element) && (children = this.getRawChildren(element)) != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.findItem(child) != null) {
                        this.setSubtreeChecked(child, state);
                    }
                    ++n2;
                }
            }
            return true;
        }

        public void updateSubtreeSelectedState(Object parent) {
            Object[] children = this.getRawChildren(parent);
            if (children != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.findItem(child) != null) {
                        TeamAreaSelectorControl.this.updateSelectedState(child);
                        this.updateSubtreeSelectedState(child);
                    }
                    ++n2;
                }
            }
        }

        public Object getParent(Object element) {
            return super.getParentElement(element);
        }

        public TreeItem getTreeItem(Object element) {
            Widget widget = this.findItem(element);
            if (widget instanceof TreeItem) {
                return (TreeItem)widget;
            }
            return null;
        }
    }
}

