/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal;

import com.ibm.team.interop.client.admin.IItemConnectorAdminClient;
import com.ibm.team.interop.common.IExternalRepositoryConnection;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.ExternalRepositoryConnectionProperties;
import com.ibm.team.interop.ide.ui.internal.Messages;
import com.ibm.team.interop.rcp.ui.internal.ExternalRepositoryConnectionWorkingCopy;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalRepositoryConnectionWizard
extends Wizard {
    private final boolean fCreateOnly;
    private ITeamRepository[] fAvailableRepositories;
    private ITeamRepository fRepository;
    private IExternalRepositoryConnection[] fExistingConnections;
    private IExternalRepositoryConnection fSelectedConnection;
    private RepositorySelectionPage fRepositorySelectionPage;
    private ExternalConnectionSelectionPage fSelectionPage;
    private ExternalRepositoryCreationPage fCreationPage;

    public ExternalRepositoryConnectionWizard(boolean createOnly, List<ITeamRepository> repositories, String title) {
        if (repositories == null || repositories.isEmpty()) {
            throw new IllegalArgumentException("repositories must not be null or empty");
        }
        if (title == null || title.length() == 0) {
            throw new IllegalArgumentException("title must not be null or empty");
        }
        this.fCreateOnly = createOnly;
        if (repositories.size() == 1) {
            this.fRepository = repositories.get(0);
        } else {
            this.fAvailableRepositories = repositories.toArray(new ITeamRepository[repositories.size()]);
        }
        this.setWindowTitle(title);
    }

    public void addPages() {
        if (this.fAvailableRepositories != null) {
            this.fRepositorySelectionPage = new RepositorySelectionPage(this.fAvailableRepositories);
            this.addPage((IWizardPage)this.fRepositorySelectionPage);
        }
        if (!this.fCreateOnly) {
            this.fSelectionPage = new ExternalConnectionSelectionPage();
            this.addPage((IWizardPage)this.fSelectionPage);
        }
        this.fCreationPage = new ExternalRepositoryCreationPage();
        this.addPage((IWizardPage)this.fCreationPage);
    }

    public IWizardPage getStartingPage() {
        if (this.fAvailableRepositories != null) {
            return this.fRepositorySelectionPage;
        }
        if (!this.fCreateOnly) {
            if (this.fRepository != null) {
                this.loadExternalConnections();
            }
            return this.fSelectionPage;
        }
        this.fCreationPage.setRepository(this.fRepository);
        return this.fCreationPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fRepositorySelectionPage) {
            this.fRepository = this.fRepositorySelectionPage.getSelectedRepository();
            if (!this.fCreateOnly) {
                if (this.fRepository != null) {
                    this.loadExternalConnections();
                }
                return this.fSelectionPage;
            }
            if (this.fRepository != null) {
                this.fCreationPage.setRepository(this.fRepository);
            }
            return this.fCreationPage;
        }
        if (page == this.fSelectionPage && this.fSelectionPage.isCreateNewConnection()) {
            if (this.fRepository != null) {
                this.fCreationPage.setRepository(this.fRepository);
            }
            return this.fCreationPage;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.fCreationPage) {
            if (!this.fCreateOnly) {
                return this.fSelectionPage;
            }
            if (this.fAvailableRepositories != null) {
                return this.fRepositorySelectionPage;
            }
        } else if (page == this.fSelectionPage && this.fAvailableRepositories != null) {
            return this.fRepositorySelectionPage;
        }
        return null;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == null) {
            return false;
        }
        if (currentPage == this.fSelectionPage) {
            return this.fSelectionPage.canFinish();
        }
        if (currentPage == this.fCreationPage) {
            return this.fCreationPage.canFinish();
        }
        return false;
    }

    public boolean performFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == null) {
            return false;
        }
        if (currentPage == this.fSelectionPage) {
            this.fSelectedConnection = this.fSelectionPage.getSelectedConnection();
        } else if (currentPage == this.fCreationPage) {
            this.createNewConnection();
        }
        return true;
    }

    public IExternalRepositoryConnection getSelectedConnection() {
        return this.fSelectedConnection;
    }

    private void loadExternalConnections() {
        this.fExistingConnections = null;
        Job job = new Job(Messages.ExternalRepositoryConnectionWizard_FETCH_CONNECTIONS_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IExternalRepositoryConnection[] conns = ExternalRepositoryConnectionWizard.this.adminClient().getAllExternalRepositoryConnections(monitor);
                    if (conns.length == 0) {
                        ExternalRepositoryConnectionWizard.this.fExistingConnections = new IExternalRepositoryConnection[0];
                    } else {
                        ExternalRepositoryConnectionWizard.this.fExistingConnections = conns;
                    }
                }
                catch (NotLoggedInException notLoggedInException) {
                }
                catch (TeamRepositoryException e) {
                    InteropIdeUIPlugin.getDefault().log(Messages.ExternalRepositoryConnectionWizard_ERROR_GETTING_CONNECTIONS, e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        if (this.fSelectionPage != null) {
            this.fSelectionPage.setExistingConnections(this.fExistingConnections);
        }
    }

    private IStatus createNewConnection() {
        IExternalRepositoryConnection newConnection = this.fCreationPage.getNewConnection();
        SaveJob job = new SaveJob(newConnection);
        job.setSystem(false);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        return job.getStatus();
    }

    private IItemConnectorAdminClient adminClient() {
        return (IItemConnectorAdminClient)this.fRepository.getClientLibrary(IItemConnectorAdminClient.class);
    }

    private IItemManager itemManager() {
        return this.fRepository.itemManager();
    }

    private static class ExternalConnectionSelectionPage
    extends WizardPage {
        private IExternalRepositoryConnection[] fExistingConnections;
        private Button fNoConnectionButton;
        private Button fCreateNewConnectionButton;
        private Button fUseExistingConnectionButton;
        private TableViewer fConnectionTableViewer;

        public ExternalConnectionSelectionPage() {
            super("ExternalConnectionSelectionPage");
            this.setTitle(Messages.ExternalRepositoryConnectionWizard_PAGE_TITLE);
            this.setDescription(Messages.ExternalRepositoryConnectionWizard_SELECTION_PAGE_DESCRIPTION);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            this.fCreateNewConnectionButton = new Button(composite, 16);
            this.fCreateNewConnectionButton.setText(Messages.ExternalRepositoryConnectionWizard_CREATE_NEW_BUTTON_LABEL);
            this.fCreateNewConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExternalConnectionSelectionPage.this.buttonSelected();
                }
            });
            this.fNoConnectionButton = new Button(composite, 16);
            this.fNoConnectionButton.setText(Messages.ExternalRepositoryConnectionWizard_NO_CONNECTION_BUTTON_LABEL);
            this.fNoConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExternalConnectionSelectionPage.this.buttonSelected();
                }
            });
            this.fUseExistingConnectionButton = new Button(composite, 16);
            this.fUseExistingConnectionButton.setText(Messages.ExternalRepositoryConnectionWizard_USE_EXISTING_BUTTON_LABEL);
            this.fUseExistingConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExternalConnectionSelectionPage.this.buttonSelected();
                }
            });
            this.fConnectionTableViewer = new TableViewer(composite, 68356);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fConnectionTableViewer.getTable());
            this.fConnectionTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fConnectionTableViewer.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
            GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(composite);
            Dialog.applyDialogFont((Control)parent);
            this.setControl((Control)composite);
        }

        public void setExistingConnections(IExternalRepositoryConnection[] existingConnections) {
            this.fExistingConnections = existingConnections;
            if (this.fExistingConnections == null || this.fExistingConnections.length == 0) {
                this.fCreateNewConnectionButton.setSelection(true);
                this.fNoConnectionButton.setSelection(false);
                this.fUseExistingConnectionButton.setSelection(false);
                this.fUseExistingConnectionButton.setEnabled(false);
                this.fConnectionTableViewer.setInput(null);
                this.fConnectionTableViewer.getTable().setEnabled(false);
            } else {
                this.fCreateNewConnectionButton.setSelection(false);
                this.fNoConnectionButton.setSelection(false);
                this.fUseExistingConnectionButton.setSelection(true);
                this.fConnectionTableViewer.setInput((Object)this.fExistingConnections);
                this.fConnectionTableViewer.getTable().setSelection(0);
            }
        }

        public boolean isCreateNewConnection() {
            return this.fCreateNewConnectionButton.getSelection();
        }

        public IExternalRepositoryConnection getSelectedConnection() {
            if (!this.fUseExistingConnectionButton.getSelection()) {
                return null;
            }
            IStructuredSelection selection = (IStructuredSelection)this.fConnectionTableViewer.getSelection();
            if (selection.size() == 0) {
                return null;
            }
            return (IExternalRepositoryConnection)selection.getFirstElement();
        }

        public boolean canFinish() {
            if (this.fNoConnectionButton.getSelection()) {
                return true;
            }
            return this.getSelectedConnection() != null;
        }

        private void buttonSelected() {
            if (this.fUseExistingConnectionButton.getSelection() && this.fExistingConnections != null && this.fExistingConnections.length > 0) {
                this.fConnectionTableViewer.getTable().setEnabled(true);
            } else {
                this.fConnectionTableViewer.getTable().setEnabled(false);
            }
            this.getWizard().getContainer().updateButtons();
        }
    }

    private static class ExternalRepositoryCreationPage
    extends WizardPage {
        private final ModifyListener fModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalRepositoryCreationPage.this.getWizard().getContainer().updateButtons();
            }
        };
        ExternalRepositoryConnectionProperties fProperties;
        ExternalRepositoryConnectionWorkingCopy fWorkingCopy;

        public ExternalRepositoryCreationPage() {
            super("CreationPage");
            this.setTitle(Messages.ExternalRepositoryConnectionWizard_PAGE_TITLE);
            this.setDescription(Messages.ExternalRepositoryConnectionWizard_CREATION_PAGE_DESCRIPTION);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            this.fProperties = new ExternalRepositoryConnectionProperties(composite);
            this.fProperties.addRequiredPropertiesModifyListener(this.fModifyListener);
            GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(composite);
            Dialog.applyDialogFont((Control)parent);
            this.setControl((Control)composite);
        }

        public boolean canFinish() {
            return this.fWorkingCopy.isLicensed() && this.fProperties.requiredPropertiesSet();
        }

        public void setRepository(ITeamRepository repository) {
            if (this.fWorkingCopy == null || !repository.getId().equals((Object)this.fWorkingCopy.getRepository().getId())) {
                this.fWorkingCopy = new ExternalRepositoryConnectionWorkingCopy(null, repository);
                Job job = new Job(Messages.ExternalRepositoryConnectionDialog_FETCH_EXTERNAL_CONNECTION_JOB_NAME){

                    protected IStatus run(IProgressMonitor monitor) {
                        ExternalRepositoryCreationPage.this.fWorkingCopy.revert(monitor);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(false);
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {}
                if (this.fWorkingCopy.getStatus() != null && !this.fWorkingCopy.getStatus().isOK()) {
                    this.setErrorMessage(this.fWorkingCopy.getStatus().getMessage());
                }
                this.fProperties.refresh(this.fWorkingCopy);
            }
        }

        public IExternalRepositoryConnection getNewConnection() {
            this.fProperties.commit(this.fWorkingCopy);
            return this.fWorkingCopy.getExternalRepositoryConnection();
        }
    }

    private static class RepositorySelectionPage
    extends WizardPage {
        private final ITeamRepository[] fRepositories;
        private TableViewer fTableViewer;

        public RepositorySelectionPage(ITeamRepository[] repositories) {
            super("RepositorySelectionPage");
            this.fRepositories = repositories;
            this.setTitle(Messages.ExternalRepositoryConnectionWizard_JAZZ_REPOSITORY_PAGE_TITLE);
            this.setDescription(Messages.ExternalRepositoryConnectionWizard_JAZZ_REPOSITORY_PAGE_DESCRIPTION);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            this.fTableViewer = new TableViewer(composite, 68356);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fTableViewer.getTable());
            this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fTableViewer.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
            this.fTableViewer.setInput((Object)this.fRepositories);
            this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    RepositorySelectionPage.this.getWizard().getContainer().updateButtons();
                }
            });
            GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(composite);
            Dialog.applyDialogFont((Control)parent);
            this.setControl((Control)composite);
        }

        public boolean canFlipToNextPage() {
            return this.getSelectedRepository() != null;
        }

        public ITeamRepository getSelectedRepository() {
            IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
            if (selection.size() == 0) {
                return null;
            }
            return (ITeamRepository)selection.getFirstElement();
        }
    }

    private class SaveJob
    extends Job {
        private final IExternalRepositoryConnection fNewConnection;
        private IStatus fStatus;

        public SaveJob(IExternalRepositoryConnection newConnection) {
            super(Messages.ExternalRepositoryConnectionWizard_CREATE_CONNECTION_JOB_NAME);
            this.fStatus = Status.OK_STATUS;
            this.fNewConnection = newConnection;
        }

        public IStatus getStatus() {
            return this.fStatus;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ExternalRepositoryConnectionWizard.this.fSelectedConnection = ExternalRepositoryConnectionWizard.this.adminClient().saveExternalRepositoryConnection(this.fNewConnection, monitor);
            }
            catch (TeamRepositoryException e) {
                this.fStatus = StatusUtil.newStatus((Object)((Object)this), (String)Messages.ExternalRepositoryConnectionWizard_ERROR_CREATING_CONNECTION, (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

