/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal;

import com.ibm.team.interop.ide.ui.internal.TableColumnInfo;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConstrainedTableViewer
extends TableViewer {
    private Composite fControl;

    public ConstrainedTableViewer(FormToolkit toolkit, Composite parent, int style, boolean singleElement) {
        super(ConstrainedTableViewer.createTable(parent, toolkit, style, singleElement));
    }

    public ConstrainedTableViewer(IFormPage page, Composite parent, int style, boolean singleElement) {
        this(page.getEditor().getToolkit(), parent, style, singleElement);
    }

    public Control getControl() {
        if (this.fControl == null) {
            this.fControl = this.getTable().getParent();
        }
        return this.fControl;
    }

    public static void hookResizeHandler(Composite parent, final Table table, TableColumnInfo[] columnInfo) {
        parent.addListener(11, new Listener(parent, columnInfo){
            private boolean fResizeHandlerQueued = false;
            private Runnable fResizeHandler;
            {
                this.fResizeHandler = new Runnable(){

                    public void run() {
                        try {
                            if (!composite.isDisposed()) {
                                composite.layout(true);
                            }
                            if (!table2.isDisposed()) {
                                int i = 0;
                                while (i < table2.getColumnCount()) {
                                    if (tableColumnInfoArray[i].layout instanceof ColumnWeightData) {
                                        int weight = ((ColumnWeightData)tableColumnInfoArray[i].layout).weight;
                                        table2.getColumn(i).setWidth((int)Math.floor(table2.getClientArea().width * weight / 100));
                                    }
                                    ++i;
                                }
                            }
                        }
                        finally {
                            fResizeHandlerQueued = false;
                        }
                    }
                };
            }

            public void handleEvent(Event event) {
                if (!this.fResizeHandlerQueued) {
                    this.fResizeHandlerQueued = true;
                    table.getDisplay().asyncExec(this.fResizeHandler);
                }
            }
        });
    }

    private static Table createTable(Composite parent, FormToolkit toolkit, int style, boolean singleElement) {
        Table table;
        if (singleElement) {
            Composite container = toolkit.createComposite(parent);
            container.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            container.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            container.setLayout((Layout)new ContainerLayout(20, 0));
            table = new Table(container, style);
            new TableColumn(table, 0);
            table.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    table.getColumn(0).setWidth(table.getClientArea().width - 3);
                }
            });
        } else {
            Composite container = toolkit.createComposite(parent);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            container.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            container.setLayout((Layout)new ContainerLayout(120, 0));
            table = new Table(container, style);
        }
        toolkit.adapt((Control)table, true, false);
        return table;
    }

    private static class ContainerLayout
    extends Layout {
        private int fHeightHint;
        private int fWidthHint;

        private ContainerLayout(int heightHint, int widthHint) {
            this.fHeightHint = heightHint;
            this.fWidthHint = widthHint;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return new Point(this.fWidthHint, this.fHeightHint);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle rect = composite.getClientArea();
            composite.getChildren()[0].setBounds(rect);
        }
    }
}

