/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.IViewerPaneListener;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ViewerPane {
    private ViewerPart fActiveViewerPart = null;
    private Map fControlToViewerMap = new HashMap();
    private InternalListener fInternalListener = new InternalListener();
    private ListenerList fListeners = new ListenerList();

    public ViewerPart getActiveViewerPart() {
        return this.fActiveViewerPart;
    }

    public void addViewerPart(ViewerPart viewerPart) {
        Control control = viewerPart.getControl();
        this.fControlToViewerMap.put(control, viewerPart);
        control.addListener(26, (Listener)this.fInternalListener);
        control.addListener(27, (Listener)this.fInternalListener);
    }

    public void removeViewerPart(ViewerPart viewerPart) {
        Control control = viewerPart.getControl();
        if (control == null) {
            for (Map.Entry entry : this.fControlToViewerMap.entrySet()) {
                if (viewerPart != entry.getValue()) continue;
                control = (Control)entry.getKey();
                break;
            }
        }
        if (!control.isDisposed()) {
            control.removeListener(26, (Listener)this.fInternalListener);
            control.removeListener(27, (Listener)this.fInternalListener);
        }
        this.fControlToViewerMap.remove(control);
    }

    public ViewerPart findViewerPart(Control control) {
        return (ViewerPart)this.fControlToViewerMap.get(control);
    }

    public void addViewerPaneListener(IViewerPaneListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeViewerPaneListener(IViewerPaneListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void dispose() {
        if (this.fControlToViewerMap != null) {
            Iterator iter = new ArrayList(this.fControlToViewerMap.values()).iterator();
            while (iter.hasNext()) {
                this.removeViewerPart((ViewerPart)iter.next());
            }
            this.fControlToViewerMap = null;
        }
        this.fActiveViewerPart = null;
        this.fInternalListener = null;
        this.fListeners = null;
    }

    public boolean isDisposed() {
        return this.fListeners == null;
    }

    private void handleViewerPartActivated(ViewerPart activeViewerPart) {
        this.fActiveViewerPart = activeViewerPart;
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IViewerPaneListener)listeners[i]).viewerPartActivated(this.fActiveViewerPart);
            ++i;
        }
    }

    private void handleViewerPartDeactivated(ViewerPart activeViewerPart) {
        this.fActiveViewerPart = null;
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IViewerPaneListener)listeners[i]).viewerPartDeactivated(this.fActiveViewerPart);
            ++i;
        }
    }

    private class InternalListener
    implements Listener {
        private InternalListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 26) {
                ViewerPane.this.handleViewerPartActivated((ViewerPart)ViewerPane.this.fControlToViewerMap.get(event.widget));
            } else if (event.type == 27) {
                ViewerPane.this.handleViewerPartDeactivated((ViewerPart)ViewerPane.this.fControlToViewerMap.get(event.widget));
            }
        }
    }
}

