/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.StyledEditingAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class TextOperationAction
extends StyledEditingAction {
    private int fOperationCode;

    public TextOperationAction(String text, String cmdId, ImageDescriptor image, int operationCode) {
        super(text, cmdId, image);
        this.fOperationCode = operationCode;
    }

    public TextOperationAction(String text, String cmdId, ImageDescriptor image, IWorkbenchPart part, int operationCode) {
        super(text, cmdId, image, part);
        this.fOperationCode = operationCode;
    }

    public TextOperationAction(String text, String cmdId, ImageDescriptor image, ISourceViewer sourceViewer, int operationCode) {
        super(text, cmdId, image, sourceViewer);
        this.fOperationCode = operationCode;
    }

    protected int getOperationCode() {
        return this.fOperationCode;
    }

    public void run() {
        final ISourceViewer viewer = this.getSourceViewer();
        if (this.getOperationCode() == -1 || viewer == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                viewer.getTextOperationTarget().doOperation(TextOperationAction.this.getOperationCode());
            }
        });
    }

    public void update() {
        ISourceViewer viewer = this.getSourceViewer();
        boolean isEnabled = viewer != null && viewer.getTextOperationTarget().canDoOperation(this.getOperationCode());
        this.setEnabled(isEnabled);
    }

    private Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return null;
    }

    private Shell getShell() {
        IWorkbenchPartSite site;
        Shell shell;
        IWorkbenchPart part = this.getPart();
        if (part != null && (shell = (site = part.getSite()).getShell()) != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }
}

