/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer;

import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchedStyledText
extends StyledText {
    private static final int DEFAULT_WIDTH = 64;
    private static final int DEFAULT_HEIGHT = 64;
    private static final boolean IS_33;

    static {
        Object version = Platform.getBundle((String)"org.eclipse.swt").getHeaders().get("Bundle-Version");
        IS_33 = version instanceof String && ((String)version).startsWith("3.3");
    }

    public PatchedStyledText(Composite parent, int style) {
        super(parent, style);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (!IS_33 || !this.getWordWrap()) {
            return super.computeSize(wHint, hHint, changed);
        }
        try {
            return this.computeSize2(wHint, hHint, changed);
        }
        catch (Exception x) {
            FoundationIDEUIPlugin.getDefault().log(x.getLocalizedMessage(), x);
            return super.computeSize(wHint, hHint, changed);
        }
    }

    private Point computeSize2(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int lineCount = (this.getStyle() & 4) != 0 ? 1 : this.getContent().getLineCount();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            Display display = this.getDisplay();
            int maxHeight = display.getClientArea().height;
            int lineIndex = 0;
            while (lineIndex < lineCount) {
                TextLayout layout = this.getTextLayout(lineIndex);
                int wrapWidth = layout.getWidth();
                if (this.getWordWrap()) {
                    layout.setWidth(wHint == 0 ? 1 : wHint);
                }
                Rectangle rect = layout.getBounds();
                width = Math.max(width, rect.width);
                layout.setWidth(wrapWidth);
                this.disposeTextLayout(layout);
                if (this.isFixedLineHeight2() && (height += rect.height) > maxHeight) break;
                ++lineIndex;
            }
            if (this.isFixedLineHeight2()) {
                height = lineCount * this.getLineHeight();
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int wTrim = this.getLeftMargin() + this.getRightMargin() + this.getCaretWidth2();
        int hTrim = this.getTopMargin() + this.getBottomMargin();
        Rectangle rect = this.computeTrim(0, 0, width + wTrim, height + hTrim);
        return new Point(rect.width, rect.height);
    }

    private TextLayout getTextLayout(int lineIndex) {
        return (TextLayout)this.call(this.get("renderer"), "getTextLayout", Integer.TYPE, lineIndex);
    }

    private void disposeTextLayout(TextLayout layout) {
        this.call(this.get("renderer"), "disposeTextLayout", TextLayout.class, layout);
    }

    private Integer getTopMargin() {
        return (Integer)this.get("topMargin");
    }

    private Integer getBottomMargin() {
        return (Integer)this.get("bottomMargin");
    }

    private Integer getRightMargin() {
        return (Integer)this.get("rightMargin");
    }

    private Integer getLeftMargin() {
        return (Integer)this.get("leftMargin");
    }

    private int getCaretWidth2() {
        Caret caret = this.getCaret();
        if (caret == null) {
            return 0;
        }
        return caret.getSize().x;
    }

    private boolean isFixedLineHeight2() {
        return (Boolean)this.get("fixedLineHeight");
    }

    private Object call(Object object, String method, Class<?> argumentType, Object argument) {
        try {
            Method accessor = object.getClass().getDeclaredMethod(method, argumentType);
            accessor.setAccessible(true);
            return accessor.invoke(object, argument);
        }
        catch (SecurityException x) {
            throw new IllegalStateException(x);
        }
        catch (NoSuchMethodException x) {
            throw new IllegalStateException(x);
        }
        catch (IllegalArgumentException x) {
            throw new IllegalStateException(x);
        }
        catch (IllegalAccessException x) {
            throw new IllegalStateException(x);
        }
        catch (InvocationTargetException x) {
            throw new IllegalStateException(x);
        }
    }

    private Object get(String field) {
        try {
            Field accessor = StyledText.class.getDeclaredField(field);
            accessor.setAccessible(true);
            return accessor.get((Object)this);
        }
        catch (SecurityException x) {
            throw new IllegalStateException(x);
        }
        catch (NoSuchFieldException x) {
            throw new IllegalStateException(x);
        }
        catch (IllegalArgumentException x) {
            throw new IllegalStateException(x);
        }
        catch (IllegalAccessException x) {
            throw new IllegalStateException(x);
        }
    }
}

