/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.internal;

import com.ibm.team.foundation.common.IArtifactType;
import com.ibm.team.foundation.common.IArtifactTypeManager;
import com.ibm.team.foundation.common.internal.ArtifactType;
import com.ibm.team.foundation.common.internal.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.NLS;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArtifactTypeManager
implements IArtifactTypeManager {
    protected static final String EXT_POINT_ARTIFACT_CLASS = "artifactClass";
    protected static final String EXT_ATTRIBUTE_DEFAULT_ICON_URI = "defaultIconUri";
    protected static final String EXT_ATTRIBUTE_NAME = "name";
    protected static final String EXT_ATTRIBUTE_ID = "id";
    protected static final String ARTIFACT_TYPE_EXTENSION_POINT = "artifactType";
    protected static final String EXT_ATTRIBUTE_CLASS = "class";
    private Map<String, ArtifactType> fClassnameToTypeIdentifier = new HashMap<String, ArtifactType>();
    private Map<String, ArtifactType> fIdToType = new HashMap<String, ArtifactType>();
    private Object fModelLock = new Object();
    private ExtensionRegistryReader<IArtifactType> fRegistryReader;
    private boolean fIsDisposed = false;
    private boolean fIsInitialized = false;

    protected abstract URL createAbsoluteUrl(String var1, IConfigurationElement var2) throws MalformedURLException;

    protected AbstractArtifactTypeManager() {
    }

    public void init() {
        this.fRegistryReader = new ExtensionRegistryReader<IArtifactType>("com.ibm.team.foundation.common", ARTIFACT_TYPE_EXTENSION_POINT){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IArtifactType handleExtensionAdded(IConfigurationElement element) throws Exception {
                String id = element.getAttribute(AbstractArtifactTypeManager.EXT_ATTRIBUTE_ID);
                String name = element.getAttribute(AbstractArtifactTypeManager.EXT_ATTRIBUTE_NAME);
                String pluginRelativeUri = element.getAttribute(AbstractArtifactTypeManager.EXT_ATTRIBUTE_DEFAULT_ICON_URI);
                URL url = null;
                try {
                    url = AbstractArtifactTypeManager.this.createAbsoluteUrl(pluginRelativeUri, element);
                }
                catch (MalformedURLException e) {
                    throw new Exception(NLS.bind((String)Messages.getString("AbstractArtifactTypeManager.ERROR_UNABLE_INIT_ARTIFACT"), (Object[])new Object[]{id}), e);
                }
                ArtifactType type = new ArtifactType(id, name, url);
                IConfigurationElement[] children = element.getChildren(AbstractArtifactTypeManager.EXT_POINT_ARTIFACT_CLASS);
                Object object = AbstractArtifactTypeManager.this.fModelLock;
                synchronized (object) {
                    AbstractArtifactTypeManager.this.fIdToType.put(type.getId(), type);
                    IConfigurationElement[] iConfigurationElementArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement classConfig = iConfigurationElementArray[n2];
                        String classname = classConfig.getAttribute(AbstractArtifactTypeManager.EXT_ATTRIBUTE_CLASS);
                        AbstractArtifactTypeManager.this.fClassnameToTypeIdentifier.put(classname, type);
                        ++n2;
                    }
                }
                return type;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void handleExtensionRemoved(IConfigurationElement element, IArtifactType descriptor) throws Exception {
                String id = descriptor.getId();
                IConfigurationElement[] children = element.getChildren(AbstractArtifactTypeManager.EXT_ATTRIBUTE_CLASS);
                Object object = AbstractArtifactTypeManager.this.fModelLock;
                synchronized (object) {
                    AbstractArtifactTypeManager.this.fIdToType.remove(id);
                    IConfigurationElement[] iConfigurationElementArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement child = iConfigurationElementArray[n2];
                        String classname = child.getAttribute(AbstractArtifactTypeManager.EXT_ATTRIBUTE_NAME);
                        AbstractArtifactTypeManager.this.fClassnameToTypeIdentifier.remove(classname);
                        ++n2;
                    }
                }
            }
        };
        this.fRegistryReader.start();
        this.fIsInitialized = true;
    }

    public boolean isDisposed() {
        return this.fIsDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (!this.isDisposed()) {
            this.fRegistryReader.stop();
            this.fIsDisposed = true;
            Object object = this.fModelLock;
            synchronized (object) {
                this.fClassnameToTypeIdentifier.clear();
            }
        }
    }

    @Override
    public IArtifactType mapElementToType(Object element) throws TeamRepositoryException {
        if (this.isDisposed()) {
            throw new IllegalStateException(Messages.getString("AbstractArtifactTypeManager.ERROR_TYPEMAPPING_DISPOSED"));
        }
        if (element == null) {
            throw new IllegalArgumentException(Messages.getString("AbstractArtifactTypeManager.ERROR_ELEMENT_NULL"));
        }
        if (!this.fIsInitialized) {
            this.init();
        }
        Class<?> currentType = element.getClass();
        ArrayList<Class> allTypes = new ArrayList<Class>();
        this.fillTypes(allTypes, currentType);
        for (Class type : allTypes) {
            IArtifactType artifactType = this.fClassnameToTypeIdentifier.get(type.getName());
            if (artifactType == null) continue;
            return artifactType;
        }
        throw new TeamRepositoryException(NLS.bind((String)Messages.getString("AbstractArtifactTypeManager.ERROR_TYPE_NOT_FOUND"), (Object[])new Object[]{element.getClass().getName()}));
    }

    @Override
    public IArtifactType getTypeFromId(String id) throws TeamRepositoryException {
        IArtifactType artifactType;
        if (this.isDisposed()) {
            throw new IllegalStateException(Messages.getString("AbstractArtifactTypeManager.ERROR_TYPEMAPPING_DISPOSED"));
        }
        if (id == null) {
            throw new IllegalArgumentException(Messages.getString("AbstractArtifactTypeManager.ERROR_ID_NULL"));
        }
        if (!this.fIsInitialized) {
            this.init();
        }
        if ((artifactType = (IArtifactType)this.fIdToType.get(id)) == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.getString("AbstractArtifactTypeManager.ERROR_FIND_TYPE"), (Object[])new Object[]{id}));
        }
        return artifactType;
    }

    private void fillTypes(List<Class> tofill, Class currentType) {
        Class<?>[] interfaces;
        if (!tofill.contains(currentType)) {
            tofill.add(currentType);
        }
        Class<?>[] classArray = interfaces = currentType.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfacee = classArray[n2];
            this.fillTypes(tofill, interfacee);
            ++n2;
        }
        Class superclass = currentType.getSuperclass();
        if (superclass != null) {
            this.fillTypes(tofill, superclass);
        }
    }
}

