/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.foundation.common.text.XMLString;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkDetector {
    private static final Pattern SPLITTER = Pattern.compile("(<a\\shref=\"([^\"]*)\">([^<]*)</a>)");
    private static final int COMPLETE_URL_GROUP = 0;
    private Set<TextLinkDetector> fContributions = new HashSet<TextLinkDetector>();
    private Set<ILinkDetectorListener> fListeners = new HashSet<ILinkDetectorListener>();
    private ILinkDetectorListener fListener = new ILinkDetectorListener(){

        public void linkDetectorChanged() {
            LinkDetector.this.notifyListeners();
        }
    };

    LinkDetector() {
    }

    public void addTextLinkDetector(TextLinkDetector detector) {
        detector.initialize();
        detector.setListener(this.fListener);
        this.fContributions.add(detector);
    }

    public void removeTextLinkDetector(TextLinkDetector detector) {
        detector.cleanup();
        this.fContributions.remove(detector);
    }

    public List<TextLinkDetector> getTextLinkDetectors() {
        return new ArrayList<TextLinkDetector>(this.fContributions);
    }

    public void setBaseURI(final URI baseURI) {
        for (final TextLinkDetector contribution : this.fContributions) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.setBaseURI(baseURI);
                }
            });
        }
    }

    public void dispose() {
        for (final TextLinkDetector contribution : this.fContributions) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.cleanup();
                }
            });
        }
        this.fContributions.clear();
    }

    public List<DetectedTextLink> match(String text, boolean verify) {
        return this.match(text);
    }

    public List<DetectedTextLink> match(final String text) {
        final ArrayList<DetectedTextLink> results = new ArrayList<DetectedTextLink>();
        final ArrayList failedDetectors = new ArrayList();
        for (final TextLinkDetector contribution : this.fContributions) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    failedDetectors.add(contribution);
                }

                public void run() throws Exception {
                    Pattern pattern = contribution.getPattern();
                    if (pattern == null) {
                        return;
                    }
                    Matcher matcher = pattern.matcher(text);
                    while (matcher.find()) {
                        DetectedTextLink result = contribution.createDetectedLink(matcher);
                        if (result == null) continue;
                        results.add(result);
                    }
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        this.fContributions.removeAll(failedDetectors);
        this.removeOverlapping(results);
        return results;
    }

    public List<DetectedTextLink> match(XMLString text) {
        List<DetectedTextLink> temp;
        ArrayList<DetectedTextLink> results = new ArrayList<DetectedTextLink>();
        String xmlText = text.getXMLText();
        Matcher splitter = SPLITTER.matcher(xmlText);
        int startIndex = 0;
        int endIndex = 0;
        while (splitter.find()) {
            endIndex = splitter.start(0);
            temp = this.match(xmlText.substring(startIndex, endIndex));
            this.patch(temp, startIndex);
            results.addAll(temp);
            startIndex = splitter.end(0);
        }
        endIndex = xmlText.length();
        temp = this.match(xmlText.substring(startIndex, endIndex));
        this.patch(temp, startIndex);
        results.addAll(temp);
        return results;
    }

    private void patch(List<DetectedTextLink> links, int startIndex) {
        for (DetectedTextLink link : links) {
            link.addOffSet(startIndex);
        }
    }

    public void addListener(ILinkDetectorListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(ILinkDetectorListener listener) {
        this.fListeners.remove(listener);
    }

    private void notifyListeners() {
        for (ILinkDetectorListener listener : this.fListeners) {
            listener.linkDetectorChanged();
        }
    }

    private void removeOverlapping(List<DetectedTextLink> candidates) {
        HashSet<DetectedTextLink> losers = new HashSet<DetectedTextLink>();
        for (DetectedTextLink candidate : candidates) {
            if (losers.contains(candidate)) continue;
            for (DetectedTextLink link : candidates) {
                if (losers.contains(link) || link == candidate || candidate.getOffset() + candidate.getLength() <= link.getOffset() || link.getOffset() + link.getLength() <= candidate.getOffset()) continue;
                if (candidate.getLength() < link.getLength()) {
                    losers.add(candidate);
                    continue;
                }
                if (link.getLength() < candidate.getLength()) {
                    losers.add(link);
                    continue;
                }
                if (candidate.getOffset() > link.getOffset()) {
                    losers.add(candidate);
                    continue;
                }
                losers.add(link);
            }
        }
        candidates.removeAll(losers);
    }

    public static interface ILinkDetectorListener {
        public void linkDetectorChanged();
    }
}

