/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.dto.impl;

import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOPackage;
import com.ibm.team.filesystem.common.internal.dto.LogicalChange;
import com.ibm.team.filesystem.common.internal.dto.LogicalConflictReport;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class LogicalConflictReportImpl
extends EDataObjectImpl
implements LogicalConflictReport {
    protected int ALL_FLAGS = 0;
    protected EList conflicts;
    protected EList pendingChanges;
    protected EList deferredChanges;
    protected IUpdateReport conflictReport;
    protected static final int CONFLICT_REPORT_ESETFLAG = 1;

    protected LogicalConflictReportImpl() {
    }

    protected EClass eStaticClass() {
        return FilesystemDTOPackage.Literals.LOGICAL_CONFLICT_REPORT;
    }

    public List getConflicts() {
        if (this.conflicts == null) {
            this.conflicts = new EObjectContainmentEList.Unsettable(ILogicalConflict.class, (InternalEObject)this, 0);
        }
        return this.conflicts;
    }

    public void unsetConflicts() {
        if (this.conflicts != null) {
            ((InternalEList.Unsettable)this.conflicts).unset();
        }
    }

    public boolean isSetConflicts() {
        return this.conflicts != null && ((InternalEList.Unsettable)this.conflicts).isSet();
    }

    public List getPendingChanges() {
        if (this.pendingChanges == null) {
            this.pendingChanges = new EObjectContainmentEList.Unsettable(ILogicalChange.class, (InternalEObject)this, 1);
        }
        return this.pendingChanges;
    }

    public void unsetPendingChanges() {
        if (this.pendingChanges != null) {
            ((InternalEList.Unsettable)this.pendingChanges).unset();
        }
    }

    public boolean isSetPendingChanges() {
        return this.pendingChanges != null && ((InternalEList.Unsettable)this.pendingChanges).isSet();
    }

    public List getDeferredChanges() {
        if (this.deferredChanges == null) {
            this.deferredChanges = new EObjectContainmentEList.Unsettable(ILogicalChange.class, (InternalEObject)this, 2);
        }
        return this.deferredChanges;
    }

    public void unsetDeferredChanges() {
        if (this.deferredChanges != null) {
            ((InternalEList.Unsettable)this.deferredChanges).unset();
        }
    }

    public boolean isSetDeferredChanges() {
        return this.deferredChanges != null && ((InternalEList.Unsettable)this.deferredChanges).isSet();
    }

    public IUpdateReport getConflictReport() {
        return this.conflictReport;
    }

    public NotificationChain basicSetConflictReport(IUpdateReport newConflictReport, NotificationChain msgs) {
        IUpdateReport oldConflictReport = this.conflictReport;
        this.conflictReport = newConflictReport;
        boolean oldConflictReportESet = (this.ALL_FLAGS & 1) != 0;
        this.ALL_FLAGS |= 1;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldConflictReport, (Object)newConflictReport, !oldConflictReportESet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setConflictReport(IUpdateReport newConflictReport) {
        if (newConflictReport != this.conflictReport) {
            NotificationChain msgs = null;
            if (this.conflictReport != null) {
                msgs = ((InternalEObject)this.conflictReport).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newConflictReport != null) {
                msgs = ((InternalEObject)newConflictReport).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetConflictReport(newConflictReport, msgs)) != null) {
                msgs.dispatch();
            }
        } else {
            boolean oldConflictReportESet = (this.ALL_FLAGS & 1) != 0;
            this.ALL_FLAGS |= 1;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newConflictReport, (Object)newConflictReport, !oldConflictReportESet));
            }
        }
    }

    public NotificationChain basicUnsetConflictReport(NotificationChain msgs) {
        IUpdateReport oldConflictReport = this.conflictReport;
        this.conflictReport = null;
        boolean oldConflictReportESet = (this.ALL_FLAGS & 1) != 0;
        this.ALL_FLAGS &= 0xFFFFFFFE;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 2, 3, (Object)oldConflictReport, null, oldConflictReportESet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void unsetConflictReport() {
        if (this.conflictReport != null) {
            NotificationChain msgs = null;
            msgs = ((InternalEObject)this.conflictReport).eInverseRemove((InternalEObject)this, -4, null, msgs);
            if ((msgs = this.basicUnsetConflictReport(msgs)) != null) {
                msgs.dispatch();
            }
        } else {
            boolean oldConflictReportESet = (this.ALL_FLAGS & 1) != 0;
            this.ALL_FLAGS &= 0xFFFFFFFE;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 3, null, null, oldConflictReportESet));
            }
        }
    }

    public boolean isSetConflictReport() {
        return (this.ALL_FLAGS & 1) != 0;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getConflicts()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getPendingChanges()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getDeferredChanges()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return this.basicUnsetConflictReport(msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getConflicts();
            }
            case 1: {
                return this.getPendingChanges();
            }
            case 2: {
                return this.getDeferredChanges();
            }
            case 3: {
                return this.getConflictReport();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getConflicts().clear();
                this.getConflicts().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getPendingChanges().clear();
                this.getPendingChanges().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getDeferredChanges().clear();
                this.getDeferredChanges().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setConflictReport((IUpdateReport)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.unsetConflicts();
                return;
            }
            case 1: {
                this.unsetPendingChanges();
                return;
            }
            case 2: {
                this.unsetDeferredChanges();
                return;
            }
            case 3: {
                this.unsetConflictReport();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetConflicts();
            }
            case 1: {
                return this.isSetPendingChanges();
            }
            case 2: {
                return this.isSetDeferredChanges();
            }
            case 3: {
                return this.isSetConflictReport();
            }
        }
        return super.eIsSet(featureID);
    }

    public Collection getConflict(IComponentHandle component, IVersionableHandle proposedVersionable) {
        ArrayList<ILogicalConflict> result = new ArrayList<ILogicalConflict>();
        for (ILogicalConflict conflict : this.getConflicts()) {
            if (!conflict.item().sameItemId((IItemHandle)proposedVersionable) || !conflict.component().sameItemId((IItemHandle)component)) continue;
            result.add(conflict);
        }
        return result;
    }

    public Collection getPendingConflict(IComponentHandle component, IVersionableHandle selectedVersionable) {
        ArrayList<ILogicalConflict> result = new ArrayList<ILogicalConflict>();
        for (ILogicalConflict conflict : this.getByComponent(component, this.getConflicts())) {
            for (IVersionableHandle conflicted : conflict.conflictingItems()) {
                if (!conflicted.sameItemId((IItemHandle)selectedVersionable)) continue;
                result.add(conflict);
            }
        }
        return result;
    }

    public Collection getAffectedComponents() {
        IComponentHandle component;
        ILogicalChange conflict;
        List conflictList = this.getConflicts();
        List pendingList = this.getPendingChanges();
        if (conflictList.isEmpty() && pendingList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashMap<UUID, IComponentHandle> idComponentMap = new HashMap<UUID, IComponentHandle>();
        int i = 0;
        while (i < conflictList.size()) {
            conflict = (ILogicalConflict)conflictList.get(i);
            component = conflict.component();
            idComponentMap.put(component.getItemId(), component);
            ++i;
        }
        i = 0;
        while (i < pendingList.size()) {
            conflict = (ILogicalChange)pendingList.get(i);
            component = conflict.component();
            idComponentMap.put(component.getItemId(), component);
            ++i;
        }
        return Collections.unmodifiableCollection(idComponentMap.values());
    }

    public Collection getConflictsForComponent(IComponentHandle component) {
        return Collections.unmodifiableCollection(this.getByComponent(component, this.getConflicts()));
    }

    public Collection getAutoMergeChangesForComponent(IComponentHandle component) {
        return Collections.unmodifiableCollection(this.getByComponent(component, this.getPendingChanges()));
    }

    public Collection getIncidentalChangesForComponent(IComponentHandle component) {
        return Collections.unmodifiableCollection(this.getByComponent(component, this.getDeferredChanges()));
    }

    private List getByComponent(IComponentHandle component, List reports) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (reports.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ILogicalChange> result = new ArrayList<ILogicalChange>();
        for (ILogicalChange change : reports) {
            if (!change.component().sameItemId((IItemHandle)component)) continue;
            result.add(change);
        }
        return result;
    }

    public List getDependentChanges(ILogicalChange change) {
        if (change == null) {
            throw new IllegalArgumentException();
        }
        HashMap map = new HashMap();
        this.buildChangeMap(map, this.getAutoMergeChangesForComponent(change.component()));
        this.buildChangeMap(map, this.getIncidentalChangesForComponent(change.component()));
        this.buildChangeMap(map, this.getConflictsForComponent(change.component()));
        ArrayList result = new ArrayList(((LogicalChange)change).getDependentChanges().size());
        for (Object id : ((LogicalChange)change).getDependentChanges()) {
            result.add(map.get(id));
        }
        return Collections.unmodifiableList(result);
    }

    public List getRequiredChanges(ILogicalChange change) {
        if (change == null) {
            throw new IllegalArgumentException();
        }
        HashMap map = new HashMap();
        this.buildChangeMap(map, this.getAutoMergeChangesForComponent(change.component()));
        this.buildChangeMap(map, this.getIncidentalChangesForComponent(change.component()));
        this.buildChangeMap(map, this.getConflictsForComponent(change.component()));
        ArrayList result = new ArrayList(((LogicalChange)change).getRelatedChanges().size());
        for (Object id : ((LogicalChange)change).getRelatedChanges()) {
            result.add(map.get(id));
        }
        return Collections.unmodifiableList(result);
    }

    private void buildChangeMap(HashMap map, Collection changes) {
        for (LogicalChange change : changes) {
            map.put(change.getId(), change);
        }
    }

    public Collection conflicts() {
        return Collections.unmodifiableCollection(this.getConflicts());
    }

    public Collection incidentalChanges() {
        return Collections.unmodifiableCollection(this.getDeferredChanges());
    }

    public Collection autoMergeChanges() {
        return Collections.unmodifiableCollection(this.getPendingChanges());
    }

    public Collection getChange(IComponentHandle component, IVersionableHandle proposedVersionable) {
        ArrayList result = new ArrayList();
        this.getChange(component, proposedVersionable, this.getConflicts(), result);
        this.getChange(component, proposedVersionable, this.getDeferredChanges(), result);
        this.getChange(component, proposedVersionable, this.getPendingChanges(), result);
        return result;
    }

    private void getChange(IComponentHandle component, IVersionableHandle proposedVersionable, List changes, Collection result) {
        for (ILogicalChange change : changes) {
            if (!proposedVersionable.sameItemId((IItemHandle)change.item()) || !change.component().sameItemId((IItemHandle)component)) continue;
            result.add(change);
        }
    }

    public Collection getPendingChanges(IComponentHandle component, IChangeSummary appliedChange) {
        ArrayList<ILogicalChange> result = new ArrayList<ILogicalChange>();
        block0: for (ILogicalConflict conflict : this.getByComponent(component, this.getConflicts())) {
            if (conflict.conflictType() == 6) {
                if (!conflict.item().sameItemId((IItemHandle)appliedChange.item())) continue;
                result.add(conflict);
                continue;
            }
            for (IVersionableHandle conflicted : conflict.conflictingItems()) {
                if (!conflicted.sameItemId((IItemHandle)appliedChange.item())) continue;
                result.add(conflict);
                continue block0;
            }
        }
        for (ILogicalChange change : this.getByComponent(component, this.getPendingChanges())) {
            if (!this.isConflictCause(change, appliedChange.item())) continue;
            result.add(change);
        }
        return Collections.unmodifiableCollection(result);
    }

    private boolean isConflictCause(ILogicalChange change, IVersionableHandle affectedVersionable) {
        return change.item().sameItemId((IItemHandle)affectedVersionable);
    }

    public IUpdateReport conflictReport() {
        return this.getConflictReport();
    }
}

