/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsJazzIgnoreRule;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;

public final class ParmsShareRequest
implements IParameterWrapper {
    public ParmsWorkspace workspace;
    public String componentItemId;
    public String componentName;
    public String changeSetItemId;
    public String parentFolderItemId;
    public String newFolderPath;
    public String[] foldersToShare;
    public ParmsJazzIgnoreRule[] ignoreRules;

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.workspace, requestName, parameterName, "workspace");
        this.workspace.validate(requestName, parameterName, "workspace");
        if (this.componentItemId == null && (this.componentName == null || this.componentName.trim().length() == 0)) {
            throw new IllegalArgumentException(NLS.bind((String)"Either {0} or {1} must be supplied for {2} in {3} request", (Object[])new Object[]{"componentItemId", "componentName", ParmValidation.getParameterName(parameterName), requestName}));
        }
        if (this.componentItemId != null && this.componentName != null && this.componentName.trim().length() != 0) {
            throw new IllegalArgumentException(NLS.bind((String)"Only one of {0} and {1} may be supplied for {2} in {3} request,", (Object[])new Object[]{"componentItemId", "componentName", ParmValidation.getParameterName(parameterName), requestName}));
        }
        if (this.componentItemId == null && this.parentFolderItemId != null) {
            throw new IllegalArgumentException(NLS.bind((String)"When a component is being created, {0} can not be specified in {1} request", (Object[])new Object[]{ParmValidation.getParameterName(parameterName, "parentFolderItemId"), requestName}));
        }
        if (this.componentItemId != null) {
            ParmValidation.requiredValue(this.parentFolderItemId, requestName, parameterName, "parentFolderItemId");
        }
        if (this.newFolderPath != null && this.newFolderPath.trim().length() != 0 && !this.newFolderPath.startsWith("/")) {
            throw new IllegalArgumentException(NLS.bind((String)"Path {0} in must have a leading slash in {1} request", (Object[])new Object[]{this.newFolderPath, requestName}));
        }
        ParmValidation.requiredValue(this.foldersToShare, requestName, "foldersToShare");
        if (this.foldersToShare == null || this.foldersToShare.length < 1) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.ParmValidation_0, (Object[])new Object[]{ParmValidation.getParameterName(parameterName, "foldersToShare"), requestName}));
        }
        int i = 0;
        while (i < this.foldersToShare.length) {
            if (this.foldersToShare[i] == null || this.foldersToShare[i].length() == 0) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.ParmValidation_1, (Object[])new Object[]{ParmValidation.getParameterName(parameterName, "foldersToShare"), i, requestName}));
            }
            ++i;
        }
    }

    public IComponentHandle getComponentHandle() {
        if (this.componentItemId == null || this.componentItemId.trim().length() == 0) {
            return null;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.componentItemId), null);
    }

    public IChangeSetHandle getChangeSetHandle() {
        if (this.changeSetItemId == null || this.changeSetItemId.trim().length() == 0) {
            return null;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.changeSetItemId), null);
    }

    public IFolderHandle getParentFolderHandle() {
        if (this.parentFolderItemId == null || this.parentFolderItemId.trim().length() == 0) {
            return null;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.parentFolderItemId), null);
    }
}

