/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCommitDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;

public final class ParmsCheckInChanges
implements IParameterWrapper {
    public ParmsWorkspace workspace;
    public String componentItemId;
    public String changeSetItemId;
    public String newChangeSetComment;
    public Boolean checkInAllComponentChanges;
    public String[] resourcesToCheckIn;
    public String[] versionablesToCheckIn;
    public ParmsOutOfSyncInstructions outOfSyncInstructions;
    public ParmsCommitDilemmaHandler commitDilemmaHandler;

    public void validate(String requestName) {
        ParmValidation.requiredValue(this.workspace, requestName, "workspace");
        this.workspace.validate(requestName, "workspace");
        ParmValidation.requiredValue(this.componentItemId, requestName, "componentItemId");
        if (this.changeSetItemId != null && this.changeSetItemId.length() > 0 && this.newChangeSetComment != null && this.newChangeSetComment.trim().length() > 0) {
            throw new IllegalArgumentException("Either changeSetItemId or newChangeSetComment should be supplied.  Not both.");
        }
        boolean resourcesSpecified = false;
        boolean versionablesSpecified = false;
        if (this.resourcesToCheckIn != null && this.resourcesToCheckIn.length > 0) {
            resourcesSpecified = true;
        }
        if (this.versionablesToCheckIn != null && this.versionablesToCheckIn.length > 0) {
            versionablesSpecified = true;
        }
        if (this.checkInAllComponentChanges != null && this.checkInAllComponentChanges.booleanValue()) {
            if (resourcesSpecified) {
                throw new IllegalArgumentException("When all component changes are to be checked in, resourcesToCheckIn can not also be specified.");
            }
            if (versionablesSpecified) {
                throw new IllegalArgumentException("When all component changes are to be checked in, versionablesToCheckIn can not also be specified.");
            }
        } else {
            if (resourcesSpecified && versionablesSpecified) {
                throw new IllegalArgumentException("Only one of versionablesToCheckIn or resoucesToCheckIn can specified.");
            }
            if (!resourcesSpecified && !versionablesSpecified) {
                throw new IllegalArgumentException("Either versionablesToCheckIn or resourcesToCheckIn must be specified.");
            }
            if (resourcesSpecified) {
                ParmValidation.requiredArray(this.resourcesToCheckIn, requestName, "resourcesToCheckIn");
            } else if (versionablesSpecified) {
                ParmValidation.requiredArray(this.versionablesToCheckIn, requestName, "versionablesToCheckIn");
            }
        }
        if (this.outOfSyncInstructions != null) {
            this.outOfSyncInstructions.validate(requestName, "outOfSyncInstructions");
        }
        if (this.commitDilemmaHandler != null) {
            this.commitDilemmaHandler.validate(requestName, "commitDilemmaHandler");
        }
    }

    public IChangeSetHandle getChangeSetHandle() {
        if (this.changeSetItemId != null && this.changeSetItemId.trim().length() > 0) {
            ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
            return (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.changeSetItemId), null);
        }
        return null;
    }

    public IComponentHandle getComponentHandle() {
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.componentItemId), null);
    }
}

