/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;

public class RepositoryUtils {
    private RepositoryUtils() {
    }

    public static ITeamRepository getTeamRepository(String repositoryURI) {
        return RepositoryUtils.getTeamRepository(repositoryURI, 0);
    }

    public static ITeamRepository getTeamRepository(String repositoryURI, int flags) {
        return TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI, flags);
    }

    public static ITeamRepository getTeamRepository(String repositoryURI, UUID id) {
        return RepositoryUtils.getTeamRepository(repositoryURI, 0, id);
    }

    public static ITeamRepository getTeamRepository(String repositoryURI, int flags, UUID id) {
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repos.length) {
            if (id.equals((Object)repos[i].getId())) {
                return repos[i];
            }
            ++i;
        }
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI, flags);
        if (repo != null && repo.getId() == null) {
            try {
                repo.setId(id);
            }
            catch (Exception exception) {}
        }
        return repo;
    }

    public static void throwAppropriateException(String msg, IStatus[] statuses) throws FileSystemClientException {
        MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, statuses, msg, null);
        if (multi.isOK()) {
            return;
        }
        if (multi.matches(4)) {
            throw new FileSystemClientException((IStatus)multi);
        }
        if (multi.matches(8)) {
            throw new OperationCanceledException();
        }
        throw new FileSystemClientException((IStatus)multi);
    }

    public static IContributorHandle getLoggedInContributor(ITeamRepository repo) throws NotLoggedInException {
        IContributor contributor = repo.loggedInContributor();
        if (contributor == null) {
            NotLoggedInException e = new NotLoggedInException(repo.getRepositoryURI());
            e.setOrigin((Object)repo);
            throw e;
        }
        return contributor;
    }
}

