/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.ContextLock;
import com.ibm.team.scm.common.IContextHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowNodeLock {
    private HashMap<UUID, IContextHandle> contextsToReadLock;
    private HashMap<UUID, IContextHandle> contextsToWriteLock;
    private HashSet<ConfigurationDescriptor> configurationsToReadLock;
    private HashSet<ConfigurationDescriptor> configurationsToWriteLock;
    private boolean hasLocked = false;
    private ContextLock locks;
    private Collection<IAuditable> determinantsForLockDecisions = new ArrayList<IAuditable>();
    private final ReentrantLock lock = new ReentrantLock();

    public void toReadLock(IContextHandle context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (this.hasLocked) {
                throw new IllegalStateException();
            }
            if (this.contextsToWriteLock != null && this.contextsToWriteLock.get(context.getItemId()) != null) {
                throw new IllegalStateException();
            }
            if (this.contextsToReadLock == null) {
                this.contextsToReadLock = new HashMap();
            }
            this.contextsToReadLock.put(context.getItemId(), context);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addDeterminants(Collection<? extends IAuditable> determinants) {
        if (determinants == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            this.determinantsForLockDecisions.addAll(determinants);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void toReadLock(ConfigurationDescriptor configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (this.hasLocked) {
                throw new IllegalStateException();
            }
            if (this.configurationsToWriteLock != null && this.configurationsToWriteLock.contains(configuration)) {
                throw new IllegalStateException();
            }
            if (this.configurationsToReadLock == null) {
                this.configurationsToReadLock = new HashSet();
            }
            this.configurationsToReadLock.add(configuration);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void toWriteLock(IContextHandle context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (this.hasLocked) {
                throw new IllegalStateException();
            }
            if (this.contextsToReadLock != null && this.contextsToReadLock.get(context.getItemId()) != null) {
                throw new IllegalStateException();
            }
            if (this.contextsToWriteLock == null) {
                this.contextsToWriteLock = new HashMap();
            }
            this.contextsToWriteLock.put(context.getItemId(), context);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void toWriteLock(ConfigurationDescriptor configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (this.hasLocked) {
                throw new IllegalStateException();
            }
            if (this.configurationsToReadLock != null && this.configurationsToReadLock.contains(configuration)) {
                throw new IllegalStateException();
            }
            if (this.configurationsToWriteLock == null) {
                this.configurationsToWriteLock = new HashSet();
            }
            this.configurationsToWriteLock.add(configuration);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void acquire() {
        block18: {
            ContextLock locksToObtain = null;
            boolean lockObtained = false;
            boolean success = false;
            try {
                this.lock.lock();
                try {
                    if (this.hasLocked) {
                        throw new IllegalStateException();
                    }
                    this.hasLocked = true;
                    if (this.needReadLocks() && this.needWriteLocks()) {
                        locksToObtain = new ContextLock();
                        this.populateWriteLock(locksToObtain, this.contextsToWriteLock, this.configurationsToWriteLock);
                        this.populateReadLock(locksToObtain, this.contextsToReadLock, this.configurationsToReadLock);
                    } else if (this.needReadLocks()) {
                        locksToObtain = new ContextLock();
                        this.populateReadLock(locksToObtain, this.contextsToReadLock, this.configurationsToReadLock);
                    } else if (this.needWriteLocks()) {
                        locksToObtain = new ContextLock();
                        this.populateWriteLock(locksToObtain, this.contextsToWriteLock, this.configurationsToWriteLock);
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (locksToObtain == null) break block18;
                locksToObtain.acquire();
                lockObtained = true;
                this.lock.lock();
                try {
                    if (this.locks != null) {
                        throw new IllegalStateException();
                    }
                    this.locks = locksToObtain;
                    success = true;
                }
                finally {
                    this.lock.unlock();
                }
            }
            finally {
                if (locksToObtain != null && lockObtained && !success) {
                    locksToObtain.release();
                }
            }
        }
    }

    private boolean needWriteLocks() {
        return this.configurationsToWriteLock != null || this.contextsToWriteLock != null;
    }

    private boolean needReadLocks() {
        return this.configurationsToReadLock != null || this.contextsToReadLock != null;
    }

    private void populateWriteLock(ContextLock lock, HashMap<UUID, IContextHandle> contextsToLock, HashSet<ConfigurationDescriptor> configurationsToLock) {
        if (contextsToLock != null) {
            for (IContextHandle context : contextsToLock.values()) {
                lock.addExclusive(context);
            }
        }
        if (configurationsToLock != null) {
            for (ConfigurationDescriptor configuration : configurationsToLock) {
                lock.addExclusive(configuration.connectionHandle, configuration.componentHandle);
            }
        }
    }

    private void populateReadLock(ContextLock lock, HashMap<UUID, IContextHandle> contextsToLock, HashSet<ConfigurationDescriptor> configurationsToLock) {
        if (contextsToLock != null) {
            for (IContextHandle context : contextsToLock.values()) {
                lock.addShared(context);
            }
        }
        if (configurationsToLock != null) {
            for (ConfigurationDescriptor configuration : configurationsToLock) {
                lock.addShared(configuration.connectionHandle, configuration.componentHandle);
            }
        }
    }

    public void release() {
        this.lock.lock();
        try {
            if (this.locks != null) {
                this.locks.release();
            }
            this.hasLocked = false;
        }
        finally {
            this.lock.unlock();
        }
    }
}

