/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyFileAreaLockUtil {
    public static ISchedulingRule getCopyFileAreaLock(final CopyFileAreaStore copyFileAreaStore, final Collection<? extends ConfigurationDescriptor> configurationsToLock, IProgressMonitor monitor) throws FileSystemClientException {
        final ISchedulingRule[] rule = new ISchedulingRule[1];
        CopyFileAreaStore.IOperation op = new CopyFileAreaStore.IOperation(){

            public void execute(IProgressMonitor monitor) throws FileSystemClientException {
                ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
                HashSet<LoadedConfigurationDescriptor> loadedComponents = new HashSet<LoadedConfigurationDescriptor>(copyFileAreaStore.allLoadedComponents(monitor));
                for (ConfigurationDescriptor configurationDescriptor : loadedComponents) {
                    rules.add(CopyFileAreaStore.getSchedulingRule(configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle));
                }
                for (ConfigurationDescriptor configurationDescriptor : configurationsToLock) {
                    if (loadedComponents.contains(configurationDescriptor)) continue;
                    rules.add(CopyFileAreaStore.getSchedulingRule(configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle));
                }
                rule[0] = copyFileAreaStore.beginBatchingNoWait(MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()])));
            }
        };
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        while (true) {
            progress.setWorkRemaining(100);
            copyFileAreaStore.run(op, (IProgressMonitor)progress.newChild(95));
            if (rule[0] != null) {
                progress.done();
                return rule[0];
            }
            Thread.yield();
        }
    }

    public static ISchedulingRule getCopyFileAreaLock(final CopyFileAreaStore copyFileAreaStore, final IConnection connection, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        final ISchedulingRule[] rule = new ISchedulingRule[1];
        final TeamRepositoryException[] ex = new TeamRepositoryException[1];
        CopyFileAreaStore.IOperation op = new CopyFileAreaStore.IOperation(){

            public void execute(IProgressMonitor monitor) throws FileSystemClientException {
                ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
                HashSet<LoadedConfigurationDescriptor> loadedComponents = new HashSet<LoadedConfigurationDescriptor>(copyFileAreaStore.allLoadedComponents(monitor));
                for (ConfigurationDescriptor configurationDescriptor : loadedComponents) {
                    rules.add(CopyFileAreaStore.getSchedulingRule(configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle));
                }
                if (connection instanceof IWorkspaceConnection) {
                    IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)connection;
                    IWorkspace workspace = iWorkspaceConnection.getResolvedWorkspace();
                    try {
                        for (IComponentHandle component : iWorkspaceConnection.getComponents()) {
                            ConfigurationDescriptor descriptor = new ConfigurationDescriptor((IConnection)iWorkspaceConnection, component);
                            if (loadedComponents.contains(descriptor)) continue;
                            rules.add(CopyFileAreaStore.getSchedulingRule((IContextHandle)workspace, component));
                            loadedComponents.add((LoadedConfigurationDescriptor)descriptor);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        ex[0] = e;
                        return;
                    }
                } else if (connection instanceof IBaselineConnection) {
                    IBaselineConnection iBaselineConnection = (IBaselineConnection)connection;
                    ConfigurationDescriptor descriptor = new ConfigurationDescriptor(iBaselineConnection);
                    if (!loadedComponents.contains(descriptor)) {
                        rules.add(CopyFileAreaStore.getSchedulingRule(descriptor.connectionHandle, descriptor.componentHandle));
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                rule[0] = copyFileAreaStore.beginBatchingNoWait(MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()])));
            }
        };
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        while (true) {
            progress.setWorkRemaining(100);
            copyFileAreaStore.run(op, (IProgressMonitor)progress.newChild(95));
            if (rule[0] != null) {
                progress.done();
                return rule[0];
            }
            if (ex[0] != null) {
                throw ex[0];
            }
            Thread.yield();
        }
    }

    public static ISchedulingRule getWorkspaceComponentLock(CopyFileAreaStore copyFileAreaStore, Collection<ConfigurationDescriptor> configurationsToLock, IProgressMonitor monitor) {
        ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
        for (ConfigurationDescriptor configuration : configurationsToLock) {
            rules.add(CopyFileAreaStore.getSchedulingRule(configuration.connectionHandle, configuration.componentHandle));
        }
        ISchedulingRule rule = MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
        return copyFileAreaStore.beginBatching(rule, monitor);
    }

    public static ISchedulingRule getCopyFileAreaLockForShareables(final CopyFileAreaStore copyFileAreaStore, final Collection<IShareable> shareablesToLock, IProgressMonitor monitor) throws FileSystemClientException {
        final ISchedulingRule[] rule = new ISchedulingRule[1];
        CopyFileAreaStore.IOperation op = new CopyFileAreaStore.IOperation(){

            public void execute(IProgressMonitor monitor) throws FileSystemClientException {
                ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
                for (IShareable shareable : shareablesToLock) {
                    rules.add(CopyFileAreaStore.getSchedulingRule(shareable));
                }
                rule[0] = copyFileAreaStore.beginBatchingNoWait(MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()])));
            }
        };
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        while (true) {
            progress.setWorkRemaining(100);
            copyFileAreaStore.run(op, (IProgressMonitor)progress.newChild(95));
            if (rule[0] != null) {
                progress.done();
                return rule[0];
            }
            Thread.yield();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doFullyLocked(CopyFileAreaStore store, ISchedulingRule workspaceRule, Runnable runnable, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        boolean[] retry = new boolean[]{true};
        while (retry[0]) {
            monitor.setWorkRemaining(6);
            Collection<LoadedConfigurationDescriptor> allLoadedComponents = store.allLoadedComponents((IProgressMonitor)monitor.newChild(1));
            IPath[] initialPaths = store.allSharePaths();
            FlowNodeLock flowLock = new FlowNodeLock();
            for (ConfigurationDescriptor configurationDescriptor : allLoadedComponents) {
                flowLock.toWriteLock(configurationDescriptor);
            }
            flowLock.acquire();
            try {
                try {
                    Job.getJobManager().beginRule(workspaceRule, (IProgressMonitor)monitor.newChild(1));
                    ISchedulingRule iSchedulingRule = CopyFileAreaLockUtil.getCopyFileAreaLock(store, allLoadedComponents, (IProgressMonitor)monitor.newChild(1));
                    try {
                        IPath path;
                        Collection<LoadedConfigurationDescriptor> currentComponents = store.allLoadedComponents((IProgressMonitor)monitor.newChild(1));
                        if (currentComponents.size() != allLoadedComponents.size()) {
                            retry[0] = true;
                            return;
                        }
                        for (ConfigurationDescriptor configurationDescriptor : currentComponents) {
                            if (allLoadedComponents.contains(configurationDescriptor)) continue;
                            retry[0] = true;
                            return;
                        }
                        IPath[] iPathArray = store.allSharePaths();
                        HashSet<IPath> currentPathSet = new HashSet<IPath>();
                        IPath[] iPathArray2 = iPathArray;
                        int n = iPathArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            path = iPathArray2[n2];
                            currentPathSet.add(path);
                            ++n2;
                        }
                        iPathArray2 = initialPaths;
                        n = initialPaths.length;
                        n2 = 0;
                        while (n2 < n) {
                            path = iPathArray2[n2];
                            if (!currentPathSet.remove(path)) {
                                retry[0] = true;
                                return;
                            }
                            ++n2;
                        }
                        if (currentPathSet.size() > 0) {
                            retry[0] = true;
                            return;
                        }
                        retry[0] = false;
                        runnable.run();
                        monitor.done();
                    }
                    finally {
                        store.release(iSchedulingRule, (IProgressMonitor)monitor.newChild(1));
                    }
                }
                finally {
                    Job.getJobManager().endRule(workspaceRule);
                }
            }
            finally {
                flowLock.release();
            }
            if (!retry[0]) continue;
            Thread.yield();
        }
    }
}

