/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ConnectionDescriptor {
    public final String uri;
    public final UUID id;
    public final IContextHandle connectionHandle;
    private ITeamRepository repo;
    private IConnection connection;

    public ConnectionDescriptor(UUID repositoryId, String repositoryUri, IContextHandle connectionHandle) {
        if (repositoryId == null) {
            throw new IllegalArgumentException();
        }
        if (repositoryUri == null) {
            throw new IllegalArgumentException();
        }
        if (!(connectionHandle instanceof IWorkspaceHandle) && !(connectionHandle instanceof IBaselineHandle)) {
            throw new IllegalArgumentException();
        }
        this.uri = repositoryUri;
        this.id = repositoryId;
        this.connectionHandle = connectionHandle;
    }

    public ConnectionDescriptor(IConnection connection) {
        if (!(connection instanceof IWorkspaceConnection) && !(connection instanceof IBaselineConnection)) {
            throw new IllegalArgumentException();
        }
        this.repo = connection.teamRepository();
        this.uri = this.repo.getRepositoryURI();
        this.id = this.repo.getId();
        this.connection = connection;
        this.connectionHandle = connection.getContextHandle();
    }

    public ITeamRepository getTeamRepository() {
        if (this.repo == null) {
            this.repo = RepositoryUtils.getTeamRepository(this.uri, this.id);
        }
        return this.repo;
    }

    public IConnection getConnection(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        if (this.connection == null) {
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getTeamRepository());
            if (this.connectionHandle instanceof IWorkspaceHandle) {
                this.connection = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)this.connectionHandle, (IProgressMonitor)mon);
            } else if (this.connectionHandle instanceof IBaselineHandle) {
                this.connection = workspaceManager.getBaselineConnection((IBaselineHandle)this.connectionHandle, (IProgressMonitor)mon);
            }
        }
        mon.done();
        return this.connection;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.connectionHandle == null ? 0 : this.connectionHandle.getItemId().hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionDescriptor other = (ConnectionDescriptor)obj;
        if (this.connectionHandle == null ? other.connectionHandle != null : !this.connectionHandle.sameItemId((IItemHandle)other.connectionHandle)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals((Object)other.id));
    }
}

