/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public class ConfigurationDescriptor
extends ConnectionDescriptor {
    public final IComponentHandle componentHandle;
    private IConfiguration configuration;

    public ConfigurationDescriptor(UUID repositoryId, String repositoryUri, IContextHandle connectionHandle, IComponentHandle componentHandle) {
        super(repositoryId, repositoryUri, connectionHandle);
        this.componentHandle = componentHandle;
    }

    public ConfigurationDescriptor(IConnection connection, IComponentHandle component) {
        super(connection);
        this.componentHandle = component;
    }

    public ConfigurationDescriptor(IBaselineConnection connection) {
        super((IConnection)connection);
        this.componentHandle = connection.getComponent();
        this.configuration = connection.configuration();
    }

    public IConfiguration getConfiguration(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.configuration == null) {
            IConnection ourConnection = this.getConnection(monitor);
            if (ourConnection instanceof IWorkspaceConnection) {
                this.configuration = ((IWorkspaceConnection)ourConnection).configuration(this.componentHandle);
            } else if (ourConnection instanceof IBaselineConnection) {
                this.configuration = ((IBaselineConnection)ourConnection).configuration();
            }
        }
        return this.configuration;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.componentHandle == null ? 0 : this.componentHandle.getItemId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationDescriptor other = (ConfigurationDescriptor)obj;
        return !(this.componentHandle == null ? other.componentHandle != null : !this.componentHandle.sameItemId((IItemHandle)other.componentHandle));
    }

    public boolean sameConfiguration(ConfigurationDescriptor other) {
        if (this == other) {
            return true;
        }
        if (this.componentHandle == null ? other.componentHandle != null : !this.componentHandle.sameItemId((IItemHandle)other.componentHandle)) {
            return false;
        }
        if (this.connectionHandle == null ? other.connectionHandle != null : !this.connectionHandle.sameItemId((IItemHandle)other.connectionHandle)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals((Object)other.id));
    }
}

