/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.ShareOutOfSync;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifySharesOperation
extends FileSystemOperation
implements IVerifyInSyncOperation {
    private boolean alreadyExecuted;
    protected final OutOfSyncDilemmaHandler verifyInSyncDilemmaHandler;
    protected final IPath copyFileAreaRoot;
    private boolean verifyAgainstCache;
    private HashMap<UUID, IWorkspaceConnection> connectionsToVerify;
    private HashMap<ConfigurationDescriptor, IConnection> configurationsToVerify;
    private ArrayList<IShare> sharesToVerify;
    private ArrayList<IConnection> shareConnections;
    private HashMap<UUID, HashMap<UUID, ISyncTime>> connectionComponentStates;

    public VerifySharesOperation(IPath copyFileAreaRoot, OutOfSyncDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? OutOfSyncDilemmaHandler.getDefault() : dilemmaHandler);
        this.verifyInSyncDilemmaHandler = dilemmaHandler == null ? OutOfSyncDilemmaHandler.getDefault() : dilemmaHandler;
        this.verifyAgainstCache = false;
        this.copyFileAreaRoot = copyFileAreaRoot;
        this.connectionsToVerify = new HashMap();
        this.configurationsToVerify = new HashMap();
        this.sharesToVerify = new ArrayList();
        this.shareConnections = new ArrayList();
        this.connectionComponentStates = new HashMap();
    }

    @Override
    public void setVerifyAgainstCache(boolean verifyAgainstCache) {
        this.verifyAgainstCache = verifyAgainstCache;
    }

    @Override
    public void addToVerify(IWorkspaceConnection workspaceConnection) {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        this.connectionsToVerify.put(workspaceConnection.getContextHandle().getItemId(), workspaceConnection);
    }

    @Override
    public void addToVerify(IConnection connection, IComponentHandle componentHandle) {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (componentHandle == null) {
            throw new IllegalArgumentException();
        }
        this.configurationsToVerify.put(new ConfigurationDescriptor(connection, componentHandle), connection);
    }

    @Override
    public void addToVerify(IConnection connection, Collection<IShare> shares) {
        if (shares == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        for (IShare shareToVerify : shares) {
            if (!shareToVerify.getSharingDescriptor().isAssociatedWithConnection(connection)) {
                throw new IllegalArgumentException();
            }
            this.shareConnections.add(connection);
            this.sharesToVerify.add(shareToVerify);
        }
    }

    @Override
    public void addToVerify(IConnection connection, IShare shareToVerify) {
        if (shareToVerify == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (!shareToVerify.getSharingDescriptor().isAssociatedWithConnection(connection)) {
            throw new IllegalArgumentException();
        }
        this.shareConnections.add(connection);
        this.sharesToVerify.add(shareToVerify);
    }

    public void addToVerifyAgainst(IConnection connection, Collection<IComponentStateSummary> expectedStates) {
        IWorkspace connectionHandle;
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (expectedStates == null) {
            throw new IllegalArgumentException();
        }
        if (connection instanceof IWorkspaceConnection) {
            connectionHandle = ((IWorkspaceConnection)connection).getResolvedWorkspace();
        } else if (connection instanceof IBaselineConnection) {
            connectionHandle = ((IBaselineConnection)connection).getBaseline();
        } else {
            throw new IllegalArgumentException();
        }
        for (IComponentStateSummary summary : expectedStates) {
            if (summary != null) continue;
            throw new IllegalArgumentException();
        }
        HashMap<Object, Object> states = this.connectionComponentStates.get(connectionHandle.getItemId());
        if (states == null) {
            states = new HashMap();
            this.connectionComponentStates.put(connectionHandle.getItemId(), states);
        }
        for (IComponentStateSummary summary : expectedStates) {
            states.put(summary.getComponent().getItemId(), summary.getConfigurationTime());
        }
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (this.alreadyExecuted) {
            throw new IllegalStateException();
        }
        this.alreadyExecuted = true;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.sharesToVerify.isEmpty() && this.configurationsToVerify.isEmpty() && this.connectionsToVerify.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        this.getComponentStatesToVerifyAgainst((IProgressMonitor)progress.newChild(50));
        HashMap<String, IShareOutOfSync> sharesToReload = this.verifyShares((IProgressMonitor)progress.newChild(25));
        HashMap<String, IShareOutOfSync> inconsistentShares = new HashMap<String, IShareOutOfSync>(sharesToReload);
        HashMap<IConnection, HashMap<UUID, IComponentHandle>> configurationsToReload = this.verifyConnections(inconsistentShares, (IProgressMonitor)progress.newChild(25));
        if (!inconsistentShares.isEmpty()) {
            this.handleOutOfSyncShares(sharesToReload, configurationsToReload, inconsistentShares, (IProgressMonitor)progress.newChild(100));
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void getComponentStatesToVerifyAgainst(IProgressMonitor monitor) throws TeamRepositoryException {
        block9: {
            SubMonitor progress;
            block8: {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * (this.sharesToVerify.size() + this.configurationsToVerify.size() + this.connectionsToVerify.size())));
                if (!this.verifyAgainstCache) break block8;
                for (IWorkspaceConnection connection : this.connectionsToVerify.values()) {
                    for (ICurrentComponentInfo componentInfo : connection.getComponentsInfo()) {
                        this.addSyncTime((IContextHandle)connection.getResolvedWorkspace(), componentInfo.getComponent(), componentInfo.configurationTime());
                    }
                }
                for (ConfigurationDescriptor configurationDescriptor : this.configurationsToVerify.keySet()) {
                    IConnection connection = configurationDescriptor.getConnection((IProgressMonitor)progress.newChild(1));
                    if (connection instanceof IBaselineConnection) {
                        this.addSyncTime(connection.getContextHandle(), ((IBaselineConnection)connection).getComponent(), ISyncTime.FACTORY.getConfigTimeFor((IBaselineHandle)((IBaselineConnection)connection).getResolvedBaseline(), null));
                        continue;
                    }
                    ICurrentComponentInfo componentInfo = ((IWorkspaceConnection)connection).getComponentInfo(configurationDescriptor.componentHandle);
                    this.addSyncTime(connection.getContextHandle(), configurationDescriptor.componentHandle, componentInfo.configurationTime());
                }
                Iterator<IConnection> shareConnectionIter = this.shareConnections.iterator();
                for (IShare iShare : this.sharesToVerify) {
                    IConnection connection = shareConnectionIter.next();
                    if (connection instanceof IBaselineConnection) {
                        this.addSyncTime(connection.getContextHandle(), ((IBaselineConnection)connection).getComponent(), ISyncTime.FACTORY.getConfigTimeFor((IBaselineHandle)((IBaselineConnection)connection).getResolvedBaseline(), null));
                        continue;
                    }
                    ISharingDescriptor descriptor = iShare.getSharingDescriptor();
                    ICurrentComponentInfo componentInfo = ((IWorkspaceConnection)connection).getComponentInfo(descriptor.getComponent());
                    this.addSyncTime(connection.getContextHandle(), descriptor.getComponent(), componentInfo.configurationTime());
                }
                break block9;
            }
            if (!this.connectionComponentStates.isEmpty()) break block9;
            HashSet<Object> connections = new HashSet<Object>();
            connections.addAll(this.connectionsToVerify.values());
            connections.addAll(this.configurationsToVerify.values());
            connections.addAll(this.shareConnections);
            for (IConnection iConnection : connections) {
                FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(iConnection.teamRepository())).getFileSystemService();
                List<IComponentStateSummary> stateSummaries = fileSystemService.getComponentStateSummaries(iConnection, (IProgressMonitor)progress.newChild(1));
                for (IComponentStateSummary stateSummary : stateSummaries) {
                    this.addSyncTime(iConnection.getContextHandle(), stateSummary.getComponent(), stateSummary.getConfigurationTime());
                }
            }
        }
    }

    private void addSyncTime(IContextHandle context, IComponentHandle component, ISyncTime syncTime) {
        HashMap<Object, Object> componentInfos = this.connectionComponentStates.get(context.getItemId());
        if (componentInfos == null) {
            componentInfos = new HashMap();
            this.connectionComponentStates.put(context.getItemId(), componentInfos);
        }
        componentInfos.put(component.getItemId(), syncTime);
    }

    private HashMap<String, IShareOutOfSync> verifyShares(IProgressMonitor monitor) {
        HashMap<String, IShareOutOfSync> inconsistentShares = new HashMap<String, IShareOutOfSync>();
        Iterator<IConnection> shareConnectionIter = this.shareConnections.iterator();
        for (IShare share : this.sharesToVerify) {
            IConnection connection = shareConnectionIter.next();
            this.validShare(connection, share, inconsistentShares);
        }
        return inconsistentShares;
    }

    private boolean validShare(IConnection connection, IShare share, HashMap<String, IShareOutOfSync> inconsistentShares) {
        SharingDescriptor descriptor = (SharingDescriptor)share.getSharingDescriptor();
        HashMap<UUID, ISyncTime> componentStates = this.connectionComponentStates.get(descriptor.getConnectionHandle().getItemId());
        ISyncTime expectedState = componentStates.get(descriptor.getComponent().getItemId());
        if (!descriptor.getConfigurationState().equals(expectedState)) {
            String path = share.getPath().toString();
            inconsistentShares.put(path, new ShareOutOfSync(share));
            return false;
        }
        return true;
    }

    private HashMap<IConnection, HashMap<UUID, IComponentHandle>> verifyConnections(HashMap<String, IShareOutOfSync> inconsistentShares, IProgressMonitor monitor) throws FileSystemClientException {
        IShare[] allShares;
        HashMap<IConnection, HashMap<UUID, IComponentHandle>> componentsToReload = new HashMap<IConnection, HashMap<UUID, IComponentHandle>>();
        IShare[] iShareArray = allShares = SharingManager.getInstance().allShares(this.copyFileAreaRoot);
        int n = allShares.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationDescriptor configurationDescriptor;
            IShare share = iShareArray[n2];
            SharingDescriptor descriptor = (SharingDescriptor)share.getSharingDescriptor();
            IConnection connection = (IConnection)this.connectionsToVerify.get(descriptor.getConnectionHandle().getItemId());
            if (connection != null && !this.validShare(connection, share, inconsistentShares)) {
                HashMap<Object, Object> components = componentsToReload.get(connection);
                if (components == null) {
                    components = new HashMap();
                    componentsToReload.put(connection, components);
                }
                components.put(descriptor.getComponent().getItemId(), descriptor.getComponent());
            }
            if (!this.configurationsToVerify.isEmpty() && (connection = this.configurationsToVerify.get(configurationDescriptor = new ConfigurationDescriptor(descriptor.getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent()))) != null && !this.validShare(connection, share, inconsistentShares)) {
                HashMap<Object, Object> components = componentsToReload.get(connection);
                if (components == null) {
                    components = new HashMap();
                    componentsToReload.put(connection, components);
                }
                components.put(descriptor.getComponent().getItemId(), descriptor.getComponent());
            }
            ++n2;
        }
        return componentsToReload;
    }

    private void handleOutOfSyncShares(HashMap<String, IShareOutOfSync> sharesToReload, HashMap<IConnection, HashMap<UUID, IComponentHandle>> configurationsToReload, HashMap<String, IShareOutOfSync> inconsistentShares, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        int result = this.verifyInSyncDilemmaHandler.outOfSync(Collections.unmodifiableCollection(inconsistentShares.values()));
        if (result == 100) {
            this.reloadOutOfSync(sharesToReload, configurationsToReload, inconsistentShares, progress);
        } else if (result != 1) {
            IStatus[] statuses = new IStatus[inconsistentShares.size()];
            int i = 0;
            for (IShareOutOfSync shareOutOfSync : inconsistentShares.values()) {
                statuses[i] = new FileSystemStatus(1, 208, NLS.bind((String)Messages.VerifySharesOperation_0, (Object)shareOutOfSync.getShare().getPath().toString()));
                ++i;
            }
            MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", 4, statuses, Messages.VerifySharesOperation_1, null);
            if (result == 0) {
                LoggingHelper.log((IStatus)status);
            } else {
                this.collectStatus((IStatus)status);
            }
        } else {
            throw new OperationCanceledException();
        }
    }

    protected void reloadOutOfSync(HashMap<String, IShareOutOfSync> sharesToReload, HashMap<IConnection, HashMap<UUID, IComponentHandle>> configurationsToReload, HashMap<String, IShareOutOfSync> inconsistentShares, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        progress.done();
    }
}

