/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolutionReport;
import com.ibm.team.filesystem.common.internal.dto.Resolution;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResolveConflictsOperation
extends FileSystemOperation {
    protected IWorkspaceConnection connection;
    protected HashSet<ILogicalChange> changes;
    private ILogicalConflictReport conflictReport;

    public ResolveConflictsOperation(IWorkspaceConnection connection, ILogicalConflictReport conflictReport, Collection<ILogicalChange> changes, UpdateDilemmaHandler dilemmaHandler) throws FileSystemClientException {
        super(dilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : dilemmaHandler);
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (conflictReport == null) {
            throw new IllegalArgumentException();
        }
        if (changes == null) {
            throw new IllegalArgumentException();
        }
        this.connection = connection;
        this.changes = new HashSet<ILogicalChange>(changes);
        this.conflictReport = conflictReport;
    }

    public Collection<ILogicalChange> getRequiredChanges() {
        HashSet<ILogicalChange> changesSeen = new HashSet<ILogicalChange>();
        HashSet<ILogicalChange> requiredChanges = new HashSet<ILogicalChange>();
        this.getRequiredChanges(this.changes, changesSeen, requiredChanges);
        return requiredChanges;
    }

    public void getRequiredChanges(Collection<ILogicalChange> changesToExamine, HashSet<ILogicalChange> changesSeen, HashSet<ILogicalChange> requiredChanges) {
        for (ILogicalChange change : changesToExamine) {
            if (changesSeen.contains(change)) continue;
            changesSeen.add(change);
            if (change.kind() == 1 && !this.changes.contains(change)) {
                requiredChanges.add(change);
            }
            List moreChangesToExamine = this.conflictReport.getRequiredChanges(change);
            this.getRequiredChanges(moreChangesToExamine, changesSeen, requiredChanges);
        }
    }

    public void addChangesToResolve(Collection<ILogicalChange> moreChanges) {
        this.changes.addAll(moreChanges);
    }

    protected void updateCopyFileArea(ConflictResolutionReport conflictResolutionReport, UpdateDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ArrayList<IUpdateReport> updateReports = new ArrayList<IUpdateReport>(conflictResolutionReport.getResolutions().size());
        for (Resolution resolution : conflictResolutionReport.getResolutions()) {
            updateReports.add(resolution.getUpdateReport());
        }
        this.updateCopyFileArea(updateReports, problemHandler, monitor);
    }

    protected final UpdateDilemmaHandler getIgnoreHandler(UpdateDilemmaHandler underlyingProblemHandler) {
        return new UpdateDilemmaHandler(){

            @Override
            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return 0;
            }

            @Override
            public boolean willIgnoreAllSharesOutOfSync() {
                return true;
            }
        };
    }

    protected abstract void updateCopyFileArea(List<IUpdateReport> var1, UpdateDilemmaHandler var2, IProgressMonitor var3) throws FileSystemClientException, TeamRepositoryException;

    protected abstract VerifySharesOperation getVerifyOperation(OutOfSyncDilemmaHandler var1);
}

