/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ResolveConflictsOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolutionReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MarkAsMergedOperation
extends ResolveConflictsOperation {
    private final MarkAsMergedDilemmaHandler problemHandler;

    public MarkAsMergedOperation(IWorkspaceConnection connection, ILogicalConflictReport conflictReport, Collection<ILogicalChange> changes, MarkAsMergedDilemmaHandler dilemmaHandler) throws FileSystemClientException {
        super(connection, conflictReport, changes, dilemmaHandler == null ? MarkAsMergedDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? MarkAsMergedDilemmaHandler.getDefault() : dilemmaHandler;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (this.changes.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        VerifySharesOperation verifyOp = this.getVerifyOperation(this.problemHandler);
        Collection<ILogicalChange> missingChanges = this.getRequiredChanges();
        if (missingChanges.size() > 0) {
            switch (this.problemHandler.missingRequiredChanges(missingChanges)) {
                case 2: {
                    throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.MarkAsMergedOperation_0, (Object)missingChanges.size())));
                }
                case 1: {
                    throw new OperationCanceledException();
                }
                case 0: {
                    this.changes.addAll(missingChanges);
                }
            }
        }
        HashSet<ConfigurationDescriptor> configurationsToLock = new HashSet<ConfigurationDescriptor>();
        for (ILogicalChange change : this.changes) {
            verifyOp.addToVerify((IConnection)this.connection, change.component());
            configurationsToLock.add(new ConfigurationDescriptor((IConnection)this.connection, change.component()));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(configurationsToLock);
        try {
            List updateReports;
            if (this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
                verifyOp.run((IProgressMonitor)progress.newChild(5));
            }
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            Map<ConfigurationDescriptor, Map<UUID, ILogicalChange>> organizedChanges = this.organizeChanges();
            MarkAsMergedDilemmaHandler ignoreSyncs = this.getIgnoreVerifyHandler(this.problemHandler);
            this.checkinPendingChanges(organizedChanges, ignoreSyncs, (IProgressMonitor)progress.newChild(25));
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.verifyChangesMerged(organizedChanges, ignoreSyncs, (IProgressMonitor)progress.newChild(25));
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.confirmMarkAsMerged(ignoreSyncs);
            FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(this.connection.teamRepository())).getFileSystemService();
            try {
                updateReports = fileSystemService.markAsMerged(this.connection, this.changes, (IProgressMonitor)progress.newChild(45));
            }
            catch (TeamRepositoryException e) {
                if (e.getData() instanceof ConflictResolutionReport) {
                    this.collectStatus(new FileSystemStatus(4, e.getMessage()));
                    if (e.getCause() != null) {
                        this.collectStatus(new FileSystemStatus(4, e.getCause().getMessage()));
                    }
                    this.updateCopyFileArea((ConflictResolutionReport)e.getData(), (UpdateDilemmaHandler)ignoreSyncs, (IProgressMonitor)progress.newChild(50));
                }
                throw e;
            }
            if (!updateReports.isEmpty()) {
                this.updateCopyFileArea(updateReports, (UpdateDilemmaHandler)ignoreSyncs, (IProgressMonitor)progress.newChild(50));
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void confirmMarkAsMerged(MarkAsMergedDilemmaHandler ignoreSyncs) throws FileSystemClientException {
        int result = ignoreSyncs.confirmMarkAsMerged(this.changes);
        if (result == 1) {
            throw new OperationCanceledException();
        }
    }

    private Map<ConfigurationDescriptor, Map<UUID, ILogicalChange>> organizeChanges() {
        HashMap<ConfigurationDescriptor, Map<UUID, ILogicalChange>> result = new HashMap<ConfigurationDescriptor, Map<UUID, ILogicalChange>>();
        for (ILogicalChange change : this.changes) {
            ConfigurationDescriptor descriptor = new ConfigurationDescriptor((IConnection)this.connection, change.component());
            HashMap<UUID, ILogicalChange> logicalChangesByVersionable = (HashMap<UUID, ILogicalChange>)result.get(descriptor);
            if (logicalChangesByVersionable == null) {
                logicalChangesByVersionable = new HashMap<UUID, ILogicalChange>();
                result.put(descriptor, logicalChangesByVersionable);
            }
            logicalChangesByVersionable.put(change.item().getItemId(), change);
        }
        return result;
    }

    private MarkAsMergedDilemmaHandler getIgnoreVerifyHandler(final MarkAsMergedDilemmaHandler underlyingProblemHandler) {
        return new MarkAsMergedDilemmaHandler(){

            @Override
            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return 0;
            }

            @Override
            public boolean willIgnoreAllSharesOutOfSync() {
                return true;
            }

            @Override
            public int uncheckedInChanges(Collection<ILocalChange> changes) {
                return underlyingProblemHandler.uncheckedInChanges(changes);
            }

            @Override
            public int unmergedChanges(Collection<ILogicalChange> changes) {
                return underlyingProblemHandler.unmergedChanges(changes);
            }

            @Override
            public int confirmMarkAsMerged(Collection<ILogicalChange> changes) {
                return underlyingProblemHandler.confirmMarkAsMerged(changes);
            }
        };
    }

    protected abstract void verifyChangesMerged(Map<ConfigurationDescriptor, Map<UUID, ILogicalChange>> var1, MarkAsMergedDilemmaHandler var2, IProgressMonitor var3) throws TeamRepositoryException, FileSystemClientException;

    protected abstract void checkinPendingChanges(Map<ConfigurationDescriptor, Map<UUID, ILogicalChange>> var1, MarkAsMergedDilemmaHandler var2, IProgressMonitor var3) throws TeamRepositoryException, FileSystemClientException;
}

