/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemLoadOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileSystemVerifySharesOperation
extends VerifySharesOperation {
    public LocalFileSystemVerifySharesOperation(IPath copyFileAreaRoot, OutOfSyncDilemmaHandler problemHandler) {
        super(copyFileAreaRoot, problemHandler);
    }

    @Override
    protected void reloadOutOfSync(HashMap<String, IShareOutOfSync> sharesToReload, HashMap<IConnection, HashMap<UUID, IComponentHandle>> configurationsToReload, HashMap<String, IShareOutOfSync> inconsistentShares, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (!inconsistentShares.isEmpty()) {
            ArrayList<IShare> shares = new ArrayList<IShare>(inconsistentShares.size());
            for (IShareOutOfSync outOfSync : inconsistentShares.values()) {
                shares.add(outOfSync.getShare());
            }
            LocalFileSystemLoadOperation op = new LocalFileSystemLoadOperation(this.copyFileAreaRoot, 2, this.verifyInSyncDilemmaHandler);
            op.requestReLoad(shares, (IProgressMonitor)monitor.newChild(10));
            op.run((IProgressMonitor)monitor.newChild(90));
        }
    }
}

