/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemUpdateMutator;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileSystemUpdateOperation
extends UpdateOperation {
    private final IPath fileSystemRoot;

    public LocalFileSystemUpdateOperation(IWorkspaceConnection connection, List<IUpdateReport> updateReports, IPath fileSystemRoot, int updatesToProcess, UpdateDilemmaHandler problemHandler) {
        this(connection, updateReports, Collections.EMPTY_LIST, fileSystemRoot, updatesToProcess, problemHandler);
    }

    public LocalFileSystemUpdateOperation(IWorkspaceConnection connection, List<IUpdateReport> updateReports, List<IComponentHandle> excludedComponents, IPath fileSystemRoot, int updatesToProcess, UpdateDilemmaHandler problemHandler) {
        super(connection, updateReports, excludedComponents, updatesToProcess, problemHandler);
        this.fileSystemRoot = fileSystemRoot;
    }

    @Override
    protected void loadFileArea(IWorkspaceConnection connection, Collection beforeComponentStates, Collection afterComponentStates, FileAreaUpdateReport updates, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        LocalFileSystemUpdateMutator mutator = new LocalFileSystemUpdateMutator((IConnection)connection, beforeComponentStates, (Collection<IComponentStateSummary>)afterComponentStates, updates, this.fileSystemRoot, this.getDilemmaHandler());
        mutator.run(progress);
    }

    @Override
    protected CopyFileAreaStore getCopyFileArea() {
        return CopyFileAreaStore.getCopyFileArea(this.fileSystemRoot);
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireRead(this.getAffectedConfigurations());
        try {
            super.execute(monitor);
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }
}

