/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemUpdateOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingInputStream;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToCRInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToCRLFInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToLFInputStream;
import com.ibm.team.repository.common.utils.VerifyLineDelimiterInputStream;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.Checksum;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileSystemCommitOperation
extends FileSystemOperation {
    private final IWorkspaceConnection workspace;
    private final ITeamRepository repository;
    private IComponentHandle component;
    private final String encoding;
    private Map<UUID, Long> uploadContentSize = new HashMap<UUID, Long>();
    private Map<UUID, Checksum> uploadHashCode = new HashMap<UUID, Checksum>();
    private Map<UUID, Boolean> uploadIsExecutable = new HashMap<UUID, Boolean>();
    private Map<UUID, Content> uploadContent = new HashMap<UUID, Content>();
    private Comparator topologicalOrder = new Comparator(){

        public int compare(Object o1, Object o2) {
            IPath path2;
            IPath path1;
            if (o1 instanceof IFileStorage) {
                path1 = ((IFileStorage)o1).getFullPath();
                path2 = ((IFileStorage)o2).getFullPath();
            } else if (o1 instanceof Shareable) {
                path1 = ((Shareable)o1).getLocalFullPath();
                path2 = ((Shareable)o2).getLocalFullPath();
            } else {
                throw new IllegalArgumentException();
            }
            return path1.segmentCount() - path2.segmentCount();
        }
    };
    private IChangeSetHandle changeSet;
    protected IShareable[] toCommit;
    private final CommitDilemmaHandler commitProblemHandler;
    private final IPath root;
    private final Collection toDelete;

    public LocalFileSystemCommitOperation(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IPath copyFileRoot, CommitDilemmaHandler commitProblemHandler) throws FileSystemClientException, TeamRepositoryException {
        this(workspace, changeSet, copyFileRoot, null, commitProblemHandler);
    }

    public LocalFileSystemCommitOperation(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IPath copyFileRoot, IShareable[] toCommit, CommitDilemmaHandler commitProblemHandler) throws FileSystemClientException, TeamRepositoryException {
        super(commitProblemHandler == null ? CommitDilemmaHandler.getDefault() : commitProblemHandler);
        CommitDilemmaHandler commitDilemmaHandler = this.commitProblemHandler = commitProblemHandler == null ? CommitDilemmaHandler.getDefault() : commitProblemHandler;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        this.workspace = workspace;
        this.changeSet = changeSet;
        this.repository = workspace.teamRepository();
        this.toCommit = toCommit;
        if (copyFileRoot == null) {
            throw new IllegalArgumentException();
        }
        if (!SharingManager.getInstance().isConnectionShared(copyFileRoot, (IContextHandle)workspace.getResolvedWorkspace())) {
            throw new IllegalStateException();
        }
        this.root = copyFileRoot;
        this.toDelete = new ArrayList();
        String defaultEncoding = System.getProperty("file.encoding");
        this.encoding = defaultEncoding == null ? "us-ascii" : defaultEncoding;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)8);
        ArrayList<Shareable> newShareables = new ArrayList<Shareable>();
        ArrayList<IFileStorage> modifiedResources = new ArrayList<IFileStorage>();
        ArrayList deletedResources = new ArrayList();
        ArrayList<IShare> shares = new ArrayList<IShare>();
        HashMap versionablesToSave = new HashMap();
        this.collectChangedResources(newShareables, modifiedResources, deletedResources, shares, (IProgressMonitor)progress.newChild(1));
        if (shares.size() > 0) {
            VerifySharesOperation verifyOp = new VerifySharesOperation(this.root, this.commitProblemHandler);
            verifyOp.addToVerify((IConnection)this.workspace, shares);
            verifyOp.run((IProgressMonitor)progress.newChild(1));
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Collections.sort(newShareables, this.topologicalOrder);
        Collections.sort(modifiedResources, this.topologicalOrder);
        Collections.sort(deletedResources, this.topologicalOrder);
        IChangeSet cs = (IChangeSet)this.repository.itemManager().fetchCompleteItem((IItemHandle)this.changeSet, 1, (IProgressMonitor)progress.newChild(1));
        this.component = cs.getComponent();
        ArrayList<IWorkspaceConnection.IConfigurationOp> ops = new ArrayList<IWorkspaceConnection.IConfigurationOp>();
        this.applyDeletions(deletedResources, ops, (IProgressMonitor)progress.newChild(1));
        this.createNewVersionables(newShareables, versionablesToSave, (IProgressMonitor)progress.newChild(1));
        this.uploadContents(modifiedResources, versionablesToSave, (IProgressMonitor)progress.newChild(1));
        monitor.subTask(Messages.LocalFileSystemCommitOperation_1);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IUpdateReport updateReport = this.commit(ops, versionablesToSave, (IProgressMonitor)progress.newChild(1));
        monitor.subTask(Messages.LocalFileSystemCommitOperation_2);
        this.updateMetaData(versionablesToSave, this.toDelete, updateReport, (IProgressMonitor)progress.newChild(1));
    }

    private void applyDeletions(List deletedRoots, ArrayList<IWorkspaceConnection.IConfigurationOp> ops, IProgressMonitor reporter) throws TeamRepositoryException, FileSystemClientException {
        if (reporter.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (deletedRoots.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)deletedRoots.size());
        ListIterator i = deletedRoots.listIterator(deletedRoots.size());
        while (i.hasPrevious()) {
            IFileStorage storage = (IFileStorage)i.previous();
            IVersionableHandle item = storage.getRemote();
            if (item instanceof IFolderHandle) {
                ops.add((IWorkspaceConnection.IConfigurationOp)this.workspace.configurationOpFactory().deleteSubtree((IFolderHandle)storage.getRemote()));
            } else {
                ops.add((IWorkspaceConnection.IConfigurationOp)this.workspace.configurationOpFactory().delete(item));
            }
            progress.worked(1);
        }
    }

    private IUpdateReport commit(ArrayList<IWorkspaceConnection.IConfigurationOp> ops, Map versionablesToSave, IProgressMonitor reporter) throws TeamRepositoryException {
        IWorkspaceConnection.IConfigurationOpFactory opFactory = this.workspace.configurationOpFactory();
        for (ItemResourcePair element : versionablesToSave.values()) {
            ops.add((IWorkspaceConnection.IConfigurationOp)opFactory.save(element.item));
        }
        if (!ops.isEmpty()) {
            return this.workspace.commit(this.changeSet, ops, reporter);
        }
        return null;
    }

    private void createNewVersionables(List<Shareable> newShareables, Map versionablesToSave, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        SubMonitor mkdirsProgress = SubMonitor.convert((IProgressMonitor)progress, (int)(newShareables.size() * 4));
        HashMap<IPath, Object> pathMap = new HashMap<IPath, Object>();
        IConfiguration configuration = this.workspace.configuration(this.component);
        IFolderHandle configRootFolder = configuration.rootFolderHandle(null);
        for (Shareable shareable : newShareables) {
            IFileStorage resource = shareable.getFileStorage();
            IFileItem versionable = null;
            if (!resource.isFolder()) {
                versionable = this.upload(this.repository.contentManager(), shareable, (IProgressMonitor)mkdirsProgress.newChild(2));
                this.mkdirs(versionablesToSave, (IVersionable)versionable, resource, pathMap, configRootFolder);
                continue;
            }
            IVersionableHandle resolvedPathHandle = null;
            resolvedPathHandle = configuration.resolvePath(configRootFolder, resource.getFullPath().segments(), (IProgressMonitor)mkdirsProgress.newChild(1));
            if (resolvedPathHandle != null) {
                if (resolvedPathHandle instanceof IFolderHandle) {
                    pathMap.put(resource.getFullPath(), resolvedPathHandle);
                    continue;
                }
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 466, NLS.bind((String)Messages.LocalFileSystemCommitOperation_3, (Object)resource.getFullPath()), null));
            }
            versionable = (IFolder)IFolder.ITEM_TYPE.createItem();
            pathMap.put(resource.getFullPath(), versionable);
            this.mkdirs(versionablesToSave, (IVersionable)versionable, resource, pathMap, configRootFolder);
            mkdirsProgress.worked(1);
        }
    }

    private void mkdirs(Map versionables, IVersionable versionable, IFileStorage resource, Map pathMap, IFolderHandle configRootFolder) throws TeamRepositoryException {
        IFolderHandle parentFolder = this.determineParentFolder(resource, versionable, pathMap);
        if (parentFolder == null) {
            parentFolder = configRootFolder;
        }
        versionable.setName(resource.getName());
        versionable.setParent(parentFolder);
        versionables.put(versionable.getItemId(), new ItemResourcePair(resource, versionable));
    }

    private IFolderHandle determineParentFolder(IFileStorage resource, IVersionable versionable, Map pathMap) throws TeamRepositoryException {
        IFileStorage parent = resource.getParent();
        if (parent != null) {
            IFolderHandle parentFolder = (IFolderHandle)pathMap.get(parent.getFullPath());
            if (parentFolder == null) {
                parentFolder = (IFolderHandle)parent.getRemote();
            }
            return parentFolder;
        }
        Assert.isTrue((boolean)false, (String)Messages.LocalFileSystemCommitOperation_4);
        return null;
    }

    private void uploadContents(List<Shareable> modifiedShareables, Map versionablesToSave, IProgressMonitor reporter) throws FileSystemClientException, TeamRepositoryException {
        if (reporter.isCanceled()) {
            throw new OperationCanceledException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)(modifiedShareables.size() * 2));
        IContentManager contentManager = this.repository.contentManager();
        for (Shareable shareable : modifiedShareables) {
            IFileItem fileVersionable = this.upload(contentManager, shareable, (IProgressMonitor)progress.newChild(1));
            versionablesToSave.put(fileVersionable.getItemId(), new ItemResourcePair(shareable.getFileStorage(), (IVersionable)fileVersionable));
        }
    }

    private IFileItem upload(IContentManager contentManager, Shareable shareable, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        IContent content;
        HashComputingInputStream contents;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IFileStorage file = shareable.getFileStorage();
        IFileItemHandle fileVersionableHandle = (IFileItemHandle)file.getRemote();
        IFileItem fileVersionable = null;
        if (fileVersionableHandle == null) {
            fileVersionable = (IFileItem)IFileItem.ITEM_TYPE.createItem();
        } else {
            fileVersionable = (IFileItem)this.workspace.configuration(this.component).fetchCompleteItem((IVersionableHandle)fileVersionableHandle, null);
            fileVersionable = (IFileItem)fileVersionable.getWorkingCopy();
        }
        UUID predecessor = fileVersionable.getContent() == null ? null : fileVersionable.getContent().getContentId();
        LineDelimiter lineDelimiter = shareable.getLineDelimiter();
        String contentType = shareable.getContentType();
        if (contentType == null && (contentType = URLConnection.guessContentTypeFromName(shareable.getLocalFullPath().lastSegment())) == null) {
            contentType = "application/unknown";
        }
        boolean inferredLineDelimiter = false;
        if (lineDelimiter == null) {
            inferredLineDelimiter = true;
            lineDelimiter = contentType.startsWith("text") ? LineDelimiter.LINE_DELIMITER_PLATFORM : LineDelimiter.LINE_DELIMITER_NONE;
        }
        HashComputingInputStream contentsToStore = contents = new HashComputingInputStream((InputStream)new BufferedInputStream(file.getContents()));
        VerifyLineDelimiterInputStream delimiterVerifier = null;
        LineDelimiter expectedLineDelimiter = lineDelimiter;
        if (lineDelimiter != LineDelimiter.LINE_DELIMITER_NONE) {
            try {
                delimiterVerifier = new VerifyLineDelimiterInputStream((InputStream)contents, this.encoding);
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.LocalFileSystemCommitOperation_6, (Throwable)e));
            }
            contentsToStore = new ReaderToInputStream((InputStreamReader)delimiterVerifier);
            if (lineDelimiter == LineDelimiter.LINE_DELIMITER_PLATFORM) {
                expectedLineDelimiter = LineDelimiter.getPlatformDelimiter();
            }
        }
        try {
            content = contentManager.storeContent(contentType, this.encoding, lineDelimiter, (InputStream)contentsToStore, predecessor, (IProgressMonitor)monitor.newChild(99));
        }
        catch (TeamRepositoryException e) {
            Throwable cause = e.getCause();
            if (inferredLineDelimiter && cause instanceof ContentLineDelimiterError) {
                delimiterVerifier = null;
                expectedLineDelimiter = LineDelimiter.LINE_DELIMITER_NONE;
                contents = new HashComputingInputStream((InputStream)new BufferedInputStream(file.getContents()));
                monitor.setWorkRemaining(100);
                content = contentManager.storeContent(contentType, this.encoding, LineDelimiter.LINE_DELIMITER_NONE, (InputStream)contents, predecessor, (IProgressMonitor)monitor.newChild(99));
            }
            throw e;
        }
        if (delimiterVerifier != null && delimiterVerifier.getLineDelimiter() != expectedLineDelimiter && delimiterVerifier.getLineDelimiter() != LineDelimiter.LINE_DELIMITER_NONE) {
            block17: {
                try {
                    if (expectedLineDelimiter == LineDelimiter.LINE_DELIMITER_LF) {
                        delimiterVerifier = new VerifyConvertToLFInputStream(file.getContents(), this.encoding);
                        break block17;
                    }
                    if (expectedLineDelimiter == LineDelimiter.LINE_DELIMITER_CRLF) {
                        delimiterVerifier = new VerifyConvertToCRLFInputStream(file.getContents(), this.encoding);
                        break block17;
                    }
                    if (expectedLineDelimiter == LineDelimiter.LINE_DELIMITER_CR) {
                        delimiterVerifier = new VerifyConvertToCRInputStream(file.getContents(), this.encoding);
                        break block17;
                    }
                    throw new IllegalStateException();
                }
                catch (IOException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.LocalFileSystemCommitOperation_7, (Throwable)e));
                }
            }
            contents = new HashComputingInputStream((InputStream)new ReaderToInputStream((InputStreamReader)delimiterVerifier));
            this.transferContents(file, contents, content.getEstimatedConvertedLength(), (IProgressMonitor)monitor.newChild(1));
        }
        fileVersionable.setContent(content);
        boolean isExecutable = file.isExecutable();
        fileVersionable.setExecutable(isExecutable);
        fileVersionable.setFileTimestamp(new Date(file.getLocalTimeStamp()));
        UUID itemId = fileVersionable.getItemId();
        this.uploadIsExecutable.put(itemId, isExecutable);
        this.uploadContentSize.put(itemId, new Long(contents.getContentSize()));
        this.uploadHashCode.put(itemId, contents.getChecksum());
        this.uploadContent.put(itemId, (Content)content);
        return fileVersionable;
    }

    private void transferContents(IFileStorage file, HashComputingInputStream contents, long convertedLength, IProgressMonitor monitor) throws FileSystemClientException {
        byte[] buffer = new byte[4096];
        InputStream inputStream = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                TemporaryOutputStream outputStream = TemporaryOutputStream.getTemporaryOutputStream((long)convertedLength);
                try {
                    int numbytes = contents.read(buffer);
                    while (numbytes != -1) {
                        outputStream.write(buffer, 0, numbytes);
                        numbytes = contents.read(buffer);
                    }
                    outputStream.close();
                    inputStream = outputStream.getInputStream((IProgressMonitor)progress.newChild(50));
                    file.setContents(inputStream, (IProgressMonitor)progress.newChild(50));
                }
                finally {
                    outputStream.dispose();
                    monitor.done();
                }
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.LocalFileSystemCommitOperation_8, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                contents.close();
            }
            catch (IOException iOException) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            contents.close();
        }
        catch (IOException iOException) {}
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    protected IWorkspaceConnection getWorkspace() {
        return this.workspace;
    }

    protected void updateMetaData(Map versionables, Collection shareablesToForget, IUpdateReport updateReport, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (updateReport != null) {
            SubMonitor subProgress = progress.newChild(75);
            subProgress.setWorkRemaining(10 + updateReport.updates().size());
            CopyFileAreaStore cfa = CopyFileAreaStore.getCopyFileArea(this.root);
            HashMap<UUID, IItemUpdateReport> reports = new HashMap<UUID, IItemUpdateReport>(updateReport.updates().size() * 4 / 3);
            for (IItemUpdateReport r : updateReport.updates()) {
                reports.put(r.item().getItemId(), r);
            }
            while (!reports.isEmpty()) {
                int reportsSize = reports.size();
                Iterator it = reports.values().iterator();
                while (it.hasNext()) {
                    Long length;
                    IFolderHandle parent;
                    String name;
                    IItemUpdateReport change = (IItemUpdateReport)it.next();
                    IVersionableHandle newState = change.getNewCurrentState();
                    UUID itemId = newState.getItemId();
                    if (!(newState instanceof IFolderHandle) && !(newState instanceof IFileItemHandle)) {
                        it.remove();
                        continue;
                    }
                    ItemResourcePair pair = (ItemResourcePair)versionables.get(itemId);
                    IFileStorage fileStorage = pair.resource;
                    Shareable shareable = fileStorage.getShareable();
                    if (newState instanceof IFolderHandle && fileStorage.getShareable().getShare().getSharingDescriptor().getRootFolder().sameItemId((IItemHandle)newState)) {
                        name = null;
                        parent = null;
                    } else {
                        if (fileStorage.getParent().getShareable().getRemote() == null) continue;
                        name = pair.item.getName();
                        parent = pair.item.getParent();
                    }
                    it.remove();
                    long contentLength = -1L;
                    HashCode hash = null;
                    LineDelimiter originalLineDelimiter = null;
                    LineDelimiter lineDelimiter = null;
                    String originalContentType = null;
                    String contentType = null;
                    UUID contentId = null;
                    UUID deltaPredecessor = null;
                    long storedSize = -1L;
                    String encoding = null;
                    long storedChecksum = -1L;
                    long storedNumLineDelimiters = -1L;
                    boolean isExecutable = false;
                    if (newState instanceof IFileItemHandle && (length = this.uploadContentSize.get(itemId)) != null) {
                        contentLength = length;
                        hash = new HashCode(this.uploadHashCode.get(itemId));
                        Content contentUploaded = this.uploadContent.get(itemId);
                        originalLineDelimiter = contentUploaded.getLineDelimiter();
                        lineDelimiter = shareable.getLineDelimiter();
                        if (lineDelimiter == null) {
                            lineDelimiter = contentUploaded.getLineDelimiter();
                        }
                        originalContentType = contentUploaded.getContentType();
                        contentType = shareable.getContentType();
                        if (contentType == null) {
                            contentType = contentUploaded.getContentType();
                        }
                        contentId = contentUploaded.getContentId();
                        deltaPredecessor = contentUploaded.getDeltaPredecessor();
                        storedSize = contentUploaded.getContentLength();
                        encoding = contentUploaded.getCharacterEncoding();
                        storedChecksum = contentUploaded.getChecksum();
                        storedNumLineDelimiters = contentUploaded.getLineDelimiterCount();
                        isExecutable = this.uploadIsExecutable.get(itemId);
                    }
                    FileItemInfo newInfo = new FileItemInfo(newState, fileStorage.getModificationStamp(), parent, name, hash, contentLength, originalLineDelimiter, lineDelimiter, originalContentType, contentType, contentId, deltaPredecessor, storedSize, encoding, storedChecksum, storedNumLineDelimiters, isExecutable, isExecutable);
                    try {
                        cfa.setItemInfo(shareable, newInfo, (IProgressMonitor)subProgress.newChild(1));
                    }
                    catch (FileSystemClientException e) {
                        LoggingHelper.log(e);
                    }
                }
                if (reports.size() != reportsSize) continue;
                throw new IllegalStateException(NLS.bind((String)Messages.LocalFileSystemCommitOperation_9, (Object)reports.values().toString()));
            }
            if (!updateReport.incidentalResolutionUpdates().isEmpty()) {
                DilemmaHandler problemHandler = this.getDilemmaHandler();
                final CommitDilemmaHandler underlyingProblemHandler = !(problemHandler instanceof CommitDilemmaHandler) ? CommitDilemmaHandler.getDefault() : (CommitDilemmaHandler)problemHandler;
                CommitDilemmaHandler ignoreSyncs = new CommitDilemmaHandler(){

                    @Override
                    public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                        return underlyingProblemHandler.collision(collisions, removedShares, sharesOutOfSync);
                    }

                    @Override
                    public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                        return 0;
                    }

                    @Override
                    public boolean willIgnoreAllSharesOutOfSync() {
                        return true;
                    }
                };
                LocalFileSystemUpdateOperation op = new LocalFileSystemUpdateOperation(this.workspace, Collections.singletonList(updateReport), this.root, 2, (UpdateDilemmaHandler)ignoreSyncs);
                op.run((IProgressMonitor)subProgress.newChild(10));
            }
            HashMap<UUID, ISyncTime> beforeStates = new HashMap<UUID, ISyncTime>();
            for (IComponentStateSummary summary : updateReport.getComponentStatesBefore()) {
                beforeStates.put(summary.getComponent().getItemId(), summary.getConfigurationTime());
            }
            for (IComponentStateSummary summary : updateReport.getComponentStatesAfter()) {
                ISyncTime beforeState = (ISyncTime)beforeStates.get(summary.getComponent().getItemId());
                cfa.setConfigurationState((IContextHandle)this.workspace.getResolvedWorkspace(), summary.getComponent(), beforeState, summary.getConfigurationTime(), null);
            }
        }
        progress.setWorkRemaining(shareablesToForget.size());
        for (Shareable shareable : shareablesToForget) {
            try {
                shareable.forget((IProgressMonitor)progress.newChild(1));
            }
            catch (FileSystemClientException e) {
                LoggingHelper.log(e);
            }
        }
        progress.done();
    }

    protected void collectChangedResources(final List<Shareable> newShareables, final List<IFileStorage> modifiedResources, final List deletedResources, List<IShare> shares, IProgressMonitor reporter) throws TeamRepositoryException, FileSystemClientException {
        IShareable[] toVisit;
        final HashMap sharesAffected = new HashMap();
        IShareableVisitor visitor = new IShareableVisitor(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean visit(IShareable shareable, IProgressMonitor monitor) {
                if (!(shareable instanceof ShareableFile)) {
                    return false;
                }
                int state = shareable.getState();
                IFileStorage file = ((Shareable)shareable).getFileStorage();
                Assert.isTrue((boolean)(file instanceof LocalFileStorage));
                if (!((LocalFileStorage)file).getFile().exists()) {
                    deletedResources.add(file);
                    LocalFileSystemCommitOperation.this.toDelete.add(shareable);
                    this.recordShareAffected(shareable);
                    return true;
                }
                if ((state & 2) == 0) {
                    if (shareable.shouldBeIgnored()) return false;
                    newShareables.add((Shareable)shareable);
                    this.recordShareAffected(shareable);
                    return true;
                } else {
                    if ((state & 4) == 0) return true;
                    modifiedResources.add(file);
                    this.recordShareAffected(shareable);
                }
                return true;
            }

            private void recordShareAffected(IShareable shareable) {
                IShare share = shareable.getShare();
                if (share != null) {
                    sharesAffected.put(share.getPath().toString(), share);
                }
            }
        };
        if (this.toCommit == null) {
            IShare[] allShares = SharingManager.getInstance().allShares(this.root);
            ArrayList<ShareableFile> sameWorkspace = new ArrayList<ShareableFile>(allShares.length);
            int i = 0;
            while (i < allShares.length) {
                if (allShares[i].getSharingDescriptor().isAssociatedWithConnection((IConnection)this.getWorkspace())) {
                    File rootFile = this.root.append(allShares[i].getPath()).toFile();
                    sameWorkspace.add(new ShareableFile(this.root, rootFile));
                }
                ++i;
            }
            toVisit = sameWorkspace.toArray(new IShareable[sameWorkspace.size()]);
        } else {
            toVisit = this.toCommit;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)toVisit.length);
        int i = 0;
        while (i < toVisit.length) {
            toVisit[i].accept(visitor, Integer.MAX_VALUE, true, false, (IProgressMonitor)progress.newChild(1));
            ++i;
        }
        shares.addAll(sharesAffected.values());
    }

    protected static class ItemResourcePair {
        public IFileStorage resource;
        public IVersionable item;

        ItemResourcePair(IFileStorage resource, IVersionable item) {
            this.resource = resource;
            this.item = item;
        }
    }
}

