/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeHistoryChangeSetsOperation
extends FileSystemOperation {
    protected ChangeHistoryChangeSetsOperation(ChangeHistoryChangeSetsDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    protected void checkinPendingChanges(Collection<ConfigurationDescriptor> affectedConfigurations, ChangeHistoryChangeSetsDilemmaHandler problemHandler, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        HashMap<ConfigurationDescriptor, List<ILocalChange>> checkin = new HashMap<ConfigurationDescriptor, List<ILocalChange>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        for (ConfigurationDescriptor descriptor : affectedConfigurations) {
            ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
            CopyFileAreaStore cfa = CopyFileAreaStore.getDefaultCopyFileArea();
            ISchedulingRule cfaLock = cfa.lock(descriptor.componentHandle, descriptor.connectionHandle, (IProgressMonitor)monitor.newChild(1));
            try {
                lcm.syncPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, FileSystemCore.getSharingManager().getDefaultCFARoot());
            }
            finally {
                cfa.release(cfaLock, (IProgressMonitor)monitor.newChild(1));
            }
            ILocalChange[] localChanges = lcm.getPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, FileSystemCore.getSharingManager().getDefaultCFARoot());
            if (localChanges.length <= 0) continue;
            List<ILocalChange> changes = Arrays.asList(localChanges);
            changes = Collections.unmodifiableList(changes);
            checkin.put(descriptor, changes);
        }
        if (!checkin.isEmpty()) {
            int result = problemHandler.uncheckedInChanges(Collections.unmodifiableMap(checkin));
            if (result == 0) {
                monitor.setWorkRemaining(checkin.size());
                for (Map.Entry entry : checkin.entrySet()) {
                    Collection changesToCheckin = (Collection)entry.getValue();
                    ILocalChange[] changes = changesToCheckin.toArray(new ILocalChange[changesToCheckin.size()]);
                    if (changesToCheckin.isEmpty()) continue;
                    ConfigurationDescriptor descriptor = (ConfigurationDescriptor)entry.getKey();
                    IFileSystemOperation op = this.getCheckInOperation((IWorkspaceConnection)descriptor.getConnection((IProgressMonitor)monitor.newChild(1)), descriptor.componentHandle, changes, "", problemHandler.getCommitDilemmaHandler());
                    this.disableVerifyInSync(op);
                    op.run((IProgressMonitor)monitor.newChild(1));
                }
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                if (result != 3) {
                    throw new FileSystemClientException(new FileSystemStatus(4, Messages.ChangeHistoryChangeSetsOperation_0));
                }
            }
        }
        monitor.done();
    }

    public abstract IFileSystemOperation getCheckInOperation(IWorkspaceConnection var1, IComponentHandle var2, ILocalChange[] var3, String var4, CommitDilemmaHandler var5);
}

