/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.OperationRequest;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.AcceptDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAcceptOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AcceptOperation
extends FileSystemOperation
implements IAcceptOperation {
    private boolean preflight;
    ArrayList<OperationRequest> acceptRequests;
    private final AcceptDilemmaHandler problemHandler;

    public AcceptOperation(AcceptDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? AcceptDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? AcceptDilemmaHandler.getDefault() : dilemmaHandler;
        this.acceptRequests = new ArrayList();
        this.preflight = false;
    }

    public void setPreflight(boolean preflight) {
        this.preflight = preflight;
    }

    public boolean isPreflightOnly() {
        return this.preflight;
    }

    @Override
    public void acceptChangeSets(IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSets) {
        this.acceptRequests.add(new OperationRequest(workspaceConnection, changeSets));
    }

    @Override
    public void acceptCombined(IWorkspaceConnection workspaceConnection, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets) {
        this.acceptRequests.add(new OperationRequest(workspaceConnection, syncReport, baselines, changeSets));
    }

    @Override
    protected void execute(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.AcceptOperation_0, (int)(10 * this.acceptRequests.size()));
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        Collection<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations(this.acceptRequests, determinants, (IProgressMonitor)monitor.newChild(this.acceptRequests.size()));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants);
        try {
            try {
                if (this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
                    IVerifyInSyncOperation verifyOp = this.getVerifyOperation(this.problemHandler);
                    for (ConfigurationDescriptor configuration : affectedConfigurations) {
                        verifyOp.addToVerify(configuration.getConnection(null), configuration.componentHandle);
                    }
                    verifyOp.run((IProgressMonitor)monitor.newChild(this.acceptRequests.size()));
                }
                final HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports = new HashMap<IWorkspaceConnection, List<IUpdateReport>>();
                TeamRepositoryException error = null;
                for (OperationRequest acceptRequest : this.acceptRequests) {
                    block22: {
                        if (!acceptRequest.getChangeSets().isEmpty() || !acceptRequest.getBaselines().isEmpty()) {
                            int reaction;
                            IUpdateReport updateReport;
                            if (acceptRequest.getSyncReport() == null) {
                                try {
                                    int flags = this.preflight ? 1 : 0;
                                    updateReport = acceptRequest.getWorkspace().accept(flags, acceptRequest.getChangeSets(), (IProgressMonitor)monitor.newChild(4));
                                    this.holdUpdateReport(acceptRequest, updateReport, updateReports);
                                    break block22;
                                }
                                catch (TeamRepositoryException e) {
                                    reaction = this.problemHandler.acceptChangeSetsProblem(acceptRequest.getWorkspace(), acceptRequest.getChangeSets(), e);
                                    if (reaction == 1) {
                                        throw new OperationCanceledException();
                                    }
                                    if (reaction != 0) {
                                        error = e;
                                        break;
                                    }
                                    break block22;
                                }
                            }
                            try {
                                updateReport = acceptRequest.getWorkspace().accept(this.preflight ? 1 : 0, acceptRequest.getSyncReport(), acceptRequest.getBaselines(), acceptRequest.getChangeSets(), (IProgressMonitor)monitor.newChild(4));
                                this.holdUpdateReport(acceptRequest, updateReport, updateReports);
                            }
                            catch (TeamRepositoryException e) {
                                reaction = this.problemHandler.acceptCombinedProblem(acceptRequest.getWorkspace(), acceptRequest.getSyncReport(), acceptRequest.getBaselines(), acceptRequest.getChangeSets(), e);
                                if (reaction == 1) {
                                    throw new OperationCanceledException();
                                }
                                if (reaction == 0) break block22;
                                error = e;
                                break;
                            }
                        }
                    }
                    this.checkCancelled((IProgressMonitor)monitor);
                }
                if (!this.preflight) {
                    IRunnableWithProgress runnableToUpdate = new IRunnableWithProgress(){

                        public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
                            for (Map.Entry entry : updateReports.entrySet()) {
                                UpdateOperation updateOperation = AcceptOperation.this.getUpdateOperation((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), 3, AcceptOperation.this.problemHandler);
                                AcceptOperation.this.disableVerifyInSync(updateOperation);
                                try {
                                    updateOperation.run((IProgressMonitor)monitor.newChild(4 * AcceptOperation.this.acceptRequests.size()));
                                }
                                catch (FileSystemClientException e) {
                                    AcceptOperation.this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
                                }
                                catch (TeamRepositoryException e) {
                                    AcceptOperation.this.collectStatus(FileSystemStatus.getStatusFor(e));
                                }
                            }
                        }
                    };
                    this.runWithinFileSystemLock(runnableToUpdate, (IProgressMonitor)monitor);
                }
                if (error != null) {
                    throw error;
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TeamRepositoryException) {
                    throw (TeamRepositoryException)cause;
                }
                if (cause instanceof FileSystemClientException) {
                    throw (FileSystemClientException)((Object)cause);
                }
                throw new TeamRepositoryException(Messages.AcceptOperation_1, cause);
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void holdUpdateReport(OperationRequest acceptRequest, IUpdateReport updateReport, HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports) {
        List<IUpdateReport> reports = updateReports.get(acceptRequest.getWorkspace());
        if (reports == null) {
            reports = new ArrayList<IUpdateReport>();
            updateReports.put(acceptRequest.getWorkspace(), reports);
        }
        reports.add(updateReport);
    }

    protected void runWithinFileSystemLock(IRunnableWithProgress runnableWithProgress, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        runnableWithProgress.run(monitor);
    }

    protected abstract UpdateOperation getUpdateOperation(IWorkspaceConnection var1, List<IUpdateReport> var2, int var3, UpdateDilemmaHandler var4);

    protected abstract IVerifyInSyncOperation getVerifyOperation(OutOfSyncDilemmaHandler var1);
}

