/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace.impl;

import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.namespace.AbstractContext;
import com.ibm.team.filesystem.client.internal.namespace.IContextHistory;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.ContextNameUtil;
import com.ibm.team.filesystem.client.internal.namespace.impl.ItemListenerMap;
import com.ibm.team.filesystem.client.internal.queries.IQuery;
import com.ibm.team.filesystem.client.internal.queries.QueryPool;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.FetchProfile;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryContext
extends AbstractContext {
    private ItemListenerMap listeners = new ItemListenerMap();
    private HashMap mapItemTypeOntoItemTypeEntry = new HashMap();

    public RepositoryContext(ITeamRepository repo) {
        super(RepositoryNamespace.create(repo));
    }

    @Override
    public IConnection getConnection() {
        return null;
    }

    @Override
    public ItemId<IComponent> getComponent() {
        return ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
    }

    @Override
    public <T extends IItem> Map<ItemId<T>, T> fetchCurrents(Collection<ItemId<T>> itemIds, FetchProfile profile, boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return RepoFetcher.fetchCurrents((ITeamRepository)this.getRepository(), itemIds, (boolean)shouldRefresh, (FetchProfile)profile, (IProgressMonitor)monitor);
    }

    @Override
    public <T extends IItem> Map<ItemId<T>, StateId<T>> getStates(Collection<ItemId<T>> itemIds, boolean shouldRefresh, IProgressMonitor rep) throws TeamRepositoryException {
        Map items = RepoFetcher.fetchCurrents((ITeamRepository)this.getRepository(), itemIds, (IProgressMonitor)rep);
        Map stateMap = NewCollection.hashMap();
        List allStates = NewCollection.arrayList();
        for (ItemId<T> next : itemIds) {
            IItem item = (IItem)items.get(next);
            StateId nextState = item == null ? new StateId(next, StateId.STATE_DELETED) : StateId.forItem((IItem)item);
            stateMap.put(next, nextState);
            allStates.add(nextState);
        }
        this.listeners.touch(allStates);
        return stateMap;
    }

    public <T extends IItem> Map<ItemId<T>, T> fetchCurrents(List<ItemId<T>> itemIds, FetchProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        Map result = RepoFetcher.fetchCurrents((ITeamRepository)this.getNamespace().getRepository(), itemIds, (IProgressMonitor)monitor);
        this.listeners.touch(ItemLists.itemsToStates(result.values()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ItemId toObserve, IChangeListener toAdd) {
        if (this.listeners.addListener(toObserve, toAdd)) {
            HashMap hashMap = this.mapItemTypeOntoItemTypeEntry;
            synchronized (hashMap) {
                ItemTypeEntry entry = (ItemTypeEntry)this.mapItemTypeOntoItemTypeEntry.get(toObserve.getItemType());
                if (entry == null) {
                    entry = new ItemTypeEntry();
                    this.getRepository().itemManager().addItemChangeListener(toObserve.getItemType(), (ISharedItemChangeListener)entry);
                    this.mapItemTypeOntoItemTypeEntry.put(toObserve.getItemType(), entry);
                }
                ++entry.listenerCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ItemId toObserve, IChangeListener toRemove) {
        if (this.listeners.removeListener(toObserve, toRemove)) {
            HashMap hashMap = this.mapItemTypeOntoItemTypeEntry;
            synchronized (hashMap) {
                ItemTypeEntry entry = (ItemTypeEntry)this.mapItemTypeOntoItemTypeEntry.get(toObserve.getItemType());
                if (entry == null) {
                    return;
                }
                --entry.listenerCount;
                if (entry.listenerCount <= 0) {
                    this.getRepository().itemManager().removeItemChangeListener(toObserve.getItemType(), (ISharedItemChangeListener)entry);
                    this.mapItemTypeOntoItemTypeEntry.remove(toObserve.getItemType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Collection itemIds, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet toRefresh = new HashSet();
        toRefresh.addAll(itemIds);
        Object object = this.listeners.getMutex();
        synchronized (object) {
            Set items = this.listeners.getItemsBeingObserved();
            toRefresh.retainAll(items);
        }
        List items = this.getRepository().itemManager().fetchCompleteItems(ItemLists.idsToHandles(toRefresh), 1, monitor);
        this.listeners.addStates(ItemLists.handlesToStates((Collection)items));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet toRefresh = new HashSet();
        Object object = this.listeners.getMutex();
        synchronized (object) {
            Set items = this.listeners.getItemsBeingObserved();
            toRefresh.addAll(items);
        }
        List items = this.getRepository().itemManager().fetchCompleteItems(ItemLists.idsToHandles(toRefresh), 1, monitor);
        this.listeners.addStates(ItemLists.handlesToStates((Collection)items));
    }

    @Override
    public List<DeliveryInfo> findChangeSetsAffecting(ItemId<?> item, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IQuery changeSetsQuery = QueryPool.getChangeSetsForItemQuery(this.getRepository(), item);
        List changeSets = changeSetsQuery.compute((IProgressMonitor)progress.newChild(1));
        Collections.sort(changeSets, new Comparator(){

            public int compare(Object o1, Object o2) {
                IChangeSet cs1 = (IChangeSet)o1;
                IChangeSet cs2 = (IChangeSet)o2;
                Date m1 = cs1.getLastChangeDate();
                Date m2 = cs2.getLastChangeDate();
                if (m1 != null && m2 != null) {
                    return m1.compareTo(m2);
                }
                if (m1 != null) {
                    return -1;
                }
                if (m2 != null) {
                    return 1;
                }
                return m1.hashCode() - m2.hashCode();
            }
        });
        List result = NewCollection.arrayList();
        for (IChangeSet next : changeSets) {
            result.add(new DeliveryInfo((ItemId<IChangeSet>)ItemId.forItem((IItem)next), (ItemId<IContributor>)ChangeSetUtil.getAuthor((IChangeSet)next), next.getLastChangeDate()));
        }
        return result;
    }

    @Override
    public IContextHistory getHistory() {
        return null;
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String getName() {
        return ContextNameUtil.getContextName(this.getRepository());
    }

    @Override
    public Collection<ItemId<IChangeSet>> changeSetsInHistory(Collection<ItemId<IChangeSet>> singleton, IProgressMonitor newChild) throws TeamRepositoryException {
        throw new TeamRepositoryException("Unsupported operation.");
    }

    @Override
    public Map<ItemId<IVersionable>, VersionablePath> resolve(Collection<ItemId<IVersionable>> versionables, IProgressMonitor monitor) throws TeamRepositoryException {
        throw new TeamRepositoryException("Unsupported operation. A repository on it's own is not enough to resolve versionable pathnames.");
    }

    private class ItemTypeEntry
    implements ISharedItemChangeListener {
        int listenerCount = 0;

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                IItem item = event.getAfterState();
                if (item instanceof IVersionableHandle) {
                    RepositoryContext.this.listeners.addState(new StateId((IItemHandle)((IVersionableHandle)item)));
                    continue;
                }
                if (!(item instanceof IAuditableHandle)) continue;
                RepositoryContext.this.listeners.addState(new StateId((IItemHandle)((IAuditableHandle)item)));
            }
        }
    }
}

