/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeListener;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Trace;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.localchanges.IVersionableTree;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNode;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFolderAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFolderDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveFrom;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveTo;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingInputStream;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto.ComponentStateSummary;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.SynchronizationTime;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalChangeManager
implements ILocalChangeManager {
    public static final IRepositoryResolver DEFAULT_RESOLVER = new DefaultRepoResolver();
    private Object avoidNotification = new Object();
    private int avoidNotificationCount = 0;
    public static final ILocalChange[] NO_CHANGES = new ILocalChange[0];
    private static LocalChangeManager instance;
    public static String RECOMPUTE_PENDING_CHANGES_FAMILY;
    private Set toRefresh = new HashSet();
    private Object refreshLock = new Object();
    private Map<LocalChangeContext, LocalChangeTracker> trackers = new HashMap<LocalChangeContext, LocalChangeTracker>();
    private LocalChangeNotifier notifier = new LocalChangeNotifier();
    private RecomputePendingChangesJob recomputeJob = new RecomputePendingChangesJob();
    private static final String BACKUP_NAME = "#apo";

    static {
        RECOMPUTE_PENDING_CHANGES_FAMILY = RecomputePendingChangesJob.class.getName();
    }

    public static synchronized LocalChangeManager getInstance() {
        if (instance == null) {
            instance = new LocalChangeManager();
        }
        return instance;
    }

    private LocalChangeManager() {
    }

    @Override
    public void addLocalChangeListener(ILocalChangeListener listener) {
        this.notifier.addListener(listener);
    }

    public String getProgressDescription(ILocalChange change) {
        if (change instanceof LocalFileAddition) {
            return NLS.bind((String)Messages.LocalChangeManager_2, (Object)change.getPath());
        }
        if (change instanceof LocalFileChange) {
            return NLS.bind((String)Messages.LocalChangeManager_3, (Object)change.getPath());
        }
        if (change instanceof LocalFileDeletion) {
            return NLS.bind((String)Messages.LocalChangeManager_4, (Object)change.getPath());
        }
        if (change instanceof LocalFolderAddition) {
            return NLS.bind((String)Messages.LocalChangeManager_5, (Object)change.getResultingPath());
        }
        if (change instanceof LocalFolderDeletion) {
            return NLS.bind((String)Messages.LocalChangeManager_6, (Object)change.getPath());
        }
        if (change instanceof LocalMoveFrom) {
            return NLS.bind((String)Messages.LocalChangeManager_7, (Object)change.getPath());
        }
        if (change instanceof LocalMoveTo) {
            return NLS.bind((String)Messages.LocalChangeManager_8, (Object)change.getResultingPath());
        }
        LoggingHelper.log((IStatus)new Status(2, "com.ibm.team.filesystem.client", String.valueOf(Messages.LocalChangeManager_9) + this.getClass().getName()));
        return Messages.LocalChangeManager_10;
    }

    public void cancelChanges(IShare share) {
        LocalChangeTracker tracker = this.findTracker(share);
        if (tracker != null) {
            tracker.cancelChanges(tracker.getPendingChanges(share.getPath(), false));
        }
    }

    private LocalChangeTracker findTracker(IShare share) {
        ISharingDescriptor desc = share.getSharingDescriptor();
        return this.findTracker(desc.getConnectionHandle(), desc.getComponent(), share.getAnchor());
    }

    private Map<LocalChangeContext, List<ILocalChange>> getChangesMap(ILocalChange[] changes) {
        HashMap<LocalChangeContext, List<ILocalChange>> changesMap = new HashMap<LocalChangeContext, List<ILocalChange>>();
        ILocalChange[] iLocalChangeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange c = iLocalChangeArray[n2];
            LocalChangeContext ctx = ((LocalChange)c).context;
            if (ctx != null) {
                ArrayList<ILocalChange> changesList = (ArrayList<ILocalChange>)changesMap.get(ctx);
                if (changesList == null) {
                    changesList = new ArrayList<ILocalChange>();
                    changesMap.put(ctx, changesList);
                }
                changesList.add(c);
            }
            ++n2;
        }
        return changesMap;
    }

    public void cancelChanges(ILocalChange[] canceled) {
        for (Map.Entry<LocalChangeContext, List<ILocalChange>> entry : this.getChangesMap(canceled).entrySet()) {
            LocalChangeTracker tracker = this.findTracker(entry.getKey());
            tracker.cancelChanges(entry.getValue().toArray(new ILocalChange[entry.getValue().size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingChanges(IContextHandle connection, IComponentHandle component, IPath cfaRoot) {
        Map<LocalChangeContext, LocalChangeTracker> map = this.trackers;
        synchronized (map) {
            this.trackers.remove(new LocalChangeContext(component, connection, cfaRoot));
        }
    }

    public void commitChanges(ILocalChange[] committed) {
        for (Map.Entry<LocalChangeContext, List<ILocalChange>> entry : this.getChangesMap(committed).entrySet()) {
            LocalChangeTracker tracker = this.findTracker(entry.getKey());
            tracker.confirmChanges(entry.getValue().toArray(new ILocalChange[entry.getValue().size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRefresh(IProgressMonitor monitor) throws FileSystemClientException {
        Set snapshot;
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.toRefresh.isEmpty()) {
                return;
            }
            snapshot = this.toRefresh;
            this.toRefresh = new HashSet();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LocalChangeManager_11, (int)snapshot.size());
        try {
            Iterator i = snapshot.iterator();
            while (i.hasNext()) {
                ILocalChange[] newChanges;
                ILocalChange[] existingChanges;
                SubMonitor subProgress = progress.newChild(1);
                subProgress.setWorkRemaining(100);
                RefreshRequest current = (RefreshRequest)i.next();
                Share share = (Share)current.getShare();
                LocalChangeTracker tracker = share.getTracker();
                LocalChangeNotifier.disableChangeNotification();
                try {
                    IShareable rootShareable = current.getStartingPoint();
                    if (rootShareable == null) {
                        rootShareable = share.getShareable(share.getPath(), true);
                    }
                    ISchedulingRule trackingRule = SharingManager.getInstance().getTrackingRule(share.getAnchor());
                    try {
                        Job.getJobManager().beginRule(trackingRule, (IProgressMonitor)subProgress.newChild(1));
                        ISchedulingRule rule = share.lock((IProgressMonitor)subProgress.newChild(1));
                        try {
                            LocalChangeTracker localChangeTracker = tracker;
                            synchronized (localChangeTracker) {
                                existingChanges = tracker.getPendingChanges(true);
                                tracker.computePendingChanges(rootShareable, (IProgressMonitor)subProgress.newChild(98));
                                tracker.syncChanges();
                                newChanges = tracker.getPendingChanges();
                            }
                        }
                        finally {
                            share.unlock(rule, (IProgressMonitor)subProgress.newChild(1));
                        }
                    }
                    finally {
                        Job.getJobManager().endRule(trackingRule);
                    }
                }
                finally {
                    LocalChangeNotifier.enableChangeNotification();
                }
                this.notifier.changesCanceled(tracker.getContext(), existingChanges);
                this.notifier.changesOccurred(tracker.getContext(), newChanges);
                subProgress.done();
            }
        }
        finally {
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalChangeTracker findTracker(LocalChangeContext ctx) {
        Map<LocalChangeContext, LocalChangeTracker> map = this.trackers;
        synchronized (map) {
            return this.trackers.get(ctx);
        }
    }

    public LocalChangeTracker findTracker(IContextHandle connection, IComponentHandle component, IPath cfaRoot) {
        return this.findTracker(new LocalChangeContext(component, connection, cfaRoot));
    }

    @Override
    public ILocalChange getPendingChange(IContextHandle connection, IComponentHandle component, IShareable shareable) {
        LocalChangeTracker tracker = this.findTracker(connection, component, shareable.getRoot());
        return tracker == null ? NoOpChange.NO_OP : tracker.getPendingChange(shareable.getVersionable());
    }

    @Override
    public ILocalChange getPendingChange(IShare share, IVersionableHandle versionable) {
        LocalChangeTracker tracker = this.findTracker(share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent(), share.getAnchor());
        return tracker == null ? NoOpChange.NO_OP : tracker.getPendingChange(versionable);
    }

    @Override
    public void syncPendingChanges(IContextHandle connection, IComponentHandle component, IPath shareRoot) {
        LocalChangeTracker tracker = this.findTracker(connection, component, shareRoot);
        if (tracker != null) {
            tracker.syncChanges();
        }
    }

    @Override
    public ILocalChange[] getPendingChanges(IContextHandle connection, IComponentHandle component, IPath shareRoot) {
        LocalChangeTracker tracker = this.findTracker(connection, component, shareRoot);
        if (tracker == null) {
            return NO_CHANGES;
        }
        return tracker.getPendingChanges();
    }

    @Override
    public ILocalChange[] getPendingChanges(IShareable[] startingPoints) {
        HashMap<LocalChangeContext, ArrayList<IShareable>> shareableMap = new HashMap<LocalChangeContext, ArrayList<IShareable>>();
        IShareable[] iShareableArray = startingPoints;
        int n = startingPoints.length;
        int n2 = 0;
        while (n2 < n) {
            ISharingDescriptor desc;
            IShareable s = iShareableArray[n2];
            IShare share = s.getShare();
            if (share != null && (desc = share.getSharingDescriptor()) != null) {
                LocalChangeContext ctx = new LocalChangeContext(desc.getComponent(), desc.getConnectionHandle(), s.getRoot());
                ArrayList<IShareable> shareables = (ArrayList<IShareable>)shareableMap.get(ctx);
                if (shareables == null) {
                    shareables = new ArrayList<IShareable>();
                    shareableMap.put(ctx, shareables);
                }
                shareables.add(s);
            }
            ++n2;
        }
        ArrayList result = new ArrayList();
        for (Map.Entry entry : shareableMap.entrySet()) {
            LocalChangeTracker tracker = this.findTracker((LocalChangeContext)entry.getKey());
            if (tracker == null) continue;
            for (IShareable s : (List)entry.getValue()) {
                result.addAll(Arrays.asList(tracker.getPendingChanges(s.getLocalFullPath(), false)));
            }
        }
        return result.toArray(new ILocalChange[result.size()]);
    }

    public IShareable getShareable(LocalChange change) throws FileSystemClientException {
        Assert.isNotNull((Object)change.path);
        Assert.isNotNull((Object)change.target);
        Assert.isNotNull((Object)change.context);
        IPath path = change.isType(16) ? change.getResultingPath() : change.getPath();
        Share share = SharingManager.getInstance().getShare(change.context.getRoot(), path);
        if (share == null) {
            return null;
        }
        IShareable found = share.getShareable(path, change.getTarget() instanceof IFolderHandle);
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeTracker getTracker(IVersionableTree versionableTree, IContextHandle connection, IComponentHandle component, IPath shareRoot, ISchedulingRule schedulingRule) {
        Map<LocalChangeContext, LocalChangeTracker> map = this.trackers;
        synchronized (map) {
            LocalChangeContext context = new LocalChangeContext(component, connection, shareRoot);
            LocalChangeTracker tracker = this.trackers.get(context);
            if (tracker == null) {
                tracker = new LocalChangeTracker(shareRoot, versionableTree, this.notifier, context, schedulingRule);
                this.trackers.put(context, tracker);
            }
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadChanges(IShare share, IProgressMonitor monitor) throws FileSystemClientException {
        LocalChangeTracker tracker = ((Share)share).getTracker();
        IShareable rootShareable = share.getShareable(share.getPath(), true);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISchedulingRule trackingRule = SharingManager.getInstance().getTrackingRule(share.getAnchor());
        try {
            Job.getJobManager().beginRule(trackingRule, (IProgressMonitor)progress.newChild(3));
            ISchedulingRule rule = ((Share)share).lock((IProgressMonitor)progress.newChild(2));
            try {
                LocalChangeTracker localChangeTracker = tracker;
                synchronized (localChangeTracker) {
                    tracker.computePendingChanges(rootShareable, (IProgressMonitor)progress.newChild(90));
                }
            }
            finally {
                ((Share)share).unlock(rule, (IProgressMonitor)progress.newChild(5));
                progress.done();
            }
        }
        finally {
            Job.getJobManager().endRule(trackingRule);
        }
    }

    public void refreshAllChanges(IProgressMonitor monitor) throws FileSystemClientException {
        this.refreshChanges(SharingManager.getInstance().allShares(), monitor);
    }

    public void computeChanges(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        Share share = (Share)shareable.getShare();
        share.getTracker().computePendingChanges(shareable, monitor);
    }

    public void refreshChanges(IShare share, IShareable startingPoint, IProgressMonitor monitor) throws FileSystemClientException {
        this.addToRefresh(share, startingPoint);
        this.doRefresh(monitor);
    }

    public void refreshChanges(IShare[] shares, IProgressMonitor monitor) throws FileSystemClientException {
        int i = 0;
        while (i < shares.length) {
            this.addToRefresh(shares[i], null);
            ++i;
        }
        this.doRefresh(monitor);
    }

    public void refreshChanges(IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        IShare[] allShares = SharingManager.getInstance().allShares();
        int i = 0;
        while (i < allShares.length) {
            ISharingDescriptor sharingDescriptor = allShares[i].getSharingDescriptor();
            if (sharingDescriptor.getComponent().sameItemId((IItemHandle)component) && sharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)connection)) {
                this.addToRefresh(allShares[i], null);
            }
            ++i;
        }
        this.doRefresh(monitor);
    }

    public void undoChanges(final ILocalChange[] toUndo, IRepositoryResolver repositoryResolver, final UndoDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (toUndo.length == 0) {
            return;
        }
        final SharingManager mgr = SharingManager.getInstance();
        final IRepositoryResolver resolver = repositoryResolver == null ? DEFAULT_RESOLVER : repositoryResolver;
        final HashMap<LocalChangeContext, Set<LocalChange>[]> changesMap = new HashMap<LocalChangeContext, Set<LocalChange>[]>();
        final HashMap<LocalChangeContext, ITeamRepository> repoMap = new HashMap<LocalChangeContext, ITeamRepository>();
        IPath root = null;
        ILocalChange[] iLocalChangeArray = toUndo;
        int n = toUndo.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange c = iLocalChangeArray[n2];
            LocalChange ch = (LocalChange)c;
            Set[] changes = (Set[])changesMap.get(ch.context);
            if (changes == null) {
                changes = new Set[]{new HashSet(), new HashSet(), new HashSet()};
                changesMap.put(ch.context, changes);
            }
            if (ch.isType(4)) {
                changes[0].add(ch);
            } else if (ch.isType(2)) {
                changes[2].add(ch);
            } else if (ch.isType(16)) {
                changes[1].add((LocalChange)ch.getCounterpart());
            } else {
                changes[1].add(ch);
            }
            ITeamRepository repo = (ITeamRepository)repoMap.get(ch.context);
            if (repo == null) {
                Share share = mgr.getShare(ch.context.getRoot(), ch.getPath());
                repo = resolver.getRepoFor(share.getSharingDescriptor().getRepositoryUri(), share.getSharingDescriptor().getRepositoryId());
                repoMap.put(ch.context, repo);
            }
            root = ch.context.getRoot();
            ++n2;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final HashSet<ConfigurationDescriptor> affectedConfigurations = this.getConfigurationsAffected(changesMap, repoMap, progress.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireRead(affectedConfigurations);
        try {
            try {
                final IPath cfaRoot = root;
                mgr.runWithinFileSystemLock(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(toUndo.length + 20));
                        try {
                            VerifySharesOperation verifyOp = mgr.getVerifySharesOperation(cfaRoot, problemHandler);
                            for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                                verifyOp.addToVerify(configurationDescriptor.getConnection((IProgressMonitor)progress.newChild(1)), configurationDescriptor.componentHandle);
                            }
                            verifyOp.run((IProgressMonitor)progress.newChild(4));
                            for (Map.Entry entry : changesMap.entrySet()) {
                                LocalChangeTracker tracker = LocalChangeManager.this.findTracker((LocalChangeContext)entry.getKey());
                                Set[] undoPerTracker = (Set[])entry.getValue();
                                ITeamRepository repo = (ITeamRepository)repoMap.get(entry.getKey());
                                LocalChangeManager.this.undoChanges(tracker, repo, (Set[])entry.getValue(), resolver, (IProgressMonitor)progress.newChild(undoPerTracker[0].size() + undoPerTracker[1].size() + undoPerTracker[2].size()));
                            }
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (FileSystemClientException e) {
                            throw new InvocationTargetException((Throwable)((Object)e));
                        }
                    }
                }, (IProgressMonitor)progress.newChild(95));
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TeamRepositoryException) {
                    throw (TeamRepositoryException)cause;
                }
                if (cause instanceof FileSystemClientException) {
                    throw (FileSystemClientException)((Object)cause);
                }
                throw new TeamRepositoryException(Messages.LocalChangeManager_12, cause);
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.done();
    }

    private HashSet<ConfigurationDescriptor> getConfigurationsAffected(Map<LocalChangeContext, Set<LocalChange>[]> changesMap, Map<LocalChangeContext, ITeamRepository> repoMap, SubMonitor progress) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> configurationsAffected = new HashSet<ConfigurationDescriptor>();
        for (Map.Entry<LocalChangeContext, Set<LocalChange>[]> e : changesMap.entrySet()) {
            LocalChangeContext context = e.getKey();
            ITeamRepository repo = repoMap.get(context);
            if (repo == null) continue;
            configurationsAffected.add(new ConfigurationDescriptor(repo.getId(), repo.getRepositoryURI(), context.getConnection(), context.getComponent()));
        }
        return configurationsAffected;
    }

    private void undoChanges(LocalChangeTracker tracker, ITeamRepository repo, Set<LocalChange>[] toUndo, IRepositoryResolver resolver, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        if (repo == null) {
            return;
        }
        ISchedulingRule rule = SharingManager.getInstance().getTrackingRule(tracker.getContext().getRoot());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            Job.getJobManager().beginRule(rule, (IProgressMonitor)progress.newChild(1));
            CopyFileAreaStore cfa = CopyFileAreaStore.getCopyFileArea(tracker.getContext().getRoot());
            ISchedulingRule cfaRule = cfa.lock(tracker.getContext().getComponent(), tracker.getContext().getConnection(), (IProgressMonitor)progress.newChild(1));
            try {
                tracker.syncChanges();
                Set<LocalChange>[] setArray = toUndo;
                int n = toUndo.length;
                int n2 = 0;
                while (n2 < n) {
                    Set<LocalChange> changeList = setArray[n2];
                    Iterator<LocalChange> i = changeList.iterator();
                    while (i.hasNext()) {
                        LocalChange change = i.next();
                        if (!change.isCanceled()) continue;
                        i.remove();
                    }
                    ++n2;
                }
                this.validateUndoPrereq(tracker, cfa, toUndo[0], toUndo[1], toUndo[2], (IProgressMonitor)progress.newChild(1));
                Object connection = tracker.getContext().getConnection() instanceof IBaselineHandle ? SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection((IBaselineHandle)tracker.getContext().getConnection(), (IProgressMonitor)progress.newChild(1)) : SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)tracker.getContext().getConnection(), (IProgressMonitor)progress.newChild(1));
                FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(repo)).getFileSystemService();
                SubMonitor subProgress = progress.newChild(94);
                subProgress.setWorkRemaining(toUndo[0].size() + toUndo[1].size() + toUndo[2].size());
                for (LocalChange c : toUndo[0]) {
                    this.undoDeletion(c, tracker, cfa, (IConnection)connection, fileSystemService, (IProgressMonitor)subProgress.newChild(1));
                }
                int remaining = toUndo[1].size() + toUndo[2].size();
                while (true) {
                    HashSet<LocalChange> changesToUndo = new HashSet<LocalChange>();
                    for (LocalChange c : toUndo[1]) {
                        if (!this.undoChange(c, tracker, cfa, (IConnection)connection, (IProgressMonitor)subProgress.newChild(1))) {
                            changesToUndo.add(c);
                            subProgress.setWorkRemaining(remaining);
                            continue;
                        }
                        --remaining;
                    }
                    if (changesToUndo.isEmpty()) break;
                    if (toUndo[1].size() == changesToUndo.size()) {
                        StringBuilder str = new StringBuilder(Messages.LocalChangeManager_13);
                        boolean first = true;
                        for (LocalChange c : changesToUndo) {
                            if (!first) {
                                str.append(", ");
                            } else {
                                first = false;
                            }
                            str.append(c.toString());
                            if (!c.isType(8)) continue;
                            str.append(" - ").append(c.getCounterpart().toString());
                        }
                        throw new IllegalStateException(str.toString());
                    }
                    toUndo[1] = changesToUndo;
                }
                for (LocalChange c : toUndo[2]) {
                    this.undoAddition(c, tracker, cfa, (IConnection)connection, (IProgressMonitor)subProgress.newChild(1));
                }
                subProgress.done();
            }
            finally {
                cfa.release(cfaRule, (IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUndoPrereq(LocalChangeTracker tracker, CopyFileAreaStore cfa, Set<LocalChange> deletions, final Set<LocalChange> changes, final Set<LocalChange> additions, IProgressMonitor monitor) throws FileSystemClientException {
        for (LocalChange c : deletions) {
            ILocalChange[] chg = tracker.getPendingChangesAt(c.getPath());
            ILocalChange[] iLocalChangeArray = chg;
            int n = chg.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange ch = iLocalChangeArray[n2];
                if (ch.isType(2)) {
                    if (!additions.contains(ch)) {
                        throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_16, (Object)c.getPath(), (Object)ch.getResultingPath())));
                    }
                } else if (ch.isType(8)) {
                    if (!changes.contains(ch)) {
                        throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_17, (Object)c.getPath(), (Object)ch.getResultingPath())));
                    }
                } else if (!ch.equals(c)) {
                    throw new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_18, (Object)ch, (Object)c));
                }
                ++n2;
            }
        }
        IComponentHandle component = tracker.getContext().getComponent();
        IContextHandle connection = tracker.getContext().getConnection();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changes.size());
        block5: for (LocalChange c : changes) {
            if (!c.isType(8)) {
                progress.worked(1);
                continue;
            }
            IFolderHandle parent = c.getCounterpart().getTargetParent();
            SubMonitor subProgress = progress.newChild(1);
            subProgress.setWorkRemaining(2);
            IPath localPath = cfa.getLocalPathFor((IVersionableHandle)parent, component, connection, (IProgressMonitor)subProgress.newChild(1));
            String name = c.getCounterpart().getPath().lastSegment();
            if (localPath != null) {
                ILocalChange[] chg;
                ILocalChange[] iLocalChangeArray = chg = tracker.getPendingChangesAt(localPath.append(name));
                int n = chg.length;
                int n3 = 0;
                while (n3 < n) {
                    ILocalChange ch = iLocalChangeArray[n3];
                    if (ch.isType(2)) {
                        if (!additions.contains(ch)) {
                            throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_19, (Object)c.getResultingPath(), (Object)ch.getResultingPath())));
                        }
                    } else if (ch.isType(8)) {
                        if (!changes.contains(ch)) {
                            throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_20, (Object)c.getResultingPath(), (Object)ch.getResultingPath())));
                        }
                    } else {
                        throw new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_21, (Object)ch, (Object)c));
                    }
                    ++n3;
                }
            }
            ArrayList<IFolderHandle> parents = new ArrayList<IFolderHandle>();
            HashSet<UUID> seenItems = new HashSet<UUID>();
            seenItems.add(c.getTarget().getItemId());
            ILocalChange lastUndoMove = c;
            while (!cfa.isShareRoot(parent, c.getComponent(), c.getConnection())) {
                parents.add(parent);
                InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)parent, c.getComponent(), c.getConnection());
                ILocalChange parentChange = tracker.getPendingChange((IVersionableHandle)parent);
                if (parentChange.isType(4)) {
                    if (!deletions.contains(parentChange)) {
                        throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_22, (Object)lastUndoMove.getResultingPath(), (Object)parentChange.getPath())));
                    }
                    parent = info.getParent();
                } else if (parentChange.isType(2)) {
                    if (additions.contains(parentChange)) continue block5;
                    parent = info.getLocalParent();
                } else if (parentChange.isType(8)) {
                    if (changes.contains(parentChange)) {
                        parent = info.getParent();
                        lastUndoMove = parentChange;
                    } else {
                        parent = info.getLocalParent();
                    }
                } else {
                    parent = info.getLocalParent();
                    if (parent == null) {
                        parent = info.getParent();
                    }
                }
                if (seenItems.contains(parent.getItemId())) {
                    parents.add(parent);
                    subProgress.setWorkRemaining(parents.size());
                    HashMap<UUID, IFolderHandle> parentSet = new HashMap<UUID, IFolderHandle>((int)((double)parents.size() / 0.75));
                    HashSet<UUID> seenParents = new HashSet<UUID>((int)((double)parents.size() / 0.75));
                    int i = 0;
                    while (i < parents.size()) {
                        IFolderHandle ancestor = (IFolderHandle)parents.get(i);
                        ILocalChange ancestorChange = tracker.getPendingChange((IVersionableHandle)ancestor);
                        seenParents.add(ancestor.getItemId());
                        if (ancestorChange.isType(8)) {
                            if (changes.contains(ancestorChange)) {
                                UUID ancestorId;
                                HashSet<UUID> toSearch = new HashSet<UUID>(parentSet.keySet());
                                while ((ancestorId = cfa.getRemoteAncestor(toSearch, (IVersionableHandle)ancestor, c.getComponent(), c.getConnection(), (IProgressMonitor)subProgress.newChild(1))) != null) {
                                    ILocalChange depChange = tracker.getPendingChange((IVersionableHandle)parentSet.get(ancestorId));
                                    if (!seenParents.contains(depChange.getCounterpart().getTargetParent().getItemId())) {
                                        throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_23, (Object)ancestorChange.getResultingPath(), (Object)depChange.getResultingPath())));
                                    }
                                    toSearch.remove(ancestorId);
                                }
                            } else {
                                parentSet.put(ancestor.getItemId(), ancestor);
                            }
                        }
                        ++i;
                    }
                    throw new IllegalStateException(Messages.LocalChangeManager_24);
                }
                seenItems.add(parent.getItemId());
            }
            subProgress.done();
        }
        final FileSystemClientException[] ex = new FileSystemClientException[1];
        LocalChangeTracker localChangeTracker = tracker;
        synchronized (localChangeTracker) {
            for (final LocalChange c : additions) {
                c.getNode().basicAccept(new LocalChangeNode.IVisitor(){

                    public boolean visit(LocalChange toVisit) {
                        if (toVisit == c) {
                            return true;
                        }
                        if (toVisit.isType(2)) {
                            if (!additions.contains(toVisit)) {
                                ex[0] = new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_25, (Object)c.getResultingPath(), (Object)toVisit.getResultingPath())));
                            }
                        } else if (toVisit.isType(8)) {
                            if (!changes.contains(toVisit)) {
                                ex[0] = new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_26, (Object)c.getResultingPath(), (Object)toVisit.getResultingPath())));
                            }
                        } else if (!toVisit.isType(4)) {
                            throw new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_27, (Object)toVisit, (Object)c));
                        }
                        return false;
                    }
                });
                if (ex[0] == null) continue;
                throw ex[0];
            }
        }
        progress.done();
    }

    private void undoDeletion(LocalChange c, LocalChangeTracker tracker, CopyFileAreaStore cfa, IConnection connection, FileSystemServiceProxy fileSystemService, IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        LoadTree loadTree = fileSystemService.getFileTreeByVersionable(connection, c.getComponent(), new IVersionableHandle[]{c.getTarget()}, -1, true, null, (IProgressMonitor)progress);
        FileAreaUpdateReport updates = this.getUpdatesForDeletion(c, tracker, loadTree.getFileAreaUpdates());
        ComponentStateSummary stateSummary = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
        stateSummary.setComponent(c.getComponent());
        stateSummary.setConfigurationState(((SynchronizationTime)loadTree.getConfigurationState()).getTime());
        List<ComponentStateSummary> stateSummaries = Collections.singletonList(stateSummary);
        SharingManager mgr = SharingManager.getInstance();
        progress.worked(50);
        IPath localPath = cfa.getLocalPathFor((IVersionableHandle)c.getTargetParent(), c.getComponent(), c.getConnection(), (IProgressMonitor)progress.newChild(1)).append(c.getPath().lastSegment());
        Share share = mgr.getShare(c.context.getRoot(), localPath);
        IShareable s = share.getShareable(c.getPath(), c.getTarget() instanceof IFolderHandle);
        IFileStorage storage = ((Shareable)s).getFileStorage();
        IFileStorage existingChild = storage.getParent().getChild(storage.getName());
        if (existingChild != null) {
            this.preserve(existingChild, (IProgressMonitor)progress.newChild(5));
            existingChild = null;
        }
        progress.setWorkRemaining(100);
        mgr.getUpdateMutator(connection, stateSummaries, stateSummaries, updates, c.context.getRoot()).run((IProgressMonitor)progress.newChild(100));
        progress.done();
    }

    private FileAreaUpdateReport getUpdatesForDeletion(LocalChange c, LocalChangeTracker tracker, List<FileAreaUpdate> updates) throws TeamRepositoryException {
        FileAreaUpdateReport result = FilesystemDTOFactory.eINSTANCE.createFileAreaUpdateReport();
        HashSet<UUID> excludedParents = new HashSet<UUID>();
        for (FileAreaUpdate update : updates) {
            if (c.getTarget().sameItemId((IItemHandle)update.getItem()) || !excludedParents.contains(update.getDestinationParent().getItemId()) && tracker.getPendingChange(update.getItem()).getType() == 0) {
                result.getAdds().add(update);
                continue;
            }
            excludedParents.add(update.getItem().getItemId());
        }
        return result;
    }

    private void preserve(IFileStorage storage, IProgressMonitor monitor) throws FileSystemClientException {
        IFileStorage parent = storage.getParent();
        String baseName = String.valueOf(storage.getName()) + BACKUP_NAME;
        int i = 2;
        String name = baseName;
        while (parent.getChild(name) != null) {
            name = String.valueOf(baseName) + Integer.toString(i++);
        }
        Share share = (Share)storage.getShareable().getShare();
        IShareable target = share.getShareable(parent.getFullPath().append(name), storage.isFolder());
        storage.move(((Shareable)target).getFileStorage(), monitor);
    }

    private boolean undoChange(LocalChange c, LocalChangeTracker tracker, CopyFileAreaStore cfa, IConnection connection, IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        IFileStorage storage;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        IPath localPath = cfa.getLocalPathFor(c.getTarget(), c.getComponent(), c.getConnection(), (IProgressMonitor)progress.newChild(1));
        Share share = SharingManager.getInstance().getShare(c.context.getRoot(), localPath);
        IShareable shareable = share.getShareable(localPath, c.getTarget() instanceof IFolderHandle);
        if (c.isType(8)) {
            SubMonitor subProgress = progress.newChild(c.isType(1) ? 19 : 99);
            subProgress.setWorkRemaining(100);
            IPath oldPath = cfa.getLocalPathFor((IVersionableHandle)c.getCounterpart().getTargetParent(), c.getComponent(), c.getConnection(), (IProgressMonitor)subProgress.newChild(20)).append(c.getCounterpart().getPath().lastSegment());
            if (localPath.isPrefixOf(oldPath)) {
                subProgress.done();
                progress.done();
                return false;
            }
            IShareable targetShareable = share.getShareable(oldPath, c.getTarget() instanceof IFolderHandle);
            IFileStorage target = ((Shareable)targetShareable).getFileStorage();
            IFileStorage existingChild = target.getParent().getChild(target.getName());
            if (existingChild != null) {
                this.preserve(existingChild, (IProgressMonitor)subProgress.newChild(20));
            }
            if (oldPath.isPrefixOf(localPath)) {
                localPath = cfa.getLocalPathFor(c.getTarget(), c.getComponent(), c.getConnection(), (IProgressMonitor)subProgress.newChild(20));
                shareable = share.getShareable(localPath, c.getTarget() instanceof IFolderHandle);
            }
            subProgress.setWorkRemaining(40);
            ((Shareable)shareable).getFileStorage().move(target, (IProgressMonitor)subProgress.newChild(40));
            localPath = oldPath;
            shareable = targetShareable;
            subProgress.done();
        }
        FileItemInfo oldInfo = null;
        boolean undoExecBit = false;
        if (c.isType(1)) {
            boolean isOriginalExecutable;
            boolean isExecutable;
            Content content;
            progress.setWorkRemaining(100);
            oldInfo = cfa.getItemInfo(localPath);
            storage = ((Shareable)shareable).getFileStorage();
            if (oldInfo.getStoredContentId() != null) {
                content = RepositoryFactory.eINSTANCE.createContent();
                content.setContentId(oldInfo.getStoredContentId());
                content.setDeltaPredecessor(oldInfo.getStoredDeltaPredecessor());
                content.setLineDelimiter(oldInfo.getOriginalLineDelimiter());
                content.setContentType(oldInfo.getOriginalContentType());
                content.setContentLength(oldInfo.getStoredSize());
                content.setCharacterEncoding(oldInfo.getStoredEncoding());
                content.setChecksum(oldInfo.getStoredChecksum());
                content.setLineDelimiterCount(oldInfo.getStoredNumLineDelimiters());
                isExecutable = oldInfo.isExecutable();
                isOriginalExecutable = oldInfo.isOriginalExecutable();
            } else {
                IFileItem file = (IFileItem)SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository()).versionableManager().fetchCompleteState(c.getTarget(), (IProgressMonitor)progress.newChild(30));
                content = (Content)file.getContent();
                isOriginalExecutable = file.isExecutable();
                isExecutable = storage.supportsExecBit() ? false : isOriginalExecutable;
                undoExecBit = isExecutable ^ isOriginalExecutable;
            }
            HashComputingInputStream is = new HashComputingInputStream(connection.teamRepository().contentManager().retrieveContentStream((IContent)content, (IProgressMonitor)progress.newChild(68)));
            storage.setContents((InputStream)is, (IProgressMonitor)new CancellationMonitor((IProgressMonitor)progress));
            FileItemInfo newInfo = new FileItemInfo(oldInfo.getVersionableHandle(), storage.getModificationStamp(), oldInfo.getParent(), oldInfo.getName(), new HashCode(is.getChecksum()), is.getContentSize(), content.getLineDelimiter(), content.getLineDelimiter(), content.getContentType(), content.getContentType(), content.getContentId(), content.getDeltaPredecessor(), content.getContentLength(), content.getCharacterEncoding(), content.getChecksum(), content.getLineDelimiterCount(), isExecutable, isOriginalExecutable);
            cfa.setItemInfo(shareable, newInfo, (IProgressMonitor)progress.newChild(1));
            oldInfo = newInfo;
        }
        if (undoExecBit || c.isType(32)) {
            progress.setWorkRemaining(1);
            if (oldInfo == null) {
                oldInfo = cfa.getItemInfo(localPath);
            }
            storage = ((Shareable)shareable).getFileStorage();
            storage.setExecutable(oldInfo.isOriginalExecutable(), (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return true;
    }

    private void undoAddition(LocalChange c, LocalChangeTracker tracker, CopyFileAreaStore cfa, IConnection connection, IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        IPath localPath = cfa.getLocalPathFor(c.getTarget(), c.getComponent(), c.getConnection(), (IProgressMonitor)progress.newChild(1));
        if (localPath != null) {
            Share share = SharingManager.getInstance().getShare(c.context.getRoot(), localPath);
            IShareable shareable = share.getShareable(localPath, c.getTarget() instanceof IFolderHandle);
            ((Shareable)shareable).getFileStorage().delete((IProgressMonitor)progress.newChild(99));
        }
        progress.done();
    }

    @Override
    public void removeLocalChangeListener(ILocalChangeListener listener) {
        this.notifier.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRefresh(IShare share, IShareable root) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.toRefresh.add(new RefreshRequest(share, root));
            this.recomputeJob.schedule(500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginAvoidNotify() {
        Object object = this.avoidNotification;
        synchronized (object) {
            ++this.avoidNotificationCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAvoidNotify() throws FileSystemClientException {
        Object object = this.avoidNotification;
        synchronized (object) {
            --this.avoidNotificationCount;
            Assert.isTrue((this.avoidNotificationCount >= 0 ? 1 : 0) != 0, (String)"Unmatched start/end notification");
            if (this.avoidNotificationCount < 0) {
                this.avoidNotificationCount = 0;
            }
            if (this.avoidNotificationCount == 0) {
                this.notifier.scheduleNotification();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabled() {
        Object object = this.avoidNotification;
        synchronized (object) {
            return this.avoidNotificationCount == 0;
        }
    }

    @Override
    public ILocalChange[] getPendingChanges(IShare[] startingPoints) {
        HashMap<LocalChangeContext, ArrayList<IPath>> pathMap = new HashMap<LocalChangeContext, ArrayList<IPath>>();
        IShare[] iShareArray = startingPoints;
        int n = startingPoints.length;
        int n2 = 0;
        while (n2 < n) {
            ISharingDescriptor desc;
            IShare share = iShareArray[n2];
            if (share != null && (desc = share.getSharingDescriptor()) != null) {
                LocalChangeContext ctx = new LocalChangeContext(desc.getComponent(), desc.getConnectionHandle(), share.getAnchor());
                ArrayList<IPath> paths = (ArrayList<IPath>)pathMap.get(ctx);
                if (paths == null) {
                    paths = new ArrayList<IPath>();
                    pathMap.put(ctx, paths);
                }
                paths.add(share.getPath());
            }
            ++n2;
        }
        ArrayList result = new ArrayList();
        for (Map.Entry entry : pathMap.entrySet()) {
            LocalChangeTracker tracker = this.findTracker((LocalChangeContext)entry.getKey());
            if (tracker == null) continue;
            for (IPath path : (List)entry.getValue()) {
                result.addAll(Arrays.asList(tracker.getPendingChanges(path, false)));
            }
        }
        return result.toArray(new ILocalChange[result.size()]);
    }

    @Override
    public void undoChanges(ILocalChange[] toUndo, UndoDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.undoChanges(toUndo, null, problemHandler, monitor);
    }

    @Override
    public void combineDeleteAdd(ILocalChange deletion, ILocalChange addition, IProgressMonitor monitor) throws FileSystemClientException {
        this.combineDeleteAdd(DEFAULT_RESOLVER, deletion, addition, monitor);
    }

    public void combineDeleteAdd(IRepositoryResolver resolver, final ILocalChange deletion, final ILocalChange addition, IProgressMonitor monitor) throws FileSystemClientException {
        if (deletion == null || !deletion.isType(4)) {
            throw new IllegalArgumentException();
        }
        if (addition == null || !addition.isType(2)) {
            throw new IllegalArgumentException();
        }
        if (!deletion.getConnection().sameItemId((IItemHandle)addition.getConnection())) {
            throw new IllegalArgumentException("Changes must be in the same workspace");
        }
        if (!deletion.getComponent().sameItemId((IItemHandle)addition.getComponent())) {
            throw new IllegalArgumentException("Changes must be in the same component");
        }
        SharingManager mgr = SharingManager.getInstance();
        IShareable del = deletion.getShareable();
        if (del == null) {
            throw new IllegalArgumentException();
        }
        IShareable add = addition.getShareable();
        if (add == null) {
            throw new IllegalArgumentException();
        }
        if (!del.getRoot().equals((Object)add.getRoot())) {
            throw new IllegalArgumentException("Changes have different roots");
        }
        final IVersionableHandle item = deletion.getTarget();
        if (item == null) {
            throw new IllegalArgumentException("No versionable");
        }
        IShare share = del.getShare();
        if (share == null) {
            throw new IllegalArgumentException();
        }
        ITeamRepository repo = resolver.getRepoFor(share.getSharingDescriptor().getRepositoryUri(), share.getSharingDescriptor().getRepositoryId());
        ((Share)share).getCopyFileArea();
        ConfigurationDescriptor desc = new ConfigurationDescriptor(repo.getId(), repo.getRepositoryURI(), addition.getConnection(), addition.getComponent());
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireRead((Collection<ConfigurationDescriptor>)Collections.singleton(desc));
        try {
            try {
                final FileSystemClientException[] ex = new FileSystemClientException[1];
                mgr.runWithinFileSystemLock(new IRunnableWithProgress(){

                    public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)100);
                        LocalChangeTracker tracker = LocalChangeManager.this.findTracker(((LocalChange)addition).context);
                        ISchedulingRule rule = SharingManager.getInstance().getTrackingRule(tracker.getContext().getRoot());
                        try {
                            Job.getJobManager().beginRule(rule, (IProgressMonitor)mon.newChild(1));
                            CopyFileAreaStore cfa = CopyFileAreaStore.getCopyFileArea(tracker.getContext().getRoot());
                            try {
                                ISchedulingRule cfaRule = cfa.lock(tracker.getContext().getComponent(), tracker.getContext().getConnection(), (IProgressMonitor)mon.newChild(1));
                                try {
                                    LocalChangeManager.this.syncPendingChanges(addition.getConnection(), addition.getComponent(), cfa.getRoot());
                                    if (addition.isCanceled()) {
                                        throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", "addition cancelled"));
                                    }
                                    if (deletion.isCanceled()) {
                                        throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", "deletion cancelled"));
                                    }
                                    LocalChangeManager.this.combineDeleteAddInternal(cfa, item, deletion, addition, (IProgressMonitor)mon.newChild(98));
                                }
                                finally {
                                    cfa.release(cfaRule, (IProgressMonitor)mon.newChild(1));
                                }
                            }
                            catch (FileSystemClientException e) {
                                ex[0] = e;
                            }
                        }
                        finally {
                            Job.getJobManager().endRule(rule);
                        }
                        mon.done();
                    }
                }, monitor);
                if (ex[0] != null) {
                    throw ex[0];
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                WorkspaceLockUtil.release(workspaceLock);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                WorkspaceLockUtil.release(workspaceLock);
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void combineDeleteAddInternal(CopyFileAreaStore cfa, IVersionableHandle oldItem, ILocalChange deletion, ILocalChange addition, IProgressMonitor monitor) throws FileSystemClientException {
        IComponentHandle comp = deletion.getComponent();
        IContextHandle conn = deletion.getConnection();
        Shareable newRoot = (Shareable)((LocalChange)addition).getShareable();
        LinkedList<Shareable> resources = new LinkedList<Shareable>();
        LinkedList<IVersionableHandle> oldItems = new LinkedList<IVersionableHandle>();
        resources.add(newRoot);
        oldItems.add(oldItem);
        while (!resources.isEmpty()) {
            assert (!oldItems.isEmpty());
            Shareable resource = (Shareable)resources.removeFirst();
            IVersionableHandle item = (IVersionableHandle)oldItems.removeFirst();
            InverseFileItemInfo itemInfo = cfa.getItemInfo(item, comp, conn);
            cfa.setItemInfo(resource, itemInfo, monitor);
            Map<String, IVersionableHandle> remoteChildren = itemInfo.getRemoteChildren();
            IFileStorage storage = resource.getFileStorage();
            IFileStorage[] localChildren = storage.getChildren();
            if (localChildren == null) continue;
            IFileStorage[] iFileStorageArray = localChildren;
            int n = localChildren.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStorage childStorage = iFileStorageArray[n2];
                assert (childStorage.exists());
                Shareable childShareable = childStorage.getShareable();
                IVersionableHandle childItem = remoteChildren.get(childStorage.getName());
                if (childItem != null) {
                    resources.addFirst(childShareable);
                    oldItems.addFirst(childItem);
                }
                ++n2;
            }
        }
        assert (oldItems.isEmpty());
        IShareable refreshRoot = deletion.getShareable();
        this.refreshChanges(refreshRoot.getShare(), refreshRoot, monitor);
        refreshRoot = addition.getShareable();
        this.refreshChanges(refreshRoot.getShare(), refreshRoot, monitor);
        this.doRefresh(monitor);
    }

    private static class DefaultRepoResolver
    implements IRepositoryResolver {
        private DefaultRepoResolver() {
        }

        public ITeamRepository getRepoFor(String uri, UUID id) {
            return RepositoryUtils.getTeamRepository(uri, id);
        }
    }

    class RecomputePendingChangesJob
    extends Job {
        public RecomputePendingChangesJob() {
            super(Messages.LocalChangeManager_0);
        }

        public boolean belongsTo(Object family) {
            return RECOMPUTE_PENDING_CHANGES_FAMILY.equals(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            long start;
            long l = start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                try {
                    LocalChangeManager.this.doRefresh(monitor);
                }
                catch (FileSystemClientException e) {
                    IStatus iStatus = FileSystemStatus.getStatusFor((Throwable)((Object)e));
                    if (Trace.LOG_ELAPSED_TIME) {
                        Trace.endTrace(start, String.valueOf(((Object)((Object)this)).getClass().getName()) + ":" + this.getName());
                    }
                    return iStatus;
                }
            }
            finally {
                if (Trace.LOG_ELAPSED_TIME) {
                    Trace.endTrace(start, String.valueOf(((Object)((Object)this)).getClass().getName()) + ":" + this.getName());
                }
            }
            return Status.OK_STATUS;
        }
    }

    public static class RefreshRequest {
        private IShare share;
        private IShareable startingPoint;

        public RefreshRequest(IShare share, IShareable startingPoint) {
            this.share = share;
            this.startingPoint = startingPoint;
        }

        public IShare getShare() {
            return this.share;
        }

        public IShareable getStartingPoint() {
            return this.startingPoint;
        }
    }
}

