/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateOrder {
    private Collection<FileAreaUpdate> adds;
    private Collection<FileAreaUpdate> deletes;
    private HashMap<UUID, List<FileAreaUpdate>> orderedAdds;
    private Collection<FileAreaUpdate> moves;
    private Collection<FileAreaUpdate> modifies;

    public UpdateOrder(Collection<FileAreaUpdate> adds, Collection<FileAreaUpdate> deletes, Collection<FileAreaUpdate> moves, Collection<FileAreaUpdate> modifies) {
        this.adds = adds;
        this.deletes = deletes;
        this.moves = moves;
        this.modifies = modifies;
    }

    public List getOrderedDeletes() {
        HashMap<UUID, List<FileAreaUpdate>> groupedDeletes = this.group(this.deletes);
        ArrayList<FileAreaUpdate> orderedDeletes = new ArrayList<FileAreaUpdate>(this.deletes.size());
        for (List<FileAreaUpdate> deleteGrouping : groupedDeletes.values()) {
            HashMap<UUID, List<FileAreaUpdate>> deleteParentage = new HashMap<UUID, List<FileAreaUpdate>>();
            for (FileAreaUpdate delete : deleteGrouping) {
                UUID parentId = delete.getSourceParent().getItemId();
                List<FileAreaUpdate> children = deleteParentage.get(parentId);
                if (children == null) {
                    children = new ArrayList<FileAreaUpdate>();
                    deleteParentage.put(parentId, children);
                }
                children.add(delete);
            }
            orderedDeletes.addAll(this.calculateOrdering(deleteParentage));
        }
        return orderedDeletes;
    }

    public List getFolderAdds() {
        if (this.orderedAdds == null) {
            this.calculateOrderedAdds();
        }
        ArrayList<FileAreaUpdate> folderAdds = new ArrayList<FileAreaUpdate>();
        for (List<FileAreaUpdate> grouping : this.orderedAdds.values()) {
            for (FileAreaUpdate add : grouping) {
                if (!(add.getItem() instanceof IFolderHandle)) continue;
                folderAdds.add(add);
            }
        }
        return folderAdds;
    }

    public List getFileAdds() {
        if (this.orderedAdds == null) {
            this.calculateOrderedAdds();
        }
        ArrayList<FileAreaUpdate> fileAdds = new ArrayList<FileAreaUpdate>();
        for (List<FileAreaUpdate> grouping : this.orderedAdds.values()) {
            for (FileAreaUpdate add : grouping) {
                if (!(add.getItem() instanceof IFileItemHandle)) continue;
                fileAdds.add(add);
            }
        }
        return fileAdds;
    }

    public List getFolderMoves() {
        ArrayList<FileAreaUpdate> folderMoves = new ArrayList<FileAreaUpdate>();
        for (FileAreaUpdate move : this.moves) {
            if (!(move.getItem() instanceof IFolderHandle)) continue;
            folderMoves.add(move);
        }
        return folderMoves;
    }

    public List getFileMoves() {
        ArrayList<FileAreaUpdate> fileMoves = new ArrayList<FileAreaUpdate>();
        for (FileAreaUpdate move : this.moves) {
            if (!(move.getItem() instanceof IFileItemHandle)) continue;
            fileMoves.add(move);
        }
        return fileMoves;
    }

    public List getGroupedModifies() {
        HashMap<UUID, List<FileAreaUpdate>> groupedModifies = this.group(this.modifies);
        ArrayList<FileAreaUpdate> collapsedUpdates = new ArrayList<FileAreaUpdate>(this.modifies.size());
        for (List<FileAreaUpdate> group : groupedModifies.values()) {
            collapsedUpdates.addAll(group);
        }
        return collapsedUpdates;
    }

    private HashMap<UUID, List<FileAreaUpdate>> group(Collection<FileAreaUpdate> updates) {
        HashMap<UUID, List<FileAreaUpdate>> groupedUpdates = new HashMap<UUID, List<FileAreaUpdate>>();
        for (FileAreaUpdate update : updates) {
            List<FileAreaUpdate> grouping = groupedUpdates.get(update.component().getItemId());
            if (grouping == null) {
                grouping = new ArrayList<FileAreaUpdate>();
                groupedUpdates.put(update.component().getItemId(), grouping);
            }
            grouping.add(update);
        }
        return groupedUpdates;
    }

    private void calculateOrderedAdds() {
        HashMap<UUID, List<FileAreaUpdate>> groupedAdds = this.group(this.adds);
        this.orderedAdds = new HashMap();
        for (Map.Entry<UUID, List<FileAreaUpdate>> entry : groupedAdds.entrySet()) {
            HashMap<UUID, List<FileAreaUpdate>> addParentage = new HashMap<UUID, List<FileAreaUpdate>>();
            for (FileAreaUpdate add : entry.getValue()) {
                List<FileAreaUpdate> children = addParentage.get(add.getDestinationParent().getItemId());
                if (children == null) {
                    children = new ArrayList<FileAreaUpdate>();
                    addParentage.put(add.getDestinationParent().getItemId(), children);
                }
                children.add(add);
            }
            ArrayList<FileAreaUpdate> orderedGrouping = this.calculateOrdering(addParentage);
            Collections.reverse(orderedGrouping);
            this.orderedAdds.put(entry.getKey(), orderedGrouping);
        }
    }

    private ArrayList<FileAreaUpdate> calculateOrdering(HashMap<UUID, List<FileAreaUpdate>> parentage) {
        ArrayList<FileAreaUpdate> orderedUpdates = new ArrayList<FileAreaUpdate>();
        while (!parentage.isEmpty()) {
            UUID parent = parentage.keySet().iterator().next();
            List<FileAreaUpdate> children = parentage.get(parent);
            this.orderChildrenFirst(children, parentage, orderedUpdates);
            parentage.remove(parent);
        }
        return orderedUpdates;
    }

    private void orderChildrenFirst(List children, HashMap disjointParents, List orderedChanges) {
        for (FileAreaUpdate child : children) {
            List grandChildren = (List)disjointParents.get(child.getItem().getItemId());
            if (grandChildren != null) {
                this.orderChildrenFirst(grandChildren, disjointParents, orderedChanges);
            }
            orderedChanges.add(child);
            disjointParents.remove(child.getItem().getItemId());
        }
    }
}

