/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.util.DownloadAdapter;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingInputStream;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileSystemUpdateMutator
extends UpdateMutator {
    private final IConnection connection;
    private final ITeamRepository repository;
    private static final String COLLISION_RENAME = "#apo";
    private final IPath fileSystemRoot;
    private final File fileSystemRootFile;
    private final CopyFileAreaStore copyFileArea;

    public LocalFileSystemUpdateMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport updates, IPath fileSystemRoot, DilemmaHandler problemHandler) throws TeamRepositoryException {
        super(connection.teamRepository(), connection, componentStatesBefore, componentStatesAfter, updates, problemHandler);
        this.repository = connection.teamRepository();
        this.connection = connection;
        this.fileSystemRoot = fileSystemRoot;
        this.fileSystemRootFile = fileSystemRoot.toFile();
        this.copyFileArea = CopyFileAreaStore.getCopyFileArea(fileSystemRoot);
    }

    private void retrieveContent(final DeferredDownloadInformation downloadInfo, IPath path, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        final File file = new File(this.fileSystemRootFile, path.toString());
        this.contentSession.retrieveContent(downloadInfo.getContent(), (IDownloadHandler)new DownloadAdapter(){

            public void downloadStreamAcquired(IContent content, InputStream in) throws TeamRepositoryException {
                try {
                    FileOutputStream out = new FileOutputStream(file);
                    boolean completed = false;
                    try {
                        HashComputingInputStream inStream = new HashComputingInputStream(in);
                        ContentManager.read((InputStream)inStream, (OutputStream)out);
                        downloadInfo.setContentUpdated(new ShareableFile(LocalFileSystemUpdateMutator.this.fileSystemRoot, file), inStream.getChecksum(), inStream.getContentSize());
                        completed = true;
                    }
                    catch (Throwable throwable) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException iOException) {}
                        if (!completed && file.exists()) {
                            file.delete();
                        }
                        throw throwable;
                    }
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                    if (!completed && file.exists()) {
                        file.delete();
                    }
                }
                catch (IOException e) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.LocalFileSystemUpdateMutator_1, (Object)file), (Throwable)e);
                }
            }

            public void downloadFailed(IContent content, TeamRepositoryException e) {
                downloadInfo.setFailure(new ShareableFile(LocalFileSystemUpdateMutator.this.fileSystemRoot, file), e);
            }
        });
    }

    private IFileStorage createFolder(IPath path) throws FileSystemClientException {
        File folder = new File(this.fileSystemRootFile, path.toString());
        if (!folder.mkdirs()) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 368, NLS.bind((String)Messages.LocalFileSystemUpdateMutator_2, (Object)path.toString()), null));
        }
        return new LocalFileStorage(this.fileSystemRoot, folder);
    }

    private static void deleteFileTree(File file) throws FileSystemClientException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] childrenFiles = file.listFiles();
                int i = 0;
                while (i < childrenFiles.length) {
                    LocalFileSystemUpdateMutator.deleteFileTree(childrenFiles[i]);
                    ++i;
                }
            }
            if (!file.delete()) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 370, NLS.bind((String)Messages.LocalFileSystemUpdateMutator_3, (Object)file.getPath()), null));
            }
        }
    }

    @Override
    protected void createFile(IComponent component, DeferredDownloadInformation downloadInfo, Shareable parentShareable, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        this.retrieveContent(downloadInfo, parentShareable.getLocalFullPath().append(downloadInfo.getName()), monitor);
    }

    @Override
    protected void createFolder(IComponent component, IFolderHandle parent, Shareable parentShareable, String name, IFolderHandle folderItemState, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        Object path = parentShareable == null ? new Path(name) : parentShareable.getLocalFullPath().append(name);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.subTask(NLS.bind((String)Messages.LocalFileSystemUpdateMutator_4, (Object)path.toString()));
        IFileStorage folder = this.createFolder((IPath)path);
        Shareable shareable = folder.getShareable();
        if (parentShareable == null) {
            SharingDescriptor descriptor = new SharingDescriptor(this.repository.getRepositoryURI(), this.repository.getId(), this.connection, (IComponentHandle)component, component.getName(), folderItemState);
            if (shareable.getShare() == null) {
                shareable.share(descriptor, true, (IProgressMonitor)progress.newChild(50));
            } else {
                this.copyFileArea.setSharingInfo(shareable, descriptor, (IProgressMonitor)progress.newChild(50));
            }
            parent = null;
            name = null;
        }
        FileItemInfo proxy = new FileItemInfo(folderItemState, parent, name);
        this.copyFileArea.setItemInfo(shareable, proxy, (IProgressMonitor)progress.newChild(50));
        progress.done();
    }

    @Override
    protected void deleteSubtree(IComponent component, Shareable toDeleteShareable, IProgressMonitor monitor) throws FileSystemClientException {
        File file = ((ShareableFile)toDeleteShareable).getFile();
        LocalFileSystemUpdateMutator.deleteFileTree(file);
        if (this.isRoot(toDeleteShareable)) {
            toDeleteShareable.unshare(monitor);
        } else {
            toDeleteShareable.forget(monitor);
        }
    }

    @Override
    protected Shareable getRootFolder(String newName) {
        return new ShareableFile(this.fileSystemRoot, new File(this.fileSystemRootFile, newName));
    }

    @Override
    protected void modifyFile(IComponent component, DeferredDownloadInformation downloadInfo, Shareable toModifyShareable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.retrieveContent(downloadInfo, toModifyShareable.getLocalFullPath(), monitor);
    }

    @Override
    protected void move(IComponent component, IComponentHandle previousComponent, Shareable toMoveShareable, Shareable destinationParentShareable, IFolderHandle parent, String newName, IVersionableHandle itemState, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        File sourceFile = ((ShareableFile)toMoveShareable).getFile();
        File targetFile = destinationParentShareable == null ? new File(this.fileSystemRootFile, newName) : new File(this.fileSystemRootFile, destinationParentShareable.getLocalFullPath().append(newName).toString());
        this.move(component, previousComponent, itemState, true, toMoveShareable, sourceFile, targetFile, (IProgressMonitor)progress);
        progress.done();
    }

    private void move(IComponent component, IComponentHandle previousComponent, IVersionableHandle itemState, boolean moveUpdate, Shareable toMoveShareable, File sourceFile, File targetFile, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        if (!sourceFile.renameTo(targetFile)) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 371, Messages.LocalFileSystemUpdateMutator_5, null));
        }
        ShareableFile targetShareable = new ShareableFile(this.fileSystemRoot, targetFile);
        this.updateMetaDataAfterMove(component, previousComponent, itemState, moveUpdate, toMoveShareable, targetShareable, toMoveShareable.getLocalFullPath().segmentCount() == 1, progress);
    }

    @Override
    protected void preserve(IComponent component, Shareable shareable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        String destination;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        File file = ((ShareableFile)shareable).getFile();
        String name = shareable.getLocalFullPath().toString();
        String extension = ((LocalFileStorage)shareable.getFileStorage()).getFile().getName();
        int posn = extension.lastIndexOf(".");
        if (posn < 0) {
            extension = "";
        } else {
            extension = extension.substring(posn);
            name = name.substring(0, name.length() - extension.length());
        }
        name = String.valueOf(name) + COLLISION_RENAME;
        int count = 0;
        File destinationFile = null;
        do {
            destination = String.valueOf(name) + count + extension;
            ++count;
        } while ((destinationFile = new File(this.fileSystemRootFile, destination)).exists());
        this.move(component, (IComponentHandle)component, null, false, shareable, file, destinationFile, (IProgressMonitor)progress.newChild(100));
    }

    @Override
    protected CopyFileAreaStore getCopyFileArea() {
        return this.copyFileArea;
    }

    @Override
    protected Shareable getShareableFor(IPath path, boolean isFolder) {
        ShareableFile result = null;
        if (path != null) {
            result = new ShareableFile(this.fileSystemRoot, path);
        }
        return result;
    }

    @Override
    protected void updateMetaData(DeferredDownloadInformation downloadInfo, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        Shareable shareable = downloadInfo.getShareable();
        if (shareable instanceof ShareableFile) {
            String name;
            IFolderHandle parent;
            File file = ((ShareableFile)shareable).getFile();
            long modificationStamp = file.lastModified();
            Content content = (Content)downloadInfo.getContent();
            LineDelimiter lineDelimiter = content.getLineDelimiter();
            String contentType = content.getContentType();
            FileItemInfo oldInfo = this.getCopyFileArea().getItemInfo(shareable.getLocalFullPath());
            if (oldInfo == null) {
                parent = downloadInfo.getParent();
                name = downloadInfo.getName();
            } else {
                parent = oldInfo.getParent();
                name = oldInfo.getName();
            }
            FileItemInfo info = new FileItemInfo((IVersionableHandle)downloadInfo.getFileItem(), modificationStamp, parent, name, new HashCode(downloadInfo.getChecksum()), downloadInfo.getContentSize(), lineDelimiter, lineDelimiter, contentType, contentType, content.getContentId(), content.getDeltaPredecessor(), content.getContentLength(), content.getCharacterEncoding(), content.getChecksum(), content.getLineDelimiterCount(), downloadInfo.isExecutable(), downloadInfo.isExecutable());
            this.copyFileArea.setItemInfo(new ShareableFile(this.fileSystemRoot, file), info, (IProgressMonitor)new CancellationMonitor(progress));
        }
    }
}

