/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadRule
implements ILoadRule {
    public static final String FOLDER_NAME = "foldername=";
    public static final String ROOT_FOLDER_NAME = "rootfoldername=";
    private IWorkspaceConnection workspaceConnection;
    private IComponentHandle componentHandle;
    private HashMap<UUID, IFolderHandle> rootFolders;
    private HashMap<UUID, IFolderHandle> toLoad;
    private boolean toLoadValid;
    private HashMap<UUID, IFolderHandle> folders;

    public LoadRule(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle) {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        if (componentHandle == null) {
            throw new IllegalArgumentException();
        }
        this.workspaceConnection = workspaceConnection;
        this.componentHandle = componentHandle;
        this.folders = new HashMap();
        this.rootFolders = new HashMap();
        this.toLoad = new HashMap();
        this.toLoadValid = true;
    }

    @Override
    public void addLoadRules(IFileItemHandle loadRules, IProgressMonitor progress) throws TeamRepositoryException {
        if (loadRules == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IFileItem file = (IFileItem)this.workspaceConnection.configuration(this.componentHandle).fetchCompleteItem((IVersionableHandle)loadRules, (IProgressMonitor)monitor.newChild(10));
        InputStream stream = this.workspaceConnection.teamRepository().contentManager().retrieveContentStream(file.getContent(), (IProgressMonitor)monitor.newChild(50));
        this.getRules(file.getContent().getCharacterEncoding(), stream, (IProgressMonitor)monitor.newChild(40));
    }

    @Override
    public void addLoadRules(InputStream stream, String characterEncoding, IProgressMonitor progress) throws TeamRepositoryException {
        if (stream == null) {
            throw new IllegalArgumentException();
        }
        if (characterEncoding == null) {
            throw new IllegalArgumentException();
        }
        this.getRules(characterEncoding, stream, progress);
    }

    private void getRules(String characterEncoding, InputStream contents, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        CharsetDecoder decoder = Charset.forName(characterEncoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        BufferedReader reader = new BufferedReader(new InputStreamReader(contents, decoder));
        IConfiguration configuration = this.workspaceConnection.configuration(this.componentHandle);
        IComponent fullComponent = (IComponent)this.workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)this.componentHandle, 0, (IProgressMonitor)monitor.newChild(1));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                IVersionableHandle folder;
                Path folderName;
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                if (line.toLowerCase().startsWith(FOLDER_NAME)) {
                    folderName = new Path(line.substring(FOLDER_NAME.length()));
                    folder = configuration.resolvePath(fullComponent.getRootFolder(), folderName.segments(), null);
                    if (!(folder instanceof IFolderHandle)) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.LoadRule_0, (Object[])new Object[]{folderName.toString(), fullComponent.getName()}));
                    }
                    this.folders.put(folder.getItemId(), (IFolderHandle)folder);
                    this.toLoad.put(folder.getItemId(), (IFolderHandle)folder);
                    continue;
                }
                if (line.toLowerCase().startsWith(ROOT_FOLDER_NAME)) {
                    folderName = new Path(line.substring(ROOT_FOLDER_NAME.length()));
                    folder = configuration.resolvePath(fullComponent.getRootFolder(), folderName.segments(), null);
                    if (!(folder instanceof IFolderHandle)) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.LoadRule_1, (Object[])new Object[]{folderName.toString(), fullComponent.getName()}));
                    }
                    this.rootFolders.put(folder.getItemId(), (IFolderHandle)folder);
                    this.toLoadValid = false;
                    continue;
                }
                throw new TeamRepositoryException(NLS.bind((String)Messages.LoadRule_2, (Object[])new Object[]{line, fullComponent.getName()}));
            }
        }
        catch (IOException iOException) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.LoadRule_3, (Object[])new Object[]{fullComponent.getName()}));
        }
    }

    @Override
    public Collection<IFolderHandle> getFoldersToLoad(IProgressMonitor progress) throws TeamRepositoryException {
        if (!this.toLoadValid) {
            this.toLoad.clear();
            this.toLoad.putAll(this.folders);
            this.toLoad.putAll(this.getRootFolderChildren(progress));
            this.toLoadValid = true;
        }
        return this.toLoad.values();
    }

    private Map<UUID, IFolderHandle> getRootFolderChildren(IProgressMonitor progress) throws TeamRepositoryException {
        HashMap<UUID, IFolderHandle> result = new HashMap<UUID, IFolderHandle>();
        if (!this.rootFolders.isEmpty()) {
            ArrayList<IFolderHandle> childrenEntriesToFetch = new ArrayList<IFolderHandle>(this.rootFolders.size());
            childrenEntriesToFetch.addAll(this.rootFolders.values());
            IConfiguration configuration = this.workspaceConnection.configuration(this.componentHandle);
            List children = configuration.childEntries(childrenEntriesToFetch, null);
            for (Map childrenEntries : children) {
                if (childrenEntries == null) continue;
                for (IVersionableHandle child : childrenEntries.values()) {
                    if (!(child instanceof IFolderHandle)) continue;
                    result.put(child.getItemId(), (IFolderHandle)child);
                }
            }
        }
        return result;
    }

    public void storeLoadRules(IShareable file, String characterEncoding, IProgressMonitor progress) {
        ((Shareable)file).getFileStorage();
        throw new UnsupportedOperationException();
    }

    public void addFolderToLoad(IFolderHandle itemToLoad) {
        if (itemToLoad == null) {
            throw new IllegalArgumentException();
        }
        this.folders.put(itemToLoad.getItemId(), itemToLoad);
        this.toLoad.put(itemToLoad.getItemId(), itemToLoad);
    }

    public void addRootFolderToLoad(IFolderHandle rootFolder) {
        if (rootFolder == null) {
            throw new IllegalArgumentException();
        }
        this.rootFolders.put(rootFolder.getItemId(), rootFolder);
        this.toLoadValid = false;
    }

    @Override
    public IComponentHandle getComponent() {
        return this.componentHandle;
    }

    @Override
    public IWorkspaceConnection getWorkspaceConnection() {
        return this.workspaceConnection;
    }
}

