/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadOverlap
implements ILoadOverlap {
    private IConnection connection;
    private IComponentHandle component;
    private ArrayList<IAncestorReport> overlappingFolders;
    private ArrayList<IShare> overlappingShares;
    private IAncestorReport overlappedFolder;

    public LoadOverlap(IConnection connection, IComponentHandle component, IAncestorReport overlappedFolderAncestors) {
        this.connection = connection;
        this.component = component;
        this.overlappedFolder = overlappedFolderAncestors;
        this.overlappingFolders = new ArrayList();
        this.overlappingShares = new ArrayList();
    }

    @Override
    public IComponentHandle getComponent() {
        return this.component;
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    @Override
    public IFolderHandle getFolder() {
        return (IFolderHandle)this.getVersionableRepresented(this.overlappedFolder);
    }

    @Override
    public String[] getFolderPath() {
        return this.getPathRepresented(this.overlappedFolder);
    }

    @Override
    public Collection<IShare> getOverlappingShares() {
        return Collections.unmodifiableCollection(this.overlappingShares);
    }

    @Override
    public Collection<IFolderHandle> getOverlappingFolders() {
        ArrayList<IFolderHandle> result = new ArrayList<IFolderHandle>(this.overlappingFolders.size());
        for (IAncestorReport overlapped : this.overlappingFolders) {
            result.add((IFolderHandle)this.getVersionableRepresented(overlapped));
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Collection<String[]> getOverlappingFolderPaths() {
        ArrayList<String[]> result = new ArrayList<String[]>(this.overlappingFolders.size());
        for (IAncestorReport overlapped : this.overlappingFolders) {
            result.add(this.getPathRepresented(overlapped));
        }
        return Collections.unmodifiableCollection(result);
    }

    public void addOverlappingFolder(IAncestorReport folder) {
        this.overlappingFolders.add(folder);
    }

    public void addOverlappingShare(IShare share) {
        this.overlappingShares.add(share);
    }

    private IVersionableHandle getVersionableRepresented(IAncestorReport report) {
        List pairs = report.getNameItemPairs();
        INameItemPair item = (INameItemPair)pairs.get(pairs.size() - 1);
        return item.getItem();
    }

    private String[] getPathRepresented(IAncestorReport report) {
        List pairs = report.getNameItemPairs();
        String[] result = new String[pairs.size() - 1];
        int i = 0;
        Iterator iPairs = pairs.iterator();
        iPairs.next();
        while (iPairs.hasNext()) {
            INameItemPair pair = (INameItemPair)iPairs.next();
            result[i] = pair.getName();
            ++i;
        }
        return result;
    }
}

