/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.IContentManagerSession;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class LoadMutator
extends FileSystemOperation {
    public static final int NONE = 0;
    public static final int MAINTAIN_SHARE_INFO = 1;
    protected final IPath root;
    private final int flags;
    private final IConnection connection;
    private final IContextHandle connectionHandle;
    protected IContentManagerSession contentSession;
    private ArrayList<DeferredShareInformation> sharePaths;
    private LoadTree loadTree;
    private ITeamRepository teamRepository;

    public LoadMutator(IConnection connection, LoadTree loadTree, IPath root, int flags, LoadDilemmaHandler loadProblemHandler) throws TeamRepositoryException {
        super(loadProblemHandler == null ? LoadDilemmaHandler.getDefault() : loadProblemHandler);
        this.teamRepository = connection.teamRepository();
        if (root == null || connection == null) {
            throw new IllegalArgumentException();
        }
        if (loadTree == null) {
            throw new IllegalArgumentException();
        }
        if (connection instanceof IWorkspaceConnection) {
            this.connectionHandle = ((IWorkspaceConnection)connection).getResolvedWorkspace();
        } else if (connection instanceof IBaselineConnection) {
            this.connectionHandle = ((IBaselineConnection)connection).getBaseline();
        } else {
            throw new IllegalArgumentException();
        }
        this.root = root;
        this.flags = flags;
        this.loadTree = loadTree;
        this.connection = connection;
    }

    protected final void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.beginning((IProgressMonitor)progress.newChild(5));
        this.doRun((IProgressMonitor)progress.newChild(90));
        this.ending((IProgressMonitor)progress.newChild(5));
        progress.done();
    }

    /*
     * Unable to fully structure code
     */
    protected final void doRun(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        updates = this.loadTree.getFileAreaUpdates();
        this.contentSession = this.teamRepository.contentManager().createSession(NLS.bind((String)Messages.LoadMutator_0, (Object)this.connection.getName()), true, (long)updates.size(), monitor);
        progress = new CancellationMonitor(monitor);
        component = null;
        i = 0;
        pathsToUpdate = new DeferredDownloadInformation[updates.size()];
        try {
            for (FileAreaUpdate update : updates) {
                if (!update.component().sameItemId(component)) {
                    component = (IComponent)this.teamRepository.itemManager().fetchCompleteItem((IItemHandle)update.component(), 0, null);
                }
                if (update.isChangeType(1)) {
                    parent = update.getDestinationParent();
                    if (update.getItem() instanceof IFolderHandle) {
                        this.createFolder(component, parent, update.getName(), (IFolderHandle)update.afterState(), (IProgressMonitor)progress);
                        this.contentSession.decrementTransferCount(1);
                    } else {
                        pathsToUpdate[i] = new DeferredDownloadInformation(update);
                        this.createFile(component, pathsToUpdate[i], update.getTimestamp(), (IProgressMonitor)progress);
                    }
                }
                if (update.isChangeType(8)) {
                    throw new IllegalStateException(Messages.LoadMutator_1);
                }
                if (update.isChangeType(4)) {
                    throw new IllegalStateException(Messages.LoadMutator_2);
                }
                if (update.isChangeType(2)) {
                    throw new IllegalStateException(Messages.LoadMutator_3);
                }
                if (update.isChangeType(16)) {
                    this.contentSession.decrementTransferCount(1);
                }
                ++i;
            }
        }
        finally {
            this.contentSession.join();
            var14_12 = pathsToUpdate;
            var13_14 = pathsToUpdate.length;
            var12_16 = 0;
            ** while (var12_16 < var13_14)
        }
lbl-1000:
        // 1 sources

        {
            updateInfo = var14_12[var12_16];
            if (updateInfo != null && updateInfo.contentUpdated()) {
                this.updateMetaData(updateInfo, (IProgressMonitor)progress);
            }
            ++var12_16;
            continue;
        }
lbl42:
        // 1 sources

        failures = this.getDownloadFailures(pathsToUpdate);
        if (failures.length > 0) {
            RepositoryUtils.throwAppropriateException(Messages.LoadMutator_4, failures);
        } else if (this.contentSession.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private IStatus[] getDownloadFailures(DeferredDownloadInformation[] pathsToUpdate) {
        ArrayList<Status> errors = new ArrayList<Status>();
        DeferredDownloadInformation[] deferredDownloadInformationArray = pathsToUpdate;
        int n = pathsToUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            DeferredDownloadInformation deferredUpdateInformation = deferredDownloadInformationArray[n2];
            if (deferredUpdateInformation != null && deferredUpdateInformation.getFailure() != null) {
                Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
                int paranoiaCount = 0;
                while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
                    Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                    if (cause == null) break;
                    rootCause = cause;
                    ++paranoiaCount;
                }
                Status status = rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.LoadMutator_5, (Object)deferredUpdateInformation.getShareable().getLocalFullPath(), (Object)deferredUpdateInformation.getContent().getCharacterEncoding()), (Throwable)deferredUpdateInformation.getFailure()) : (rootCause instanceof CharacterCodingException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.LoadMutator_8, (Object)deferredUpdateInformation.getShareable().getLocalFullPath(), (Object)deferredUpdateInformation.getContent().getCharacterEncoding()), (Throwable)deferredUpdateInformation.getFailure()) : new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.LoadMutator_6, (Object)deferredUpdateInformation.getShareable().getLocalFullPath()), (Throwable)deferredUpdateInformation.getFailure()));
                errors.add(status);
            }
            ++n2;
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    protected abstract void updateMetaData(DeferredDownloadInformation var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected void beginning(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        this.deleteRootArea(monitor);
        this.sharePaths = new ArrayList();
    }

    protected abstract void deleteRootArea(IProgressMonitor var1) throws FileSystemClientException;

    protected void checkCancelled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected boolean isMaintainShareable() {
        return (this.flags & 1) == 1;
    }

    protected abstract void createNewFile(IComponent var1, DeferredDownloadInformation var2, Date var3, IProgressMonitor var4) throws FileSystemClientException, TeamRepositoryException;

    protected abstract IFileStorage createNewFolder(IComponent var1, IFolderHandle var2, String var3, IVersionableHandle var4, IProgressMonitor var5) throws FileSystemClientException, TeamRepositoryException;

    protected final IConnection getConnection() {
        return this.connection;
    }

    protected final IContextHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    protected final IPath getRoot() {
        return this.root;
    }

    public final void createFile(IComponent component, DeferredDownloadInformation deferredLoadInformation, Date date, IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        monitor.setTaskName(NLS.bind((String)Messages.LoadMutator_7, (Object)deferredLoadInformation.getName()));
        this.createNewFile(component, deferredLoadInformation, date, (IProgressMonitor)monitor.newChild(75));
    }

    public final void createFolder(IComponent component, IFolderHandle parentFolder, String name, IFolderHandle folderItemState, IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        IFileStorage folder = this.createNewFolder(component, parentFolder, name, (IVersionableHandle)folderItemState, (IProgressMonitor)monitor.newChild(75));
        if (folder != null && this.isMaintainShareable()) {
            FileItemInfo proxy;
            IPath path = folder.getFullPath();
            if (parentFolder == null) {
                return;
            }
            if (path.segmentCount() == 1) {
                Shareable shareable = folder.getShareable();
                IComponent fullComponent = (IComponent)this.connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)component, 0, (IProgressMonitor)monitor.newChild(1));
                SharingDescriptor descriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)component, fullComponent.getName(), folderItemState);
                if (shareable.getShare() == null) {
                    shareable.share(descriptor, true, (IProgressMonitor)monitor.newChild(12));
                } else {
                    CopyFileAreaStore.getCopyFileArea(this.root).setSharingInfo(shareable, descriptor, (IProgressMonitor)monitor.newChild(12));
                }
                DeferredShareInformation shareInfo = new DeferredShareInformation(path, this.connectionHandle, (IComponentHandle)component, folderItemState);
                this.sharePaths.add(shareInfo);
                proxy = new FileItemInfo(folderItemState, null, null);
            } else {
                proxy = new FileItemInfo(folderItemState, parentFolder, name);
            }
            CopyFileAreaStore.getCopyFileArea(this.root).setItemInfo(folder.getShareable(), proxy, (IProgressMonitor)monitor.newChild(12));
        }
        this.checkCancelled((IProgressMonitor)monitor.newChild(0));
        monitor.done();
    }

    protected void ending(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.sharePaths.size());
        if (this.isMaintainShareable()) {
            for (DeferredShareInformation shareInfo : this.sharePaths) {
                CopyFileAreaStore.getCopyFileArea(this.root).setConfigurationState(shareInfo.connectionHandle, shareInfo.component, shareInfo.shareRootItem, ISyncTime.FACTORY.createFrom(this.loadTree.getConfigurationState()), (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    private static class DeferredShareInformation {
        protected IPath path;
        protected IContextHandle connectionHandle;
        protected IComponentHandle component;
        protected IFolderHandle shareRootItem;

        public DeferredShareInformation(IPath path, IContextHandle connectionHandle, IComponentHandle component, IFolderHandle shareRootItem) {
            this.path = path;
            this.connectionHandle = connectionHandle;
            this.component = component;
            this.shareRootItem = shareRootItem;
        }
    }
}

